/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.jetty.server.handler;

import java.io.IOException;
import org.opengis.cite.jetty.server.HttpChannel;
import org.opengis.cite.jetty.server.HttpConfiguration;
import org.opengis.cite.jetty.server.Request;
import org.opengis.cite.jetty.server.handler.AbstractHandler;
import org.opengis.cite.jetty.util.URIUtil;
import org.opengis.cite.servlet.ServletException;
import org.opengis.cite.servlet.http.HttpServletRequest;
import org.opengis.cite.servlet.http.HttpServletResponse;

public class SecuredRedirectHandler
extends AbstractHandler {
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpChannel channel = baseRequest.getHttpChannel();
        if (baseRequest.isSecure() || channel == null) {
            return;
        }
        HttpConfiguration httpConfig = channel.getHttpConfiguration();
        if (httpConfig == null) {
            response.sendError(403, "No http configuration available");
            return;
        }
        if (httpConfig.getSecurePort() > 0) {
            String scheme = httpConfig.getSecureScheme();
            int port = httpConfig.getSecurePort();
            String url = URIUtil.newURI(scheme, baseRequest.getServerName(), port, baseRequest.getRequestURI(), baseRequest.getQueryString());
            response.setContentLength(0);
            baseRequest.getResponse().sendRedirect(302, url, true);
        } else {
            response.sendError(403, "Not Secure");
        }
        baseRequest.setHandled(true);
    }
}

