/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.securityclient10.httpServer;

import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.opengis.cite.securityclient10.httpServer.SamlAuthRequest;
import org.opengis.cite.securityclient10.httpServer.ServerOptions;
import org.opengis.cite.servlet.http.HttpServletRequest;
import org.opengis.cite.servlet.http.HttpServletResponse;

public class EmulatedServer {
    protected DocumentBuilderFactory documentFactory;
    protected DocumentBuilder documentBuilder;
    protected ServerOptions options;
    protected String relayState;

    public EmulatedServer() {
        try {
            this.documentFactory = DocumentBuilderFactory.newInstance();
            this.documentFactory.setNamespaceAware(true);
            this.documentBuilder = this.documentFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        this.relayState = "token";
    }

    protected void enableCors(HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Methods", "GET, POST, OPTIONS");
    }

    protected boolean getAuthenticationEnabled() {
        return this.options.getAuthentication() != null;
    }

    protected PrintWriter getWriterForResponse(HttpServletResponse response) {
        PrintWriter printWriter = null;
        try {
            printWriter = response.getWriter();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return printWriter;
    }

    protected static String getUri(HttpServletRequest request, Boolean contextOnly) {
        String path = contextOnly != false ? "/" + request.getRequestURI().split("/")[1] : request.getRequestURI();
        return String.format("%s://%s:%d%s", request.getScheme(), request.getServerName(), request.getServerPort(), path);
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, TransformerException {
    }

    private void buildException(String string, HttpServletResponse response) {
    }

    protected String buildSamlAuthRequest(String href) throws TransformerException {
        SamlAuthRequest request = new SamlAuthRequest(href);
        return request.toUrlParameterString();
    }

    protected void buildSecurityContext(HttpServletRequest request, HttpServletResponse response) throws TransformerException {
        response.setHeader("Set-Cookie", "sessionToken=sample-token; Max-age=600; httpOnly");
    }

    protected boolean validateSamlAuthenticationResponse(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected boolean validateSecureRequest(HttpServletRequest request, HttpServletResponse response) throws TransformerException {
        String cookie = request.getHeader("Cookie");
        if (!this.getAuthenticationEnabled()) {
            this.buildException("Authentication undefined in test run properties", response);
            return false;
        }
        if (cookie == null) {
            String idpUrl = this.options.getIdpUrl() + "?RelayState=" + this.relayState + "&SAMLRequest=" + this.buildSamlAuthRequest(EmulatedServer.getUri(request, true));
            response.setStatus(302);
            response.setHeader("Location", idpUrl);
            return false;
        }
        if (cookie.contains("sessionToken=")) {
            return true;
        }
        this.buildException("Cookie is missing sessionToken", response);
        return false;
    }
}

