/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.securityclient10.httpServer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.opengis.cite.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RequestRepresenter {
    private Document requestsDocument = null;
    private DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder documentBuilder = this.documentFactory.newDocumentBuilder();
    private TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private Transformer transformer = this.transformerFactory.newTransformer();

    public RequestRepresenter() throws TransformerConfigurationException, ParserConfigurationException {
        this.transformer.setOutputProperty("indent", "yes");
        this.transformer.setOutputProperty("omit-xml-declaration", "no");
        this.transformer.setOutputProperty("method", "xml");
        this.createDocument();
    }

    private void createDocument() {
        this.requestsDocument = this.documentBuilder.newDocument();
        Element rootElement = this.requestsDocument.createElement("HttpRequestSet");
        this.requestsDocument.appendChild(rootElement);
    }

    public void serializeRequest(HttpServletRequest request) throws IOException {
        Element rootElement = this.requestsDocument.getDocumentElement();
        Element requestElement = this.requestsDocument.createElement("Request");
        requestElement.setAttribute("method", request.getMethod());
        requestElement.setAttribute("https", request.isSecure() ? "true" : "false");
        requestElement.setAttribute("queryString", request.getQueryString());
        requestElement.setAttribute("authentication", request.getAuthType());
        rootElement.appendChild(requestElement);
        Enumeration<String> headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String headerName = headers.nextElement();
            String headerValue = request.getHeader(headerName);
            Element header = this.requestsDocument.createElement("Header");
            header.setAttribute("name", headerName);
            header.setTextContent(headerValue);
            requestElement.appendChild(header);
        }
        Element body = this.requestsDocument.createElement("Body");
        body.setAttribute("contentEncoding", request.getCharacterEncoding());
        body.setAttribute("contentLength", String.valueOf(request.getContentLength()));
        String bodyContent = "";
        bodyContent = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
        body.setTextContent(bodyContent);
        requestElement.appendChild(body);
    }

    public void saveToPath(Path path) throws TransformerException, FileNotFoundException {
        StringWriter stringWriter = new StringWriter();
        this.transformer.transform(new DOMSource(this.requestsDocument), new StreamResult(stringWriter));
        String xmlDoc = stringWriter.toString();
        System.out.println("Writing to file: " + path.toString());
        PrintWriter outputFile = new PrintWriter(path.toAbsolutePath().toString());
        outputFile.print(xmlDoc);
        outputFile.close();
    }
}

