/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.securityclient10.httpServer;

import java.io.PrintWriter;
import java.util.Enumeration;
import javax.xml.transform.TransformerException;
import org.opengis.cite.securityclient10.httpServer.EmulatedServer;
import org.opengis.cite.securityclient10.httpServer.ServerOptions;
import org.opengis.cite.securityclient10.util.XMLUtils;
import org.opengis.cite.servlet.http.HttpServletRequest;
import org.opengis.cite.servlet.http.HttpServletResponse;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class ServerWms111
extends EmulatedServer {
    public ServerWms111(ServerOptions options) {
        this.options = options;
    }

    @Override
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws TransformerException {
        System.out.println("Building WMS 1.1.1 Response");
        System.out.println("Query Params: " + request.getQueryString());
        this.enableCors(response);
        String serviceValue = null;
        String requestValue = null;
        Enumeration<String> e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String parameter = e.nextElement();
            if (parameter.compareToIgnoreCase("service") == 0) {
                serviceValue = request.getParameter(parameter);
                continue;
            }
            if (parameter.compareToIgnoreCase("request") != 0) continue;
            requestValue = request.getParameter(parameter);
        }
        if (request.getPathInfo().endsWith("/saml2")) {
            if (this.validateSamlAuthenticationResponse(request, response)) {
                this.buildSecurityContext(request, response);
                this.buildCapabilities(request, response, true);
            }
        } else if (serviceValue == null || requestValue == null || !serviceValue.equals("WMS")) {
            this.buildException("Invalid query parameters", response);
        } else {
            switch (requestValue) {
                case "GetCapabilities": 
                case "capabilities": {
                    if (request.getPathInfo().endsWith("/full") && this.getAuthenticationEnabled()) {
                        if (!this.validateSecureRequest(request, response)) break;
                        this.buildCapabilities(request, response, true);
                        break;
                    }
                    this.buildCapabilities(request, response, false);
                    break;
                }
                case "GetMap": {
                    this.buildException("Operation not supported by test server", response);
                    break;
                }
                case "GetFeatureInfo": 
                case "DescribeLayer": 
                case "GetLegendGraphic": 
                case "GetStyles": 
                case "PutStyles": {
                    this.buildException("Unsupported Operation", response);
                    break;
                }
                default: {
                    this.buildException("Invalid request parameter", response);
                }
            }
        }
    }

    public void buildCapabilities(HttpServletRequest request, HttpServletResponse response, boolean completeCapabilities) throws TransformerException {
        response.setContentType("application/vnd.ogc.wms_xml");
        response.setStatus(200);
        String baseHref = ServerWms111.getUri(request, false);
        String href = completeCapabilities ? baseHref + "/full" : baseHref;
        PrintWriter printWriter = this.getWriterForResponse(response);
        DOMImplementation domImplementation = this.documentBuilder.getDOMImplementation();
        DocumentType doctype = domImplementation.createDocumentType("doctype", null, "http://schemas.opengis.net/wms/1.1.1/capabilities_1_1_1.dtd");
        Document doc = domImplementation.createDocument(null, "WMT_MS_Capabilities", doctype);
        Element rootElement = doc.getDocumentElement();
        rootElement.setAttribute("version", "1.1.1");
        Element service = doc.createElement("Service");
        rootElement.appendChild(service);
        Element name = doc.createElement("Name");
        name.setTextContent("WMS");
        service.appendChild(name);
        Element title = doc.createElement("Title");
        title.setTextContent("ETS Security Client 1.0 WMS 1.1.1");
        service.appendChild(title);
        Element abstractElement = doc.createElement("Abstract");
        abstractElement.setTextContent("WMS 1.1.1 for validating secure client requests under ETS Security Client 1.0");
        service.appendChild(abstractElement);
        Element onlineResource = doc.createElement("OnlineResource");
        onlineResource.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        onlineResource.setAttribute("xlink:type", "simple");
        onlineResource.setAttribute("xlink:href", href);
        service.appendChild(onlineResource);
        Element capability = doc.createElement("Capability");
        rootElement.appendChild(capability);
        Element requestElement = doc.createElement("Request");
        capability.appendChild(requestElement);
        Element getCapabilities = doc.createElement("GetCapabilities");
        requestElement.appendChild(getCapabilities);
        Element getCapabilitiesFormat = doc.createElement("Format");
        getCapabilitiesFormat.setTextContent("application/vnd.ogc.wms_xml");
        getCapabilities.appendChild(getCapabilitiesFormat);
        Element getCapabilitiesDCPType = doc.createElement("DCPType");
        getCapabilities.appendChild(getCapabilitiesDCPType);
        Element getCapabilitiesDCPTypeHTTP = doc.createElement("HTTP");
        getCapabilitiesDCPType.appendChild(getCapabilitiesDCPTypeHTTP);
        Element getCapabilitiesDCPTypeHTTPGet = doc.createElement("Get");
        getCapabilitiesDCPTypeHTTP.appendChild(getCapabilitiesDCPTypeHTTPGet);
        Element getCapabilitiesDCPTypeHTTPGetOR = doc.createElement("OnlineResource");
        getCapabilitiesDCPTypeHTTPGetOR.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        getCapabilitiesDCPTypeHTTPGetOR.setAttribute("xlink:type", "simple");
        getCapabilitiesDCPTypeHTTPGetOR.setAttribute("xlink:href", href);
        getCapabilitiesDCPTypeHTTPGet.appendChild(getCapabilitiesDCPTypeHTTPGetOR);
        Element getCapabilitiesDCPTypeHTTPPost = doc.createElement("Post");
        getCapabilitiesDCPTypeHTTP.appendChild(getCapabilitiesDCPTypeHTTPPost);
        Element getCapabilitiesDCPTypeHTTPPostOR = doc.createElement("OnlineResource");
        getCapabilitiesDCPTypeHTTPPostOR.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        getCapabilitiesDCPTypeHTTPPostOR.setAttribute("xlink:type", "simple");
        getCapabilitiesDCPTypeHTTPPostOR.setAttribute("xlink:href", href);
        getCapabilitiesDCPTypeHTTPPost.appendChild(getCapabilitiesDCPTypeHTTPPostOR);
        Element getMap = doc.createElement("GetMap");
        requestElement.appendChild(getMap);
        Element getMapFormat = doc.createElement("Format");
        getMapFormat.setTextContent("image/png");
        getMap.appendChild(getMapFormat);
        Element getMapDCPType = doc.createElement("DCPType");
        getMap.appendChild(getMapDCPType);
        Element getMapDCPTypeHTTP = doc.createElement("HTTP");
        getMapDCPType.appendChild(getMapDCPTypeHTTP);
        Element getMapDCPTypeHTTPGet = doc.createElement("Get");
        getMapDCPTypeHTTP.appendChild(getMapDCPTypeHTTPGet);
        Element getMapDCPTypeHTTPGetOR = doc.createElement("OnlineResource");
        getMapDCPTypeHTTPGetOR.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        getMapDCPTypeHTTPGetOR.setAttribute("xlink:type", "simple");
        getMapDCPTypeHTTPGetOR.setAttribute("xlink:href", href);
        getMapDCPTypeHTTPGet.appendChild(getMapDCPTypeHTTPGetOR);
        Element exception = doc.createElement("Exception");
        capability.appendChild(exception);
        Element exceptionFormat = doc.createElement("Format");
        exceptionFormat.setTextContent("application/vnd.ogc.se_xml");
        exception.appendChild(exceptionFormat);
        if (completeCapabilities) {
            Element layer = doc.createElement("Layer");
            capability.appendChild(layer);
            Element layerTitle = doc.createElement("Title");
            layerTitle.setTextContent("False Layer Data");
            layer.appendChild(layerTitle);
            Element layerSrs = doc.createElement("SRS");
            layerSrs.setTextContent("EPSG:4326");
            layer.appendChild(layerSrs);
        }
        Element vendorSpecificCapabilities = this.buildVendorSpecificCapabilities(doc, baseHref);
        capability.appendChild(vendorSpecificCapabilities);
        printWriter.print(XMLUtils.writeDocumentToString(doc, true));
    }

    private Element buildGetElement(Document doc, String href) {
        Element constraintNoValues;
        Element constraint;
        Element get = doc.createElement("ows:Get");
        get.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        get.setAttribute("xlink:type", "simple");
        get.setAttribute("xlink:href", href);
        if (this.options.getAuthentication().equals("saml2") && this.options.getIdpUrl() != null) {
            constraint = doc.createElement("ows:Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:authentication:saml2");
            get.appendChild(constraint);
            Element constraintValuesReference = doc.createElement("ows:ValuesReference");
            constraintValuesReference.setAttribute("ows:reference", this.options.getIdpUrl());
            constraint.appendChild(constraintValuesReference);
        }
        if (this.options.getHttpMethods().booleanValue()) {
            constraint = doc.createElement("ows:Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:http-methods");
            get.appendChild(constraint);
            Element constraintAllowedValues = doc.createElement("ows:AllowedValues");
            constraint.appendChild(constraintAllowedValues);
            Element valueGet = doc.createElement("ows:Value");
            valueGet.setTextContent("GET");
            constraintAllowedValues.appendChild(valueGet);
            Element valuePost = doc.createElement("ows:Value");
            valuePost.setTextContent("POST");
            constraintAllowedValues.appendChild(valuePost);
        }
        if (this.options.getCors().booleanValue()) {
            constraint = doc.createElement("ows:Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:cors");
            get.appendChild(constraint);
            constraintNoValues = doc.createElement("ows:NoValues");
            constraint.appendChild(constraintNoValues);
        }
        if (this.options.getHttpExceptionHandling().booleanValue()) {
            constraint = doc.createElement("ows:Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:http-exception-handling");
            get.appendChild(constraint);
            constraintNoValues = doc.createElement("ows:NoValues");
            constraint.appendChild(constraintNoValues);
        }
        return get;
    }

    private Element buildPostElement(Document doc, String href) {
        Element constraintNoValues;
        Element constraintAllowedValues;
        Element constraint;
        Element post = doc.createElement("ows:Post");
        post.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        post.setAttribute("xlink:type", "simple");
        post.setAttribute("xlink:href", href);
        if (this.options.getAuthentication().equals("saml2") && this.options.getIdpUrl() != null) {
            constraint = doc.createElement("ows:Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:authentication:saml2");
            post.appendChild(constraint);
            Element constraintValuesReference = doc.createElement("ows:ValuesReference");
            constraintValuesReference.setAttribute("ows:reference", this.options.getIdpUrl());
            constraint.appendChild(constraintValuesReference);
        }
        if (this.options.getHttpMethods().booleanValue()) {
            constraint = doc.createElement("ows:Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:http-methods");
            post.appendChild(constraint);
            constraintAllowedValues = doc.createElement("ows:AllowedValues");
            constraint.appendChild(constraintAllowedValues);
            Element valueGet = doc.createElement("ows:Value");
            valueGet.setTextContent("GET");
            constraintAllowedValues.appendChild(valueGet);
            Element valuePost = doc.createElement("ows:Value");
            valuePost.setTextContent("POST");
            constraintAllowedValues.appendChild(valuePost);
        }
        if (this.options.getCors().booleanValue()) {
            constraint = doc.createElement("ows:Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:cors");
            post.appendChild(constraint);
            constraintNoValues = doc.createElement("ows:NoValues");
            constraint.appendChild(constraintNoValues);
        }
        if (this.options.getHttpExceptionHandling().booleanValue()) {
            constraint = doc.createElement("ows:Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:http-exception-handling");
            post.appendChild(constraint);
            constraintNoValues = doc.createElement("ows:NoValues");
            constraint.appendChild(constraintNoValues);
        }
        if (this.options.getHttpPostContentType().booleanValue()) {
            constraint = doc.createElement("ows:Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:content-type");
            post.appendChild(constraint);
            constraintAllowedValues = doc.createElement("ows:AllowedValues");
            constraint.appendChild(constraintAllowedValues);
            Element value = doc.createElement("ows:Value");
            value.setTextContent("application/x-www-form-urlencoded");
            constraintAllowedValues.appendChild(value);
        }
        return post;
    }

    private Element buildVendorSpecificCapabilities(Document doc, String href) {
        Element vendorSpecificCapabilities = doc.createElement("VendorSpecificCapabilities");
        String completeCapabilitiesUrl = href + "/full";
        Element extendedSecurityCapabilities = doc.createElement("ows_security:ExtendedSecurityCapabilities");
        extendedSecurityCapabilities.setAttribute("xmlns:ows_security", "http://www.opengis.net/security/1.0");
        vendorSpecificCapabilities.appendChild(extendedSecurityCapabilities);
        Element operationsMetadata = doc.createElement("ows:OperationsMetadata");
        operationsMetadata.setAttribute("xmlns:ows", "http://www.opengis.net/ows/1.1");
        extendedSecurityCapabilities.appendChild(operationsMetadata);
        Element getCapabilities = doc.createElement("ows:Operation");
        getCapabilities.setAttribute("name", "GetCapabilities");
        operationsMetadata.appendChild(getCapabilities);
        Element getCapabilitiesDcp = doc.createElement("ows:DCP");
        getCapabilities.appendChild(getCapabilitiesDcp);
        Element getCapabilitiesDcpHttp = doc.createElement("ows:HTTP");
        getCapabilitiesDcp.appendChild(getCapabilitiesDcpHttp);
        Element getCapabilitiesDcpHttpGet = this.buildGetElement(doc, completeCapabilitiesUrl);
        getCapabilitiesDcpHttp.appendChild(getCapabilitiesDcpHttpGet);
        Element getCapabilitiesDcpHttpPost = this.buildPostElement(doc, completeCapabilitiesUrl);
        getCapabilitiesDcpHttp.appendChild(getCapabilitiesDcpHttpPost);
        return vendorSpecificCapabilities;
    }

    public void buildException(String reason, HttpServletResponse response) throws TransformerException {
        response.setContentType("application/vnd.ogc.se_xml");
        response.setStatus(404);
        PrintWriter printWriter = this.getWriterForResponse(response);
        DOMImplementation domImplementation = this.documentBuilder.getDOMImplementation();
        DocumentType doctype = domImplementation.createDocumentType("doctype", null, "http://schemas.opengis.net/wms/1.1.1/exception_1_1_1.dtd");
        Document doc = domImplementation.createDocument(null, "ServiceExceptionReport", doctype);
        Element rootElement = doc.getDocumentElement();
        rootElement.setAttribute("version", "1.1.1");
        Element serviceException = doc.createElement("ServiceException");
        serviceException.setTextContent(reason);
        rootElement.appendChild(serviceException);
        printWriter.print(XMLUtils.writeDocumentToString(doc, true));
    }
}

