/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.securityclient10.httpServer;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ReadPendingException;
import java.nio.channels.WritePendingException;
import org.opengis.cite.jetty.io.Connection;
import org.opengis.cite.jetty.io.EndPoint;
import org.opengis.cite.jetty.util.Callback;

public class UnifiedEndPoint
implements EndPoint {
    private final EndPoint endPoint;
    private final ByteBuffer start;
    private int leftToRead;
    private final byte[] bytes;
    private IOException pendingException = null;

    public UnifiedEndPoint(EndPoint channel, int readAheadLength) {
        this.endPoint = channel;
        this.bytes = new byte[readAheadLength];
        this.start = ByteBuffer.wrap(this.bytes);
        this.start.flip();
        this.leftToRead = readAheadLength;
    }

    @Override
    public synchronized int fill(ByteBuffer dst) throws IOException {
        this.throwPendingException();
        if (this.leftToRead > 0) {
            this.readAhead();
        }
        if (this.leftToRead > 0) {
            return 0;
        }
        int sr = this.start.remaining();
        if (sr > 0) {
            dst.compact();
            int n = this.readFromStart(dst);
            if (n < sr) {
                return n;
            }
        }
        return sr + this.endPoint.fill(dst);
    }

    public byte[] getBytes() {
        if (this.pendingException == null) {
            try {
                this.readAhead();
            }
            catch (IOException e) {
                this.pendingException = e;
            }
        }
        return this.bytes;
    }

    private synchronized void readAhead() throws IOException {
        if (this.leftToRead > 0) {
            int n = this.endPoint.fill(this.start);
            this.leftToRead = n == -1 ? -1 : (this.leftToRead -= n);
            if (this.leftToRead <= 0) {
                this.start.rewind();
            }
        }
    }

    private int readFromStart(ByteBuffer dst) throws IOException {
        int n = Math.min(dst.remaining(), this.start.remaining());
        if (n > 0) {
            dst.put(this.bytes, this.start.position(), n);
            this.start.position(this.start.position() + n);
            dst.flip();
        }
        return n;
    }

    private void throwPendingException() throws IOException {
        if (this.pendingException != null) {
            IOException e = this.pendingException;
            this.pendingException = null;
            throw e;
        }
    }

    @Override
    public long getIdleTimeout() {
        return this.endPoint.getIdleTimeout();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.endPoint.getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.endPoint.getRemoteAddress();
    }

    @Override
    public boolean isOpen() {
        return this.endPoint.isOpen();
    }

    @Override
    public long getCreatedTimeStamp() {
        return this.endPoint.getCreatedTimeStamp();
    }

    @Override
    public void shutdownOutput() {
        this.endPoint.shutdownOutput();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.endPoint.isOutputShutdown();
    }

    @Override
    public boolean isInputShutdown() {
        return this.endPoint.isInputShutdown();
    }

    @Override
    public void close() {
        this.endPoint.close();
    }

    @Override
    public boolean flush(ByteBuffer ... buffer) throws IOException {
        return this.endPoint.flush(buffer);
    }

    @Override
    public Object getTransport() {
        return this.endPoint.getTransport();
    }

    @Override
    public void setIdleTimeout(long idleTimeout) {
        this.endPoint.setIdleTimeout(idleTimeout);
    }

    @Override
    public void fillInterested(Callback callback) throws ReadPendingException {
        this.endPoint.fillInterested(callback);
    }

    @Override
    public boolean tryFillInterested(Callback callback) {
        return this.endPoint.tryFillInterested(callback);
    }

    @Override
    public boolean isFillInterested() {
        return this.endPoint.isFillInterested();
    }

    @Override
    public void write(Callback callback, ByteBuffer ... buffers) throws WritePendingException {
        this.endPoint.write(callback, buffers);
    }

    @Override
    public Connection getConnection() {
        return this.endPoint.getConnection();
    }

    @Override
    public void setConnection(Connection connection) {
        this.endPoint.setConnection(connection);
    }

    @Override
    public void onOpen() {
        this.endPoint.onOpen();
    }

    @Override
    public void onClose() {
        this.endPoint.onClose();
    }

    @Override
    public boolean isOptimizedForDirectBuffers() {
        return this.endPoint.isOptimizedForDirectBuffers();
    }

    @Override
    public void upgrade(Connection newConnection) {
        this.endPoint.upgrade(newConnection);
    }
}

