/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.securityclient10.httpServer;

import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.opengis.cite.jetty.http.HttpVersion;
import org.opengis.cite.jetty.io.Connection;
import org.opengis.cite.jetty.io.EndPoint;
import org.opengis.cite.jetty.io.ssl.SslConnection;
import org.opengis.cite.jetty.server.AbstractConnectionFactory;
import org.opengis.cite.jetty.server.ConnectionFactory;
import org.opengis.cite.jetty.server.Connector;
import org.opengis.cite.jetty.util.annotation.Name;
import org.opengis.cite.jetty.util.ssl.SslContextFactory;
import org.opengis.cite.securityclient10.httpServer.UnifiedEndPoint;

public class UnifiedSslConnectionFactory
extends AbstractConnectionFactory {
    private final SslContextFactory _sslContextFactory;
    private final String _nextProtocol;

    public UnifiedSslConnectionFactory() {
        this(HttpVersion.HTTP_1_1.asString());
    }

    public UnifiedSslConnectionFactory(@Name(value="next") String nextProtocol) {
        this((SslContextFactory)null, nextProtocol);
    }

    public UnifiedSslConnectionFactory(@Name(value="sslContextFactory") SslContextFactory factory, @Name(value="next") String nextProtocol) {
        super("SSL");
        this._sslContextFactory = factory == null ? new SslContextFactory() : factory;
        this._nextProtocol = nextProtocol;
        this.addBean(this._sslContextFactory);
    }

    public SslContextFactory getSslContextFactory() {
        return this._sslContextFactory;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        SSLEngine engine = this._sslContextFactory.newSSLEngine();
        engine.setUseClientMode(false);
        SSLSession session = engine.getSession();
        if (session.getPacketBufferSize() > this.getInputBufferSize()) {
            this.setInputBufferSize(session.getPacketBufferSize());
        }
    }

    @Override
    public Connection newConnection(Connector connector, EndPoint realEndPoint) {
        EndPoint plainEndPoint;
        SslConnection sslConnection;
        boolean isSSL;
        UnifiedEndPoint aheadEndPoint = new UnifiedEndPoint(realEndPoint, 1);
        byte[] bytes = aheadEndPoint.getBytes();
        if (bytes == null || bytes.length == 0) {
            isSSL = true;
        } else {
            byte b = bytes[0];
            boolean bl = isSSL = b >= 127 || b < 32 && b != 10 && b != 13 && b != 9;
        }
        if (isSSL) {
            SSLEngine engine = this._sslContextFactory.newSSLEngine(aheadEndPoint.getRemoteAddress());
            engine.setUseClientMode(false);
            sslConnection = this.newSslConnection(connector, aheadEndPoint, engine);
            sslConnection.setRenegotiationAllowed(this._sslContextFactory.isRenegotiationAllowed());
            this.configure(sslConnection, connector, aheadEndPoint);
            plainEndPoint = sslConnection.getDecryptedEndPoint();
        } else {
            sslConnection = null;
            plainEndPoint = aheadEndPoint;
        }
        ConnectionFactory next = connector.getConnectionFactory(this._nextProtocol);
        Connection connection = next.newConnection(connector, plainEndPoint);
        plainEndPoint.setConnection(connection);
        return sslConnection == null ? connection : sslConnection;
    }

    protected SslConnection newSslConnection(Connector connector, EndPoint endPoint, SSLEngine engine) {
        return new SslConnection(connector.getByteBufferPool(), connector.getExecutor(), endPoint, engine);
    }

    @Override
    public String toString() {
        return String.format("%s@%x{%s->%s}", this.getClass().getSimpleName(), this.hashCode(), this.getProtocol(), this._nextProtocol);
    }
}

