/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.securityclient10.util;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PropertiesDocument {
    private DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder documentBuilder;
    private Document document;
    private Properties properties;

    public PropertiesDocument() {
        try {
            this.documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        this.properties = new Properties();
    }

    public PropertiesDocument(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        this.documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        this.document = this.documentBuilder.parse(xmlFile);
        this.properties = this.documentToProperties(this.document);
    }

    public PropertiesDocument(Document testRunArgs) throws ParserConfigurationException {
        this.documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        this.document = this.documentBuilder.newDocument();
        this.properties = this.documentToProperties(testRunArgs);
    }

    public Document getDocument() {
        Document doc = this.documentBuilder.newDocument();
        Element rootElement = doc.createElement("properties");
        doc.appendChild(rootElement);
        Enumeration<?> keys = this.properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Element entry = doc.createElement("entry");
            entry.setAttribute("key", key);
            entry.setTextContent(this.getProperty(key));
            rootElement.appendChild(entry);
        }
        return doc;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    private Properties documentToProperties(Document doc) {
        Properties props = new Properties();
        NodeList entries = doc.getDocumentElement().getElementsByTagName("entry");
        for (int i = 0; i < entries.getLength(); ++i) {
            Element entry = (Element)entries.item(i);
            props.setProperty(entry.getAttribute("key"), entry.getTextContent());
        }
        return props;
    }
}

