/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.securityclient10.httpServer;

import java.io.PrintWriter;
import java.util.Enumeration;
import javax.xml.transform.TransformerException;
import org.opengis.cite.securityclient10.httpServer.EmulatedServer;
import org.opengis.cite.securityclient10.httpServer.ServerOptions;
import org.opengis.cite.securityclient10.util.XMLUtils;
import org.opengis.cite.servlet.http.HttpServletRequest;
import org.opengis.cite.servlet.http.HttpServletResponse;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ServerWms13
extends EmulatedServer {
    public ServerWms13(ServerOptions options) {
        this.documentFactory.setNamespaceAware(true);
        this.options = options;
    }

    @Override
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws TransformerException {
        System.out.println("Building WMS 1.3.0 Response");
        System.out.println("Query Params: " + request.getQueryString());
        this.enableCors(response);
        String serviceValue = null;
        String requestValue = null;
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String parameter = (String)e.nextElement();
            if (parameter.compareToIgnoreCase("service") == 0) {
                serviceValue = request.getParameter(parameter);
                continue;
            }
            if (parameter.compareToIgnoreCase("request") != 0) continue;
            requestValue = request.getParameter(parameter);
        }
        if (request.getPathInfo().endsWith("/saml2")) {
            if (this.validateSamlAuthenticationResponse(request, response)) {
                this.buildSecurityContext(request, response);
                this.buildCapabilities(request, response, true);
            }
        } else if (serviceValue == null || requestValue == null || !serviceValue.equals("WMS")) {
            this.buildException("Invalid query parameters", response);
        } else {
            switch (requestValue) {
                case "GetCapabilities": {
                    if (request.getPathInfo().endsWith("/full") && this.getAuthenticationEnabled()) {
                        if (!this.validateSecureRequest(request, response)) break;
                        this.buildCapabilities(request, response, true);
                        break;
                    }
                    this.buildCapabilities(request, response, false);
                    break;
                }
                case "GetMap": {
                    this.buildException("Operation not supported by test server", response);
                    break;
                }
                case "GetFeatureInfo": {
                    this.buildException("Unsupported Operation", response);
                    break;
                }
                default: {
                    this.buildException("Invalid request parameter", response);
                }
            }
        }
    }

    public void buildCapabilities(HttpServletRequest request, HttpServletResponse response, boolean completeCapabilities) throws TransformerException {
        response.setContentType("application/vnd.ogc.wms_xml");
        response.setStatus(200);
        String baseHref = ServerWms13.getUri(request, false);
        String href = completeCapabilities ? baseHref + "/full" : baseHref;
        PrintWriter printWriter = this.getWriterForResponse(response);
        DOMImplementation domImplementation = this.documentBuilder.getDOMImplementation();
        Document doc = domImplementation.createDocument("http://www.opengis.net/wms", "WMS_Capabilities", null);
        Element rootElement = doc.getDocumentElement();
        rootElement.setAttribute("version", "1.3.0");
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xlink", "http://www.w3.org/1999/xlink");
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ows", "http://www.opengis.net/ows/1.1");
        rootElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.opengis.net/wms http://schemas.opengis.net/wms/1.3.0/capabilities_1_3_0.xsd");
        Element service = doc.createElementNS("http://www.opengis.net/wms", "Service");
        rootElement.appendChild(service);
        Element name = doc.createElementNS("http://www.opengis.net/wms", "Name");
        name.setTextContent("WMS");
        service.appendChild(name);
        Element title = doc.createElementNS("http://www.opengis.net/wms", "Title");
        title.setTextContent("ETS Security Client 1.0 WMS 1.3.0");
        service.appendChild(title);
        Element abstractElement = doc.createElementNS("http://www.opengis.net/wms", "Abstract");
        abstractElement.setTextContent("WMS 1.3.0 for validating secure client requests under ETS Security Client 1.0");
        service.appendChild(abstractElement);
        Element onlineResource = doc.createElementNS("http://www.opengis.net/wms", "OnlineResource");
        onlineResource.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        onlineResource.setAttribute("xlink:type", "simple");
        onlineResource.setAttribute("xlink:href", href);
        service.appendChild(onlineResource);
        Element capability = doc.createElementNS("http://www.opengis.net/wms", "Capability");
        rootElement.appendChild(capability);
        Element requestElement = doc.createElementNS("http://www.opengis.net/wms", "Request");
        capability.appendChild(requestElement);
        Element getCapabilities = doc.createElementNS("http://www.opengis.net/wms", "GetCapabilities");
        requestElement.appendChild(getCapabilities);
        Element getCapabilitiesFormat = doc.createElementNS("http://www.opengis.net/wms", "Format");
        getCapabilitiesFormat.setTextContent("application/vnd.ogc.wms_xml");
        getCapabilities.appendChild(getCapabilitiesFormat);
        Element getCapabilitiesDCPType = doc.createElementNS("http://www.opengis.net/wms", "DCPType");
        getCapabilities.appendChild(getCapabilitiesDCPType);
        Element getCapabilitiesDCPTypeHTTP = doc.createElementNS("http://www.opengis.net/wms", "HTTP");
        getCapabilitiesDCPType.appendChild(getCapabilitiesDCPTypeHTTP);
        Element getCapabilitiesDCPTypeHTTPGet = doc.createElementNS("http://www.opengis.net/wms", "Get");
        getCapabilitiesDCPTypeHTTP.appendChild(getCapabilitiesDCPTypeHTTPGet);
        Element getCapabilitiesDCPTypeHTTPGetOR = doc.createElementNS("http://www.opengis.net/wms", "OnlineResource");
        getCapabilitiesDCPTypeHTTPGetOR.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        getCapabilitiesDCPTypeHTTPGetOR.setAttribute("xlink:type", "simple");
        getCapabilitiesDCPTypeHTTPGetOR.setAttribute("xlink:href", href);
        getCapabilitiesDCPTypeHTTPGet.appendChild(getCapabilitiesDCPTypeHTTPGetOR);
        Element getCapabilitiesDCPTypeHTTPPost = doc.createElementNS("http://www.opengis.net/wms", "Post");
        getCapabilitiesDCPTypeHTTP.appendChild(getCapabilitiesDCPTypeHTTPPost);
        Element getCapabilitiesDCPTypeHTTPPostOR = doc.createElementNS("http://www.opengis.net/wms", "OnlineResource");
        getCapabilitiesDCPTypeHTTPPostOR.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        getCapabilitiesDCPTypeHTTPPostOR.setAttribute("xlink:type", "simple");
        getCapabilitiesDCPTypeHTTPPostOR.setAttribute("xlink:href", href);
        getCapabilitiesDCPTypeHTTPPost.appendChild(getCapabilitiesDCPTypeHTTPPostOR);
        Element getMap = doc.createElementNS("http://www.opengis.net/wms", "GetMap");
        requestElement.appendChild(getMap);
        Element getMapFormat = doc.createElementNS("http://www.opengis.net/wms", "Format");
        getMapFormat.setTextContent("image/png");
        getMap.appendChild(getMapFormat);
        Element getMapDCPType = doc.createElementNS("http://www.opengis.net/wms", "DCPType");
        getMap.appendChild(getMapDCPType);
        Element getMapDCPTypeHTTP = doc.createElementNS("http://www.opengis.net/wms", "HTTP");
        getMapDCPType.appendChild(getMapDCPTypeHTTP);
        Element getMapDCPTypeHTTPGet = doc.createElementNS("http://www.opengis.net/wms", "Get");
        getMapDCPTypeHTTP.appendChild(getMapDCPTypeHTTPGet);
        Element getMapDCPTypeHTTPGetOR = doc.createElementNS("http://www.opengis.net/wms", "OnlineResource");
        getMapDCPTypeHTTPGetOR.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        getMapDCPTypeHTTPGetOR.setAttribute("xlink:type", "simple");
        getMapDCPTypeHTTPGetOR.setAttribute("xlink:href", href);
        getMapDCPTypeHTTPGet.appendChild(getMapDCPTypeHTTPGetOR);
        Element exception = doc.createElementNS("http://www.opengis.net/wms", "Exception");
        capability.appendChild(exception);
        Element exceptionFormat = doc.createElementNS("http://www.opengis.net/wms", "Format");
        exceptionFormat.setTextContent("application/vnd.ogc.se_xml");
        exception.appendChild(exceptionFormat);
        if (completeCapabilities) {
            Element layer = doc.createElementNS("http://www.opengis.net/wms", "Layer");
            capability.appendChild(layer);
            Element layerTitle = doc.createElementNS("http://www.opengis.net/wms", "Title");
            layerTitle.setTextContent("False Layer Data");
            layer.appendChild(layerTitle);
            Element layerSrs = doc.createElementNS("http://www.opengis.net/wms", "CRS");
            layerSrs.setTextContent("EPSG:4326");
            layer.appendChild(layerSrs);
        }
        Element vendorSpecificCapabilities = this.buildExtendedSecurityCapabilities(doc, baseHref);
        capability.appendChild(vendorSpecificCapabilities);
        printWriter.print(XMLUtils.writeDocumentToString(doc, true));
    }

    private Element buildGetElement(Document doc, String href, String[] methods) {
        Element constraintNoValues;
        Element constraint;
        Element get = doc.createElementNS("http://www.opengis.net/ows/1.1", "Get");
        get.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        get.setAttribute("xlink:type", "simple");
        get.setAttribute("xlink:href", href);
        if (this.options.getAuthentication().equals("saml2") && this.options.getIdpUrl() != null) {
            constraint = doc.createElementNS("http://www.opengis.net/ows/1.1", "Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:authentication:saml2");
            get.appendChild(constraint);
            Element constraintValuesReference = doc.createElementNS("http://www.opengis.net/ows/1.1", "ValuesReference");
            constraintValuesReference.setAttributeNS("http://www.opengis.net/ows/1.1", "ows:reference", this.options.getIdpUrl());
            constraint.appendChild(constraintValuesReference);
        }
        if (this.options.getHttpMethods().booleanValue()) {
            constraint = doc.createElementNS("http://www.opengis.net/ows/1.1", "Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:http-methods");
            get.appendChild(constraint);
            Element constraintAllowedValues = doc.createElementNS("http://www.opengis.net/ows/1.1", "AllowedValues");
            constraint.appendChild(constraintAllowedValues);
            for (int i = 0; i < methods.length; ++i) {
                String method = methods[i];
                Element value = doc.createElementNS("http://www.opengis.net/ows/1.1", "Value");
                value.setTextContent(method);
                constraintAllowedValues.appendChild(value);
            }
        }
        if (this.options.getCors().booleanValue()) {
            constraint = doc.createElementNS("http://www.opengis.net/ows/1.1", "Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:cors");
            get.appendChild(constraint);
            constraintNoValues = doc.createElementNS("http://www.opengis.net/ows/1.1", "NoValues");
            constraint.appendChild(constraintNoValues);
        }
        if (this.options.getHttpExceptionHandling().booleanValue()) {
            constraint = doc.createElementNS("http://www.opengis.net/ows/1.1", "Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:http-exception-handling");
            get.appendChild(constraint);
            constraintNoValues = doc.createElementNS("http://www.opengis.net/ows/1.1", "NoValues");
            constraint.appendChild(constraintNoValues);
        }
        return get;
    }

    private Element buildPostElement(Document doc, String href, String[] methods) {
        Element constraintNoValues;
        Element constraintAllowedValues;
        Element constraint;
        Element post = doc.createElementNS("http://www.opengis.net/ows/1.1", "Post");
        post.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        post.setAttribute("xlink:type", "simple");
        post.setAttribute("xlink:href", href);
        if (this.options.getAuthentication().equals("saml2") && this.options.getIdpUrl() != null) {
            constraint = doc.createElementNS("http://www.opengis.net/ows/1.1", "Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:authentication:saml2");
            post.appendChild(constraint);
            Element constraintValuesReference = doc.createElementNS("http://www.opengis.net/ows/1.1", "ValuesReference");
            constraintValuesReference.setAttributeNS("http://www.opengis.net/ows/1.1", "ows:reference", this.options.getIdpUrl());
            constraint.appendChild(constraintValuesReference);
        }
        if (this.options.getHttpMethods().booleanValue()) {
            constraint = doc.createElementNS("http://www.opengis.net/ows/1.1", "Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:http-methods");
            post.appendChild(constraint);
            constraintAllowedValues = doc.createElementNS("http://www.opengis.net/ows/1.1", "AllowedValues");
            constraint.appendChild(constraintAllowedValues);
            for (int i = 0; i < methods.length; ++i) {
                String method = methods[i];
                Element value = doc.createElementNS("http://www.opengis.net/ows/1.1", "Value");
                value.setTextContent(method);
                constraintAllowedValues.appendChild(value);
            }
        }
        if (this.options.getCors().booleanValue()) {
            constraint = doc.createElementNS("http://www.opengis.net/ows/1.1", "Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:cors");
            post.appendChild(constraint);
            constraintNoValues = doc.createElementNS("http://www.opengis.net/ows/1.1", "NoValues");
            constraint.appendChild(constraintNoValues);
        }
        if (this.options.getHttpExceptionHandling().booleanValue()) {
            constraint = doc.createElementNS("http://www.opengis.net/ows/1.1", "Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:http-exception-handling");
            post.appendChild(constraint);
            constraintNoValues = doc.createElementNS("http://www.opengis.net/ows/1.1", "NoValues");
            constraint.appendChild(constraintNoValues);
        }
        if (this.options.getHttpPostContentType().booleanValue()) {
            constraint = doc.createElementNS("http://www.opengis.net/ows/1.1", "Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:content-type");
            post.appendChild(constraint);
            constraintAllowedValues = doc.createElementNS("http://www.opengis.net/ows/1.1", "AllowedValues");
            constraint.appendChild(constraintAllowedValues);
            Element value = doc.createElementNS("http://www.opengis.net/ows/1.1", "Value");
            value.setTextContent("application/x-www-form-urlencoded");
            constraintAllowedValues.appendChild(value);
        }
        return post;
    }

    private Element buildExtendedSecurityCapabilities(Document doc, String href) {
        Element extendedSecurityCapabilities = doc.createElementNS("http://www.opengis.net/security/1.0", "ExtendedSecurityCapabilities");
        String completeCapabilitiesUrl = href + "/full";
        Element operationsMetadata = doc.createElementNS("http://www.opengis.net/ows/1.1", "OperationsMetadata");
        extendedSecurityCapabilities.appendChild(operationsMetadata);
        Element getCapabilities = doc.createElementNS("http://www.opengis.net/ows/1.1", "Operation");
        getCapabilities.setAttribute("name", "GetCapabilities");
        operationsMetadata.appendChild(getCapabilities);
        Element getCapabilitiesDcp = doc.createElementNS("http://www.opengis.net/ows/1.1", "DCP");
        getCapabilities.appendChild(getCapabilitiesDcp);
        Element getCapabilitiesDcpHttp = doc.createElementNS("http://www.opengis.net/ows/1.1", "HTTP");
        getCapabilitiesDcp.appendChild(getCapabilitiesDcpHttp);
        String[] getCapabilitiesMethods = new String[]{"GET", "POST"};
        Element getCapabilitiesDcpHttpGet = this.buildGetElement(doc, completeCapabilitiesUrl, getCapabilitiesMethods);
        getCapabilitiesDcpHttp.appendChild(getCapabilitiesDcpHttpGet);
        Element getCapabilitiesDcpHttpPost = this.buildPostElement(doc, completeCapabilitiesUrl, getCapabilitiesMethods);
        getCapabilitiesDcpHttp.appendChild(getCapabilitiesDcpHttpPost);
        Element getMap = doc.createElementNS("http://www.opengis.net/ows/1.1", "Operation");
        getMap.setAttribute("name", "GetMap");
        operationsMetadata.appendChild(getMap);
        Element getMapDcp = doc.createElementNS("http://www.opengis.net/ows/1.1", "DCP");
        getMap.appendChild(getMapDcp);
        Element getMapDcpHttp = doc.createElementNS("http://www.opengis.net/ows/1.1", "HTTP");
        getMapDcp.appendChild(getMapDcpHttp);
        String[] getMapMethods = new String[]{"GET"};
        Element getMapDcpHttpGet = this.buildGetElement(doc, completeCapabilitiesUrl, getMapMethods);
        getMapDcpHttp.appendChild(getMapDcpHttpGet);
        return extendedSecurityCapabilities;
    }

    public void buildException(String reason, HttpServletResponse response) throws TransformerException {
        response.setContentType("application/vnd.ogc.se_xml");
        response.setStatus(404);
        PrintWriter printWriter = this.getWriterForResponse(response);
        DOMImplementation domImplementation = this.documentBuilder.getDOMImplementation();
        Document doc = domImplementation.createDocument("http://www.opengis.net/ogc", "ServiceExceptionReport", null);
        Element rootElement = doc.getDocumentElement();
        rootElement.setAttribute("version", "1.3.0");
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        rootElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.opengis.net/ogc http://schemas.opengis.net/wms/1.3.0/exceptions_1_3_0.xsd");
        Element serviceException = doc.createElementNS("http://www.opengis.net/ogc", "ServiceException");
        serviceException.setTextContent(reason);
        rootElement.appendChild(serviceException);
        printWriter.print(XMLUtils.writeDocumentToString(doc, true));
    }
}

