/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.securityclient10.httpServer;

import java.io.PrintWriter;
import java.util.Enumeration;
import javax.xml.transform.TransformerException;
import org.opengis.cite.securityclient10.httpServer.EmulatedServer;
import org.opengis.cite.securityclient10.httpServer.ServerOptions;
import org.opengis.cite.securityclient10.util.XMLUtils;
import org.opengis.cite.servlet.http.HttpServletRequest;
import org.opengis.cite.servlet.http.HttpServletResponse;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ServerWps20
extends EmulatedServer {
    public ServerWps20(ServerOptions options) {
        this.documentFactory.setNamespaceAware(true);
        this.options = options;
    }

    @Override
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws TransformerException {
        System.out.println("Building WPS 2.0 Response");
        System.out.println("Query Params: " + request.getQueryString());
        this.enableCors(response);
        String serviceValue = null;
        String requestValue = null;
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String parameter = (String)e.nextElement();
            if (parameter.compareToIgnoreCase("service") == 0) {
                serviceValue = request.getParameter(parameter);
                continue;
            }
            if (parameter.compareToIgnoreCase("request") != 0) continue;
            requestValue = request.getParameter(parameter);
        }
        if (request.getPathInfo().endsWith("/saml2")) {
            if (this.validateSamlAuthenticationResponse(request, response)) {
                this.buildSecurityContext(request, response);
                this.buildCapabilities(request, response, true);
            }
        } else if (serviceValue == null || requestValue == null || !serviceValue.equals("WPS")) {
            this.buildInvalidParameterException(response);
        } else {
            switch (requestValue) {
                case "GetCapabilities": {
                    if (request.getPathInfo().endsWith("/full") && this.getAuthenticationEnabled()) {
                        if (!this.validateSecureRequest(request, response)) break;
                        this.buildCapabilities(request, response, true);
                        break;
                    }
                    this.buildCapabilities(request, response, false);
                    break;
                }
                default: {
                    this.buildNotSupportedException(response);
                }
            }
        }
    }

    private Element buildGetElement(Document doc, String href, String[] methods) {
        Element constraintNoValues;
        Element constraint;
        Element get = doc.createElementNS("http://www.opengis.net/ows/2.0", "Get");
        get.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", href);
        if (this.options.getAuthentication().equals("saml2") && this.options.getIdpUrl() != null) {
            constraint = doc.createElementNS("http://www.opengis.net/ows/2.0", "Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:authentication:saml2");
            get.appendChild(constraint);
            Element constraintValuesReference = doc.createElementNS("http://www.opengis.net/ows/2.0", "ValuesReference");
            constraintValuesReference.setAttributeNS("http://www.opengis.net/ows/2.0", "ows:reference", this.options.getIdpUrl());
            constraint.appendChild(constraintValuesReference);
        }
        if (this.options.getHttpMethods().booleanValue()) {
            constraint = doc.createElementNS("http://www.opengis.net/ows/2.0", "Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:http-methods");
            get.appendChild(constraint);
            Element constraintAllowedValues = doc.createElementNS("http://www.opengis.net/ows/2.0", "AllowedValues");
            constraint.appendChild(constraintAllowedValues);
            for (int i = 0; i < methods.length; ++i) {
                String method = methods[i];
                Element value = doc.createElementNS("http://www.opengis.net/ows/2.0", "Value");
                value.setTextContent(method);
                constraintAllowedValues.appendChild(value);
            }
        }
        if (this.options.getCors().booleanValue()) {
            constraint = doc.createElementNS("http://www.opengis.net/ows/2.0", "Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:cors");
            get.appendChild(constraint);
            constraintNoValues = doc.createElementNS("http://www.opengis.net/ows/2.0", "NoValues");
            constraint.appendChild(constraintNoValues);
        }
        if (this.options.getHttpExceptionHandling().booleanValue()) {
            constraint = doc.createElementNS("http://www.opengis.net/ows/2.0", "Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:http-exception-handling");
            get.appendChild(constraint);
            constraintNoValues = doc.createElementNS("http://www.opengis.net/ows/2.0", "NoValues");
            constraint.appendChild(constraintNoValues);
        }
        return get;
    }

    private Element buildPostElement(Document doc, String href, String[] methods) {
        Element constraintNoValues;
        Element constraintAllowedValues;
        Element constraint;
        Element post = doc.createElementNS("http://www.opengis.net/ows/2.0", "Post");
        post.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", href);
        if (this.options.getAuthentication().equals("saml2") && this.options.getIdpUrl() != null) {
            constraint = doc.createElementNS("http://www.opengis.net/ows/2.0", "Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:authentication:saml2");
            post.appendChild(constraint);
            Element constraintValuesReference = doc.createElementNS("http://www.opengis.net/ows/2.0", "ValuesReference");
            constraintValuesReference.setAttributeNS("http://www.opengis.net/ows/2.0", "ows:reference", this.options.getIdpUrl());
            constraint.appendChild(constraintValuesReference);
        }
        if (this.options.getHttpMethods().booleanValue()) {
            constraint = doc.createElementNS("http://www.opengis.net/ows/2.0", "Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:http-methods");
            post.appendChild(constraint);
            constraintAllowedValues = doc.createElementNS("http://www.opengis.net/ows/2.0", "AllowedValues");
            constraint.appendChild(constraintAllowedValues);
            for (int i = 0; i < methods.length; ++i) {
                String method = methods[i];
                Element value = doc.createElementNS("http://www.opengis.net/ows/2.0", "Value");
                value.setTextContent(method);
                constraintAllowedValues.appendChild(value);
            }
        }
        if (this.options.getCors().booleanValue()) {
            constraint = doc.createElementNS("http://www.opengis.net/ows/2.0", "Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:cors");
            post.appendChild(constraint);
            constraintNoValues = doc.createElementNS("http://www.opengis.net/ows/2.0", "NoValues");
            constraint.appendChild(constraintNoValues);
        }
        if (this.options.getHttpExceptionHandling().booleanValue()) {
            constraint = doc.createElementNS("http://www.opengis.net/ows/2.0", "Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:http-exception-handling");
            post.appendChild(constraint);
            constraintNoValues = doc.createElementNS("http://www.opengis.net/ows/2.0", "NoValues");
            constraint.appendChild(constraintNoValues);
        }
        if (this.options.getHttpPostContentType().booleanValue()) {
            constraint = doc.createElementNS("http://www.opengis.net/ows/2.0", "Constraint");
            constraint.setAttribute("name", "urn:ogc:def:security:1.0:rc:content-type");
            post.appendChild(constraint);
            constraintAllowedValues = doc.createElementNS("http://www.opengis.net/ows/2.0", "AllowedValues");
            constraint.appendChild(constraintAllowedValues);
            Element value = doc.createElementNS("http://www.opengis.net/ows/2.0", "Value");
            value.setTextContent("application/x-www-form-urlencoded");
            constraintAllowedValues.appendChild(value);
        }
        return post;
    }

    public void buildCapabilities(HttpServletRequest request, HttpServletResponse response, boolean completeCapabilities) throws TransformerException {
        response.setContentType("text/xml");
        response.setStatus(200);
        boolean samlAuth = this.options.getAuthentication().equals("saml2") && this.options.getIdpUrl() != null;
        String baseHref = ServerWps20.getUri(request, false);
        String href = samlAuth ? baseHref + "/full" : baseHref;
        PrintWriter printWriter = this.getWriterForResponse(response);
        DOMImplementation domImplementation = this.documentBuilder.getDOMImplementation();
        Document doc = domImplementation.createDocument("http://www.opengis.net/wps/2.0", "wps:Capabilities", null);
        Element rootElement = doc.getDocumentElement();
        rootElement.setAttribute("service", "WPS");
        rootElement.setAttribute("version", "2.0.0");
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ows", "http://www.opengis.net/ows/2.0");
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wps", "http://www.opengis.net/wps/2.0");
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xlink", "http://www.w3.org/1999/xlink");
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xml", "http://www.w3.org/XML/1998/namespace");
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        rootElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.opengis.net/wps/2.0 http://schemas.opengis.net/wps/2.0/wps.xsd");
        Element serviceIdentification = doc.createElementNS("http://www.opengis.net/ows/2.0", "ows:ServiceIdentification");
        rootElement.appendChild(serviceIdentification);
        Element title = doc.createElementNS("http://www.opengis.net/ows/2.0", "ows:Title");
        title.setTextContent("ETS Security Client 1.0 WPS 2.0");
        serviceIdentification.appendChild(title);
        Element abstractElement = doc.createElementNS("http://www.opengis.net/ows/2.0", "ows:Abstract");
        abstractElement.setTextContent("WPS 2.0 for validating secure client requests under ETS Security Client 1.0");
        serviceIdentification.appendChild(abstractElement);
        Element serviceType = doc.createElementNS("http://www.opengis.net/ows/2.0", "ows:ServiceType");
        serviceType.setTextContent("WPS");
        serviceIdentification.appendChild(serviceType);
        Element serviceTypeVersion = doc.createElementNS("http://www.opengis.net/ows/2.0", "ows:ServiceTypeVersion");
        serviceTypeVersion.setTextContent("2.0.0");
        serviceIdentification.appendChild(serviceTypeVersion);
        Element fees = doc.createElementNS("http://www.opengis.net/ows/2.0", "ows:Fees");
        fees.setTextContent("NONE");
        serviceIdentification.appendChild(fees);
        Element accessConstraints = doc.createElementNS("http://www.opengis.net/ows/2.0", "ows:AccessConstraints");
        accessConstraints.setTextContent("NONE");
        serviceIdentification.appendChild(accessConstraints);
        Element operationsMetadata = doc.createElementNS("http://www.opengis.net/ows/2.0", "ows:OperationsMetadata");
        rootElement.appendChild(operationsMetadata);
        Element getCapabilities = doc.createElementNS("http://www.opengis.net/ows/2.0", "ows:Operation");
        getCapabilities.setAttribute("name", "GetCapabilities");
        operationsMetadata.appendChild(getCapabilities);
        Element getCapabilitiesDcp = doc.createElementNS("http://www.opengis.net/ows/2.0", "ows:DCP");
        getCapabilities.appendChild(getCapabilitiesDcp);
        Element getCapabilitiesDcpHttp = doc.createElementNS("http://www.opengis.net/ows/2.0", "ows:HTTP");
        getCapabilitiesDcp.appendChild(getCapabilitiesDcpHttp);
        String[] getCapabilitiesMethods = new String[]{"GET", "POST"};
        Element getCapabilitiesDcpHttpGet = this.buildGetElement(doc, href, getCapabilitiesMethods);
        getCapabilitiesDcpHttp.appendChild(getCapabilitiesDcpHttpGet);
        Element getCapabilitiesDcpHttpPost = this.buildPostElement(doc, href, getCapabilitiesMethods);
        getCapabilitiesDcpHttp.appendChild(getCapabilitiesDcpHttpPost);
        Element describeProcess = doc.createElementNS("http://www.opengis.net/ows/2.0", "ows:Operation");
        describeProcess.setAttribute("name", "DescribeProcess");
        operationsMetadata.appendChild(describeProcess);
        Element describeProcessDcp = doc.createElementNS("http://www.opengis.net/ows/2.0", "ows:DCP");
        describeProcess.appendChild(describeProcessDcp);
        Element describeProcessDcpHttp = doc.createElementNS("http://www.opengis.net/ows/2.0", "ows:HTTP");
        describeProcessDcp.appendChild(describeProcessDcpHttp);
        String[] describeProcessMethods = new String[]{"GET", "POST"};
        Element describeProcessDcpHttpGet = this.buildGetElement(doc, href, describeProcessMethods);
        describeProcessDcpHttp.appendChild(describeProcessDcpHttpGet);
        Element describeProcessDcpHttpPost = this.buildPostElement(doc, href, describeProcessMethods);
        describeProcessDcpHttp.appendChild(describeProcessDcpHttpPost);
        if (completeCapabilities) {
            Element contents = doc.createElementNS("http://www.opengis.net/wps/2.0", "wps:Contents");
            rootElement.appendChild(contents);
            Element processSummary = doc.createElementNS("http://www.opengis.net/wps/2.0", "wps:ProcessSummary");
            processSummary.setAttribute("jobControlOptions", "sync-execute dismiss");
            contents.appendChild(processSummary);
            Element processTitle = doc.createElementNS("http://www.opengis.net/ows/2.0", "ows:Title");
            processTitle.setTextContent("False Process");
            processSummary.appendChild(processTitle);
            Element processIdentifier = doc.createElementNS("http://www.opengis.net/ows/2.0", "ows:Identifier");
            processIdentifier.setTextContent(href + "/false-process");
            processSummary.appendChild(processIdentifier);
        }
        printWriter.print(XMLUtils.writeDocumentToString(doc, true));
    }

    public void buildException(String reason, int code, HttpServletResponse response) throws TransformerException {
        response.setContentType("text/xml");
        response.setStatus(code);
        PrintWriter printWriter = this.getWriterForResponse(response);
        DOMImplementation domImplementation = this.documentBuilder.getDOMImplementation();
        Document doc = domImplementation.createDocument("http://www.opengis.net/ows/2.0", "ExceptionReport", null);
        Element rootElement = doc.getDocumentElement();
        rootElement.setAttribute("version", "1.0.0");
        rootElement.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", "en");
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        rootElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.opengis.net/ows/2.0 http://schemas.opengis.net/ows/2.0/owsExceptionReport.xsd");
        Element exceptionElement = doc.createElementNS("http://www.opengis.net/ows/2.0", "Exception");
        exceptionElement.setAttribute("exceptionCode", reason);
        rootElement.appendChild(exceptionElement);
        printWriter.print(XMLUtils.writeDocumentToString(doc, true));
    }

    public void buildInvalidParameterException(HttpServletResponse response) throws TransformerException {
        this.buildException("InvalidParameterValue", 400, response);
    }

    public void buildNotSupportedException(HttpServletResponse response) throws TransformerException {
        this.buildException("OperationNotSupported", 501, response);
    }
}

