/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.securityclient10;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.occamlab.te.spi.executors.TestRunExecutor;
import com.occamlab.te.spi.executors.testng.TestNGExecutor;
import com.occamlab.te.spi.jaxrs.TestSuiteController;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.opengis.cite.securityclient10.CommandLineArguments;
import org.opengis.cite.securityclient10.TestRunArg;
import org.opengis.cite.securityclient10.TestRunArgValidator;
import org.opengis.cite.securityclient10.httpServer.RequestRepresenter;
import org.opengis.cite.securityclient10.httpServer.ServerOptions;
import org.opengis.cite.securityclient10.httpServer.TestServer;
import org.opengis.cite.securityclient10.util.PropertiesDocument;
import org.opengis.cite.securityclient10.util.TestSuiteLogger;
import org.opengis.cite.servlet.ServletException;
import org.w3c.dom.Document;

public class TestNGController
implements TestSuiteController {
    private static final Logger LOG = Logger.getLogger(TestNGController.class.getName());
    private TestRunExecutor executor;
    private Properties etsProperties = new Properties();
    private static volatile TestServer httpServer;

    public static void main(String[] args) throws Exception {
        CommandLineArguments testRunArgs = new CommandLineArguments();
        JCommander cmd = new JCommander((Object)testRunArgs);
        try {
            cmd.parse(args);
        }
        catch (ParameterException px) {
            System.out.println(px.getMessage());
            cmd.usage();
        }
        if (testRunArgs.doDeleteSubjectOnFinish()) {
            System.setProperty("deleteSubjectOnFinish", "true");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        File xmlArgs = testRunArgs.getPropertiesFile();
        Document testRunProps = db.parse(xmlArgs);
        TestNGController controller = new TestNGController(testRunArgs.getOutputDir());
        Source testResults = controller.doTestRun(testRunProps);
        System.out.println("Test results: " + testResults.getSystemId());
        TestServer server = TestNGController.getServer();
        if (server != null) {
            server.shutdown();
        }
    }

    public TestNGController() {
        this(System.getProperty("java.io.tmpdir"));
    }

    public TestNGController(String outputDir) {
        InputStream is = this.getClass().getResourceAsStream("ets.properties");
        try {
            this.etsProperties.load(is);
        }
        catch (IOException ex) {
            TestSuiteLogger.log(Level.WARNING, "Unable to load ets.properties. " + ex.getMessage());
        }
        URL tngSuite = TestNGController.class.getResource("testng.xml");
        File resultsDir = null == outputDir || outputDir.isEmpty() ? new File(System.getProperty("user.home")) : (outputDir.startsWith("file:") ? new File(URI.create(outputDir)) : new File(outputDir));
        TestSuiteLogger.log(Level.CONFIG, "Using TestNG config: " + tngSuite);
        TestSuiteLogger.log(Level.CONFIG, "Using outputDirPath: " + resultsDir.getAbsolutePath());
        this.executor = new TestNGExecutor(tngSuite.toString(), resultsDir.getAbsolutePath(), false);
    }

    public String getCode() {
        return this.etsProperties.getProperty("ets-code");
    }

    public String getTitle() {
        return this.etsProperties.getProperty("ets-title");
    }

    public String getVersion() {
        return this.etsProperties.getProperty("ets-version");
    }

    public Source doTestRun(Document testRunArgs) throws ParserConfigurationException {
        TestServer server;
        PropertiesDocument testRunProperties;
        try {
            testRunProperties = new PropertiesDocument(testRunArgs);
        }
        catch (TransformerFactoryConfigurationError e1) {
            e1.printStackTrace();
            return this.executeWithException(e1);
        }
        this.validateTestRunArgs(testRunProperties);
        String serviceType = testRunProperties.getProperty(TestRunArg.Service_Type.toString());
        boolean hasHttpMethods = this.parseBooleanProperty(testRunProperties, TestRunArg.HTTP_METHODS);
        boolean hasW3CCors = this.parseBooleanProperty(testRunProperties, TestRunArg.W3C_CORS);
        boolean hasExceptionHandling = this.parseBooleanProperty(testRunProperties, TestRunArg.HTTP_EXCEPTION_HANDLING);
        boolean hasPostContentType = this.parseBooleanProperty(testRunProperties, TestRunArg.HTTP_POST_CONTENT_TYPE);
        String auth = testRunProperties.getProperty(TestRunArg.Authentication.toString());
        if (hasW3CCors) {
            hasHttpMethods = true;
        }
        this.logConformanceClasses(serviceType, hasHttpMethods, hasW3CCors, hasExceptionHandling, hasPostContentType, auth);
        try {
            server = TestNGController.getServer(testRunProperties.getProperty(TestRunArg.Address.toString()), Integer.parseInt(testRunProperties.getProperty(TestRunArg.Port.toString())), testRunProperties.getProperty(TestRunArg.JKS_Path.toString()), testRunProperties.getProperty(TestRunArg.JKS_Password.toString()));
        }
        catch (Exception e) {
            return this.executeWithException(e);
        }
        String path = testRunProperties.getProperty(TestRunArg.Path.toString()) == "" ? this.getNonce() : testRunProperties.getProperty(TestRunArg.Path.toString());
        ServerOptions serverOptions = new ServerOptions(serviceType);
        serverOptions.setAuthentication(auth);
        serverOptions.setIdpUrl(testRunProperties.getProperty(TestRunArg.IDP_URL.toString()));
        serverOptions.setHttpMethods(hasHttpMethods);
        serverOptions.setCors(hasW3CCors);
        serverOptions.setHttpExceptionHandling(hasExceptionHandling);
        serverOptions.setHttpPostContentType(hasPostContentType);
        try {
            server.registerHandler(path, serverOptions);
        }
        catch (Exception e) {
            return this.executeWithException(e);
        }
        System.out.println(String.format("Your test session endpoint is at https://%s:%s/%s", testRunProperties.getProperty(TestRunArg.Host.toString()), testRunProperties.getProperty(TestRunArg.Port.toString()), path));
        try {
            server.waitForRequest(path);
        }
        catch (InterruptedException | ExecutionException e) {
            return this.executeWithException(e);
        }
        RequestRepresenter requests = server.getRequests(path);
        String nonce = this.getNonce();
        Path requestsFilePath = Paths.get(System.getProperty("java.io.tmpdir"), "requests-" + nonce + ".xml");
        try {
            requests.saveToPath(requestsFilePath);
        }
        catch (FileNotFoundException | TransformerException e) {
            return this.executeWithException(e);
        }
        testRunProperties.setProperty(TestRunArg.IUT.toString(), requestsFilePath.toAbsolutePath().toString());
        try {
            server.unregisterHandler(path);
        }
        catch (ServletException e) {
            return this.executeWithException(e);
        }
        testRunProperties.removeProperty(TestRunArg.JKS_Path.toString());
        testRunProperties.removeProperty(TestRunArg.JKS_Password.toString());
        return this.executor.execute(testRunProperties.getDocument());
    }

    private static TestServer getServer(String address, int port, String jks_path, String jks_password) throws Exception {
        if (null == httpServer && httpServer == null) {
            httpServer = new TestServer(address, port, jks_path, jks_password);
        }
        return httpServer;
    }

    private static TestServer getServer() {
        return httpServer;
    }

    private String getNonce() {
        String symbols = "abcdefghijklmnopqrstuvwxyz0123456789";
        SecureRandom random = new SecureRandom();
        char[] bytes = new char[16];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = symbols.charAt(random.nextInt(symbols.length()));
        }
        return String.valueOf(bytes);
    }

    private Source executeWithException(Throwable e) {
        LOG.log(Level.SEVERE, "Failure", e);
        PropertiesDocument testRunProperties = new PropertiesDocument();
        testRunProperties.setProperty(e.getClass().toString(), e.getMessage());
        return this.executor.execute(testRunProperties.getDocument());
    }

    private void validateTestRunArgs(PropertiesDocument testRunProperties) {
        TestRunArgValidator.validateProperties(testRunProperties.getProperties());
    }

    private boolean parseBooleanProperty(PropertiesDocument testRunProperties, TestRunArg httpMethods2) {
        String httpMethods = testRunProperties.getProperty(httpMethods2.toString());
        return httpMethods != null && httpMethods.equals("true");
    }

    private void logConformanceClasses(String serviceType, boolean hasHttpMethods, boolean hasW3CCors, boolean hasExceptionHandling, boolean hasPostContentType, String auth) {
        System.out.println("ETS Security Client 1.0 Active Conformance Classes");
        System.out.println("==================================================");
        System.out.println("* Abstract Conformance Class Common Security");
        if (serviceType.equals("wms111")) {
            System.out.println("* Conformance Class WMS 1.1.1");
        } else if (serviceType.equals("wms13")) {
            System.out.println("* Conformance Class WMS 1.3.0");
        } else {
            System.out.println("* Conformance Class OWS Common");
        }
        if (hasHttpMethods) {
            System.out.println("* HTTP Methods annotation enabled");
        }
        if (hasW3CCors) {
            System.out.println("* W3C CORS annotation enabled");
        }
        if (hasExceptionHandling) {
            System.out.println("* HTTP Exception Handling annotation enabled");
        }
        if (hasPostContentType) {
            System.out.println("* HTTP POST Content-Type annotation enabled");
        }
        if (auth != null && auth.equals("saml2")) {
            System.out.println("* SAML 2.0 Authentication Required");
        }
        System.out.println("==================================================");
    }
}

