/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.securityclient10;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.opengis.cite.securityclient10.TestRunArg;

public class TestRunArgValidator {
    private static final String[] allowedServiceTypes = new String[]{"wms111", "wms13", "wps20"};

    public static void validateMap(Map<String, String> params) {
        String serviceTypeParam = params.get(TestRunArg.Service_Type.toString());
        if (null == serviceTypeParam || serviceTypeParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.Service_Type.toString());
        }
        if (Arrays.stream(allowedServiceTypes).noneMatch(serviceTypeParam::equals)) {
            throw new IllegalArgumentException("Unsupported service type in test run properties: " + serviceTypeParam);
        }
        String addressParam = params.get(TestRunArg.Address.toString());
        if (null == addressParam || addressParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.Address.toString());
        }
        Integer portParam = Integer.parseInt(params.get(TestRunArg.Port.toString()));
        String hostParam = params.get(TestRunArg.Host.toString());
        if (null == hostParam || hostParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.Host.toString());
        }
        String pathParam = params.get(TestRunArg.Path.toString());
        String jksParam = params.get(TestRunArg.JKS_Path.toString());
        if (null == jksParam || jksParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.JKS_Path.toString());
        }
        String jksPassParam = params.get(TestRunArg.JKS_Password.toString());
        if (null == jksPassParam || jksPassParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.JKS_Password.toString());
        }
        String authentication = params.get(TestRunArg.Authentication.toString());
        String idpUrl = params.get(TestRunArg.IDP_URL.toString());
        String httpMethods = params.get(TestRunArg.HTTP_METHODS.toString());
        Boolean hasHttpMethods = httpMethods != null && httpMethods.equals("true");
        String w3cCors = params.get(TestRunArg.W3C_CORS.toString());
        Boolean hasW3cCors = w3cCors != null && w3cCors.equals("true");
        String httpExceptionHandling = params.get(TestRunArg.HTTP_EXCEPTION_HANDLING.toString());
        Boolean hasExceptionHandling = httpExceptionHandling != null && httpExceptionHandling.equals("true");
        String httpPostContentType = params.get(TestRunArg.HTTP_POST_CONTENT_TYPE.toString());
        Boolean hasPostContentType = httpPostContentType != null && httpPostContentType.equals("true");
        String iutParam = params.get(TestRunArg.IUT.toString());
    }

    public static void validateProperties(Properties properties) {
        HashMap<String, String> args = new HashMap<String, String>();
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            args.put(key, properties.getProperty(key));
        }
        TestRunArgValidator.validateMap(args);
    }
}

