/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.jetty.http;

import org.opengis.cite.jetty.http.BadMessageException;
import org.opengis.cite.jetty.http.HttpField;
import org.opengis.cite.jetty.http.HttpHeader;
import org.opengis.cite.jetty.util.HostPort;

public class HostPortHttpField
extends HttpField {
    final HostPort _hostPort;

    public HostPortHttpField(String authority) {
        this(HttpHeader.HOST, HttpHeader.HOST.asString(), authority);
    }

    protected HostPortHttpField(HttpHeader header, String name, String authority) {
        super(header, name, authority);
        try {
            this._hostPort = new HostPort(authority);
        }
        catch (Exception e) {
            throw new BadMessageException(400, "Bad HostPort", e);
        }
    }

    public HostPortHttpField(String host, int port) {
        this(new HostPort(host, port));
    }

    public HostPortHttpField(HostPort hostport) {
        super(HttpHeader.HOST, HttpHeader.HOST.asString(), hostport.toString());
        this._hostPort = hostport;
    }

    public String getHost() {
        return this._hostPort.getHost();
    }

    public int getPort() {
        return this._hostPort.getPort();
    }

    public int getPort(int defaultPort) {
        return this._hostPort.getPort(defaultPort);
    }

    public HostPort getHostPort() {
        return this._hostPort;
    }
}

