/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.securityclient10.httpServer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.zip.DeflaterOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.opengis.cite.securityclient10.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SamlAuthRequest {
    private DocumentBuilderFactory documentFactory;
    private DocumentBuilder documentBuilder;
    private TransformerFactory transformerFactory;
    private Transformer transformer;
    private Document doc;
    private String href;

    public SamlAuthRequest(String href) {
        this.href = href;
        try {
            this.documentFactory = DocumentBuilderFactory.newInstance();
            this.documentFactory.setNamespaceAware(true);
            this.documentBuilder = this.documentFactory.newDocumentBuilder();
            this.transformerFactory = TransformerFactory.newInstance();
            this.transformer = this.transformerFactory.newTransformer();
        }
        catch (ParserConfigurationException | TransformerConfigurationException e) {
            e.printStackTrace();
        }
        this.transformer.setOutputProperty("indent", "yes");
        this.transformer.setOutputProperty("omit-xml-declaration", "yes");
        this.transformer.setOutputProperty("method", "xml");
        this.buildDocument();
    }

    public String toUrlParameterString() throws TransformerException {
        String plain = XMLUtils.writeDocumentToString(this.doc, false);
        return this.deflateAndBase64String(plain);
    }

    private void buildDocument() {
        this.doc = this.documentBuilder.newDocument();
        Element rootElement = this.doc.createElement("samlp:AuthnRequest");
        rootElement.setAttribute("xmlns:samlp", "urn:oasis:names:tc:SAML:2.0:protocol");
        rootElement.setAttribute("xmlns:saml", "urn:oasis:names:tc:SAML:2.0:assertion");
        rootElement.setAttribute("ID", "identifier_1");
        rootElement.setAttribute("Version", "2.0");
        ZonedDateTime date = ZonedDateTime.now(ZoneId.of("UTC"));
        rootElement.setAttribute("IssueInstant", date.toString());
        rootElement.setAttribute("AssertionConsumerServiceURL", this.href + "/saml2");
        this.doc.appendChild(rootElement);
        Element issuer = this.doc.createElement("saml:Issuer");
        issuer.setTextContent(this.href);
        rootElement.appendChild(issuer);
        Element nameIdPolicy = this.doc.createElement("samlp:NameIDPolicy");
        nameIdPolicy.setAttribute("AllowCreate", "true");
        nameIdPolicy.setAttribute("Format", "urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        rootElement.appendChild(nameIdPolicy);
    }

    private String deflateAndBase64String(String input) {
        byte[] inputBytes = null;
        try {
            inputBytes = input.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DeflaterOutputStream outputStream = new DeflaterOutputStream(output);
        String base64String = null;
        try {
            outputStream.write(inputBytes, 0, inputBytes.length);
            outputStream.close();
            byte[] encodedBytes = Base64.getEncoder().encode(output.toByteArray());
            base64String = new String(encodedBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String outputString = null;
        try {
            outputString = URLEncoder.encode(base64String, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return outputString;
    }
}

