/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.securityclient10.httpServer;

public class ServerOptions {
    private String authentication;
    private Boolean cors;
    private Boolean httpExceptionHandling;
    private Boolean httpMethods;
    private Boolean httpPostContentType;
    private String idpUrl;
    private String serviceType;

    public ServerOptions(String serviceType) {
        this.serviceType = serviceType;
        this.authentication = "none";
        this.cors = false;
        this.httpExceptionHandling = false;
        this.httpMethods = false;
        this.httpPostContentType = false;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public int getExpectedRequestCount() {
        if (this.authentication.equals("none")) {
            return 1;
        }
        if (this.authentication.equals("saml2") && this.idpUrl != null) {
            return 3;
        }
        return 1;
    }

    public Boolean getCors() {
        return this.cors;
    }

    public Boolean getHttpExceptionHandling() {
        return this.httpExceptionHandling;
    }

    public Boolean getHttpPostContentType() {
        return this.httpPostContentType;
    }

    public Boolean getHttpMethods() {
        return this.httpMethods;
    }

    public String getIdpUrl() {
        return this.idpUrl;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setAuthentication(String auth) {
        if (auth != null && !auth.isEmpty()) {
            this.authentication = auth;
        }
    }

    public void setCors(boolean enabled) {
        this.cors = enabled;
    }

    public void setHttpExceptionHandling(boolean enabled) {
        this.httpExceptionHandling = enabled;
    }

    public void setHttpMethods(boolean enabled) {
        this.httpMethods = enabled;
    }

    public void setHttpPostContentType(boolean enabled) {
        this.httpPostContentType = enabled;
    }

    public void setIdpUrl(String url) {
        this.idpUrl = url == null || url.isEmpty() ? null : url;
    }
}

