/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.securityclient10.httpServer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.transform.TransformerException;
import org.opengis.cite.jetty.http.HttpVersion;
import org.opengis.cite.jetty.http.pathmap.MappedResource;
import org.opengis.cite.jetty.server.ConnectionFactory;
import org.opengis.cite.jetty.server.Connector;
import org.opengis.cite.jetty.server.Handler;
import org.opengis.cite.jetty.server.HttpConfiguration;
import org.opengis.cite.jetty.server.HttpConnectionFactory;
import org.opengis.cite.jetty.server.SecureRequestCustomizer;
import org.opengis.cite.jetty.server.Server;
import org.opengis.cite.jetty.server.ServerConnector;
import org.opengis.cite.jetty.server.handler.ContextHandlerCollection;
import org.opengis.cite.jetty.servlet.ServletContextHandler;
import org.opengis.cite.jetty.servlet.ServletHandler;
import org.opengis.cite.jetty.servlet.ServletHolder;
import org.opengis.cite.jetty.util.ssl.SslContextFactory;
import org.opengis.cite.securityclient10.httpServer.EmulatedServer;
import org.opengis.cite.securityclient10.httpServer.HandlerOptions;
import org.opengis.cite.securityclient10.httpServer.RequestRepresenter;
import org.opengis.cite.securityclient10.httpServer.ServerOptions;
import org.opengis.cite.securityclient10.httpServer.ServerWms111;
import org.opengis.cite.securityclient10.httpServer.ServerWms13;
import org.opengis.cite.securityclient10.httpServer.ServerWps20;
import org.opengis.cite.securityclient10.httpServer.UnifiedSslConnectionFactory;
import org.opengis.cite.servlet.AsyncContext;
import org.opengis.cite.servlet.ServletException;
import org.opengis.cite.servlet.http.HttpServlet;
import org.opengis.cite.servlet.http.HttpServletRequest;
import org.opengis.cite.servlet.http.HttpServletResponse;

public class TestServer {
    private int serverPort;
    private Server jettyServer;
    private ContextHandlerCollection serverHandlers;
    private static volatile HashMap<String, HandlerOptions> handlerBlocks;

    public TestServer(String host, int port, String jks_path, String jks_password) throws Exception {
        handlerBlocks = new HashMap();
        this.serverPort = port;
        this.jettyServer = new Server();
        this.jettyServer.setStopAtShutdown(true);
        this.jettyServer.setStopTimeout(1L);
        File keystore = new File(jks_path);
        if (!keystore.exists()) {
            throw new FileNotFoundException("Missing keystore: " + keystore.getAbsolutePath());
        }
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(keystore.getAbsolutePath());
        sslContextFactory.setKeyStorePassword(jks_password);
        sslContextFactory.setTrustStorePath(keystore.getAbsolutePath());
        sslContextFactory.setTrustStorePassword(jks_password);
        HttpConfiguration httpsConfig = new HttpConfiguration();
        httpsConfig.setSecureScheme("https");
        httpsConfig.setSecurePort(port);
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        ServerConnector connector = new ServerConnector(this.jettyServer, new ConnectionFactory[]{new UnifiedSslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
        connector.setPort(port);
        connector.setHost(host);
        this.jettyServer.setConnectors(new Connector[]{connector});
        this.serverHandlers = new ContextHandlerCollection();
        this.jettyServer.setHandler((Handler)this.serverHandlers);
        this.jettyServer.start();
    }

    public int getPort() {
        return this.serverPort;
    }

    public RequestRepresenter getRequests(String path) {
        HandlerOptions options = handlerBlocks.get(path);
        if (options == null) {
            return null;
        }
        return options.getRequests();
    }

    public void registerHandler(String path, ServerOptions serverOptions) throws Exception {
        HandlerOptions options = new HandlerOptions(serverOptions);
        handlerBlocks.put(path, options);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        ServletHolder baseHolder = context.addServlet(TestAsyncServlet.class, "/" + path);
        baseHolder.setAsyncSupported(true);
        ServletHolder wildcardHolder = context.addServlet(TestAsyncServlet.class, "/" + path + "/*");
        wildcardHolder.setAsyncSupported(true);
        this.serverHandlers.addHandler((Handler)context);
        context.start();
    }

    public void shutdown() throws Exception {
        this.jettyServer.stop();
    }

    public void unregisterHandler(String path) throws ServletException {
        Handler[] handlers;
        for (Handler context : handlers = this.serverHandlers.getHandlers()) {
            ServletHandler servletHandler;
            MappedResource a;
            if (context.getClass() != ServletContextHandler.class || (a = (servletHandler = ((ServletContextHandler)context).getServletHandler()).getMappedServlet("/" + path)) == null) continue;
            this.serverHandlers.removeHandler(context);
            break;
        }
    }

    public void waitForRequest(String path) throws InterruptedException, ExecutionException {
        HandlerOptions options = handlerBlocks.get(path);
        options.setReceived(false);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<String> future = executor.submit(new WaitTask(path));
        try {
            System.out.println("Started wait.");
            System.out.println(future.get(300L, TimeUnit.SECONDS));
            System.out.println("Finished!");
        }
        catch (TimeoutException e) {
            future.cancel(true);
            System.out.println("Terminated!");
        }
        executor.shutdownNow();
    }

    class WaitTask
    implements Callable<String> {
        private String path;

        public WaitTask(String path) {
            this.path = path;
        }

        @Override
        public String call() throws Exception {
            System.out.println("Waiting\u2026");
            HandlerOptions options = (HandlerOptions)handlerBlocks.get(this.path);
            while (!options.getReceived().booleanValue()) {
                Thread.sleep(1000L);
            }
            return "";
        }
    }

    public static class TestAsyncServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            this.handleRequest(request, response);
        }

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            this.handleRequest(request, response);
        }

        protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            this.handleRequest(request, response);
        }

        protected void handleRequest(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
            final AsyncContext ctxt = request.startAsync();
            final String path = request.getServletPath().substring(1);
            ctxt.start(new Runnable(){
                private EmulatedServer emulated;

                @Override
                public void run() {
                    System.out.println("Request received.");
                    System.out.printf("Path: %s\n", request.getPathInfo());
                    System.out.printf("HTTP Method: %s\n", request.getMethod());
                    System.out.printf("Is Secure: %s\n", request.isSecure() ? "true" : "false");
                    System.out.printf("Query String: %s\n", request.getQueryString());
                    System.out.printf("Auth Type: %s\n", request.getAuthType());
                    System.out.println("Request Headers:");
                    Enumeration headers = request.getHeaderNames();
                    while (headers.hasMoreElements()) {
                        String headerName = (String)headers.nextElement();
                        String headerValue = request.getHeader(headerName);
                        System.out.printf("%s: %s\n", headerName, headerValue);
                    }
                    System.out.println();
                    String nonce = path.split("/")[0];
                    HandlerOptions options = (HandlerOptions)handlerBlocks.get(nonce);
                    try {
                        options.saveRequest(request);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    ServerOptions serverOptions = options.getServerOptions();
                    String serviceType = serverOptions.getServiceType();
                    if (serviceType.equals("wms111")) {
                        this.emulated = new ServerWms111(serverOptions);
                    } else if (serviceType.equals("wms13")) {
                        this.emulated = new ServerWms13(serverOptions);
                    } else if (serviceType.equals("wps20")) {
                        this.emulated = new ServerWps20(serverOptions);
                    } else {
                        System.err.println("Unknown service type for emulation: " + serviceType);
                    }
                    if (this.emulated != null) {
                        try {
                            this.emulated.handleRequest(request, response);
                        }
                        catch (IOException | TransformerException e) {
                            e.printStackTrace();
                        }
                    }
                    if (options.getRequestCount() == serverOptions.getExpectedRequestCount()) {
                        options.setReceived(true);
                    }
                    ctxt.complete();
                }
            });
        }
    }
}

