/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.sensorml20.level2;

import java.net.URL;
import java.util.ArrayList;
import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.sensorml20.BaseFixture;
import org.opengis.cite.sensorml20.ETSAssert;
import org.opengis.cite.sensorml20.util.DocumentTools;
import org.opengis.cite.sensorml20.util.UrlValidate;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AggregateProcessSchema
extends BaseFixture {
    @Test(description="B.3.1 - Requirement 64")
    public void AggregateProcessSchemaValid() {
        DOMSource source = new DOMSource(this.testSubject);
        URL schRef = this.getClass().getResource("/org/opengis/cite/sensorml20/sch/aggregate_process.sch");
        ETSAssert.assertSchematronValid(schRef, source);
    }

    @Test(description="B.3.2 - Requirement 65")
    public void ComponentReference() {
        NodeList componentNodes = this.testSubject.getDocumentElement().getElementsByTagName("sml:component");
        for (int i = 0; i < componentNodes.getLength(); ++i) {
            Node component = componentNodes.item(i);
            ArrayList<Node> componentChilds = DocumentTools.getAllNode(component);
            Boolean isRef = false;
            for (int j = 0; j < componentChilds.size(); ++j) {
                Element comChild;
                if (componentChilds.get(j).getLocalName() == null || !(comChild = (Element)componentChilds.get(j)).getNodeName().equals("sml:setValue") || !comChild.hasAttribute("ref")) continue;
                isRef = true;
                break;
            }
            if (!isRef.booleanValue()) continue;
            ArrayList<String> uids = new ArrayList<String>();
            NodeList identifiers = this.testSubject.getDocumentElement().getElementsByTagName("gml:identifier");
            for (int identifiersCount = 0; identifiersCount < identifiers.getLength(); ++identifiersCount) {
                uids.add(identifiers.item(identifiersCount).getTextContent());
            }
            for (int j = 0; j < componentChilds.size(); ++j) {
                String titleAttribute;
                if (componentChilds.get(j).getLocalName() == null || !componentChilds.get(j).getNodeName().equals("sml:typeOf")) continue;
                Element comChild = (Element)componentChilds.get(j);
                if (comChild.hasAttribute("xlink:title")) {
                    titleAttribute = comChild.getAttribute("xlink:title");
                    if (uids.contains(titleAttribute)) {
                        throw new AssertionError((Object)"value of xlink:title attribute shall be a uniqueID");
                    }
                } else {
                    throw new AssertionError((Object)"component property shall require meaningful values for the xlink:title");
                }
                uids.add(titleAttribute);
                if (comChild.hasAttribute("xlink:href")) {
                    if (!UrlValidate.ValidateHttpUrl(comChild.getAttribute("xlink:href")).booleanValue()) {
                        throw new AssertionError((Object)"component shall define a resolvable URL for reference");
                    }
                    continue;
                }
                throw new AssertionError((Object)"component property shall require meaningful values for the xlink:href");
            }
        }
    }

    @Test(description="B.3.2 - Requirement 66")
    public void InputConnectionRestrictions() {
        NodeList inputNodes = this.testSubject.getDocumentElement().getElementsByTagName("sml:input");
        NodeList connectNodes = this.testSubject.getDocumentElement().getElementsByTagName("sml:connection");
        for (int connectCount = 0; connectCount < connectNodes.getLength(); ++connectCount) {
            if (!connectNodes.item(connectCount).hasChildNodes()) continue;
            NodeList linkNodes = connectNodes.item(connectCount).getChildNodes();
            for (int linkCount = 0; linkCount < linkNodes.getLength(); ++linkCount) {
                Node link = linkNodes.item(linkCount);
                if (link.getLocalName() == null || !link.getNodeName().equals("sml:Link")) continue;
                String source = "";
                String destination = "";
                NodeList linkChilds = link.getChildNodes();
                for (int linkChildCount = 0; linkChildCount < linkChilds.getLength(); ++linkChildCount) {
                    if (linkChilds.item(linkChildCount).getLocalName() == null) continue;
                    Element linkChild = (Element)linkChilds.item(linkChildCount);
                    if (linkChild.getNodeName().equals("sml:source")) {
                        source = linkChild.getAttribute("ref");
                    }
                    if (!linkChild.getNodeName().equals("sml:destination")) continue;
                    destination = linkChild.getAttribute("ref");
                }
                if (source.indexOf("input") == -1 || destination.indexOf("input") == -1) continue;
                Boolean result = false;
                String[] sourceSplits = source.split("/");
                String inputName = sourceSplits[sourceSplits.length - 1];
                for (int inputCount = 0; inputCount < inputNodes.getLength(); ++inputCount) {
                    String processName;
                    Element inputNode = (Element)inputNodes.item(inputCount);
                    if (!inputNode.getAttribute("name").equals(inputName) || (processName = DocumentTools.GetMasterParentNodeName(inputNode)) != "sml:AggregateProcess") continue;
                    result = true;
                }
                Assert.assertTrue((boolean)result, (String)"input-to-input connections shall from aggregate process");
            }
        }
    }

    @Test(description="B.3.2 - Requirement 67")
    public void OutputConnectionRestrictions() {
        NodeList outputNodes = this.testSubject.getDocumentElement().getElementsByTagName("sml:output");
        NodeList connectNodes = this.testSubject.getDocumentElement().getElementsByTagName("sml:connection");
        for (int connectCount = 0; connectCount < connectNodes.getLength(); ++connectCount) {
            if (!connectNodes.item(connectCount).hasChildNodes()) continue;
            NodeList linkNodes = connectNodes.item(connectCount).getChildNodes();
            for (int linkCount = 0; linkCount < linkNodes.getLength(); ++linkCount) {
                Node link = linkNodes.item(linkCount);
                if (link.getLocalName() == null || !link.getNodeName().equals("sml:Link")) continue;
                String source = "";
                String destination = "";
                NodeList linkChilds = link.getChildNodes();
                for (int linkChildCount = 0; linkChildCount < linkChilds.getLength(); ++linkChildCount) {
                    if (linkChilds.item(linkChildCount).getLocalName() == null) continue;
                    Element linkChild = (Element)linkChilds.item(linkChildCount);
                    if (linkChild.getNodeName().equals("sml:source")) {
                        source = linkChild.getAttribute("ref");
                    }
                    if (!linkChild.getNodeName().equals("sml:destination")) continue;
                    destination = linkChild.getAttribute("ref");
                }
                if (source.indexOf("output") == -1 || destination.indexOf("output") == -1) continue;
                Boolean result = false;
                String[] destSplits = destination.split("/");
                String outputName = destSplits[destSplits.length - 1];
                for (int outputCount = 0; outputCount < outputNodes.getLength(); ++outputCount) {
                    String processName;
                    Element outputNode = (Element)outputNodes.item(outputCount);
                    if (!outputNode.getAttribute("name").equals(outputName) || (processName = DocumentTools.GetMasterParentNodeName(outputNode)) != "sml:AggregateProcess") continue;
                    result = true;
                }
                Assert.assertTrue((boolean)result, (String)"output cannot connect to another output of aggregate process");
            }
        }
    }

    @Test(description="B.3.2 - Requirement 68")
    public void MultipleConnections() {
        ArrayList<String> sources = new ArrayList<String>();
        NodeList connectNodes = this.testSubject.getDocumentElement().getElementsByTagName("sml:connection");
        for (int connectCount = 0; connectCount < connectNodes.getLength(); ++connectCount) {
            if (!connectNodes.item(connectCount).hasChildNodes()) continue;
            NodeList linkNodes = connectNodes.item(connectCount).getChildNodes();
            for (int linkCount = 0; linkCount < linkNodes.getLength(); ++linkCount) {
                Node link = linkNodes.item(linkCount);
                if (link.getLocalName() == null || !link.getNodeName().equals("sml:Link")) continue;
                NodeList linkChilds = link.getChildNodes();
                for (int linkChildCount = 0; linkChildCount < linkChilds.getLength(); ++linkChildCount) {
                    String connectRef;
                    Element linkChild;
                    if (linkChilds.item(linkChildCount).getLocalName() == null || !(linkChild = (Element)linkChilds.item(linkChildCount)).getNodeName().equals("sml:source") || !linkChild.hasAttribute("ref") || (connectRef = linkChild.getAttribute("ref")).indexOf("") == -1) continue;
                    if (sources.contains(connectRef)) {
                        throw new AssertionError((Object)"an input can only have one source connection");
                    }
                    sources.add(connectRef);
                }
            }
        }
    }

    @Test(description="B.3.2 - Requirement 69")
    public void ParameterConnectionrestrictions() {
        NodeList connectNodes = this.testSubject.getDocumentElement().getElementsByTagName("sml:connection");
        for (int connectCount = 0; connectCount < connectNodes.getLength(); ++connectCount) {
            if (!connectNodes.item(connectCount).hasChildNodes()) continue;
            NodeList linkNodes = connectNodes.item(connectCount).getChildNodes();
            for (int linkCount = 0; linkCount < linkNodes.getLength(); ++linkCount) {
                Node link = linkNodes.item(linkCount);
                if (link.getLocalName() == null || !link.getNodeName().equals("sml:Link")) continue;
                NodeList linkChilds = link.getChildNodes();
                for (int linkChildCount = 0; linkChildCount < linkChilds.getLength(); ++linkChildCount) {
                    Element linkChild;
                    if (linkChilds.item(linkChildCount).getLocalName() != null && (linkChild = (Element)linkChilds.item(linkChildCount)).getNodeName().equals("sml:source") && linkChild.getAttribute("ref").indexOf("parameter") != -1) {
                        throw new AssertionError((Object)"A parameter can only be connected as a destination");
                    }
                }
            }
        }
    }

    @Test(description="B.3.2 - Requirement 70")
    public void PropertyConnectionrestrictions() {
        NodeList connectNodes = this.testSubject.getDocumentElement().getElementsByTagName("sml:connection");
        for (int connectCount = 0; connectCount < connectNodes.getLength(); ++connectCount) {
            if (!connectNodes.item(connectCount).hasChildNodes()) continue;
            NodeList linkNodes = connectNodes.item(connectCount).getChildNodes();
            for (int linkCount = 0; linkCount < linkNodes.getLength(); ++linkCount) {
                Node link = linkNodes.item(linkCount);
                if (link.getLocalName() == null || !link.getNodeName().equals("sml:Link")) continue;
                NodeList linkChilds = link.getChildNodes();
                for (int linkChildCount = 0; linkChildCount < linkChilds.getLength(); ++linkChildCount) {
                    String connectRef;
                    Element linkChild;
                    if (linkChilds.item(linkChildCount).getLocalName() != null && (linkChild = (Element)linkChilds.item(linkChildCount)).getNodeName().equals("sml:destination") && (connectRef = linkChild.getAttribute("ref")).indexOf("input") == -1 && connectRef.indexOf("output") == -1 && connectRef.indexOf("parameter") == -1) {
                        throw new AssertionError((Object)"destinations shall be a input , output or parameter");
                    }
                }
            }
        }
    }

    @Test(description="B.3.2 - Requirement 71")
    public void DesignatingLinkPaths() {
        NodeList linkNodes = this.testSubject.getDocumentElement().getElementsByTagName("sml:Link");
        for (int linkCount = 0; linkCount < linkNodes.getLength(); ++linkCount) {
            Element link = (Element)linkNodes.item(linkCount);
            NodeList sourceNodes = link.getElementsByTagName("sml:source");
            for (int sourceCount = 0; sourceCount < sourceNodes.getLength(); ++sourceCount) {
                Element source = (Element)sourceNodes.item(sourceCount);
                if (!source.hasAttribute("ref")) {
                    throw new AssertionError((Object)"destinations shall be a input , output or parameter");
                }
                String sourceRef = source.getAttribute("ref");
                Boolean validateResult = this.ValidateLinkRef((Element)this.testSubject.getDocumentElement().cloneNode(true), sourceRef);
                Assert.assertTrue((boolean)validateResult, (String)"path rule error");
            }
            NodeList destinationNodes = link.getElementsByTagName("sml:destination");
            for (int destinationCount = 0; destinationCount < destinationNodes.getLength(); ++destinationCount) {
                String destinationRef;
                Element destination = (Element)destinationNodes.item(destinationCount);
                if (destination.hasAttribute("ref")) {
                    String[] paths;
                    destinationRef = destination.getAttribute("ref");
                    for (String path : paths = destinationRef.split("/")) {
                        Boolean lowerCamelCaseCheckResult = Character.isLowerCase(path.charAt(0));
                        Assert.assertTrue((boolean)lowerCamelCaseCheckResult, (String)"path rule error");
                    }
                } else {
                    throw new AssertionError((Object)"destinations shall be a input , output or parameter");
                }
                Boolean validateResult = this.ValidateLinkRef((Element)this.testSubject.getDocumentElement().cloneNode(true), destinationRef);
                Assert.assertTrue((boolean)validateResult, (String)"path rule error");
            }
        }
    }

    private Boolean ValidateLinkRef(Element node, String ref) {
        String[] refSplite = ref.split("/");
        if (refSplite.length == 0) {
            return false;
        }
        NodeList baseElements = node.getChildNodes();
        Boolean isBase = false;
        for (int baseCount = 0; baseCount < baseElements.getLength(); ++baseCount) {
            if (baseElements.item(baseCount).getLocalName() == null || !baseElements.item(baseCount).getLocalName().equals(refSplite[0])) continue;
            isBase = true;
        }
        if (!isBase.booleanValue()) {
            return false;
        }
        ArrayList<Node> pathNodes = new ArrayList<Node>();
        for (int refCount = 0; refCount < refSplite.length; ++refCount) {
            String name = refSplite[refCount];
            if (refCount == 0) {
                NodeList targetNodes = node.getElementsByTagName("sml:" + name);
                if (targetNodes.getLength() > 0) {
                    for (int targetCount = 0; targetCount < targetNodes.getLength(); ++targetCount) {
                        pathNodes.add(targetNodes.item(targetCount));
                    }
                    continue;
                }
                return false;
            }
            ArrayList<Element> newPathNodes = new ArrayList<Element>();
            for (int pathNodeCount = 0; pathNodeCount < pathNodes.size(); ++pathNodeCount) {
                Element pathNode = (Element)pathNodes.get(pathNodeCount);
                ArrayList<Node> tempNodes = DocumentTools.getAllNode(pathNode);
                for (int tempCount = 0; tempCount < tempNodes.size(); ++tempCount) {
                    Element tempNode;
                    if (tempNodes.get(tempCount) == null || !(tempNode = (Element)tempNodes.get(tempCount)).getLocalName().equals(name) && !tempNode.getAttribute("name").equals(name)) continue;
                    newPathNodes.add(tempNode);
                }
            }
            if (newPathNodes.size() > 0) {
                pathNodes = newPathNodes;
                continue;
            }
            return false;
        }
        return true;
    }
}

