/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import com.saxonica.schema.PreparedSchema;
import com.saxonica.schema.SchemaModelLoader;
import com.saxonica.schema.SchemaModelSerializer;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SchemaValidator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaURIResolver;

public class SchemaManager {
    private Configuration config;
    private ErrorListener errorListener;

    protected SchemaManager(Configuration config) {
        this.config = config;
        this.errorListener = null;
    }

    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setSchemaURIResolver(SchemaURIResolver resolver2) {
        this.config.setSchemaURIResolver(resolver2);
    }

    public SchemaURIResolver getSchemaURIResolver() {
        return this.config.getSchemaURIResolver();
    }

    public void load(Source source) throws SaxonApiException {
        try {
            this.config.addSchemaSource(source, this.errorListener);
        }
        catch (SchemaException e) {
            throw new SaxonApiException(e);
        }
    }

    public void importComponents(Source source) throws SaxonApiException {
        try {
            SchemaModelLoader loader = new SchemaModelLoader(this.config);
            PreparedSchema preparedSchema = loader.load(source);
        }
        catch (XPathException err) {
            throw new SaxonApiException(err);
        }
    }

    public void exportComponents(Destination destination) throws SaxonApiException {
        try {
            Receiver out = destination.getReceiver(this.config);
            SchemaModelSerializer serializer = new SchemaModelSerializer(this.config, out);
            serializer.serialize();
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public SchemaValidator newSchemaValidator() {
        return new SchemaValidator(this.config);
    }
}

