/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.ErrorListener;
import net.sf.saxon.query.ModuleURIResolver;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.trans.XPathException;

public class XQueryCompiler {
    private Processor processor;
    private StaticQueryContext env;
    private ItemType requiredContextItemType;

    protected XQueryCompiler(Processor processor) {
        this.processor = processor;
        this.env = new StaticQueryContext(processor.getUnderlyingConfiguration());
    }

    public void setBaseURI(URI baseURI) {
        if (!baseURI.isAbsolute()) {
            throw new IllegalArgumentException("Base URI must be an absolute URI");
        }
        this.env.setBaseURI(baseURI.toString());
    }

    public URI getBaseURI() {
        try {
            return new URI(this.env.getBaseURI());
        }
        catch (URISyntaxException err) {
            throw new IllegalStateException(err);
        }
    }

    public void setErrorListener(ErrorListener listener) {
        this.env.setErrorListener(listener);
    }

    public ErrorListener getErrorListener() {
        return this.env.getErrorListener();
    }

    public void setCompileWithTracing(boolean option) {
        this.env.setCompileWithTracing(option);
    }

    public boolean isCompileWithTracing() {
        return this.env.isCompileWithTracing();
    }

    public void setModuleURIResolver(ModuleURIResolver resolver2) {
        this.env.setModuleURIResolver(resolver2);
    }

    public ModuleURIResolver getModuleURIResolver() {
        return this.env.getModuleURIResolver();
    }

    public void declareNamespace(String prefix, String uri) {
        this.env.declareNamespace(prefix, uri);
    }

    public void setRequiredContextItemType(ItemType type) {
        this.requiredContextItemType = type;
        this.env.setRequiredContextItemType(type.getUnderlyingItemType());
    }

    public ItemType getRequiredContextItemType() {
        return this.requiredContextItemType;
    }

    public XQueryExecutable compile(String query) throws SaxonApiException {
        try {
            return new XQueryExecutable(this.processor, this.env.compileQuery(query));
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }
}

