/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.sensorml20.level1;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.opengis.cite.sensorml20.BaseFixture;
import org.opengis.cite.sensorml20.util.DocumentTools;
import org.opengis.cite.sensorml20.util.URIUtils;
import org.opengis.cite.sensorml20.util.UrlValidate;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CoreAbstractProcess
extends BaseFixture {
    @Test(description="Requirement 6", groups={"CoreAbstractProcess"}, dependsOnGroups={"CoreConceptss"}, priority=1)
    public void DependencyCore() {
    }

    @Test(description="Requirement 7", groups={"CoreAbstractProcess"}, dependsOnMethods={"DependencyCore", "GmlDependency", "UniqueId", "ExtensionIndependence", "ExtensionRestrictions", "SweCommonDependency", "AggregateData", "TypeOf", "SimpleInheritance", "Configuration", "SWECommonDependency"}, priority=2)
    public void PackageFullyImplemented() {
    }

    @Test(description="Requirement 8", groups={"CoreAbstractProcess"}, dependsOnMethods={"DependencyCore"}, priority=3)
    public void GmlDependency() {
    }

    @Test(description="Requirement 9", groups={"CoreAbstractProcess"}, dependsOnMethods={"DependencyCore"}, priority=4)
    public void UniqueId() {
        NodeList identifierList = this.testSubject.getDocumentElement().getElementsByTagName("gml:identifier");
        int listLength = identifierList.getLength();
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < listLength; ++i) {
            Node item = identifierList.item(i);
            String id = item.getNodeValue();
            if (idList.contains(id)) {
                throw new AssertionError((Object)"ID is not unique !!");
            }
            idList.add(id);
        }
    }

    @Test(description="Requirement 10", groups={"CoreAbstractProcess"}, priority=5, dependsOnMethods={"DependencyCore"})
    public void ExtensionIndependence() throws ParserConfigurationException, SAXException, IOException {
        NodeList extensionNodes = this.testSubject.getDocumentElement().getElementsByTagName("sml:extension");
        if (extensionNodes != null && extensionNodes.getLength() > 0) {
            for (int i = 0; i < extensionNodes.getLength(); ++i) {
                Node item = extensionNodes.item(i);
                NodeList childs = item.getChildNodes();
                for (int j = 0; j < childs.getLength(); ++j) {
                    Boolean result;
                    String pref;
                    Node firstChild = childs.item(j);
                    if (firstChild.getLocalName() != null && (pref = firstChild.getPrefix()) != null && !(result = DocumentTools.ValidateNewNameSpace(pref)).booleanValue()) {
                        throw new AssertionError((Object)"extsnsion property shall within a separate namespace. (other than sml)");
                    }
                }
            }
        }
    }

    @Test(description="Requirement 11", groups={"CoreAbstractProcess"}, dependsOnMethods={"DependencyCore"}, priority=6)
    public void ExtensionRestrictions() {
    }

    @Test(description="Requirement 12", groups={"CoreAbstractProcess"}, dependsOnMethods={"DependencyCore"}, priority=7)
    public void SweCommonDependency() {
    }

    @Test(description="Requirement 13", groups={"CoreAbstractProcess"}, dependsOnMethods={"DependencyCore"}, priority=8)
    public void AggregateData() {
    }

    @Test(description="Requirement 14", groups={"CoreAbstractProcess"}, priority=9)
    public void TypeOf() {
        NodeList typeofList = this.testSubject.getDocumentElement().getElementsByTagName("sml:typeOf");
        int listLength = typeofList.getLength();
        if (listLength == 0) {
            for (int i = 0; i < listLength; ++i) {
                Element item = (Element)typeofList.item(i);
                Assert.assertTrue((boolean)item.hasAttribute("xlink:title"), (String)"Title is not defined!!");
                Assert.assertTrue((boolean)item.hasAttribute("xlink:href"), (String)"Url is not defined!!");
                String url = item.getAttribute("xlink:href");
                String urlRegex = "\\b(https?|ftp|file|ldap)://[-A-Za-z0-9+&@#/%?=~_|!:,.;]*[-A-Za-z0-9+&@#/%=~_|]";
                Assert.assertTrue((boolean)url.matches(urlRegex), (String)"TypeOf Url Error !!");
            }
        }
    }

    @Test(description="Requirement 15", groups={"CoreAbstractProcess"}, dependsOnMethods={"DependencyCore", "TypeOf"}, priority=10)
    public void SimpleInheritance() throws SAXException, IOException, URISyntaxException {
        NodeList typeNodes = this.testSubject.getDocumentElement().getElementsByTagName("sml:typeOf");
        for (int typeCount = 0; typeCount < typeNodes.getLength(); ++typeCount) {
            Element typeNode = (Element)typeNodes.item(typeCount);
            String url = typeNode.getAttribute("xlink:href");
            URI absoluteUri = URIUtils.getAbsoluteUri(url, this.testSubjectUri);
            Assert.assertTrue((boolean)UrlValidate.ValidateHttpUrl(absoluteUri.toString()), (String)"referenced process error");
        }
    }

    @Test(description="Requirement 16", groups={"CoreAbstractProcess"}, dependsOnMethods={"DependencyCore", "SimpleInheritance"}, priority=11)
    public void Configuration() throws URISyntaxException, SAXException, IOException {
        Element typeNode;
        String url;
        URI uri;
        Document doc;
        NodeList configurationNodes;
        int listLength;
        NodeList typeNodes = this.testSubject.getDocumentElement().getElementsByTagName("sml:typeOf");
        if (typeNodes.getLength() > 0 && (listLength = (configurationNodes = (doc = URIUtils.parseURI(uri = URIUtils.getAbsoluteUri(url = (typeNode = (Element)typeNodes.item(0)).getAttribute("xlink:href"), this.testSubjectUri))).getDocumentElement().getElementsByTagName("sml:configuration")).getLength()) == 0) {
            throw new AssertionError((Object)"Configuration property does not exist !!");
        }
    }

    @Test(description="Requirement 17", groups={"CoreAbstractProcess"}, dependsOnMethods={"DependencyCore"}, priority=12)
    public void SWECommonDependency() {
    }
}

