/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.sensorml20.level2;

import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.sensorml20.BaseFixture;
import org.opengis.cite.sensorml20.ETSAssert;
import org.opengis.cite.sensorml20.util.DocumentTools;
import org.opengis.cite.sensorml20.util.UrlValidate;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PhysicalComponentSchema
extends BaseFixture {
    @Test(description="Requirement 72")
    public void AggregateProcessSchemaValid() {
        DOMSource source = new DOMSource(this.testSubject);
        URL schRef = this.getClass().getResource("/org/opengis/cite/sensorml20/sch/physical_component.sch");
        ETSAssert.assertSchematronValid(schRef, source);
    }

    @Test(description="Requirement 73")
    public void AttachedToTarget() {
        NodeList attachedTotNodes = this.testSubject.getDocumentElement().getElementsByTagName("sml:attachedTo");
        for (int attachCount = 0; attachCount < attachedTotNodes.getLength(); ++attachCount) {
            Element attachedTo = (Element)attachedTotNodes.item(attachCount);
            if (attachedTo.hasAttribute("xlink:href")) {
                try {
                    URL url = new URL(attachedTo.getAttribute("xlink:href"));
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document doc = db.parse(url.openStream());
                    String ProcessName = doc.getDocumentElement().getNodeName();
                    if (ProcessName.equals("sml:PhysicalComponent") || ProcessName.equals("sml:PhysicalSystem")) continue;
                    throw new AssertionError((Object)"reference is not PhysicalSystem or PhysicalComponent");
                }
                catch (Exception ex) {
                    throw new AssertionError((Object)"It's not a resolvable reference Url");
                }
            }
            throw new AssertionError((Object)"attachedTo property shall have xlink:href attribute");
        }
    }

    @Test(description="Requirement 74")
    public void AttachedToReference() {
        NodeList attachedToNodes = this.testSubject.getDocumentElement().getElementsByTagName("sml:attachedTo");
        for (int attachedToCount = 0; attachedToCount < attachedToNodes.getLength(); ++attachedToCount) {
            Element attachedTo = (Element)attachedToNodes.item(attachedToCount);
            ArrayList<String> uids = new ArrayList<String>();
            NodeList identifiers = this.testSubject.getDocumentElement().getElementsByTagName("gml:identifier");
            for (int identifiersCount = 0; identifiersCount < identifiers.getLength(); ++identifiersCount) {
                uids.add(identifiers.item(identifiersCount).getTextContent());
            }
            if (attachedTo.hasAttribute("xlink:title")) {
                String titleAttribute = attachedTo.getAttribute("xlink:title");
                if (uids.contains(titleAttribute)) {
                    throw new AssertionError((Object)"value of xlink:title attribute shall be a uniqueID");
                }
            } else {
                throw new AssertionError((Object)"attachedTo property shall require meaningful values for the xlink:title");
            }
            if (attachedTo.hasAttribute("xlink:href")) {
                if (!UrlValidate.ValidateHttpUrl(attachedTo.getAttribute("xlink:href")).booleanValue()) {
                    throw new AssertionError((Object)"attachedTo shall define a resolvable URL for reference");
                }
                continue;
            }
            throw new AssertionError((Object)"attachedTo property shall require meaningful values for the xlink:href");
        }
    }

    @Test(description="Requirement 75")
    public void PositionByPosition() {
        NodeList positionNodes = this.testSubject.getDocumentElement().getElementsByTagName("sml:position");
        for (int positionCount = 0; positionCount < positionNodes.getLength(); ++positionCount) {
            Element position = (Element)positionNodes.item(positionCount);
            NodeList positionChilds = position.getChildNodes();
            Boolean useDataRecord = false;
            for (int pchildCount = 0; pchildCount < positionChilds.getLength(); ++pchildCount) {
                Node pChild = positionChilds.item(pchildCount);
                if (pChild.getLocalName() == null || !pChild.getNodeName().equals("swe:DataRecord")) continue;
                useDataRecord = true;
                ArrayList<Node> fieldList = new ArrayList<Node>();
                NodeList recordChilds = pChild.getChildNodes();
                for (int recordChildCount = 0; recordChildCount < recordChilds.getLength(); ++recordChildCount) {
                    Node recodeChild = recordChilds.item(recordChildCount);
                    if (!recodeChild.getNodeName().equals("swe:field")) continue;
                    fieldList.add(recodeChild);
                }
                if (fieldList.size() == 2) {
                    Element firstField = (Element)fieldList.get(0);
                    Element secondField = (Element)fieldList.get(1);
                    if (!firstField.getAttribute("name").equals("location")) {
                        throw new AssertionError((Object)"First field name is not location");
                    }
                    if (!secondField.getAttribute("name").equals("orientation")) {
                        throw new AssertionError((Object)"Second field name is not orientation");
                    }
                    continue;
                }
                throw new AssertionError((Object)"Position property shall consist of two swe:Vector fields");
            }
        }
    }

    @Test(description="Requirement 76")
    public void DynamicState() {
        NodeList positionNodes = this.testSubject.getDocumentElement().getElementsByTagName("sml:position");
        for (int positionCount = 0; positionCount < positionNodes.getLength(); ++positionCount) {
            NodeList positionChilds = positionNodes.item(positionCount).getChildNodes();
            for (int childCount = 0; childCount < positionChilds.getLength(); ++childCount) {
                Node child = positionChilds.item(childCount);
                if (child.getNodeName().equals("swe:DataArray") || child.getNodeName().equals("sml:AbstractProcess")) continue;
                throw new SkipException("dynamic state shall be described using a swe:DataArray or a sml:AbstractProcess.");
            }
        }
    }

    @Test(description="Requirement 77")
    public void PositionByTrajectory() {
        NodeList positionNodes = this.testSubject.getDocumentElement().getElementsByTagName("sml:position");
        for (int positionCount = 0; positionCount < positionNodes.getLength(); ++positionCount) {
            NodeList positionChilds = positionNodes.item(positionCount).getChildNodes();
            for (int childCount = 0; childCount < positionChilds.getLength(); ++childCount) {
                Node positionChild = positionChilds.item(childCount);
                if (!positionChild.getNodeName().equals("swe:DataArray")) continue;
                NodeList dataArrayChilds = positionChild.getChildNodes();
                for (int dataArrayCount = 0; dataArrayCount < dataArrayChilds.getLength(); ++dataArrayCount) {
                    Element dataArrayChild;
                    if (dataArrayChilds.item(dataArrayCount).getLocalName() == null || !(dataArrayChild = (Element)dataArrayChilds.item(dataArrayCount)).getAttribute("name").equals("trajectory")) continue;
                    Boolean useSweTime = false;
                    Boolean useVector = false;
                    ArrayList<Node> trajectoryChilds = DocumentTools.getAllNode(dataArrayChild);
                    for (int trajectoryChildCount = 0; trajectoryChildCount < trajectoryChilds.size(); ++trajectoryChildCount) {
                        Node trajectoryChild = trajectoryChilds.get(trajectoryChildCount);
                        if (trajectoryChild.getLocalName() == null) continue;
                        if (trajectoryChild.getNodeName().equals("swe:Time")) {
                            useSweTime = true;
                        }
                        if (!trajectoryChild.getNodeName().equals("swe:Vector")) continue;
                        useVector = true;
                    }
                    Assert.assertTrue((useSweTime != false && useVector != false ? 1 : 0) != 0, (String)"DataArray Shall contains a time field and one or more swe:Vector elements as its fields");
                }
            }
        }
    }

    @Test(description="Requirement 78")
    public void PositionByProcess() {
        Boolean useSmlAbstractProcess = false;
        NodeList positionNodes = this.testSubject.getDocumentElement().getElementsByTagName("sml:position");
        for (int positinCount = 0; positinCount < positionNodes.getLength(); ++positinCount) {
            Node pChild = positionNodes.item(positinCount);
            if (!pChild.getNodeName().equals("sml:SimpleProcess") && !pChild.getNodeName().equals("sml:PhysicalComponent") && !pChild.getNodeName().equals("sml:PhysicalSystem") && !pChild.getNodeName().equals("sml:AggregateProcess")) continue;
            useSmlAbstractProcess = true;
            break;
        }
        if (useSmlAbstractProcess.booleanValue()) {
            Boolean useSweData = false;
            NodeList outputNodes = this.testSubject.getDocumentElement().getElementsByTagName("sml:outputs");
            block1: for (int outCount = 0; outCount < outputNodes.getLength(); ++outCount) {
                ArrayList<Node> outputChilds = DocumentTools.getAllNode(outputNodes.item(outCount));
                for (int oChildCount = 0; oChildCount < outputChilds.size(); ++oChildCount) {
                    Node oChild = outputChilds.get(oChildCount);
                    if (!oChild.getNodeName().equals("swe:DataArray") && !oChild.getNodeName().equals("swe:DataRecord")) continue;
                    useSweData = true;
                    continue block1;
                }
            }
            Assert.assertTrue((boolean)useSweData, (String)"output of the process shall contains a swe:DataArray , or a swe:DataRecord ");
        }
    }
}

