/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.instruct.TerminationException;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.InputSource;

public class Compile {
    private TransformerFactoryImpl factory = new TransformerFactoryImpl();
    private boolean showTime = false;
    private boolean debug = false;

    public static void main(String[] args) throws Exception {
        new Compile().doMain(args);
    }

    protected void doMain(String[] args) {
        boolean useURLs = false;
        try {
            Source styleSource;
            int i = 0;
            while (true) {
                if (i >= args.length) {
                    this.badUsage("No stylesheet file name");
                }
                if (args[i].charAt(0) != '-') break;
                if (args[i].equals("-u")) {
                    useURLs = true;
                    ++i;
                    continue;
                }
                if (args[i].equals("-t")) {
                    System.err.println(this.factory.getConfiguration().getProductTitle());
                    System.err.println(Configuration.getPlatform().getPlatformVersion());
                    this.factory.setAttribute("http://saxon.sf.net/feature/timing", Boolean.TRUE);
                    this.showTime = true;
                    ++i;
                    continue;
                }
                if (args[i].equals("-y")) {
                    if (args.length < ++i + 2) {
                        this.badUsage("No style parser class");
                    }
                    String styleParserName = args[i++];
                    this.factory.setAttribute("http://saxon.sf.net/feature/styleParserClass", styleParserName);
                    continue;
                }
                if (args[i].equals("-r")) {
                    if (args.length < ++i + 2) {
                        this.badUsage("No URIResolver class");
                    }
                    String r = args[i++];
                    this.factory.setURIResolver(this.factory.getConfiguration().makeURIResolver(r));
                    continue;
                }
                if (args[i].equals("-debug")) {
                    ++i;
                    this.debug = true;
                    continue;
                }
                if (args[i].equals("-1.1")) {
                    ++i;
                    this.factory.setAttribute("http://saxon.sf.net/feature/xml-version", "1.1");
                    continue;
                }
                this.badUsage("Unknown option " + args[i]);
            }
            if (args.length < i + 1) {
                this.badUsage("No stylesheet file name");
            }
            String styleFileName = args[i++];
            if (args.length < i + 1) {
                this.badUsage("No output file name");
            }
            String outputFileName = args[i++];
            long startTime = new Date().getTime();
            if (useURLs || styleFileName.startsWith("http:") || styleFileName.startsWith("file:")) {
                styleSource = this.factory.getURIResolver().resolve(styleFileName, null);
                if (styleSource == null) {
                    styleSource = this.factory.getConfiguration().getSystemURIResolver().resolve(styleFileName, null);
                }
            } else {
                File sheetFile = new File(styleFileName);
                if (!sheetFile.exists()) {
                    Compile.quit("Stylesheet file " + sheetFile + " does not exist", 2);
                }
                InputSource eis = new InputSource(sheetFile.toURL().toString());
                styleSource = new SAXSource(this.factory.getConfiguration().getStyleParser(), eis);
            }
            if (styleSource == null) {
                Compile.quit("URIResolver for stylesheet file must return a Source", 2);
            }
            Templates sheet = this.factory.newTemplates(styleSource);
            if (this.showTime) {
                long endTime = new Date().getTime();
                System.err.println("Stylesheet compilation time: " + (endTime - startTime) + " milliseconds");
            }
            try {
                String msg = ((PreparedStylesheet)sheet).getExecutable().getReasonUnableToCompile();
                if (msg != null) {
                    System.err.println(msg);
                    Compile.quit("Unable to compile stylesheet", 2);
                }
                System.err.println("Serializing compiled stylesheet");
                ((PreparedStylesheet)sheet).setTargetNamePool(((PreparedStylesheet)sheet).getConfiguration().getNamePool());
                OutputStream fos = new FileOutputStream(outputFileName);
                if (this.debug) {
                    fos = new TracingObjectOutputStream(fos);
                }
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(sheet);
                oos.close();
                System.err.println("Finished serializing stylesheet");
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
        catch (TerminationException err) {
            Compile.quit(err.getMessage(), 1);
        }
        catch (XPathException err) {
            Compile.quit("Stylesheet compilation failed: " + err.getMessage(), 2);
        }
        catch (TransformerConfigurationException err) {
            Compile.quit("Stylesheet compilation failed: " + err.getMessage(), 2);
        }
        catch (TransformerFactoryConfigurationError err) {
            Compile.quit("Stylesheet compilation failed: " + err.getMessage(), 2);
        }
        catch (Exception err2) {
            err2.printStackTrace();
        }
    }

    protected static void quit(String message, int code) {
        System.err.println(message);
        System.exit(code);
    }

    protected void badUsage(String message) {
        System.err.println(message);
        System.err.println(this.factory.getConfiguration().getProductTitle());
        System.err.println("Usage: java net.sf.saxon.Compile [options] stylesheet-file output-file");
        System.err.println("Options: ");
        System.err.println("  -r classname    Use specified URIResolver class");
        System.err.println("  -t              Display version and timing information");
        System.err.println("  -u              Names are URLs not filenames");
        System.err.println("  -y classname    Use specified SAX parser for stylesheet");
        System.err.println("  -debug          Produce trace output to diagnose failures");
        System.err.println("  -1.1            Allow XML 1.1 documents");
        System.err.println("  -?              Display this message ");
        System.exit(2);
    }

    private static class TracingObjectOutputStream
    extends FilterOutputStream {
        OutputStream oos;

        public TracingObjectOutputStream(OutputStream oos) {
            super(oos);
            this.oos = oos;
        }

        public void write(byte[] b) throws IOException {
            char[] chars = new char[b.length];
            for (int i = 0; i < b.length; ++i) {
                chars[i] = (char)b[i];
            }
            String s = new String(chars);
            if (s.indexOf("saxon") >= 0) {
                System.err.println("write byte[]: " + s);
            }
            super.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            char[] chars = new char[len];
            for (int i = 0; i < len; ++i) {
                chars[i] = (char)b[i + off];
            }
            String s = new String(chars);
            if (s.indexOf("saxon") >= 0) {
                System.err.println("write byte[]: " + s);
            }
            super.write(b, off, len);
        }
    }
}

