/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.OutputURIResolver;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.StandardErrorListener;
import net.sf.saxon.StandardURIResolver;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.CharacterMapExpander;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.Emitter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SaxonOutputKeys;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.SerializerFactory;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.event.TransformerReceiver;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.ApplyTemplates;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GlobalParameterSet;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.ParameterSet;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.instruct.TerminationException;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.StrippedDocument;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.UnfailingIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trace.TraceEventMulticaster;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.StandardUnparsedTextResolver;
import net.sf.saxon.trans.UnparsedTextURIResolver;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.TreeBuilder;
import net.sf.saxon.type.SchemaURIResolver;
import net.sf.saxon.value.DateTimeValue;
import org.xml.sax.SAXParseException;

public class Controller
extends Transformer
implements InstructionInfoProvider {
    private Configuration config;
    private Item initialContextItem;
    private Item contextForGlobalVariables;
    private Bindery bindery;
    private NamePool namePool;
    private Receiver messageEmitter;
    private RuleManager ruleManager;
    private Properties localOutputProperties;
    private GlobalParameterSet parameters;
    private PreparedStylesheet preparedStylesheet;
    private TraceListener traceListener;
    private boolean tracingPaused;
    private URIResolver standardURIResolver;
    private URIResolver userURIResolver;
    private Result principalResult;
    private String principalResultURI;
    private boolean thereHasBeenAnExplicitResultDocument;
    private OutputURIResolver outputURIResolver;
    private UnparsedTextURIResolver unparsedTextResolver;
    private SchemaURIResolver schemaURIResolver;
    private ErrorListener errorListener;
    private int recoveryPolicy;
    private Executable executable;
    private int treeModel = 1;
    private Template initialTemplate = null;
    private HashSet allOutputDestinations;
    private DocumentPool sourceDocumentPool;
    private SequenceOutputter reusableSequenceOutputter = null;
    private HashMap userDataTable;
    private DateTimeValue currentDateTime;
    private boolean dateTimePreset = false;
    private StructuredQName initialMode = null;
    private NodeInfo lastRememberedNode = null;
    private int lastRememberedNumber = -1;
    private ClassLoader classLoader;
    private PathMap pathMap = null;

    public Controller(Configuration config) {
        this.config = config;
        this.executable = new Executable(config);
        this.executable.setHostLanguage(config.getHostLanguage());
        this.sourceDocumentPool = new DocumentPool();
        this.reset();
    }

    public Controller(Configuration config, Executable executable) {
        this.config = config;
        this.executable = executable;
        this.sourceDocumentPool = new DocumentPool();
        this.reset();
    }

    public void reset() {
        this.bindery = new Bindery();
        this.namePool = this.config.getNamePool();
        this.standardURIResolver = this.config.getSystemURIResolver();
        this.userURIResolver = this.config.getURIResolver();
        this.outputURIResolver = this.config.getOutputURIResolver();
        this.schemaURIResolver = this.config.getSchemaURIResolver();
        this.unparsedTextResolver = new StandardUnparsedTextResolver();
        this.errorListener = this.config.getErrorListener();
        this.recoveryPolicy = this.config.getRecoveryPolicy();
        if (this.errorListener instanceof StandardErrorListener) {
            PrintStream ps = ((StandardErrorListener)this.errorListener).getErrorOutput();
            this.errorListener = ((StandardErrorListener)this.errorListener).makeAnother(this.executable.getHostLanguage());
            ((StandardErrorListener)this.errorListener).setErrorOutput(ps);
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(this.recoveryPolicy);
        }
        this.userDataTable = new HashMap(20);
        this.traceListener = null;
        this.tracingPaused = false;
        TraceListener tracer = this.config.getTraceListener();
        if (tracer != null) {
            this.addTraceListener(tracer);
        }
        this.setTreeModel(this.config.getTreeModel());
        this.initialContextItem = null;
        this.contextForGlobalVariables = null;
        this.messageEmitter = null;
        this.localOutputProperties = null;
        this.parameters = null;
        this.principalResult = null;
        this.principalResultURI = null;
        this.initialTemplate = null;
        this.allOutputDestinations = null;
        this.thereHasBeenAnExplicitResultDocument = false;
        this.currentDateTime = null;
        this.dateTimePreset = false;
        this.initialMode = null;
        this.lastRememberedNode = null;
        this.lastRememberedNumber = -1;
        this.classLoader = null;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setInitialMode(String expandedModeName) {
        if (expandedModeName == null) {
            return;
        }
        if (expandedModeName.length() == 0) {
            return;
        }
        this.initialMode = StructuredQName.fromClarkName(expandedModeName);
    }

    public String getInitialMode() {
        return this.initialMode.getClarkName();
    }

    public void setOutputProperties(Properties properties) {
        if (properties == null) {
            this.localOutputProperties = null;
        } else {
            Enumeration<?> keys = properties.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                this.setOutputProperty(key, properties.getProperty(key));
            }
        }
    }

    public Properties getOutputProperties() {
        if (this.localOutputProperties == null) {
            if (this.executable == null) {
                return new Properties();
            }
            this.localOutputProperties = new Properties(this.executable.getDefaultOutputProperties());
        }
        Properties newProps = new Properties();
        Enumeration<?> keys = this.localOutputProperties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            newProps.setProperty(key, this.localOutputProperties.getProperty(key));
        }
        return newProps;
    }

    public void setOutputProperty(String name, String value) {
        if (this.localOutputProperties == null) {
            this.localOutputProperties = this.getOutputProperties();
        }
        try {
            SaxonOutputKeys.checkOutputProperty(name, value, this.getConfiguration().getNameChecker());
        }
        catch (XPathException err) {
            throw new IllegalArgumentException(err.getMessage());
        }
        this.localOutputProperties.setProperty(name, value);
    }

    public String getOutputProperty(String name) {
        try {
            SaxonOutputKeys.checkOutputProperty(name, null, this.getConfiguration().getNameChecker());
        }
        catch (XPathException err) {
            throw new IllegalArgumentException(err.getMessage());
        }
        if (this.localOutputProperties == null) {
            if (this.executable == null) {
                return null;
            }
            this.localOutputProperties = this.executable.getDefaultOutputProperties();
        }
        return this.localOutputProperties.getProperty(name);
    }

    public void setBaseOutputURI(String uri) {
        this.principalResultURI = uri;
    }

    public String getBaseOutputURI() {
        return this.principalResultURI;
    }

    public Result getPrincipalResult() {
        return this.principalResult;
    }

    public boolean checkUniqueOutputDestination(String uri) {
        if (uri == null) {
            return true;
        }
        if (this.allOutputDestinations == null) {
            this.allOutputDestinations = new HashSet(20);
        }
        if (uri.startsWith("file:///")) {
            uri = "file:/" + uri.substring(8);
        }
        return !this.allOutputDestinations.contains(uri);
    }

    public void addUnavailableOutputDestination(String uri) {
        if (this.allOutputDestinations == null) {
            this.allOutputDestinations = new HashSet(20);
        }
        this.allOutputDestinations.add(uri);
    }

    public void removeUnavailableOutputDestination(String uri) {
        if (this.allOutputDestinations != null) {
            this.allOutputDestinations.remove(uri);
        }
    }

    public boolean isUnusedOutputDestination(String uri) {
        return this.allOutputDestinations == null || !this.allOutputDestinations.contains(uri);
    }

    public void checkImplicitResultTree() throws XPathException {
        if (!this.checkUniqueOutputDestination(this.principalResultURI)) {
            XPathException err = new XPathException("Cannot write an implicit result document if an explicit result document has been written to the same URI: " + this.principalResultURI);
            err.setErrorCode("XTDE1490");
            throw err;
        }
    }

    public void setThereHasBeenAnExplicitResultDocument() {
        this.thereHasBeenAnExplicitResultDocument = true;
    }

    public boolean hasThereBeenAnExplicitResultDocument() {
        return this.thereHasBeenAnExplicitResultDocument;
    }

    public SequenceOutputter allocateSequenceOutputter(int size) {
        if (this.reusableSequenceOutputter != null) {
            SequenceOutputter out = this.reusableSequenceOutputter;
            this.reusableSequenceOutputter = null;
            return out;
        }
        return new SequenceOutputter(this, size);
    }

    public void reuseSequenceOutputter(SequenceOutputter out) {
        this.reusableSequenceOutputter = out;
    }

    public void setInitialTemplate(String expandedName) throws XPathException {
        if (expandedName == null) {
            this.initialTemplate = null;
            return;
        }
        StructuredQName qName = StructuredQName.fromClarkName(expandedName);
        Template t = this.getExecutable().getNamedTemplate(qName);
        if (t == null) {
            XPathException err = new XPathException("There is no named template with expanded name " + expandedName);
            err.setErrorCode("XTDE0040");
            this.reportFatalError(err);
            throw err;
        }
        if (t.hasRequiredParams()) {
            XPathException err = new XPathException("The named template " + expandedName + " has required parameters, so cannot be used as the entry point");
            err.setErrorCode("XTDE0060");
            this.reportFatalError(err);
            throw err;
        }
        this.initialTemplate = t;
    }

    public String getInitialTemplate() {
        if (this.initialTemplate == null) {
            return null;
        }
        return this.initialTemplate.getTemplateName().getClarkName();
    }

    public PipelineConfiguration makePipelineConfiguration() {
        PipelineConfiguration pipe = new PipelineConfiguration();
        pipe.setConfiguration(this.getConfiguration());
        pipe.setErrorListener(this.getErrorListener());
        pipe.setURIResolver(this.userURIResolver == null ? this.standardURIResolver : this.userURIResolver);
        pipe.setSchemaURIResolver(this.schemaURIResolver);
        pipe.setExpandAttributeDefaults(this.getConfiguration().isExpandAttributeDefaults());
        pipe.setController(this);
        Executable executable = this.getExecutable();
        if (executable != null) {
            pipe.setLocationProvider(executable.getLocationMap());
            pipe.setHostLanguage(executable.getHostLanguage());
        }
        return pipe;
    }

    private Receiver makeMessageEmitter() throws XPathException {
        String emitterClass = this.config.getMessageEmitterClass();
        Object messageReceiver = this.config.getInstance(emitterClass, this.getClassLoader());
        if (!(messageReceiver instanceof Receiver)) {
            throw new XPathException(emitterClass + " is not a Receiver");
        }
        this.setMessageEmitter((Receiver)messageReceiver);
        if (messageReceiver instanceof Emitter) {
            Properties props = new Properties();
            props.setProperty("omit-xml-declaration", "yes");
            ((Emitter)messageReceiver).setOutputProperties(props);
        }
        return (Receiver)messageReceiver;
    }

    public void setMessageEmitter(Receiver receiver) {
        this.messageEmitter = receiver;
        if (receiver.getPipelineConfiguration() == null) {
            this.messageEmitter.setPipelineConfiguration(this.makePipelineConfiguration());
        }
        if (this.messageEmitter instanceof Emitter && ((Emitter)this.messageEmitter).getOutputProperties() == null) {
            try {
                Properties props = new Properties();
                props.setProperty("method", "xml");
                props.setProperty("indent", "yes");
                props.setProperty("omit-xml-declaration", "yes");
                ((Emitter)this.messageEmitter).setOutputProperties(props);
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
    }

    public Receiver getMessageEmitter() {
        return this.messageEmitter;
    }

    public CharacterMapExpander makeCharacterMapExpander(String useMaps, SerializerFactory sf) throws XPathException {
        CharacterMapExpander characterMapExpander = null;
        HashMap characterMapIndex = this.getExecutable().getCharacterMapIndex();
        if (useMaps != null && characterMapIndex != null) {
            ArrayList<IntHashMap> characterMaps = new ArrayList<IntHashMap>(5);
            StringTokenizer st = new StringTokenizer(useMaps, " \t\n\r", false);
            while (st.hasMoreTokens()) {
                String expandedName = st.nextToken();
                StructuredQName qName = StructuredQName.fromClarkName(expandedName);
                IntHashMap map = (IntHashMap)characterMapIndex.get(qName);
                if (map == null) {
                    throw new XPathException("Character map '" + expandedName + "' has not been defined");
                }
                characterMaps.add(map);
            }
            if (!characterMaps.isEmpty()) {
                characterMapExpander = sf.newCharacterMapExpander();
                characterMapExpander.setCharacterMaps(characterMaps);
            }
        }
        return characterMapExpander;
    }

    public void setRecoveryPolicy(int policy) {
        this.recoveryPolicy = policy;
        if (this.errorListener instanceof StandardErrorListener) {
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(policy);
        }
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void recoverableError(XPathException err) throws XPathException {
        try {
            if (this.executable.getHostLanguage() == 51) {
                this.reportFatalError(err);
                throw err;
            }
            this.errorListener.error(err);
        }
        catch (TransformerException e) {
            XPathException de = XPathException.makeXPathException(e);
            de.setHasBeenReported();
            throw de;
        }
    }

    public void reportFatalError(XPathException err) {
        if (!err.hasBeenReported()) {
            try {
                this.getErrorListener().fatalError(err);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            err.setHasBeenReported();
        }
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public DocumentPool getDocumentPool() {
        return this.sourceDocumentPool;
    }

    public void clearDocumentPool() {
        this.sourceDocumentPool = new DocumentPool();
    }

    public void setPrincipalSourceDocument(DocumentInfo doc) {
        this.initialContextItem = doc;
    }

    public void setInitialContextItem(Item item) {
        this.initialContextItem = item;
        this.contextForGlobalVariables = item;
    }

    public Bindery getBindery() {
        return this.bindery;
    }

    public DocumentInfo getPrincipalSourceDocument() {
        if (this.contextForGlobalVariables instanceof DocumentInfo) {
            return (DocumentInfo)this.contextForGlobalVariables;
        }
        return null;
    }

    public Item getInitialContextItem() {
        return this.initialContextItem;
    }

    public Item getContextForGlobalVariables() {
        return this.contextForGlobalVariables;
    }

    public void setURIResolver(URIResolver resolver2) {
        this.userURIResolver = resolver2;
        if (resolver2 instanceof StandardURIResolver) {
            ((StandardURIResolver)resolver2).setConfiguration(this.getConfiguration());
        }
    }

    public URIResolver getURIResolver() {
        return this.userURIResolver;
    }

    public URIResolver getStandardURIResolver() {
        return this.standardURIResolver;
    }

    public void setOutputURIResolver(OutputURIResolver resolver2) {
        this.outputURIResolver = resolver2 == null ? this.config.getOutputURIResolver() : resolver2;
    }

    public OutputURIResolver getOutputURIResolver() {
        return this.outputURIResolver;
    }

    public void setUnparsedTextURIResolver(UnparsedTextURIResolver resolver2) {
        this.unparsedTextResolver = resolver2;
    }

    public UnparsedTextURIResolver getUnparsedTextURIResolver() {
        return this.unparsedTextResolver;
    }

    public void setSchemaURIResolver(SchemaURIResolver resolver2) {
        this.schemaURIResolver = resolver2;
    }

    public SchemaURIResolver getSchemaURIResolver() {
        return this.schemaURIResolver;
    }

    public KeyManager getKeyManager() {
        return this.executable.getKeyManager();
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void setTreeModel(int model) {
        this.treeModel = model;
    }

    public Builder makeBuilder() {
        Builder b = this.treeModel == 1 ? new TinyBuilder() : new TreeBuilder();
        b.setTiming(this.config.isTiming());
        b.setLineNumbering(this.config.isLineNumbering());
        b.setPipelineConfiguration(this.makePipelineConfiguration());
        return b;
    }

    public Stripper makeStripper(Receiver b) {
        if (this.config.isStripsAllWhiteSpace()) {
            if (b == null) {
                return AllElementStripper.getInstance();
            }
            AllElementStripper s = new AllElementStripper();
            s.setUnderlyingReceiver(b);
            s.setPipelineConfiguration(b.getPipelineConfiguration());
            return s;
        }
        Stripper stripper = this.executable == null ? new Stripper(new Mode(-4, Mode.DEFAULT_MODE_NAME)) : this.executable.newStripper();
        stripper.setXPathContext(this.newXPathContext());
        if (b == null) {
            stripper.setPipelineConfiguration(this.makePipelineConfiguration());
        } else {
            stripper.setPipelineConfiguration(b.getPipelineConfiguration());
            stripper.setUnderlyingReceiver(b);
        }
        return stripper;
    }

    public void registerDocument(DocumentInfo doc, String systemId) {
        this.sourceDocumentPool.add(doc, systemId);
    }

    public void setRuleManager(RuleManager r) {
        this.ruleManager = r;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public final boolean isTracing() {
        return this.traceListener != null && !this.tracingPaused;
    }

    public final void pauseTracing(boolean pause) {
        this.tracingPaused = pause;
    }

    public void addTraceListener(TraceListener trace) {
        if (trace != null) {
            this.traceListener = TraceEventMulticaster.add(this.traceListener, trace);
        }
    }

    public void removeTraceListener(TraceListener trace) {
        this.traceListener = TraceEventMulticaster.remove(this.traceListener, trace);
    }

    public void setPreparedStylesheet(PreparedStylesheet sheet) {
        this.preparedStylesheet = sheet;
        this.executable = sheet.getExecutable();
    }

    public void setExecutable(Executable exec) {
        this.executable = exec;
    }

    public void initializeController() throws XPathException {
        this.setRuleManager(this.executable.getRuleManager());
        if (this.traceListener != null) {
            this.traceListener.open();
        }
        this.bindery = new Bindery();
        this.executable.initializeBindery(this.bindery);
        this.defineGlobalParameters();
    }

    public void defineGlobalParameters() throws XPathException {
        this.executable.checkAllRequiredParamsArePresent(this.parameters);
        this.bindery.defineGlobalParameters(this.parameters);
    }

    public void allocateGlobalVariables(int numberOfVariables) {
        SlotManager map = this.executable.getGlobalVariableMap();
        map.setNumberOfVariables(numberOfVariables);
        this.bindery.allocateGlobals(map);
    }

    public Object getUserData(Object key, String name) {
        String keyValue = key.hashCode() + " " + name;
        return this.userDataTable.get(keyValue);
    }

    public void setUserData(Object key, String name, Object data) {
        String keyVal = key.hashCode() + " " + name;
        if (data == null) {
            this.userDataTable.remove(keyVal);
        } else {
            this.userDataTable.put(keyVal, data);
        }
    }

    public void transform(Source source, Result result) throws TransformerException {
        if (this.preparedStylesheet == null) {
            throw new XPathException("Stylesheet has not been prepared");
        }
        if (!this.dateTimePreset) {
            this.currentDateTime = null;
        }
        boolean close = false;
        try {
            Source s2;
            NodeInfo startNode = null;
            boolean wrap = true;
            int validationMode = this.config.getSchemaValidationMode();
            Source underSource = source;
            if (source instanceof AugmentedSource) {
                Boolean localWrap = ((AugmentedSource)source).getWrapDocument();
                if (localWrap != null) {
                    wrap = localWrap;
                }
                close = ((AugmentedSource)source).isPleaseCloseAfterUse();
                int localValidate = ((AugmentedSource)source).getSchemaValidation();
                if (localValidate != 0) {
                    validationMode = localValidate;
                }
                if (validationMode == 1 || validationMode == 2) {
                    wrap = false;
                }
                underSource = ((AugmentedSource)source).getContainedSource();
            }
            if ((s2 = this.config.getSourceResolver().resolveSource(underSource, this.config)) != null) {
                underSource = s2;
            }
            if (wrap && (underSource instanceof NodeInfo || underSource instanceof DOMSource)) {
                startNode = this.prepareInputTree(underSource);
                this.registerDocument(startNode.getDocumentRoot(), underSource.getSystemId());
            } else if (source == null) {
                if (this.initialTemplate == null) {
                    throw new XPathException("Either a source document or an initial template must be specified");
                }
            } else {
                Builder sourceBuilder = this.makeBuilder();
                Sender sender = new Sender(sourceBuilder.getPipelineConfiguration());
                Receiver r = sourceBuilder;
                if (this.config.isStripsAllWhiteSpace() || this.executable.stripsWhitespace() || validationMode == 1 || validationMode == 2) {
                    r = this.makeStripper(sourceBuilder);
                }
                if (this.executable.stripsInputTypeAnnotations()) {
                    r = this.config.getAnnotationStripper(r);
                }
                sender.send(source, r);
                if (close) {
                    ((AugmentedSource)source).close();
                }
                DocumentInfo doc = (DocumentInfo)sourceBuilder.getCurrentRoot();
                sourceBuilder.reset();
                this.registerDocument(doc, source.getSystemId());
                startNode = doc;
            }
            this.transformDocument(startNode, result);
        }
        catch (TerminationException err) {
            throw err;
        }
        catch (XPathException err) {
            Throwable cause = err.getException();
            if (cause != null && cause instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)cause;
                if ((cause = spe.getException()) instanceof RuntimeException) {
                    this.reportFatalError(err);
                }
            } else {
                this.reportFatalError(err);
            }
            throw err;
        }
        finally {
            if (close) {
                ((AugmentedSource)source).close();
            }
            this.principalResultURI = null;
        }
    }

    public NodeInfo prepareInputTree(Source source) {
        NodeInfo start = this.getConfiguration().unravel(source);
        if (this.executable.stripsWhitespace()) {
            DocumentInfo docInfo = start.getDocumentRoot();
            StrippedDocument strippedDoc = new StrippedDocument(docInfo, this.makeStripper(null));
            start = strippedDoc.wrap(start);
        }
        return start;
    }

    public static NodeInfo unravel(Source source, Configuration config) {
        return config.unravel(source);
    }

    public void transformDocument(NodeInfo startNode, Result result) throws TransformerException {
        OutputStream os;
        SequenceReceiver out;
        Properties xslOutputProps;
        String nextInChain;
        if (this.executable == null) {
            throw new XPathException("Stylesheet has not been compiled");
        }
        if (this.getMessageEmitter() == null) {
            Receiver me = this.makeMessageEmitter();
            this.setMessageEmitter(me);
            if (me instanceof Emitter && ((Emitter)me).getWriter() == null) {
                ((Emitter)me).setWriter(new OutputStreamWriter(System.err));
            }
        }
        this.getMessageEmitter().open();
        boolean mustClose = result instanceof StreamResult && ((StreamResult)result).getOutputStream() == null;
        this.principalResult = result;
        if (this.principalResultURI == null) {
            this.principalResultURI = result.getSystemId();
        }
        XPathContextMajor initialContext = this.newXPathContext();
        initialContext.setOrigin(this);
        if (startNode != null) {
            this.initialContextItem = startNode;
            this.contextForGlobalVariables = startNode.getRoot();
            if (startNode.getConfiguration() == null) {
                throw new TransformerException("The supplied source document must be associated with a Configuration");
            }
            if (!startNode.getConfiguration().isCompatible(this.preparedStylesheet.getConfiguration())) {
                throw new XPathException("Source document and stylesheet must use the same or compatible Configurations", "SXXP0004");
            }
            UnfailingIterator currentIter = SingletonIterator.makeIterator(startNode);
            if (this.initialTemplate != null) {
                currentIter.next();
            }
            initialContext.setCurrentIterator(currentIter);
        }
        this.initializeController();
        if (this.getConfiguration().getTraceListener() != null) {
            this.preEvaluateGlobals(initialContext);
        }
        if ((nextInChain = (xslOutputProps = this.localOutputProperties == null ? this.executable.getDefaultOutputProperties() : this.localOutputProperties).getProperty("{http://saxon.sf.net/}next-in-chain")) != null) {
            String baseURI = xslOutputProps.getProperty("{http://saxon.sf.net/}next-in-chain-base-uri");
            result = this.prepareNextStylesheet(nextInChain, baseURI, result);
        }
        Properties props = new Properties(xslOutputProps);
        props.setProperty("{http://saxon.sf.net/}implicit-result-document", "yes");
        initialContext.changeOutputDestination(props, result, true, 50, 3, null);
        if (this.initialTemplate == null) {
            this.initialContextItem = startNode;
            Mode mode = this.getRuleManager().getMode(this.initialMode, false);
            if (mode == null || this.initialMode != null && mode.isEmpty()) {
                throw new XPathException("Requested initial mode " + (this.initialMode == null ? "" : this.initialMode.getDisplayName()) + " does not exist", "XTDE0045");
            }
            for (TailCall tc = ApplyTemplates.applyTemplates(initialContext.getCurrentIterator(), mode, null, null, initialContext, false, 0); tc != null; tc = tc.processLeavingTail()) {
            }
        } else {
            Template t = this.initialTemplate;
            XPathContextMajor c2 = initialContext.newContext();
            c2.setOrigin(this);
            c2.openStackFrame(t.getStackFrameMap());
            c2.setLocalParameters(new ParameterSet());
            c2.setTunnelParameters(new ParameterSet());
            for (TailCall tc = t.expand(c2); tc != null; tc = tc.processLeavingTail()) {
            }
        }
        if (this.traceListener != null) {
            this.traceListener.close();
        }
        if ((out = initialContext.getReceiver()) instanceof ComplexContentOutputter && ((ComplexContentOutputter)out).contentHasBeenWritten() && this.principalResultURI != null) {
            if (!this.checkUniqueOutputDestination(this.principalResultURI)) {
                XPathException err = new XPathException("Cannot write more than one result document to the same URI, or write to a URI that has been read: " + result.getSystemId());
                err.setErrorCode("XTDE1490");
                throw err;
            }
            this.addUnavailableOutputDestination(this.principalResultURI);
        }
        out.endDocument();
        out.close();
        this.getMessageEmitter().close();
        if (mustClose && result instanceof StreamResult && (os = ((StreamResult)result).getOutputStream()) != null) {
            try {
                os.close();
            }
            catch (IOException err) {
                throw new XPathException(err);
            }
        }
    }

    public void preEvaluateGlobals(XPathContext context) throws XPathException {
        HashMap vars = this.getExecutable().getCompiledGlobalVariables();
        if (vars != null) {
            for (GlobalVariable var : vars.values()) {
                var.evaluateVariable(context);
            }
        }
    }

    public Result prepareNextStylesheet(String href, String baseURI, Result result) throws TransformerException {
        PreparedStylesheet next = this.preparedStylesheet.getCachedStylesheet(href, baseURI);
        if (next == null) {
            Source source = null;
            if (this.userURIResolver != null) {
                source = this.userURIResolver.resolve(href, baseURI);
            }
            if (source == null) {
                source = this.standardURIResolver.resolve(href, baseURI);
            }
            TransformerFactoryImpl factory = new TransformerFactoryImpl();
            factory.setConfiguration(this.config);
            next = (PreparedStylesheet)factory.newTemplates(source);
            this.preparedStylesheet.putCachedStylesheet(href, baseURI, next);
        }
        TransformerReceiver nextTransformer = new TransformerReceiver((Controller)next.newTransformer());
        nextTransformer.setSystemId(this.principalResultURI);
        nextTransformer.setPipelineConfiguration(this.makePipelineConfiguration());
        nextTransformer.setResult(result);
        nextTransformer.open();
        return nextTransformer;
    }

    public void setParameter(String expandedName, Object value) {
        if (this.parameters == null) {
            this.parameters = new GlobalParameterSet();
        }
        this.parameters.put(StructuredQName.fromClarkName(expandedName), value);
    }

    public void setParameter(StructuredQName qName, ValueRepresentation value) {
        if (this.parameters == null) {
            this.parameters = new GlobalParameterSet();
        }
        this.parameters.put(qName, value);
    }

    public void clearParameters() {
        this.parameters = null;
    }

    public Object getParameter(String expandedName) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(StructuredQName.fromClarkName(expandedName));
    }

    public Iterator iterateParameters() {
        if (this.parameters == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        int k = this.parameters.getNumberOfKeys();
        ArrayList<String> list = new ArrayList<String>(k);
        Collection keys = this.parameters.getKeys();
        for (StructuredQName qName : keys) {
            String clarkName = qName.getClarkName();
            list.add(clarkName);
        }
        return list.iterator();
    }

    public void setCurrentDateTime(DateTimeValue dateTime) throws XPathException {
        if (this.currentDateTime == null) {
            if (dateTime.getComponent(7) == null) {
                throw new XPathException("No timezone is present in supplied value of current date/time");
            }
        } else {
            throw new IllegalStateException("Current date and time can only be set once, and cannot subsequently be changed");
        }
        this.currentDateTime = dateTime;
        this.dateTimePreset = true;
    }

    public DateTimeValue getCurrentDateTime() {
        if (this.currentDateTime == null) {
            this.currentDateTime = new DateTimeValue(new GregorianCalendar(), true);
        }
        return this.currentDateTime;
    }

    public int getImplicitTimezone() {
        return this.getCurrentDateTime().getTimezoneInMinutes();
    }

    public XPathContextMajor newXPathContext() {
        return new XPathContextMajor(this);
    }

    public void setRememberedNumber(NodeInfo node, int number) {
        this.lastRememberedNode = node;
        this.lastRememberedNumber = number;
    }

    public int getRememberedNumber(NodeInfo node) {
        if (this.lastRememberedNode == node) {
            return this.lastRememberedNumber;
        }
        return -1;
    }

    public void setUseDocumentProjection(PathMap pathMap) {
        this.pathMap = pathMap;
    }

    public PathMap getPathMapForDocumentProjection() {
        return this.pathMap;
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails details = new InstructionDetails();
        details.setConstructType(2000);
        return details;
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

