/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.sensorml20.level2;

import java.net.URL;
import java.util.ArrayList;
import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.sensorml20.BaseFixture;
import org.opengis.cite.sensorml20.ETSAssert;
import org.opengis.cite.sensorml20.util.DocumentTools;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigurableProcessSchema
extends BaseFixture {
    @Test(description="B.6.1 - Requirement 80")
    public void AggregateProcessSchemaValid() {
        DOMSource source = new DOMSource(this.testSubject);
        URL schRef = this.getClass().getResource("/org/opengis/cite/sensorml20/sch/configuration.sch");
        ETSAssert.assertSchematronValid(schRef, source);
    }

    @Test(description="B.6.2 - Requirement 81")
    public void ModeRestriction() {
        NodeList parameterNodes = this.testSubject.getDocumentElement().getElementsByTagName("sml:parameters");
        ArrayList<Node> parameterAllChilds = new ArrayList<Node>();
        for (int parametersCount = 0; parametersCount < parameterNodes.getLength(); ++parametersCount) {
            ArrayList<Node> tempChilds = DocumentTools.getAllNode(parameterNodes.item(parametersCount));
            tempChilds.remove(0);
            parameterAllChilds.addAll(tempChilds);
        }
        NodeList setValueNodes = this.testSubject.getDocumentElement().getElementsByTagName("sml:setValue");
        for (int setValueCount = 0; setValueCount < setValueNodes.getLength(); ++setValueCount) {
            Boolean isLocalParameter;
            Element setValue = (Element)setValueNodes.item(setValueCount);
            String setValueReference = setValue.getAttribute("ref");
            if (setValueReference != null) {
                String[] refSplits = setValueReference.split("/");
                String parameterName = refSplits[refSplits.length - 1];
                isLocalParameter = false;
                for (int allParameterChildCount = 0; allParameterChildCount < parameterAllChilds.size(); ++allParameterChildCount) {
                    Element pChild = (Element)parameterAllChilds.get(allParameterChildCount);
                    if (!pChild.getAttribute("name").equals(parameterName)) continue;
                    isLocalParameter = true;
                }
            } else {
                throw new AssertionError((Object)"SetValue property shall consist of ref attribute");
            }
            Assert.assertTrue((boolean)isLocalParameter, (String)"setValue references only parameter properties within the current process or parent process");
        }
    }

    @Test(description="B.6.3 - Requirement 82")
    public void ParameterValues() {
        NodeList parameterNodes = this.testSubject.getDocumentElement().getElementsByTagName("sml:parameters");
        ArrayList<Node> parameterAllChilds = new ArrayList<Node>();
        for (int parametersCount = 0; parametersCount < parameterNodes.getLength(); ++parametersCount) {
            ArrayList<Node> tempChilds = DocumentTools.getAllNode(parameterNodes.item(parametersCount));
            tempChilds.remove(0);
            parameterAllChilds.addAll(tempChilds);
        }
        NodeList setValueNodes = this.testSubject.getDocumentElement().getElementsByTagName("sml:setValue");
        for (int setValueCount = 0; setValueCount < setValueNodes.getLength(); ++setValueCount) {
            Element setValue = (Element)setValueNodes.item(setValueCount);
            String setValueReference = setValue.getAttribute("ref");
            if (setValueReference != null) {
                String[] refSplits = setValueReference.split("/");
                String parameterName = refSplits[refSplits.length - 1];
                for (int allParameterChildCount = 0; allParameterChildCount < parameterAllChilds.size(); ++allParameterChildCount) {
                    Element pChild = (Element)parameterAllChilds.get(allParameterChildCount);
                    if (!pChild.getAttribute("name").equals(parameterName)) continue;
                    ArrayList<Node> fieldChilds = DocumentTools.getAllNode((Node)parameterAllChilds.get(allParameterChildCount));
                    fieldChilds.remove(0);
                    for (int fieldChildCount = 0; fieldChildCount < fieldChilds.size(); ++fieldChildCount) {
                        Node filedChild = fieldChilds.get(fieldChildCount);
                        if (!filedChild.getNodeName().equals("swe:interval")) continue;
                        String[] intervalSplits = filedChild.getTextContent().split(" ");
                        if (intervalSplits.length > 1) {
                            Double minNum = Double.parseDouble(intervalSplits[0]);
                            Double maxNum = Double.parseDouble(intervalSplits[1]);
                            Double setValueNum = Double.parseDouble(setValue.getTextContent());
                            if (setValueNum < minNum || setValueNum > maxNum) {
                                throw new AssertionError((Object)"The parameter values set by a Mode cannot be outside of the allow values");
                            }
                            continue;
                        }
                        throw new AssertionError((Object)"Interval format error");
                    }
                }
                continue;
            }
            throw new AssertionError((Object)"SetValue property shall consist of ref attribute");
        }
    }
}

