/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.sensorml20.level2;

import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.opengis.cite.sensorml20.ETSAssert;
import org.opengis.cite.sensorml20.ErrorMessage;
import org.opengis.cite.sensorml20.Namespaces;
import org.opengis.cite.sensorml20.SuiteAttribute;
import org.opengis.cite.sensorml20.TestRunArg;
import org.opengis.cite.sensorml20.level1.DataFixture;
import org.opengis.cite.sensorml20.util.TestSuiteLogger;
import org.opengis.cite.sensorml20.util.XMLUtils;
import org.opengis.cite.validation.SchematronValidator;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.log4testng.Logger;

public class SchematronTests
extends DataFixture {
    private SchematronValidator dataValidator;

    public void createSchematronValidator(ITestContext testContext) {
        Map<String, String> piData = this.getXmlModelPIData(this.dataFile);
        String phase = "#ALL";
        StreamSource schema = null;
        if (this.isSchematronReference(piData)) {
            URI schematronURI = URI.create(piData.get("href"));
            if (!schematronURI.isAbsolute()) {
                String dataURI = testContext.getSuite().getParameter(TestRunArg.XML.toString());
                URI baseURI = URI.create(dataURI);
                schematronURI = baseURI.resolve(schematronURI);
            }
            schema = new StreamSource(schematronURI.toString());
            if (piData.containsKey("phase")) {
                phase = piData.get("phase");
            }
        } else {
            Set suiteAttrs = testContext.getSuite().getAttributeNames();
            if (suiteAttrs.contains(SuiteAttribute.SCHEMATRON.getName())) {
                URI schematronURI = (URI)testContext.getSuite().getAttribute(SuiteAttribute.SCHEMATRON.getName());
                schema = new StreamSource(schematronURI.toString());
            }
        }
        if (null != schema) {
            try {
                this.dataValidator = new SchematronValidator((Source)schema, phase);
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).warn((Object)"Failed to create SchematronValidator.\n", (Throwable)e);
            }
        }
    }

    public void checkCoreConstraints() {
        URL schRef = this.getClass().getResource("/org/opengis/cite/sensorml20/sch/core.sch");
        ETSAssert.assertSchematronValid(schRef, new StreamSource(this.dataFile));
    }

    public void checkSimpleProcessConstraints() {
        URL schRef = this.getClass().getResource("/org/opengis/cite/sensorml20/sch/simple_process.sch");
        ETSAssert.assertSchematronValid(schRef, new StreamSource(this.dataFile));
    }

    public void checkAggregateProcessConstraints() {
        URL schRef = this.getClass().getResource("/org/opengis/cite/sensorml20/sch/aggregate_process.sch");
        ETSAssert.assertSchematronValid(schRef, new StreamSource(this.dataFile));
    }

    public void checkPhysicalComponentConstraints() {
        URL schRef = this.getClass().getResource("/org/opengis/cite/sensorml20/sch/physical_component.sch");
        ETSAssert.assertSchematronValid(schRef, new StreamSource(this.dataFile));
    }

    public void checkPhysicalSystemConstraints() {
        URL schRef = this.getClass().getResource("/org/opengis/cite/sensorml20/sch/physical_system.sch");
        ETSAssert.assertSchematronValid(schRef, new StreamSource(this.dataFile));
    }

    public void checkGMLSchematronConstraints() {
        URL schRef = this.getClass().getResource("/org/opengis/cite/iso19136/sch/gml-3.2.1.sch");
        ETSAssert.assertSchematronValid(schRef, new StreamSource(this.dataFile));
    }

    public void checkSchematronConstraints() {
        if (null == this.dataValidator) {
            throw new SkipException("Schematron schema reference not found.");
        }
        StreamSource xmlSource = new StreamSource(this.dataFile);
        DOMResult result = (DOMResult)this.dataValidator.validate((Source)xmlSource);
        Assert.assertFalse((boolean)this.dataValidator.ruleViolationsDetected(), (String)ErrorMessage.format("NotSchemaValid", this.dataValidator.getRuleViolationCount(), XMLUtils.writeNodeToString(result.getNode())));
    }

    boolean isSchematronReference(Map<String, String> piData) {
        if (null != piData && null != piData.get("schematypens")) {
            return piData.get("schematypens").equals(Namespaces.SCH);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> getXmlModelPIData(File dataFile) {
        HashMap<String, String> piData = null;
        XMLStreamReader reader = null;
        FileInputStream input = null;
        try {
            input = new FileInputStream(dataFile);
            XMLInputFactory factory = XMLInputFactory.newInstance();
            reader = factory.createXMLStreamReader(input);
            int event = reader.getEventType();
            while (event != 1) {
                event = reader.next();
                if (event != 3 || !reader.getPITarget().equals("xml-model")) continue;
                String[] pseudoAttrs = reader.getPIData().split("\\s+");
                piData = new HashMap<String, String>();
                for (String pseudoAttr : pseudoAttrs) {
                    String[] nv = pseudoAttr.split("=");
                    piData.put(nv[0].trim(), nv[1].replace('\"', ' ').trim());
                }
                break;
            }
        }
        catch (Exception e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to parse document at " + dataFile.getAbsolutePath(), e);
            Map<String, String> map = null;
            return map;
        }
        finally {
            try {
                if (null != reader) {
                    reader.close();
                }
                if (null != input) {
                    input.close();
                }
            }
            catch (Exception x) {
                TestSuiteLogger.log(Level.INFO, x.getMessage());
            }
        }
        return piData;
    }
}

