/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.sensorml20.level1;

import java.util.ArrayList;
import org.opengis.cite.sensorml20.BaseFixture;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AggregateProcess
extends BaseFixture {
    @Test(description="A.4.1 - Requirement 22", groups={"AggregateProcess"}, dependsOnGroups={"SimpleProcess"})
    public void DependencyCore() {
        String rootName = this.testSubject.getDocumentElement().getNodeName();
        if (!rootName.equals("sml:AggregateProcess")) {
            throw new SkipException("Not an Aggregate Process");
        }
    }

    @Test(description="A.4.2 - Requirement 23", groups={"AggregateProcess"}, dependsOnMethods={"DependencyCore", "Definition", "Components"})
    public void PackageFullyImplemented() {
    }

    @Test(description="A.4.3 - Requirement 24", groups={"AggregateProcess"}, dependsOnMethods={"DependencyCore"})
    public void Definition() {
        String rootName = this.testSubject.getDocumentElement().getNodeName();
        if (rootName == "sml:AggregateProcess") {
            if (this.testSubject.getElementsByTagName("sml:inputs").getLength() == 0) {
                throw new AssertionError((Object)"AggregateProcess Must Define Inputs !!");
            }
            if (this.testSubject.getElementsByTagName("sml:outputs").getLength() == 0) {
                throw new AssertionError((Object)"AggregateProcess Must Define Outputs !!");
            }
            if (this.testSubject.getElementsByTagName("sml:components").getLength() == 0) {
                throw new AssertionError((Object)"AggregateProcess Must Define Sub Process !!");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test(description="A.4.4 - Requirement 25", groups={"AggregateProcess"}, dependsOnMethods={"DependencyCore"})
    public void Components() {
        String rootName = this.testSubject.getDocumentElement().getNodeName();
        if (rootName != "sml:AggregateProcess") return;
        NodeList components = this.testSubject.getDocumentElement().getElementsByTagName("sml:components");
        if (components.getLength() <= 0) throw new AssertionError((Object)"components does not exist !!");
        ArrayList<Element> componentsList = new ArrayList<Element>();
        NodeList tempList = components.item(0).getChildNodes();
        for (int i = 0; i < tempList.getLength(); ++i) {
            Element item = (Element)tempList.item(i);
            if (item.getNodeName() != "sml:ComponentsList") continue;
            componentsList.add(item);
        }
        if (componentsList.size() <= 1) throw new AssertionError((Object)"componentsList does not exist !!");
        NodeList component = ((Element)componentsList.get(0)).getChildNodes();
        if (component.getLength() == 0) {
            throw new AssertionError((Object)"requires one or more Process !!");
        }
        Boolean checkComponent = false;
        for (int i = 0; i < component.getLength(); ++i) {
            Element item = (Element)component.item(i);
            if (item.getNodeName() == "sml:component") {
                checkComponent = true;
            }
            Assert.assertTrue((boolean)checkComponent, (String)"Sub Process Not SimpleProcess!!");
        }
        if (this.testSubject.getDocumentElement().getElementsByTagName("sml:connections").getLength() != 0) return;
        throw new AssertionError((Object)"connection does not exist !!");
    }
}

