/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ConfigEntry {
    public String organization = null;
    public String standard = null;
    public String version = null;
    public String revision = null;
    public QName suite = null;
    public String title = null;
    public String description = null;
    public String link = null;
    public String dataLink = null;
    public List<QName> profiles = new ArrayList<QName>();
    public List<String> profileTitles = new ArrayList<String>();
    public List<String> profileDescriptions = new ArrayList<String>();
    public List<File> sources = new ArrayList<File>();
    public File resources;
    public String webdir;

    ConfigEntry(File file) throws Exception {
        this.readConfigFile(file);
    }

    void readConfigFile(File file) throws Exception {
        String dirname;
        Element suiteEl;
        Element revisionEl;
        Element versionEl;
        Element standardEl;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setExpandEntityReferences(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(file);
        Element config = doc.getDocumentElement();
        Element organizationEl = this.getElementByTagName(config, "organization");
        if (organizationEl != null) {
            this.organization = this.getElementByTagName(organizationEl, "name").getTextContent();
        }
        if ((standardEl = this.getElementByTagName(config, "standard")) != null) {
            this.standard = this.getElementByTagName(standardEl, "name").getTextContent();
        }
        if ((versionEl = this.getElementByTagName(config, "version")) != null) {
            this.version = this.getElementByTagName(versionEl, "name").getTextContent();
        }
        if ((revisionEl = this.getElementByTagName(config, "revision")) != null) {
            this.revision = this.getElementByTagName(revisionEl, "name").getTextContent();
        }
        if ((suiteEl = this.getElementByTagName(config, "suite")) != null) {
            Element descriptionEl;
            String localName = this.getElementByTagName(suiteEl, "local-name").getTextContent();
            String namespaceUri = this.getElementByTagName(suiteEl, "namespace-uri").getTextContent();
            String prefix = this.getElementByTagName(suiteEl, "prefix").getTextContent();
            this.suite = new QName(namespaceUri, localName, prefix);
            Element titleEl = this.getElementByTagName(suiteEl, "title");
            if (titleEl != null) {
                this.title = titleEl.getTextContent();
            }
            if ((descriptionEl = this.getElementByTagName(suiteEl, "description")) != null) {
                this.description = descriptionEl.getTextContent();
            }
            NodeList linkNodes = suiteEl.getElementsByTagName("link");
            for (int i = 0; i < linkNodes.getLength(); ++i) {
                Element linkEl = (Element)linkNodes.item(i);
                String value = linkEl.getTextContent();
                if ("data".equals(linkEl.getAttribute("linkType"))) {
                    this.dataLink = file.getParentFile().getName() + "/" + value;
                    continue;
                }
                if (value.startsWith("data/")) {
                    this.dataLink = file.getParentFile().getName() + "/" + value;
                    continue;
                }
                this.link = value;
            }
        }
        NodeList profileNodes = config.getElementsByTagName("profile");
        for (int i = 0; i < profileNodes.getLength(); ++i) {
            Element profileEl = (Element)profileNodes.item(i);
            String localName = this.getElementByTagName(profileEl, "local-name").getTextContent();
            String namespaceUri = this.getElementByTagName(profileEl, "namespace-uri").getTextContent();
            String prefix = this.getElementByTagName(profileEl, "prefix").getTextContent();
            this.profiles.add(new QName(namespaceUri, localName, prefix));
            Element titleEl = this.getElementByTagName(profileEl, "title");
            this.profileTitles.add(titleEl == null ? "" : titleEl.getTextContent());
            Element descriptionEl = this.getElementByTagName(profileEl, "description");
            this.profileDescriptions.add(descriptionEl == null ? "" : descriptionEl.getTextContent());
        }
        NodeList sourceNodes = config.getElementsByTagName("source");
        for (int i = 0; i < sourceNodes.getLength(); ++i) {
            Element sourceEl = (Element)sourceNodes.item(i);
            this.sources.add(new File(file.getParentFile(), sourceEl.getTextContent()));
        }
        Element resourcesEl = this.getElementByTagName(config, "resources");
        if (resourcesEl != null) {
            this.resources = new File(file.getParentFile(), resourcesEl.getTextContent());
        }
        this.webdir = file.getParentFile().getName();
        Element webEl = this.getElementByTagName(config, "web");
        if (webEl != null && (dirname = webEl.getAttribute("dirname")).length() > 0) {
            this.webdir = dirname;
        }
    }

    void add(ConfigEntry config) {
        this.profiles.addAll(config.profiles);
        this.profileTitles.addAll(config.profileTitles);
        this.profileDescriptions.addAll(config.profileDescriptions);
        this.sources.addAll(config.sources);
    }

    Element getElementByTagName(Node node, String tagname) {
        NodeList nl;
        if (node.getNodeType() == 9) {
            nl = ((Document)node).getElementsByTagName(tagname);
        } else if (node.getNodeType() == 1) {
            nl = ((Element)node).getElementsByTagName(tagname);
        } else {
            return null;
        }
        if (nl.getLength() >= 0) {
            return (Element)nl.item(0);
        }
        return null;
    }
}

