/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import net.sf.saxon.Controller;
import net.sf.saxon.Err;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.value.YearMonthDurationValue;

public final class DateTimeValue
extends CalendarValue
implements Comparable {
    private int year;
    private byte month;
    private byte day;
    private byte hour;
    private byte minute;
    private byte second;
    private int microsecond;
    public static final DateTimeValue javaOrigin = new DateTimeValue(1970, 1, 1, 0, 0, 0, 0, 0);

    private DateTimeValue() {
    }

    public static DateTimeValue getCurrentDateTime(XPathContext context) {
        Controller c;
        if (context == null || (c = context.getController()) == null) {
            return new DateTimeValue(new GregorianCalendar(), true);
        }
        return c.getCurrentDateTime();
    }

    public DateTimeValue(Calendar calendar, boolean tzSpecified) {
        int era = calendar.get(0);
        this.year = calendar.get(1);
        if (era == 0) {
            this.year = 1 - this.year;
        }
        this.month = (byte)(calendar.get(2) + 1);
        this.day = (byte)calendar.get(5);
        this.hour = (byte)calendar.get(11);
        this.minute = (byte)calendar.get(12);
        this.second = (byte)calendar.get(13);
        this.microsecond = calendar.get(14) * 1000;
        if (tzSpecified) {
            int tz = (calendar.get(15) + calendar.get(16)) / 60000;
            this.setTimezoneInMinutes(tz);
        }
        this.typeLabel = BuiltInAtomicType.DATE_TIME;
    }

    public static DateTimeValue fromJavaDate(Date suppliedDate) throws XPathException {
        long millis = suppliedDate.getTime();
        return (DateTimeValue)javaOrigin.add(DayTimeDurationValue.fromMilliseconds(millis));
    }

    public static DateTimeValue makeDateTimeValue(DateValue date, TimeValue time) throws XPathException {
        boolean zoneSpecified;
        if (date == null || time == null) {
            return null;
        }
        DayTimeDurationValue tz1 = (DayTimeDurationValue)date.getComponent(7);
        DayTimeDurationValue tz2 = (DayTimeDurationValue)time.getComponent(7);
        boolean bl = zoneSpecified = tz1 != null || tz2 != null;
        if (tz1 != null && tz2 != null && !tz1.equals(tz2)) {
            XPathException err = new XPathException("Supplied date and time are in different timezones");
            err.setErrorCode("FORG0008");
            throw err;
        }
        DateTimeValue v = new DateTimeValue();
        v.year = (int)((Int64Value)date.getComponent(13)).longValue();
        v.month = (byte)((Int64Value)date.getComponent(2)).longValue();
        v.day = (byte)((Int64Value)date.getComponent(3)).longValue();
        v.hour = (byte)((Int64Value)time.getComponent(4)).longValue();
        v.minute = (byte)((Int64Value)time.getComponent(5)).longValue();
        BigDecimal secs = ((DecimalValue)time.getComponent(6)).getDecimalValue();
        v.second = (byte)secs.intValue();
        v.microsecond = secs.multiply(BigDecimal.valueOf(1000000L)).intValue() % 1000000;
        if (zoneSpecified) {
            if (tz1 == null) {
                tz1 = tz2;
            }
            v.setTimezoneInMinutes((int)(tz1.getLengthInMicroseconds() / 60000000L));
        }
        v.typeLabel = BuiltInAtomicType.DATE_TIME;
        return v;
    }

    public static ConversionResult makeDateTimeValue(CharSequence s2) {
        int value;
        DateTimeValue dt = new DateTimeValue();
        StringTokenizer tok = new StringTokenizer(Whitespace.trimWhitespace(s2).toString(), "-:.+TZ", true);
        if (!tok.hasMoreElements()) {
            return DateTimeValue.badDate("too short", s2);
        }
        String part = (String)tok.nextElement();
        int era = 1;
        if ("+".equals(part)) {
            return DateTimeValue.badDate("Date must not start with '+' sign", s2);
        }
        if ("-".equals(part)) {
            era = -1;
            part = (String)tok.nextElement();
        }
        if ((value = DurationValue.simpleInteger(part)) < 0) {
            return DateTimeValue.badDate("Non-numeric year component", s2);
        }
        dt.year = value * era;
        if (part.length() < 4) {
            return DateTimeValue.badDate("Year is less than four digits", s2);
        }
        if (part.length() > 4 && part.charAt(0) == '0') {
            return DateTimeValue.badDate("When year exceeds 4 digits, leading zeroes are not allowed", s2);
        }
        if (dt.year == 0) {
            return DateTimeValue.badDate("Year zero is not allowed", s2);
        }
        if (era < 0) {
            ++dt.year;
        }
        if (!tok.hasMoreElements()) {
            return DateTimeValue.badDate("Too short", s2);
        }
        if (!"-".equals(tok.nextElement())) {
            return DateTimeValue.badDate("Wrong delimiter after year", s2);
        }
        if (!tok.hasMoreElements()) {
            return DateTimeValue.badDate("Too short", s2);
        }
        part = (String)tok.nextElement();
        if (part.length() != 2) {
            return DateTimeValue.badDate("Month must be two digits", s2);
        }
        value = DurationValue.simpleInteger(part);
        if (value < 0) {
            return DateTimeValue.badDate("Non-numeric month component", s2);
        }
        dt.month = (byte)value;
        if (dt.month < 1 || dt.month > 12) {
            return DateTimeValue.badDate("Month is out of range", s2);
        }
        if (!tok.hasMoreElements()) {
            return DateTimeValue.badDate("Too short", s2);
        }
        if (!"-".equals(tok.nextElement())) {
            return DateTimeValue.badDate("Wrong delimiter after month", s2);
        }
        if (!tok.hasMoreElements()) {
            return DateTimeValue.badDate("Too short", s2);
        }
        part = (String)tok.nextElement();
        if (part.length() != 2) {
            return DateTimeValue.badDate("Day must be two digits", s2);
        }
        value = DurationValue.simpleInteger(part);
        if (value < 0) {
            return DateTimeValue.badDate("Non-numeric day component", s2);
        }
        dt.day = (byte)value;
        if (dt.day < 1 || dt.day > 31) {
            return DateTimeValue.badDate("Day is out of range", s2);
        }
        if (!tok.hasMoreElements()) {
            return DateTimeValue.badDate("Too short", s2);
        }
        if (!"T".equals(tok.nextElement())) {
            return DateTimeValue.badDate("Wrong delimiter after day", s2);
        }
        if (!tok.hasMoreElements()) {
            return DateTimeValue.badDate("Too short", s2);
        }
        part = (String)tok.nextElement();
        if (part.length() != 2) {
            return DateTimeValue.badDate("Hour must be two digits", s2);
        }
        value = DurationValue.simpleInteger(part);
        if (value < 0) {
            return DateTimeValue.badDate("Non-numeric hour component", s2);
        }
        dt.hour = (byte)value;
        if (dt.hour > 24) {
            return DateTimeValue.badDate("Hour is out of range", s2);
        }
        if (!tok.hasMoreElements()) {
            return DateTimeValue.badDate("Too short", s2);
        }
        if (!":".equals(tok.nextElement())) {
            return DateTimeValue.badDate("Wrong delimiter after hour", s2);
        }
        if (!tok.hasMoreElements()) {
            return DateTimeValue.badDate("Too short", s2);
        }
        part = (String)tok.nextElement();
        if (part.length() != 2) {
            return DateTimeValue.badDate("Minute must be two digits", s2);
        }
        value = DurationValue.simpleInteger(part);
        if (value < 0) {
            return DateTimeValue.badDate("Non-numeric minute component", s2);
        }
        dt.minute = (byte)value;
        if (dt.minute > 59) {
            return DateTimeValue.badDate("Minute is out of range", s2);
        }
        if (dt.hour == 24 && dt.minute != 0) {
            return DateTimeValue.badDate("If hour is 24, minute must be 00", s2);
        }
        if (!tok.hasMoreElements()) {
            return DateTimeValue.badDate("Too short", s2);
        }
        if (!":".equals(tok.nextElement())) {
            return DateTimeValue.badDate("Wrong delimiter after minute", s2);
        }
        if (!tok.hasMoreElements()) {
            return DateTimeValue.badDate("Too short", s2);
        }
        part = (String)tok.nextElement();
        if (part.length() != 2) {
            return DateTimeValue.badDate("Second must be two digits", s2);
        }
        value = DurationValue.simpleInteger(part);
        if (value < 0) {
            return DateTimeValue.badDate("Non-numeric second component", s2);
        }
        dt.second = (byte)value;
        if (dt.second > 59) {
            return DateTimeValue.badDate("Second is out of range", s2);
        }
        if (dt.hour == 24 && dt.second != 0) {
            return DateTimeValue.badDate("If hour is 24, second must be 00", s2);
        }
        int tz = 0;
        int state = 0;
        while (tok.hasMoreElements()) {
            if (state == 9) {
                return DateTimeValue.badDate("Characters after the end", s2);
            }
            String delim = (String)tok.nextElement();
            if (".".equals(delim)) {
                if (state != 0) {
                    return DateTimeValue.badDate("Decimal separator occurs twice", s2);
                }
                if (!tok.hasMoreElements()) {
                    return DateTimeValue.badDate("Decimal point must be followed by digits", s2);
                }
                part = (String)tok.nextElement();
                value = DurationValue.simpleInteger(part);
                if (value < 0) {
                    return DateTimeValue.badDate("Non-numeric fractional seconds component", s2);
                }
                double fractionalSeconds = Double.parseDouble('.' + part);
                dt.microsecond = (int)Math.round(fractionalSeconds * 1000000.0);
                if (dt.hour == 24 && dt.microsecond != 0) {
                    return DateTimeValue.badDate("If hour is 24, fractional seconds must be 0", s2);
                }
                state = 1;
                continue;
            }
            if ("Z".equals(delim)) {
                if (state > 1) {
                    return DateTimeValue.badDate("Z cannot occur here", s2);
                }
                tz = 0;
                state = 9;
                dt.setTimezoneInMinutes(0);
                continue;
            }
            if ("+".equals(delim) || "-".equals(delim)) {
                if (state > 1) {
                    return DateTimeValue.badDate(delim + " cannot occur here", s2);
                }
                state = 2;
                if (!tok.hasMoreElements()) {
                    return DateTimeValue.badDate("Missing timezone", s2);
                }
                part = (String)tok.nextElement();
                if (part.length() != 2) {
                    return DateTimeValue.badDate("Timezone hour must be two digits", s2);
                }
                value = DurationValue.simpleInteger(part);
                if (value < 0) {
                    return DateTimeValue.badDate("Non-numeric timezone hour component", s2);
                }
                tz = value;
                if (tz > 14) {
                    return DateTimeValue.badDate("Timezone is out of range (-14:00 to +14:00)", s2);
                }
                tz *= 60;
                if (!"-".equals(delim)) continue;
                tz = -tz;
                continue;
            }
            if (":".equals(delim)) {
                if (state != 2) {
                    return DateTimeValue.badDate("Misplaced ':'", s2);
                }
                state = 9;
                part = (String)tok.nextElement();
                value = DurationValue.simpleInteger(part);
                if (value < 0) {
                    return DateTimeValue.badDate("Non-numeric timezone minute component", s2);
                }
                int tzminute = value;
                if (part.length() != 2) {
                    return DateTimeValue.badDate("Timezone minute must be two digits", s2);
                }
                if (tzminute > 59) {
                    return DateTimeValue.badDate("Timezone minute is out of range", s2);
                }
                if (tz < 0) {
                    tzminute = -tzminute;
                }
                if (Math.abs(tz) == 840 && tzminute != 0) {
                    return DateTimeValue.badDate("Timezone is out of range (-14:00 to +14:00)", s2);
                }
                dt.setTimezoneInMinutes(tz += tzminute);
                continue;
            }
            return DateTimeValue.badDate("Timezone format is incorrect", s2);
        }
        if (state == 2 || state == 3) {
            return DateTimeValue.badDate("Timezone incomplete", s2);
        }
        boolean midnight = false;
        if (dt.hour == 24) {
            dt.hour = 0;
            midnight = true;
        }
        if (!DateValue.isValidDate(dt.year, dt.month, dt.day)) {
            return DateTimeValue.badDate("Non-existent date", s2);
        }
        if (midnight) {
            DateValue t2 = DateValue.tomorrow(dt.year, dt.month, dt.day);
            dt.year = t2.getYear();
            dt.month = t2.getMonth();
            dt.day = t2.getDay();
        }
        dt.typeLabel = BuiltInAtomicType.DATE_TIME;
        return dt;
    }

    private static ValidationFailure badDate(String msg, CharSequence value) {
        ValidationFailure err = new ValidationFailure("Invalid dateTime value " + Err.wrap(value, 4) + " (" + msg + ")");
        err.setErrorCode("FORG0001");
        return err;
    }

    public DateTimeValue(int year, byte month, byte day, byte hour, byte minute, byte second, int microsecond, int tz) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.microsecond = microsecond;
        this.setTimezoneInMinutes(tz);
        this.typeLabel = BuiltInAtomicType.DATE_TIME;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DATE_TIME;
    }

    public int getYear() {
        return this.year;
    }

    public byte getMonth() {
        return this.month;
    }

    public byte getDay() {
        return this.day;
    }

    public byte getHour() {
        return this.hour;
    }

    public byte getMinute() {
        return this.minute;
    }

    public byte getSecond() {
        return this.second;
    }

    public int getMicrosecond() {
        return this.microsecond;
    }

    public DateTimeValue toDateTime() {
        return this;
    }

    public DateTimeValue normalize(XPathContext cc) throws NoDynamicContextException {
        if (this.hasTimezone()) {
            return (DateTimeValue)this.adjustTimezone(0);
        }
        DateTimeValue dt = (DateTimeValue)this.copyAsSubType(null);
        dt.setTimezoneInMinutes(cc.getImplicitTimezone());
        return (DateTimeValue)dt.adjustTimezone(0);
    }

    public ComparisonKey getComparisonKey(XPathContext context) throws NoDynamicContextException {
        return new ComparisonKey(519, this.normalize(context));
    }

    public BigDecimal toJulianInstant() {
        int julianDay = DateValue.getJulianDayNumber(this.year, this.month, this.day);
        long julianSecond = (long)julianDay * 86400L;
        BigDecimal j = BigDecimal.valueOf(julianSecond += ((long)this.hour * 60L + (long)this.minute) * 60L + (long)this.second);
        if (this.microsecond == 0) {
            return j;
        }
        return j.add(BigDecimal.valueOf(this.microsecond).divide(DecimalValue.BIG_DECIMAL_ONE_MILLION, 6, 6));
    }

    public static DateTimeValue fromJulianInstant(BigDecimal instant) {
        BigInteger julianSecond = instant.toBigInteger();
        BigDecimal microseconds = instant.subtract(new BigDecimal(julianSecond)).multiply(DecimalValue.BIG_DECIMAL_ONE_MILLION);
        long js = julianSecond.longValue();
        long jd = js / 86400L;
        DateValue date = DateValue.dateFromJulianDayNumber((int)jd);
        byte hour = (byte)((js %= 86400L) / 3600L);
        byte minute = (byte)((js %= 3600L) / 60L);
        return new DateTimeValue(date.getYear(), date.getMonth(), date.getDay(), hour, minute, (byte)(js %= 60L), microseconds.intValue(), 0);
    }

    public GregorianCalendar getCalendar() {
        int tz = this.hasTimezone() ? this.getTimezoneInMinutes() * 60000 : 0;
        SimpleTimeZone zone = new SimpleTimeZone(tz, "LLL");
        GregorianCalendar calendar = new GregorianCalendar(zone);
        calendar.setGregorianChange(new Date(Long.MIN_VALUE));
        calendar.setLenient(false);
        int yr = this.year;
        if (this.year <= 0) {
            yr = 1 - this.year;
            calendar.set(0, 0);
        }
        calendar.set(yr, this.month - 1, this.day, this.hour, this.minute, this.second);
        calendar.set(14, this.microsecond / 1000);
        if (tz >= -43200000 && tz <= 43200000) {
            calendar.set(15, tz);
        }
        calendar.set(16, 0);
        return calendar;
    }

    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, XPathContext context) {
        switch (requiredType.getPrimitiveType()) {
            case 519: 
            case 632: {
                return this;
            }
            case 521: {
                return new DateValue(this.year, this.month, this.day, this.getTimezoneInMinutes());
            }
            case 520: {
                return new TimeValue(this.hour, this.minute, this.second, this.microsecond, this.getTimezoneInMinutes());
            }
            case 523: {
                return new GYearValue(this.year, this.getTimezoneInMinutes());
            }
            case 522: {
                return new GYearMonthValue(this.year, this.month, this.getTimezoneInMinutes());
            }
            case 526: {
                return new GMonthValue(this.month, this.getTimezoneInMinutes());
            }
            case 524: {
                return new GMonthDayValue(this.month, this.day, this.getTimezoneInMinutes());
            }
            case 525: {
                return new GDayValue(this.day, this.getTimezoneInMinutes());
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationFailure err = new ValidationFailure("Cannot convert dateTime to " + requiredType.getDisplayName());
        err.setErrorCode("XPTY0004");
        return err;
    }

    public CharSequence getStringValueCS() {
        FastStringBuffer sb = new FastStringBuffer(30);
        int yr = this.year;
        if (this.year <= 0) {
            sb.append('-');
            yr = -yr + 1;
        }
        DateTimeValue.appendString(sb, yr, yr > 9999 ? (yr + "").length() : 4);
        sb.append('-');
        DateTimeValue.appendTwoDigits(sb, this.month);
        sb.append('-');
        DateTimeValue.appendTwoDigits(sb, this.day);
        sb.append('T');
        DateTimeValue.appendTwoDigits(sb, this.hour);
        sb.append(':');
        DateTimeValue.appendTwoDigits(sb, this.minute);
        sb.append(':');
        DateTimeValue.appendTwoDigits(sb, this.second);
        if (this.microsecond != 0) {
            sb.append('.');
            int ms = this.microsecond;
            int div = 100000;
            while (ms > 0) {
                int d = ms / div;
                sb.append((char)(d + 48));
                ms %= div;
                div /= 10;
            }
        }
        if (this.hasTimezone()) {
            this.appendTimezone(sb);
        }
        return sb;
    }

    public CharSequence getCanonicalLexicalRepresentation() {
        if (this.hasTimezone() && this.getTimezoneInMinutes() != 0) {
            return this.adjustTimezone(0).getStringValueCS();
        }
        return this.getStringValueCS();
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        DateTimeValue v = new DateTimeValue(this.year, this.month, this.day, this.hour, this.minute, this.second, this.microsecond, this.getTimezoneInMinutes());
        v.typeLabel = typeLabel;
        return v;
    }

    public CalendarValue adjustTimezone(int timezone) {
        DateValue t2;
        if (!this.hasTimezone()) {
            CalendarValue in = (CalendarValue)this.copyAsSubType(this.typeLabel);
            in.setTimezoneInMinutes(timezone);
            return in;
        }
        int oldtz = this.getTimezoneInMinutes();
        if (oldtz == timezone) {
            return this;
        }
        int tz = timezone - oldtz;
        int h2 = this.hour;
        int mi = this.minute;
        if ((mi += tz) < 0 || mi > 59) {
            h2 = (int)((double)h2 + Math.floor((double)mi / 60.0));
            mi = (mi + 1440) % 60;
        }
        if (h2 >= 0 && h2 < 24) {
            return new DateTimeValue(this.year, this.month, this.day, (byte)h2, (byte)mi, this.second, this.microsecond, timezone);
        }
        DateTimeValue dt = this;
        while (h2 < 0) {
            t2 = DateValue.yesterday(dt.getYear(), dt.getMonth(), dt.getDay());
            dt = new DateTimeValue(t2.getYear(), t2.getMonth(), t2.getDay(), (byte)(h2 += 24), (byte)mi, this.second, this.microsecond, timezone);
        }
        if (h2 > 23) {
            t2 = DateValue.tomorrow(this.year, this.month, this.day);
            return new DateTimeValue(t2.getYear(), t2.getMonth(), t2.getDay(), (byte)(h2 -= 24), (byte)mi, this.second, this.microsecond, timezone);
        }
        return dt;
    }

    public CalendarValue add(DurationValue duration) throws XPathException {
        if (duration instanceof DayTimeDurationValue) {
            long microseconds = ((DayTimeDurationValue)duration).getLengthInMicroseconds();
            BigDecimal seconds = BigDecimal.valueOf(microseconds).divide(DecimalValue.BIG_DECIMAL_ONE_MILLION, 6, 6);
            BigDecimal julian = this.toJulianInstant();
            julian = julian.add(seconds);
            DateTimeValue dt = DateTimeValue.fromJulianInstant(julian);
            dt.setTimezoneInMinutes(this.getTimezoneInMinutes());
            return dt;
        }
        if (duration instanceof YearMonthDurationValue) {
            int months = ((YearMonthDurationValue)duration).getLengthInMonths();
            int m4 = this.month - 1 + months;
            int y = this.year + m4 / 12;
            if ((m4 %= 12) < 0) {
                m4 += 12;
                --y;
            }
            ++m4;
            int d = this.day;
            while (!DateValue.isValidDate(y, m4, d)) {
                --d;
            }
            return new DateTimeValue(y, (byte)m4, (byte)d, this.hour, this.minute, this.second, this.microsecond, this.getTimezoneInMinutes());
        }
        XPathException err = new XPathException("DateTime arithmetic is not supported on xs:duration, only on its subtypes");
        err.setIsTypeError(true);
        throw err;
    }

    public DayTimeDurationValue subtract(CalendarValue other, XPathContext context) throws XPathException {
        if (!(other instanceof DateTimeValue)) {
            XPathException err = new XPathException("First operand of '-' is a dateTime, but the second is not");
            err.setIsTypeError(true);
            throw err;
        }
        return super.subtract(other, context);
    }

    public Object convertToJava(Class target, XPathContext context) throws XPathException {
        if (target.isAssignableFrom(Date.class)) {
            return this.getCalendar().getTime();
        }
        if (target.isAssignableFrom(GregorianCalendar.class)) {
            return this.getCalendar();
        }
        if (target.isAssignableFrom(DateTimeValue.class)) {
            return this;
        }
        if (target == String.class || target == CharSequence.class) {
            return this.getStringValue();
        }
        if (target == Object.class) {
            return this.getStringValue();
        }
        Object o = super.convertToJava(target, context);
        if (o == null) {
            throw new XPathException("Conversion of dateTime to " + target.getName() + " is not supported");
        }
        return o;
    }

    public AtomicValue getComponent(int component) throws XPathException {
        switch (component) {
            case 13: {
                return Int64Value.makeIntegerValue(this.year);
            }
            case 1: {
                return Int64Value.makeIntegerValue(this.year > 0 ? (long)this.year : (long)(this.year - 1));
            }
            case 2: {
                return Int64Value.makeIntegerValue(this.month);
            }
            case 3: {
                return Int64Value.makeIntegerValue(this.day);
            }
            case 4: {
                return Int64Value.makeIntegerValue(this.hour);
            }
            case 5: {
                return Int64Value.makeIntegerValue(this.minute);
            }
            case 6: {
                BigDecimal d = BigDecimal.valueOf(this.microsecond);
                d = d.divide(DecimalValue.BIG_DECIMAL_ONE_MILLION, 6, 4);
                d = d.add(BigDecimal.valueOf(this.second));
                return new DecimalValue(d);
            }
            case 12: {
                return Int64Value.makeIntegerValue(this.second);
            }
            case 11: {
                return new Int64Value(this.microsecond);
            }
            case 7: {
                if (this.hasTimezone()) {
                    return DayTimeDurationValue.fromMilliseconds(this.getTimezoneInMinutes() * 60 * 1000);
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown component for dateTime: " + component);
    }

    public int compareTo(CalendarValue other, XPathContext context) throws NoDynamicContextException {
        if (!(other instanceof DateTimeValue)) {
            throw new ClassCastException("DateTime values are not comparable to " + other.getClass());
        }
        DateTimeValue v2 = (DateTimeValue)other;
        if (this.getTimezoneInMinutes() == v2.getTimezoneInMinutes()) {
            if (this.year != v2.year) {
                return IntegerValue.signum(this.year - v2.year);
            }
            if (this.month != v2.month) {
                return IntegerValue.signum(this.month - v2.month);
            }
            if (this.day != v2.day) {
                return IntegerValue.signum(this.day - v2.day);
            }
            if (this.hour != v2.hour) {
                return IntegerValue.signum(this.hour - v2.hour);
            }
            if (this.minute != v2.minute) {
                return IntegerValue.signum(this.minute - v2.minute);
            }
            if (this.second != v2.second) {
                return IntegerValue.signum(this.second - v2.second);
            }
            if (this.microsecond != v2.microsecond) {
                return IntegerValue.signum(this.microsecond - v2.microsecond);
            }
            return 0;
        }
        return this.normalize(context).compareTo(v2.normalize(context), context);
    }

    public int compareTo(Object v2) {
        try {
            return this.compareTo((DateTimeValue)v2, null);
        }
        catch (Exception err) {
            throw new ClassCastException("DateTime comparison requires access to implicit timezone");
        }
    }

    public Comparable getSchemaComparable() {
        return new DateTimeComparable();
    }

    public boolean equals(Object o) {
        return this.compareTo((DateTimeValue)o) == 0;
    }

    public int hashCode() {
        return DateTimeValue.hashCode(this.year, this.month, this.day, this.hour, this.minute, this.second, this.microsecond, this.getTimezoneInMinutes());
    }

    static int hashCode(int year, byte month, byte day, byte hour, byte minute, byte second, int microsecond, int tzMinutes) {
        DateValue t2;
        int tz = -tzMinutes;
        int h2 = hour;
        int mi = minute;
        if ((mi += tz) < 0 || mi > 59) {
            h2 = (int)((double)h2 + Math.floor((double)mi / 60.0));
            mi = (mi + 1440) % 60;
        }
        while (h2 < 0) {
            h2 += 24;
            t2 = DateValue.yesterday(year, month, day);
            year = t2.getYear();
            month = t2.getMonth();
            day = t2.getDay();
        }
        while (h2 > 23) {
            h2 -= 24;
            t2 = DateValue.tomorrow(year, month, day);
            year = t2.getYear();
            month = t2.getMonth();
            day = t2.getDay();
        }
        return year << 4 ^ month << 28 ^ day << 23 ^ h2 << 18 ^ mi << 13 ^ second ^ microsecond;
    }

    private class DateTimeComparable
    implements Comparable {
        private DateTimeComparable() {
        }

        private DateTimeValue asDateTimeValue() {
            return DateTimeValue.this;
        }

        public int compareTo(Object o) {
            if (o instanceof DateTimeComparable) {
                DateTimeValue dt0 = DateTimeValue.this;
                DateTimeValue dt1 = ((DateTimeComparable)o).asDateTimeValue();
                if (dt0.hasTimezone()) {
                    if (dt1.hasTimezone()) {
                        dt0 = (DateTimeValue)dt0.adjustTimezone(0);
                        dt1 = (DateTimeValue)dt1.adjustTimezone(0);
                        return dt0.compareTo(dt1);
                    }
                    DateTimeValue dt1max = (DateTimeValue)dt1.adjustTimezone(840);
                    if (dt0.compareTo(dt1max) < 0) {
                        return -1;
                    }
                    DateTimeValue dt1min = (DateTimeValue)dt1.adjustTimezone(-840);
                    if (dt0.compareTo(dt1min) > 0) {
                        return 1;
                    }
                    return Integer.MIN_VALUE;
                }
                if (dt1.hasTimezone()) {
                    DateTimeValue dt0min = (DateTimeValue)dt0.adjustTimezone(-840);
                    if (dt0min.compareTo(dt1) < 0) {
                        return -1;
                    }
                    DateTimeValue dt0max = (DateTimeValue)dt0.adjustTimezone(840);
                    if (dt0max.compareTo(dt1) > 0) {
                        return 1;
                    }
                    return Integer.MIN_VALUE;
                }
                dt0 = (DateTimeValue)dt0.adjustTimezone(0);
                dt1 = (DateTimeValue)dt1.adjustTimezone(0);
                return dt0.compareTo(dt1);
            }
            return Integer.MIN_VALUE;
        }

        public boolean equals(Object o) {
            return o instanceof DateTimeComparable && DateTimeValue.this.hasTimezone() == ((DateTimeComparable)o).asDateTimeValue().hasTimezone() && this.compareTo(o) == 0;
        }

        public int hashCode() {
            DateTimeValue dt0 = (DateTimeValue)DateTimeValue.this.adjustTimezone(0);
            return dt0.year << 20 ^ dt0.month << 16 ^ dt0.day << 11 ^ dt0.hour << 7 ^ dt0.minute << 2 ^ dt0.second * 1000000 + dt0.microsecond;
        }
    }
}

