/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.io.Serializable;
import java.util.concurrent.Callable;
import org.mockito.internal.exceptions.stacktrace.ConditionalStackTraceFilter;
import org.mockito.invocation.InvocationFactory;

public interface RealMethod
extends Serializable {
    public boolean isInvokable();

    public Object invoke() throws Throwable;

    public static class FromBehavior
    implements RealMethod {
        private final InvocationFactory.RealMethodBehavior<?> behavior;

        FromBehavior(InvocationFactory.RealMethodBehavior<?> behavior) {
            this.behavior = behavior;
        }

        @Override
        public boolean isInvokable() {
            return true;
        }

        @Override
        public Object invoke() throws Throwable {
            try {
                return this.behavior.call();
            }
            catch (Throwable t2) {
                new ConditionalStackTraceFilter().filter(t2);
                throw t2;
            }
        }
    }

    public static class FromCallable
    extends FromBehavior
    implements RealMethod {
        public FromCallable(final Callable<?> callable) {
            super(new InvocationFactory.RealMethodBehavior(){

                public Object call() throws Throwable {
                    return callable.call();
                }
            });
        }
    }

    public static enum IsIllegal implements RealMethod
    {
        INSTANCE;


        @Override
        public boolean isInvokable() {
            return false;
        }

        @Override
        public Object invoke() {
            throw new IllegalStateException();
        }
    }
}

