/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.answers;

import java.lang.reflect.Method;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.Answer1;
import org.mockito.stubbing.Answer2;
import org.mockito.stubbing.Answer3;
import org.mockito.stubbing.Answer4;
import org.mockito.stubbing.Answer5;
import org.mockito.stubbing.Answer6;
import org.mockito.stubbing.VoidAnswer1;
import org.mockito.stubbing.VoidAnswer2;
import org.mockito.stubbing.VoidAnswer3;
import org.mockito.stubbing.VoidAnswer4;
import org.mockito.stubbing.VoidAnswer5;
import org.mockito.stubbing.VoidAnswer6;

public class AnswerFunctionalInterfaces {
    private AnswerFunctionalInterfaces() {
    }

    public static <T, A> Answer<T> toAnswer(final Answer1<T, A> answer) {
        final Method answerMethod = AnswerFunctionalInterfaces.findAnswerMethod(answer.getClass(), 1);
        return new Answer<T>(){

            @Override
            public T answer(InvocationOnMock invocation) throws Throwable {
                return answer.answer(AnswerFunctionalInterfaces.lastParameter(invocation, answerMethod, 0));
            }
        };
    }

    public static <A> Answer<Void> toAnswer(final VoidAnswer1<A> answer) {
        final Method answerMethod = AnswerFunctionalInterfaces.findAnswerMethod(answer.getClass(), 1);
        return new Answer<Void>(){

            @Override
            public Void answer(InvocationOnMock invocation) throws Throwable {
                answer.answer(AnswerFunctionalInterfaces.lastParameter(invocation, answerMethod, 0));
                return null;
            }
        };
    }

    public static <T, A, B> Answer<T> toAnswer(final Answer2<T, A, B> answer) {
        final Method answerMethod = AnswerFunctionalInterfaces.findAnswerMethod(answer.getClass(), 2);
        return new Answer<T>(){

            @Override
            public T answer(InvocationOnMock invocation) throws Throwable {
                return answer.answer(invocation.getArgument(0), AnswerFunctionalInterfaces.lastParameter(invocation, answerMethod, 1));
            }
        };
    }

    public static <A, B> Answer<Void> toAnswer(final VoidAnswer2<A, B> answer) {
        final Method answerMethod = AnswerFunctionalInterfaces.findAnswerMethod(answer.getClass(), 2);
        return new Answer<Void>(){

            @Override
            public Void answer(InvocationOnMock invocation) throws Throwable {
                answer.answer(invocation.getArgument(0), AnswerFunctionalInterfaces.lastParameter(invocation, answerMethod, 1));
                return null;
            }
        };
    }

    public static <T, A, B, C> Answer<T> toAnswer(final Answer3<T, A, B, C> answer) {
        final Method answerMethod = AnswerFunctionalInterfaces.findAnswerMethod(answer.getClass(), 3);
        return new Answer<T>(){

            @Override
            public T answer(InvocationOnMock invocation) throws Throwable {
                return answer.answer(invocation.getArgument(0), invocation.getArgument(1), AnswerFunctionalInterfaces.lastParameter(invocation, answerMethod, 2));
            }
        };
    }

    public static <A, B, C> Answer<Void> toAnswer(final VoidAnswer3<A, B, C> answer) {
        final Method answerMethod = AnswerFunctionalInterfaces.findAnswerMethod(answer.getClass(), 3);
        return new Answer<Void>(){

            @Override
            public Void answer(InvocationOnMock invocation) throws Throwable {
                answer.answer(invocation.getArgument(0), invocation.getArgument(1), AnswerFunctionalInterfaces.lastParameter(invocation, answerMethod, 2));
                return null;
            }
        };
    }

    public static <T, A, B, C, D> Answer<T> toAnswer(final Answer4<T, A, B, C, D> answer) {
        final Method answerMethod = AnswerFunctionalInterfaces.findAnswerMethod(answer.getClass(), 4);
        return new Answer<T>(){

            @Override
            public T answer(InvocationOnMock invocation) throws Throwable {
                return answer.answer(invocation.getArgument(0), invocation.getArgument(1), invocation.getArgument(2), AnswerFunctionalInterfaces.lastParameter(invocation, answerMethod, 3));
            }
        };
    }

    public static <A, B, C, D> Answer<Void> toAnswer(final VoidAnswer4<A, B, C, D> answer) {
        final Method answerMethod = AnswerFunctionalInterfaces.findAnswerMethod(answer.getClass(), 4);
        return new Answer<Void>(){

            @Override
            public Void answer(InvocationOnMock invocation) throws Throwable {
                answer.answer(invocation.getArgument(0), invocation.getArgument(1), invocation.getArgument(2), AnswerFunctionalInterfaces.lastParameter(invocation, answerMethod, 3));
                return null;
            }
        };
    }

    public static <T, A, B, C, D, E> Answer<T> toAnswer(final Answer5<T, A, B, C, D, E> answer) {
        final Method answerMethod = AnswerFunctionalInterfaces.findAnswerMethod(answer.getClass(), 5);
        return new Answer<T>(){

            @Override
            public T answer(InvocationOnMock invocation) throws Throwable {
                return answer.answer(invocation.getArgument(0), invocation.getArgument(1), invocation.getArgument(2), invocation.getArgument(3), AnswerFunctionalInterfaces.lastParameter(invocation, answerMethod, 4));
            }
        };
    }

    public static <A, B, C, D, E> Answer<Void> toAnswer(final VoidAnswer5<A, B, C, D, E> answer) {
        final Method answerMethod = AnswerFunctionalInterfaces.findAnswerMethod(answer.getClass(), 5);
        return new Answer<Void>(){

            @Override
            public Void answer(InvocationOnMock invocation) throws Throwable {
                answer.answer(invocation.getArgument(0), invocation.getArgument(1), invocation.getArgument(2), invocation.getArgument(3), AnswerFunctionalInterfaces.lastParameter(invocation, answerMethod, 4));
                return null;
            }
        };
    }

    public static <T, A, B, C, D, E, F> Answer<T> toAnswer(final Answer6<T, A, B, C, D, E, F> answer) {
        final Method answerMethod = AnswerFunctionalInterfaces.findAnswerMethod(answer.getClass(), 6);
        return new Answer<T>(){

            @Override
            public T answer(InvocationOnMock invocation) throws Throwable {
                return answer.answer(invocation.getArgument(0), invocation.getArgument(1), invocation.getArgument(2), invocation.getArgument(3), invocation.getArgument(4), AnswerFunctionalInterfaces.lastParameter(invocation, answerMethod, 5));
            }
        };
    }

    public static <A, B, C, D, E, F> Answer<Void> toAnswer(final VoidAnswer6<A, B, C, D, E, F> answer) {
        final Method answerMethod = AnswerFunctionalInterfaces.findAnswerMethod(answer.getClass(), 6);
        return new Answer<Void>(){

            @Override
            public Void answer(InvocationOnMock invocation) throws Throwable {
                answer.answer(invocation.getArgument(0), invocation.getArgument(1), invocation.getArgument(2), invocation.getArgument(3), invocation.getArgument(4), AnswerFunctionalInterfaces.lastParameter(invocation, answerMethod, 5));
                return null;
            }
        };
    }

    private static Method findAnswerMethod(Class<?> type, int numberOfParameters) {
        for (Method m4 : type.getDeclaredMethods()) {
            if (m4.isBridge() || !m4.getName().equals("answer") || m4.getParameterTypes().length != numberOfParameters) continue;
            return m4;
        }
        throw new IllegalStateException("Failed to find answer() method on the supplied class: " + type.getName() + ", with the supplied number of parameters: " + numberOfParameters);
    }

    private static <A> A lastParameter(InvocationOnMock invocation, Method answerMethod, int argumentIndex) {
        Method invocationMethod = invocation.getMethod();
        if (invocationMethod.isVarArgs() && invocationMethod.getParameterTypes().length == argumentIndex + 1) {
            Class<?> invocationRawArgType = invocationMethod.getParameterTypes()[argumentIndex];
            Class<?> answerRawArgType = answerMethod.getParameterTypes()[argumentIndex];
            if (answerRawArgType.isAssignableFrom(invocationRawArgType)) {
                return (A)invocation.getRawArguments()[argumentIndex];
            }
        }
        return (A)invocation.getArgument(argumentIndex);
    }
}

