/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.sensorml20.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.opengis.cite.sensorml20.util.URIUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DocumentTools {
    private static ArrayList<String> ProcessNames = new ArrayList();

    public static ArrayList<Node> getAllNode(Node node) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(node);
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node tempNode = node.getChildNodes().item(i);
            if (tempNode.getLocalName() == null) continue;
            ArrayList<Node> childs = DocumentTools.getAllNode(tempNode);
            nodes.addAll(childs);
        }
        return nodes;
    }

    public static String GetMasterParentNodeName(Node node) {
        if (ProcessNames.size() == 0) {
            ProcessNames.add("sml:SimpleProcess");
            ProcessNames.add("sml:AggregateProcess");
            ProcessNames.add("sml:PhysicalComponent");
            ProcessNames.add("sml:PhysicalSystem");
        }
        if (ProcessNames.contains(node.getNodeName())) {
            return node.getNodeName();
        }
        Node parentNode = node.getParentNode();
        if (parentNode != null) {
            return DocumentTools.GetMasterParentNodeName(node.getParentNode());
        }
        return "";
    }

    public static ArrayList<Node> GetElementByLocalName(Node node, String localName) {
        ArrayList<Node> nodes = DocumentTools.getAllNode(node);
        ArrayList<Node> rets = new ArrayList<Node>();
        for (Node item : nodes) {
            if (!item.getLocalName().equals(localName)) continue;
            rets.add(item);
        }
        return rets;
    }

    public static void MergeReference(Document doc, URI docUri) throws URISyntaxException, SAXException, IOException {
        NodeList typeofNodes;
        System.out.println("Start Merging");
        if (doc != null && (typeofNodes = doc.getElementsByTagName("sml:typeOf")).getLength() > 0) {
            Element typeofNode = (Element)typeofNodes.item(0);
            String ref = typeofNode.getAttribute("xlink:href");
            URI uri = URIUtils.getAbsoluteUri(ref, docUri);
            Document merge = URIUtils.parseURI(uri);
            DocumentTools.MergeDocument(doc, merge);
            NamedNodeMap docImports = doc.getDocumentElement().getAttributes();
            NamedNodeMap mergeImports = merge.getDocumentElement().getAttributes();
            for (int mergeCount = 0; mergeCount < mergeImports.getLength(); ++mergeCount) {
                Node mergeItem = mergeImports.item(mergeCount);
                Boolean isAdd = true;
                for (int docCount = 0; docCount < docImports.getLength(); ++docCount) {
                    Node docItem = docImports.item(docCount);
                    if (!docItem.getNodeName().equals(mergeItem.getNodeName())) continue;
                    isAdd = false;
                }
                if (!isAdd.booleanValue()) continue;
                doc.getDocumentElement().setAttribute(mergeItem.getNodeName(), mergeItem.getNodeValue());
            }
        }
    }

    public static void MergeDocument(Document base, Document merge) {
        Element mergeRootNode = merge.getDocumentElement();
        NodeList mergeRootChilds = mergeRootNode.getChildNodes();
        for (int mergeChildCount = 0; mergeChildCount < mergeRootChilds.getLength(); ++mergeChildCount) {
            Node kid = mergeRootChilds.item(mergeChildCount).cloneNode(true);
            base.adoptNode(kid);
            base.getDocumentElement().appendChild(kid);
        }
    }

    public static Boolean ValidateNewNameSpace(String pre) {
        if (pre.equals("sml")) {
            return false;
        }
        if (pre.equals("gml")) {
            return false;
        }
        if (pre.equals("swe")) {
            return false;
        }
        return true;
    }

    public static void ElementToStream(Element element, OutputStream out) {
        try {
            DOMSource source = new DOMSource(element);
            StreamResult result = new StreamResult(out);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String DocumentToString(Document doc) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DocumentTools.ElementToStream(doc.getDocumentElement(), baos);
        return new String(baos.toByteArray());
    }
}

