/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Objects;
import org.testng.internal.Utils;

public class ConstructorOrMethod {
    private Method m_method;
    private Constructor<?> m_constructor;
    private boolean m_enabled = true;

    public ConstructorOrMethod(Method m4) {
        this.m_method = m4;
    }

    public ConstructorOrMethod(Constructor<?> c) {
        this.m_constructor = c;
    }

    public ConstructorOrMethod(Executable e) {
        if (e instanceof Constructor) {
            this.m_constructor = (Constructor)e;
        } else {
            this.m_method = (Method)e;
        }
    }

    public Class<?> getDeclaringClass() {
        return this.getMethod() != null ? this.getMethod().getDeclaringClass() : this.getConstructor().getDeclaringClass();
    }

    public String getName() {
        return this.getMethod() != null ? this.getMethod().getName() : this.getConstructor().getName();
    }

    public Class<?>[] getParameterTypes() {
        return this.getMethod() != null ? this.getMethod().getParameterTypes() : this.getConstructor().getParameterTypes();
    }

    public Method getMethod() {
        return this.m_method;
    }

    public Constructor<?> getConstructor() {
        return this.m_constructor;
    }

    private Executable getInternalConstructorOrMethod() {
        if (this.m_method != null) {
            return this.m_method;
        }
        return this.m_constructor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstructorOrMethod that = (ConstructorOrMethod)o;
        return this.getInternalConstructorOrMethod().equals(that.getInternalConstructorOrMethod());
    }

    public int hashCode() {
        return Objects.hash(this.getInternalConstructorOrMethod());
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public boolean getEnabled() {
        return this.m_enabled;
    }

    public String toString() {
        if (this.m_method != null) {
            return this.m_method.toString();
        }
        return this.m_constructor.toString();
    }

    public String stringifyParameterTypes() {
        return Utils.stringifyTypes(this.getParameterTypes());
    }
}

