/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.sensorml20.level1;

import org.opengis.cite.sensorml20.BaseFixture;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PhysicalComponent
extends BaseFixture {
    @Test(description="A.5.1 - Requirement 26", groups={"PhysicalComponent"}, dependsOnMethods={"DependencyCore", "ByPointOrLocation", "ByPostion", "ByTrajectory", "ByProcess", "Definition"})
    public void PackageFullyImplemented() {
    }

    @Test(description="A.5.2 - Requirement 27", groups={"PhysicalComponent"}, dependsOnGroups={"CoreAbstractProcess"})
    public void DependencyCore() {
        String rootName = this.testSubject.getDocumentElement().getNodeName();
        if (!rootName.equals("sml:PhysicalComponent")) {
            throw new SkipException("Not a PhysicalComponent Process");
        }
    }

    private Boolean ValidateSpatialRule(Element node) {
        String[] ruleNames = new String[]{"swe:Text", "gml:Point", "swe:Vector", "swe:DataRecord", "swe:DataArray", "sml:AbstractProcess"};
        for (int ruleCount = 0; ruleCount < ruleNames.length; ++ruleCount) {
            String ruleName = ruleNames[ruleCount];
            NodeList list = node.getElementsByTagName(ruleName);
            if (list.getLength() <= 0) continue;
            return true;
        }
        return false;
    }

    @Test(description="A.5.3 - Requirement 28", groups={"PhysicalComponent"}, dependsOnMethods={"DependencyCore"})
    public void ByPointOrLocation() {
        NodeList positionList = this.testSubject.getDocumentElement().getElementsByTagName("sml:position");
        for (int positionCount = 0; positionCount < positionList.getLength(); ++positionCount) {
            Element positionNode = (Element)positionList.item(positionCount);
            Assert.assertTrue((boolean)this.ValidateSpatialRule(positionNode), (String)"position element shall define content");
            NodeList pointList = positionNode.getElementsByTagName("gml:Point");
            if (pointList.getLength() != 0) continue;
            throw new SkipException("location or point is not defined");
        }
    }

    @Test(description="A.5.4 - Requirement 29", groups={"PhysicalComponent"}, dependsOnMethods={"DependencyCore"})
    public void ByPostion() {
        NodeList positionList = this.testSubject.getDocumentElement().getElementsByTagName("sml:position");
        for (int positionCount = 0; positionCount < positionList.getLength(); ++positionCount) {
            Element positionNode = (Element)positionList.item(positionCount);
            Assert.assertTrue((boolean)this.ValidateSpatialRule(positionNode), (String)"position element shall define content");
            NodeList dataList = positionNode.getElementsByTagName("swe:DataRecord");
            if (dataList.getLength() != 0) continue;
            throw new SkipException("location data set is not defined");
        }
    }

    @Test(description="A.5.5 - Requirement 30", groups={"PhysicalComponent"}, dependsOnMethods={"DependencyCore"})
    public void ByTrajectory() {
        NodeList positionList = this.testSubject.getDocumentElement().getElementsByTagName("sml:position");
        for (int positionCount = 0; positionCount < positionList.getLength(); ++positionCount) {
            Element positionNode = (Element)positionList.item(positionCount);
            Assert.assertTrue((boolean)this.ValidateSpatialRule(positionNode), (String)"position element shall define content");
            NodeList dataList = positionNode.getElementsByTagName("swe:DataArray");
            if (dataList.getLength() != 0) continue;
            throw new SkipException("time-tagged dynamic state information is not defined");
        }
    }

    @Test(description="A.5.6 - Requirement 31", groups={"PhysicalComponent"}, dependsOnMethods={"DependencyCore"})
    public void ByProcess() {
        NodeList positionList = this.testSubject.getDocumentElement().getElementsByTagName("sml:position");
        for (int positionCount = 0; positionCount < positionList.getLength(); ++positionCount) {
            Element positionNode = (Element)positionList.item(positionCount);
            Assert.assertTrue((boolean)this.ValidateSpatialRule(positionNode), (String)"position element shall define content");
            NodeList dataList = positionNode.getElementsByTagName("sml:AbstractProcess");
            if (dataList.getLength() != 0) continue;
            throw new SkipException("positional information is not defined");
        }
    }

    @Test(description="A.5.7 - Requirement 32", groups={"PhysicalComponent"}, dependsOnMethods={"DependencyCore"})
    public void Definition() {
        NodeList componens = this.testSubject.getDocumentElement().getElementsByTagName("sml:components");
        int componensCount = componens.getLength();
        if (componensCount > 0) {
            throw new AssertionError((Object)"No intent to further divide the device description into sub-\u00adprocess components");
        }
        NodeList inputs = this.testSubject.getDocumentElement().getElementsByTagName("sml:inputs");
        int inputsCount = inputs.getLength();
        if (inputsCount == 0) {
            throw new AssertionError((Object)"No inputs");
        }
        NodeList outputs = this.testSubject.getDocumentElement().getElementsByTagName("sml:outputs");
        int outputsCount = outputs.getLength();
        if (outputsCount == 0) {
            throw new AssertionError((Object)"No outputs");
        }
    }
}

