/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.sensorml20.util;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.logging.LoggingFeature;
import org.opengis.cite.sensorml20.ReusableEntityFilter;
import org.w3c.dom.Document;

public class ClientUtils {
    private static final Logger LOGGER = Logger.getLogger(ClientUtils.class.getName());

    public static Client buildClient() {
        ClientConfig config = new ClientConfig();
        config.property("jersey.config.client.followRedirects", (Object)true);
        config.property("jersey.config.client.connectTimeout", (Object)10000);
        config.register((Object)new LoggingFeature(LOGGER, Level.ALL, LoggingFeature.Verbosity.PAYLOAD_ANY, Integer.valueOf(5000)));
        Client client = ClientBuilder.newClient((Configuration)config);
        client.register((Object)new ReusableEntityFilter());
        return client;
    }

    public static Client buildClientWithProxy(String proxyHost, int proxyPort) {
        ClientConfig config = new ClientConfig();
        config.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
        config.register((Object)new LoggingFeature(LOGGER, Level.ALL, LoggingFeature.Verbosity.PAYLOAD_ANY, Integer.valueOf(5000)));
        InetSocketAddress addr = new InetSocketAddress(proxyHost, proxyPort);
        Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
        config.property("jersey.config.client.proxy.uri", (Object)proxy);
        config.property("jersey.config.client.followRedirects", (Object)true);
        config.property("jersey.config.client.logging.verbosity", (Object)LoggingFeature.Verbosity.PAYLOAD_ANY);
        config.property("jersey.config.client.logging.logger.level", (Object)Level.ALL);
        Client client = ClientBuilder.newClient((Configuration)config);
        client.register((Object)new ReusableEntityFilter());
        return client;
    }

    public static Response buildGetRequest(URI endpoint, Map<String, String> qryParams, MediaType ... mediaTypes) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)endpoint);
        if (null != qryParams) {
            for (Map.Entry<String, String> param : qryParams.entrySet()) {
                uriBuilder.queryParam(param.getKey(), new Object[]{param.getValue()});
            }
        }
        URI uri = uriBuilder.build(new Object[0]);
        WebTarget target = ClientUtils.buildClient().target(uri);
        Invocation.Builder reqBuilder = target.request();
        if (null != mediaTypes && mediaTypes.length > 0) {
            reqBuilder = reqBuilder.accept(mediaTypes);
        }
        Invocation req = reqBuilder.buildGet();
        return req.invoke();
    }

    public static MediaType removeParameters(MediaType mediaType) {
        return new MediaType(mediaType.getType(), mediaType.getSubtype());
    }

    public static Source getResponseEntityAsSource(ClientResponse response, String targetURI) {
        Source source = (Source)response.readEntity(DOMSource.class);
        if (null != targetURI && !targetURI.isEmpty()) {
            source.setSystemId(targetURI);
        }
        return source;
    }

    public static Document getResponseEntityAsDocument(ClientResponse response, String targetURI) {
        DOMSource domSource = (DOMSource)ClientUtils.getResponseEntityAsSource(response, targetURI);
        Document entityDoc = (Document)domSource.getNode();
        entityDoc.setDocumentURI(domSource.getSystemId());
        return entityDoc;
    }
}

