/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te;

import com.occamlab.te.Generator;
import com.occamlab.te.SetupOptions;
import com.occamlab.te.index.Index;
import com.occamlab.te.index.SuiteEntry;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ListSuites {
    public static void main(String[] args) throws Exception {
        SetupOptions setupOpts = new SetupOptions();
        File scriptsDir = new File(SetupOptions.getBaseConfigDirectory(), "scripts");
        String cmd = "java com.occamlab.te.ListSuites";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-source=")) {
                File f = new File(scriptsDir, args[i].substring(8));
                if (f.exists() && setupOpts.addSourceWithValidation(f)) continue;
                System.out.println("Error: Can't find CTL script(s) at " + f.getAbsolutePath());
                return;
            }
            if (args[i].startsWith("-cmd=")) {
                cmd = args[i].substring(5);
                continue;
            }
            if (!args[i].equals("-h") && !args[i].equals("-help") && !args[i].equals("-?")) continue;
            ListSuites.syntax(cmd);
            return;
        }
        if (setupOpts.getSources().isEmpty()) {
            String path = SetupOptions.getBaseConfigDirectory() + "/config.xml";
            if (new File(path).exists()) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setExpandEntityReferences(false);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(path);
                NodeList nl = doc.getElementsByTagName("source");
                if (nl != null) {
                    for (int i = 0; i < nl.getLength(); ++i) {
                        Element source = (Element)nl.item(i);
                        File f = new File(scriptsDir, source.getTextContent());
                        if (!f.exists() || !setupOpts.addSourceWithValidation(f)) {
                            System.out.println("Error: Can't find CTL script(s) at " + f.getAbsolutePath());
                        }
                        ListSuites.listSuites(setupOpts, true);
                        setupOpts.getSources().clear();
                    }
                }
            } else {
                System.out.println("No config.xml file found in TE_BASE path " + SetupOptions.getBaseConfigDirectory());
            }
        } else {
            ListSuites.listSuites(setupOpts, false);
        }
    }

    static void listSuites(SetupOptions setupOpts, boolean printSource) throws Exception {
        Index index = Generator.generateXsl(setupOpts);
        if (printSource) {
            System.out.println("Source: " + setupOpts.getSources().get(0));
        }
        for (String suiteId : index.getSuiteKeys()) {
            String link;
            SuiteEntry suite = index.getSuite(suiteId);
            if (printSource) {
                System.out.print("  ");
            }
            System.out.print("Suite " + suite.getPrefix() + ":" + suite.getLocalName());
            System.out.println(" (" + suiteId + ")");
            System.out.println("  Title: " + suite.getTitle());
            String desc = suite.getDescription();
            if (desc != null) {
                System.out.println("  Description: " + desc);
            }
            if ((link = suite.getLink()) != null) {
                System.out.println("  Link: " + link);
            }
            System.out.println();
        }
        if (index.getSuiteKeys().isEmpty()) {
            System.out.println("No suites found.");
            System.out.println("Check the sources in config.xml or supply -source=path option(s).");
        }
        System.out.println();
    }

    static void syntax(String cmd) {
        System.out.println();
        System.out.println("Lists available test suites:");
        System.out.println();
        System.out.println(cmd + " [-source=ctlfile|dir]...\n");
    }
}

