/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.parsers;

import com.occamlab.te.parsers.XSLTransformationErrorHandler;
import com.occamlab.te.util.DomUtils;
import com.occamlab.te.util.URLConnectionUtils;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSLTransformationParser {
    private static final Logger LOGR = Logger.getLogger(XSLTransformationParser.class.getName());
    DocumentBuilder db = null;
    TransformerFactory tf = null;
    Templates defaultTemplates = null;
    HashMap<String, String> defaultProperties = null;
    HashMap<String, String> defaultParams = null;
    Boolean defaultIgnoreErrors;
    Boolean defaultIgnoreWarnings;

    public XSLTransformationParser() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        this.db = dbf.newDocumentBuilder();
        this.tf = TransformerFactory.newInstance();
        this.defaultProperties = new HashMap();
        this.defaultParams = new HashMap();
        this.defaultIgnoreErrors = Boolean.FALSE;
        this.defaultIgnoreWarnings = Boolean.TRUE;
    }

    public XSLTransformationParser(Node node) throws Exception {
        this.defaultTemplates = this.parseInstruction(DomUtils.getElement(node), this.defaultProperties, this.defaultParams, this.defaultIgnoreErrors, this.defaultIgnoreWarnings);
    }

    public XSLTransformationParser(String reftype, String ref) throws Exception {
        this.defaultTemplates = this.tf.newTemplates(this.getSource(reftype, ref));
    }

    private Source getSource(String reftype, String ref) throws Exception {
        if (reftype.equals("url")) {
            URL url = new URL(ref);
            return new StreamSource(url.openStream());
        }
        if (reftype.equals("file")) {
            return new StreamSource(ref);
        }
        if (reftype.equals("resource")) {
            ClassLoader cl = this.getClass().getClassLoader();
            return new StreamSource(cl.getResourceAsStream(ref));
        }
        return null;
    }

    private Templates parseInstruction(Element instruction, HashMap<String, String> properties, HashMap<String, String> params, Boolean ignoreErrors, Boolean ignoreWarnings) throws Exception {
        String ignoreWarningsAtt;
        Element stylesheet;
        String[] atts;
        Templates templates = null;
        for (String att : atts = new String[]{"url", "file", "resource"}) {
            String val = instruction.getAttribute(att);
            if (val.length() <= 0) continue;
            templates = this.tf.newTemplates(this.getSource(att, val));
            break;
        }
        if ((stylesheet = DomUtils.getElementByTagNameNS(instruction, "http://www.w3.org/1999/XSL/Transform", "stylesheet")) == null) {
            stylesheet = DomUtils.getElementByTagNameNS(instruction, "http://www.w3.org/1999/XSL/Transform", "transform");
        }
        if (stylesheet != null) {
            templates = this.tf.newTemplates(new DOMSource(stylesheet));
        }
        List<Element> children = DomUtils.getChildElements(instruction);
        for (Element e : children) {
            if (e.getLocalName().equals("property") && e.getNamespaceURI().equals("http://www.occamlab.com/te/parsers")) {
                properties.put(e.getAttribute("name"), e.getTextContent());
            }
            if (!e.getLocalName().equals("with-param") || !e.getNamespaceURI().equals("http://www.occamlab.com/te/parsers")) continue;
            params.put(e.getAttribute("name"), e.getTextContent());
        }
        String ignoreErrorsAtt = instruction.getAttribute("ignoreErrors");
        if (ignoreErrorsAtt != null) {
            ignoreErrors = Boolean.parseBoolean(ignoreErrorsAtt);
        }
        if ((ignoreWarningsAtt = instruction.getAttribute("ignoreWarnings")) != null) {
            ignoreWarnings = Boolean.parseBoolean(ignoreWarningsAtt);
        }
        return templates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parse(URLConnection uc, Element instruction, PrintWriter logger) throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>(this.defaultProperties);
        HashMap<String, String> params = new HashMap<String, String>(this.defaultParams);
        Boolean ignoreErrors = this.defaultIgnoreErrors;
        Boolean ignoreWarnings = this.defaultIgnoreWarnings;
        Templates templates = this.parseInstruction(instruction, properties, params, ignoreErrors, ignoreWarnings);
        Transformer t2 = null;
        t2 = templates != null ? templates.newTransformer() : (this.defaultTemplates != null ? this.defaultTemplates.newTransformer() : this.tf.newTransformer());
        for (Map.Entry<String, String> prop : properties.entrySet()) {
            t2.setOutputProperty(prop.getKey(), prop.getValue());
        }
        for (Map.Entry<String, String> param : params.entrySet()) {
            t2.setParameter(param.getKey(), param.getValue());
        }
        XSLTransformationErrorHandler el = new XSLTransformationErrorHandler(logger, ignoreErrors, ignoreWarnings);
        t2.setErrorListener(el);
        Document doc = this.db.newDocument();
        InputStream is = null;
        try {
            if (LOGR.isLoggable(Level.FINER)) {
                String msg = String.format("Attempting to transform source from %s using instruction set:%n %s", uc.getURL(), DomUtils.serializeNode(instruction));
                LOGR.finer(msg);
            }
            is = URLConnectionUtils.getInputStream(uc);
            t2.transform(new StreamSource(is), new DOMResult(doc));
        }
        catch (TransformerException e) {
            el.error(e);
        }
        finally {
            if (null != is) {
                is.close();
            }
        }
        if (el.getErrorCount() > 0 && !ignoreErrors.booleanValue()) {
            return null;
        }
        if (el.getWarningCount() > 0 && !ignoreWarnings.booleanValue()) {
            return null;
        }
        return doc;
    }
}

