/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.saxon;

import com.occamlab.te.index.FunctionEntry;
import com.occamlab.te.index.Index;
import com.occamlab.te.saxon.GetTypeFunctionCall;
import com.occamlab.te.saxon.TEJavaFunctionCall;
import com.occamlab.te.saxon.TEXSLFunctionCall;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;

public class TEFunctionLibrary
implements FunctionLibrary {
    Configuration config = null;
    Index index = null;

    public TEFunctionLibrary(Configuration config, Index index) {
        this.config = config;
        this.index = index;
    }

    @Override
    public Expression bind(StructuredQName functionName, Expression[] staticArgs, StaticContext env) throws XPathException {
        if (functionName.getNamespaceURI().equals("http://www.occamlab.com/te") && functionName.getLocalName().equals("get-type")) {
            return new GetTypeFunctionCall(functionName, staticArgs, env);
        }
        String key = functionName.getClarkName();
        List<FunctionEntry> functions = this.index.getFunctions(key);
        int argCount = staticArgs.length;
        if (functions != null) {
            for (FunctionEntry fe : functions) {
                if (argCount < fe.getMinArgs() || argCount > fe.getMaxArgs()) continue;
                if (fe.isJava()) {
                    return new TEJavaFunctionCall(fe, functionName, staticArgs, env);
                }
                return new TEXSLFunctionCall(fe, functionName, staticArgs, env);
            }
        }
        return null;
    }

    @Override
    public FunctionLibrary copy() {
        return new TEFunctionLibrary(this.config, this.index);
    }

    @Override
    public boolean isAvailable(StructuredQName functionName, int arity) {
        String key = functionName.getClarkName();
        List<FunctionEntry> functions = this.index.getFunctions(key);
        if (functions != null) {
            for (FunctionEntry fe : functions) {
                if (arity == -1) {
                    return true;
                }
                if (arity < fe.getMinArgs() || arity > fe.getMaxArgs()) continue;
                return true;
            }
        }
        return false;
    }
}

