/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.GDateValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Whitespace;

public class GMonthValue
extends GDateValue {
    private static Pattern regex = Pattern.compile("--([0-9][0-9])(--)?(Z|[+-][0-9][0-9]:[0-9][0-9])?");

    private GMonthValue() {
    }

    public static ConversionResult makeGMonthValue(CharSequence value) {
        GMonthValue g2 = new GMonthValue();
        Matcher m4 = regex.matcher(Whitespace.trimWhitespace(value));
        if (!m4.matches()) {
            return new ValidationFailure("Cannot convert '" + value + "' to a gMonth");
        }
        String base = m4.group(1);
        String tz = m4.group(3);
        String date = "2000-" + base + "-01" + (tz == null ? "" : tz);
        g2.typeLabel = BuiltInAtomicType.G_MONTH;
        return GMonthValue.setLexicalValue(g2, date);
    }

    public GMonthValue(byte month, int tz) {
        this(month, tz, BuiltInAtomicType.G_MONTH);
    }

    public GMonthValue(byte month, int tz, AtomicType type) {
        this.year = 2000;
        this.month = month;
        this.day = 1;
        this.setTimezoneInMinutes(tz);
        this.typeLabel = type;
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        GMonthValue v = new GMonthValue(this.month, this.getTimezoneInMinutes());
        v.typeLabel = typeLabel;
        return v;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.G_MONTH;
    }

    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, XPathContext context) {
        switch (requiredType.getPrimitiveType()) {
            case 526: 
            case 632: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationFailure err = new ValidationFailure("Cannot convert gMonth to " + requiredType.getDisplayName());
        err.setErrorCode("XPTY0004");
        return err;
    }

    public CharSequence getStringValueCS() {
        FastStringBuffer sb = new FastStringBuffer(16);
        sb.append("--");
        GMonthValue.appendTwoDigits(sb, this.month);
        if (this.hasTimezone()) {
            this.appendTimezone(sb);
        }
        return sb;
    }

    public CalendarValue add(DurationValue duration) throws XPathException {
        XPathException err = new XPathException("Cannot add a duration to an xs:gMonth");
        err.setErrorCode("XPTY0004");
        throw err;
    }

    public CalendarValue adjustTimezone(int tz) {
        DateTimeValue dt = (DateTimeValue)this.toDateTime().adjustTimezone(tz);
        return new GMonthValue(dt.getMonth(), dt.getTimezoneInMinutes());
    }
}

