/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.lib.Timer;
import org.slf4j.Logger;

@Deprecated
public class ProgressMonitor {
    private final Output output;
    private final long tickPoint;
    private final int superTick;
    private final Timer timer;
    private final String label;
    private long counterBatch = 0L;
    private long counterTotal = 0L;
    private long lastTime = 0L;

    public static ProgressMonitor create(Logger log, String label, long tickPoint, int superTick) {
        Output outputToLog = (fmt, args) -> {
            if (log != null && log.isInfoEnabled()) {
                String str = String.format(fmt, args);
                log.info(str);
            }
        };
        return new ProgressMonitor(label, tickPoint, superTick, outputToLog);
    }

    public ProgressMonitor(String label, long tickPoint, int superTick, Output output) {
        this.output = output;
        this.label = label;
        this.tickPoint = tickPoint;
        this.superTick = superTick;
        this.timer = new Timer();
    }

    public void startMessage() {
        this.startMessage(null);
    }

    public void startMessage(String msg) {
        if (msg != null) {
            this.output.print(msg, new Object[0]);
        } else {
            this.output.print("Start: " + this.label, new Object[0]);
        }
    }

    public void finishMessage() {
        long timePoint = this.timer.getTimeInterval();
        if (timePoint != 0L) {
            double time = (double)timePoint / 1000.0;
            long runAvgRate = this.counterTotal * 1000L / timePoint;
            this.print("Finished: %,d %s %.2fs (Avg: %,d)", this.counterTotal, this.label, time, runAvgRate);
        } else {
            this.print("Finished: %,d %s (Avg: ----)", this.counterTotal, this.label);
        }
    }

    public void start() {
        this.timer.startTimer();
        this.lastTime = 0L;
    }

    public long finish() {
        long totalTime = this.timer.endTimer();
        return totalTime;
    }

    public long getTicks() {
        return this.counterTotal;
    }

    public void tick() {
        ++this.counterBatch;
        ++this.counterTotal;
        if (ProgressMonitor.tickPoint(this.counterTotal, this.tickPoint)) {
            long timePoint = this.timer.readTimer();
            long thisTime = timePoint - this.lastTime;
            if (thisTime != 0L && timePoint != 0L) {
                long batchAvgRate = this.counterBatch * 1000L / thisTime;
                long runAvgRate = this.counterTotal * 1000L / timePoint;
                this.print("Add: %,d %s (Batch: %,d / Avg: %,d)", this.counterTotal, this.label, batchAvgRate, runAvgRate);
            } else {
                this.print("Add: %,d %s (Batch: ---- / Avg: ----)", this.counterTotal, this.label);
            }
            this.lastTime = timePoint;
            if (ProgressMonitor.tickPoint(this.counterTotal, (long)this.superTick * this.tickPoint)) {
                this.elapsed(timePoint);
            }
            this.counterBatch = 0L;
            this.lastTime = timePoint;
        }
    }

    protected void elapsed(long timerReading) {
        float elapsedSecs = (float)timerReading / 1000.0f;
        this.print("  Elapsed: %,.2f seconds [%s]", Float.valueOf(elapsedSecs), DateTimeUtils.nowAsString());
    }

    private void print(String fmt, Object ... args) {
        if (this.output != null) {
            this.output.print(fmt, args);
        }
    }

    static boolean tickPoint(long counter, long quantum) {
        return counter % quantum == 0L;
    }

    @FunctionalInterface
    public static interface Output {
        public void print(String var1, Object ... var2);
    }
}

