/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.sta10.createUpdateDelete;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.cite.sta10.SuiteAttribute;
import org.opengis.cite.sta10.util.EntityProperties;
import org.opengis.cite.sta10.util.EntityType;
import org.opengis.cite.sta10.util.HTTPMethods;
import org.opengis.cite.sta10.util.ServiceURLBuilder;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class Capability2Tests {
    public String rootUri;
    private List<Long> thingIds = new ArrayList<Long>();
    private List<Long> locationIds = new ArrayList<Long>();
    private List<Long> historicalLocationIds = new ArrayList<Long>();
    private List<Long> datastreamIds = new ArrayList<Long>();
    private List<Long> observationIds = new ArrayList<Long>();
    private List<Long> sensorIds = new ArrayList<Long>();
    private List<Long> obsPropIds = new ArrayList<Long>();
    private List<Long> foiIds = new ArrayList<Long>();

    @BeforeClass
    public void obtainTestSubject(ITestContext testContext) {
        Object obj = testContext.getSuite().getAttribute(SuiteAttribute.LEVEL.getName());
        if (null != obj) {
            Integer level = (Integer)Integer.class.cast(obj);
            Assert.assertTrue((level > 1 ? 1 : 0) != 0, (String)("Conformance level 2 will not be checked since ics = " + level));
        }
        this.rootUri = testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName()).toString();
        this.rootUri = this.rootUri.trim();
        if (this.rootUri.lastIndexOf(47) == this.rootUri.length() - 1) {
            this.rootUri = this.rootUri.substring(0, this.rootUri.length() - 1);
        }
        this.deleteEverythings();
    }

    @Test(description="POST Entities", groups={"level-2"}, priority=2)
    public void createEntities() {
        try {
            String urlParameters = "{\"description\":\"This is a Test Thing From TestNG\"}";
            JSONObject entity = this.postEntity(EntityType.THING, urlParameters);
            long thingId = entity.getLong("@iot.id");
            this.thingIds.add(thingId);
            urlParameters = "{\n  \"description\": \"bow river\",\n  \"encodingType\": \"http://example.org/location_types#GeoJSON\",\n  \"location\": { \"type\": \"Point\", \"coordinates\": [-114.05, 51.05] }\n}";
            entity = this.postEntity(EntityType.LOCATION, urlParameters);
            long locationId = entity.getLong("@iot.id");
            this.locationIds.add(locationId);
            JSONObject locationEntity = entity;
            urlParameters = "{\n  \"description\": \"Fuguro Barometer\",\n  \"encodingType\": \"http://schema.org/description\",\n  \"metadata\": \"Barometer\"\n}";
            entity = this.postEntity(EntityType.SENSOR, urlParameters);
            long sensorId = entity.getLong("@iot.id");
            this.sensorIds.add(sensorId);
            urlParameters = "{\n  \"name\": \"DewPoint Temperature\",\n  \"definition\": \"http://dbpedia.org/page/Dew_point\",\n  \"description\": \"The dewpoint temperature is the temperature to which the air must be cooled, at constant pressure, for dew to form. As the grass and other objects near the ground cool to the dewpoint, some of the water vapor in the atmosphere condenses into liquid water on the objects.\"\n}";
            entity = this.postEntity(EntityType.OBSERVED_PROPERTY, urlParameters);
            long obsPropId = entity.getLong("@iot.id");
            this.obsPropIds.add(obsPropId);
            urlParameters = "{\n  \"description\": \"A weather station.\",\n  \"encodingType\": \"http://example.org/location_types#GeoJSON\",\n  \"feature\": {\n    \"type\": \"Point\",\n    \"coordinates\": [\n      10,\n      10\n    ]\n  }\n}";
            entity = this.postEntity(EntityType.FEATURE_OF_INTEREST, urlParameters);
            long foiId = entity.getLong("@iot.id");
            this.foiIds.add(foiId);
            urlParameters = "{\n  \"unitOfMeasurement\": {\n    \"name\": \"Celsius\",\n    \"symbol\": \"degC\",\n    \"definition\": \"http://qudt.org/vocab/unit#DegreeCelsius\"\n  },\n  \"description\": \"test datastream.\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n  \"Thing\": { \"@iot.id\": " + thingId + " },\n" + "  \"ObservedProperty\":{ \"@iot.id\":" + obsPropId + "},\n" + "  \"Sensor\": { \"@iot.id\": " + sensorId + " }\n" + "}";
            entity = this.postEntity(EntityType.DATASTREAM, urlParameters);
            long datastreamId = entity.getLong("@iot.id");
            this.datastreamIds.add(datastreamId);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-01T00:40:00.000Z\",\n  \"result\": 8,\n  \"Datastream\":{\"@iot.id\": " + datastreamId + "},\n" + "  \"FeatureOfInterest\": {\"@iot.id\": " + foiId + "}  \n" + "}";
            entity = this.postEntity(EntityType.OBSERVATION, urlParameters);
            long obsId1 = entity.getLong("@iot.id");
            this.observationIds.add(obsId1);
            urlParameters = "{\"Locations\":[{\"@iot.id\":" + locationId + "}]}";
            this.patchEntity(EntityType.THING, urlParameters, thingId);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-01T00:00:00.000Z\",\n  \"resultTime\": \"2015-03-01T01:00:00.000Z\",\n  \"result\": 100,\n  \"Datastream\":{\"@iot.id\": " + datastreamId + "}\n" + "}";
            entity = this.postEntity(EntityType.OBSERVATION, urlParameters);
            this.checkForObservationResultTime(entity, "2015-03-01T01:00:00.000Z");
            long obsId2 = entity.getLong("@iot.id");
            this.observationIds.add(obsId2);
            long automatedFOIId = this.checkAutomaticInsertionOfFOI(obsId2, locationEntity, -1L);
            this.foiIds.add(automatedFOIId);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-05-01T00:00:00.000Z\",\n  \"result\": 105,\n  \"Datastream\":{\"@iot.id\": " + datastreamId + "}\n" + "}";
            entity = this.postEntity(EntityType.OBSERVATION, urlParameters);
            this.checkForObservationResultTime(entity, null);
            long obsId3 = entity.getLong("@iot.id");
            this.observationIds.add(obsId3);
            this.checkAutomaticInsertionOfFOI(obsId2, locationEntity, automatedFOIId);
            urlParameters = "{\n  \"time\": \"2015-03-01T00:40:00.000Z\",\n  \"Thing\":{\"@iot.id\": " + thingId + "},\n" + "  \"Locations\": [{\"@iot.id\": " + locationId + "}]  \n" + "}";
            entity = this.postEntity(EntityType.HISTORICAL_LOCATION, urlParameters);
            long histLocId = entity.getLong("@iot.id");
            this.historicalLocationIds.add(histLocId);
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    @Test(description="POST Entities using Deep Insert", groups={"level-2"}, priority=2)
    public void createEntitiesWithDeepInsert() {
        try {
            String urlParameters = "{\n  \"description\": \"Office Building\",\n  \"properties\": {\n    \"reference\": \"Third Floor\"\n  },\n  \"Locations\": [\n    {\n      \"description\": \"West Roof\",\n      \"location\": { \"type\": \"Point\", \"coordinates\": [-117.05, 51.05] },\n      \"encodingType\": \"http://example.org/location_types#GeoJSON\"\n    }\n  ],\n  \"Datastreams\": [\n    {\n      \"unitOfMeasurement\": {\n        \"name\": \"Lumen\",\n        \"symbol\": \"lm\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/unit/Instances.html#Lumen\"\n      },\n      \"description\": \"Light exposure.\",\n      \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n      \"ObservedProperty\": {\n        \"name\": \"Luminous Flux\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html#LuminousFlux\",\n        \"description\": \"Luminous Flux or Luminous Power is the measure of the perceived power of light.\"\n      },\n      \"Sensor\": {        \n        \"description\": \"Acme Fluxomatic 1000\",\n        \"encodingType\": \"http://schema.org/description\",\n        \"metadata\": \"Light flux sensor\"\n      }\n    }\n  ]\n}";
            JSONObject entity = this.postEntity(EntityType.THING, urlParameters);
            long thingId = entity.getLong("@iot.id");
            JSONObject deepInsertedObj = new JSONObject("{\n      \"unitOfMeasurement\": {\n        \"name\": \"Lumen\",\n        \"symbol\": \"lm\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/unit/Instances.html#Lumen\"\n      },\n      \"description\": \"Light exposure.\",\n      \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\"\n    }\n");
            long datastreamId = this.checkRelatedEntity(EntityType.THING, thingId, EntityType.DATASTREAM, deepInsertedObj);
            this.datastreamIds.add(datastreamId);
            deepInsertedObj = new JSONObject("{\n      \"description\": \"West Roof\",\n      \"location\": { \"type\": \"Point\", \"coordinates\": [-117.05, 51.05] },\n      \"encodingType\": \"http://example.org/location_types#GeoJSON\"\n    }\n");
            this.locationIds.add(this.checkRelatedEntity(EntityType.THING, thingId, EntityType.LOCATION, deepInsertedObj));
            deepInsertedObj = new JSONObject("{\n        \"description\": \"Acme Fluxomatic 1000\",\n        \"encodingType\": \"http://schema.org/description\",\n        \"metadata\": \"Light flux sensor\"\n      }\n");
            this.sensorIds.add(this.checkRelatedEntity(EntityType.DATASTREAM, datastreamId, EntityType.SENSOR, deepInsertedObj));
            deepInsertedObj = new JSONObject("{\n        \"name\": \"Luminous Flux\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html#LuminousFlux\",\n        \"description\": \"Luminous Flux or Luminous Power is the measure of the perceived power of light.\"\n      },\n");
            this.obsPropIds.add(this.checkRelatedEntity(EntityType.DATASTREAM, datastreamId, EntityType.OBSERVED_PROPERTY, deepInsertedObj));
            this.thingIds.add(thingId);
            urlParameters = "{\n  \"unitOfMeasurement\": {\n    \"name\": \"Celsius\",\n    \"symbol\": \"degC\",\n    \"definition\": \"http://qudt.org/vocab/unit#DegreeCelsius\"\n  },\n  \"description\": \"test datastream.\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n  \"Thing\": { \"@iot.id\": " + thingId + " },\n" + "   \"ObservedProperty\": {\n" + "        \"name\": \"Luminous Flux\",\n" + "        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html#LuminousFlux\",\n" + "        \"description\": \"Luminous Flux or Luminous Power is the measure of the perceived power of light.\"\n" + "   },\n" + "   \"Sensor\": {        \n" + "        \"description\": \"Acme Fluxomatic 1000\",\n" + "        \"encodingType\": \"http://schema.org/description\",\n" + "        \"metadata\": \"Light flux sensor\"\n" + "   },\n" + "      \"Observations\": [\n" + "        {\n" + "          \"phenomenonTime\": \"2015-03-01T00:10:00Z\",\n" + "          \"result\": 10\n" + "        }\n" + "      ]" + "}";
            entity = this.postEntity(EntityType.DATASTREAM, urlParameters);
            datastreamId = entity.getLong("@iot.id");
            deepInsertedObj = new JSONObject("{\n        \"description\": \"Acme Fluxomatic 1000\",\n        \"encodingType\": \"http://schema.org/description\",\n        \"metadata\": \"Light flux sensor\"\n      }\n");
            this.sensorIds.add(this.checkRelatedEntity(EntityType.DATASTREAM, datastreamId, EntityType.SENSOR, deepInsertedObj));
            deepInsertedObj = new JSONObject("{\n        \"name\": \"Luminous Flux\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html#LuminousFlux\",\n        \"description\": \"Luminous Flux or Luminous Power is the measure of the perceived power of light.\"\n      },\n");
            this.obsPropIds.add(this.checkRelatedEntity(EntityType.DATASTREAM, datastreamId, EntityType.OBSERVED_PROPERTY, deepInsertedObj));
            deepInsertedObj = new JSONObject("{\n          \"phenomenonTime\": \"2015-03-01T00:10:00.000Z\",\n          \"result\": 10\n        }\n");
            this.observationIds.add(this.checkRelatedEntity(EntityType.DATASTREAM, datastreamId, EntityType.OBSERVATION, deepInsertedObj));
            this.datastreamIds.add(datastreamId);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-01T00:00:00Z\",\n  \"result\": 100,\n  \"FeatureOfInterest\": {\n  \t\"description\": \"A weather station.\",\n  \t\"encodingType\": \"http://example.org/location_types#GeoJSON\",\n    \"feature\": {\n      \"type\": \"Point\",\n      \"coordinates\": [\n        -114.05,\n        51.05\n      ]\n    }\n  },\n  \"Datastream\":{\"@iot.id\": " + datastreamId + "}\n" + "}";
            entity = this.postEntity(EntityType.OBSERVATION, urlParameters);
            long obsId1 = entity.getLong("@iot.id");
            deepInsertedObj = new JSONObject("{\n  \"description\": \"A weather station.\",\n  \"encodingType\": \"http://example.org/location_types#GeoJSON\",\n    \"feature\": {\n      \"type\": \"Point\",\n      \"coordinates\": [\n        -114.05,\n        51.05\n      ]\n    }\n  }\n");
            this.foiIds.add(this.checkRelatedEntity(EntityType.OBSERVATION, obsId1, EntityType.FEATURE_OF_INTEREST, deepInsertedObj));
            this.observationIds.add(obsId1);
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    @Test(description="POST Invalid Entities using Deep Insert", groups={"level-2"}, priority=1)
    public void createInvalidEntitiesWithDeepInsert() {
        try {
            String urlParameters = "{\n  \"description\": \"Office Building\",\n  \"properties\": {\n    \"reference\": \"Third Floor\"\n  },\n  \"Locations\": [\n    {\n      \"description\": \"West Roof\",\n      \"location\": { \"type\": \"Point\", \"coordinates\": [-117.05, 51.05] },\n      \"encodingType\": \"http://example.org/location_types#GeoJSON\"\n    }\n  ],\n  \"Datastreams\": [\n    {\n      \"unitOfMeasurement\": {\n        \"name\": \"Lumen\",\n        \"symbol\": \"lm\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/unit/Instances.html#Lumen\"\n      },\n      \"description\": \"Light exposure.\",\n      \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n      \"ObservedProperty\": {\n        \"name\": \"Luminous Flux\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html#LuminousFlux\",\n        \"description\": \"Luminous Flux or Luminous Power is the measure of the perceived power of light.\"\n      }\n    }\n  ]\n}";
            this.postInvalidEntity(EntityType.THING, urlParameters);
            ArrayList<EntityType> entityTypesToCheck = new ArrayList<EntityType>();
            entityTypesToCheck.add(EntityType.THING);
            entityTypesToCheck.add(EntityType.LOCATION);
            entityTypesToCheck.add(EntityType.HISTORICAL_LOCATION);
            entityTypesToCheck.add(EntityType.DATASTREAM);
            entityTypesToCheck.add(EntityType.OBSERVED_PROPERTY);
            this.checkNotExisting(entityTypesToCheck);
            urlParameters = "{\"description\": \"Office Building\"}";
            long thingId = this.postEntity(EntityType.THING, urlParameters).getLong("@iot.id");
            urlParameters = "{\n  \"unitOfMeasurement\": {\n    \"name\": \"Celsius\",\n    \"symbol\": \"degC\",\n    \"definition\": \"http://qudt.org/vocab/unit#DegreeCelsius\"\n  },\n  \"description\": \"test datastream.\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n  \"Thing\": { \"@iot.id\": " + thingId + " },\n" + "   \"ObservedProperty\": {\n" + "        \"name\": \"Luminous Flux\",\n" + "        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html#LuminousFlux\",\n" + "        \"description\": \"Luminous Flux or Luminous Power is the measure of the perceived power of light.\"\n" + "   },\n" + "      \"Observations\": [\n" + "        {\n" + "          \"phenomenonTime\": \"2015-03-01T00:10:00Z\",\n" + "          \"result\": 10\n" + "        }\n" + "      ]" + "}";
            this.postInvalidEntity(EntityType.DATASTREAM, urlParameters);
            urlParameters = "{\n  \"unitOfMeasurement\": {\n    \"name\": \"Celsius\",\n    \"symbol\": \"degC\",\n    \"definition\": \"http://qudt.org/vocab/unit#DegreeCelsius\"\n  },\n  \"description\": \"test datastream.\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n  \"Thing\": { \"@iot.id\": " + thingId + " },\n" + "   \"Sensor\": {        \n" + "        \"description\": \"Acme Fluxomatic 1000\",\n" + "        \"encodingType\": \"http://schema.org/description\",\n" + "        \"metadata\": \"Light flux sensor\"\n" + "   },\n" + "      \"Observations\": [\n" + "        {\n" + "          \"phenomenonTime\": \"2015-03-01T00:10:00Z\",\n" + "          \"result\": 10\n" + "        }\n" + "      ]" + "}";
            this.postInvalidEntity(EntityType.DATASTREAM, urlParameters);
            urlParameters = "{\n  \"unitOfMeasurement\": {\n    \"name\": \"Celsius\",\n    \"symbol\": \"degC\",\n    \"definition\": \"http://qudt.org/vocab/unit#DegreeCelsius\"\n  },\n  \"description\": \"test datastream.\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n   \"ObservedProperty\": {\n        \"name\": \"Luminous Flux\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html#LuminousFlux\",\n        \"description\": \"Luminous Flux or Luminous Power is the measure of the perceived power of light.\"\n   },\n   \"Sensor\": {        \n        \"description\": \"Acme Fluxomatic 1000\",\n        \"encodingType\": \"http://schema.org/description\",\n        \"metadata\": \"Light flux sensor\"\n   },\n      \"Observations\": [\n        {\n          \"phenomenonTime\": \"2015-03-01T00:10:00Z\",\n          \"result\": 10\n        }\n      ]}";
            this.postInvalidEntity(EntityType.DATASTREAM, urlParameters);
            entityTypesToCheck.clear();
            entityTypesToCheck.add(EntityType.DATASTREAM);
            entityTypesToCheck.add(EntityType.SENSOR);
            entityTypesToCheck.add(EntityType.OBSERVATION);
            entityTypesToCheck.add(EntityType.FEATURE_OF_INTEREST);
            entityTypesToCheck.add(EntityType.OBSERVED_PROPERTY);
            this.checkNotExisting(entityTypesToCheck);
            urlParameters = "{\n  \"unitOfMeasurement\": {\n    \"name\": \"Celsius\",\n    \"symbol\": \"degC\",\n    \"definition\": \"http://qudt.org/vocab/unit#DegreeCelsius\"\n  },\n  \"description\": \"test datastream.\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n  \"Thing\": { \"@iot.id\": " + thingId + " },\n" + "   \"ObservedProperty\": {\n" + "        \"name\": \"Luminous Flux\",\n" + "        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html#LuminousFlux\",\n" + "        \"description\": \"Luminous Flux or Luminous Power is the measure of the perceived power of light.\"\n" + "   },\n" + "   \"Sensor\": {        \n" + "        \"description\": \"Acme Fluxomatic 1000\",\n" + "        \"encodingType\": \"http://schema.org/description\",\n" + "        \"metadata\": \"Light flux sensor\"\n" + "   }\n" + "}";
            long datastreamId = this.postEntity(EntityType.DATASTREAM, urlParameters).getLong("@iot.id");
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-01T00:00:00Z\",\n  \"result\": 100,\n  \"Datastream\":{\"@iot.id\": " + datastreamId + "}\n" + "}";
            this.postInvalidEntity(EntityType.OBSERVATION, urlParameters);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-01T00:00:00Z\",\n  \"result\": 100,\n  \"FeatureOfInterest\": {\n  \t\"description\": \"A weather station.\",\n    \"feature\": {\n      \"type\": \"Point\",\n      \"coordinates\": [\n        -114.05,\n        51.05\n      ]\n    }\n  },\n  \"Datastream\":{\"@iot.id\": " + datastreamId + "}\n" + "}";
            this.postInvalidEntity(EntityType.OBSERVATION, urlParameters);
            entityTypesToCheck.clear();
            entityTypesToCheck.add(EntityType.OBSERVATION);
            entityTypesToCheck.add(EntityType.FEATURE_OF_INTEREST);
            this.checkNotExisting(entityTypesToCheck);
            this.deleteEverythings();
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    @Test(description="POST Invalid Entities", groups={"level-2"}, priority=3)
    public void createInvalidEntities() {
        try {
            String urlParameters = "{\n  \"unitOfMeasurement\": {\n    \"name\": \"Celsius\",\n    \"symbol\": \"degC\",\n    \"definition\": \"http://qudt.org/vocab/unit#DegreeCelsius\"\n  },\n  \"description\": \"test datastream.\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n  \"Thing\": { \"@iot.id\": " + this.thingIds.get(0) + " },\n" + "  \"ObservedProperty\":{ \"@iot.id\":" + this.obsPropIds.get(0) + "},\n" + "}";
            this.postInvalidEntity(EntityType.DATASTREAM, urlParameters);
            urlParameters = "{\n  \"unitOfMeasurement\": {\n    \"name\": \"Celsius\",\n    \"symbol\": \"degC\",\n    \"definition\": \"http://qudt.org/vocab/unit#DegreeCelsius\"\n  },\n  \"description\": \"test datastream.\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n  \"Thing\": { \"@iot.id\": " + this.thingIds.get(0) + " },\n" + "  \"Sensor\": { \"@iot.id\": " + this.sensorIds.get(0) + " }\n" + "}";
            this.postInvalidEntity(EntityType.DATASTREAM, urlParameters);
            urlParameters = "{\n  \"unitOfMeasurement\": {\n    \"name\": \"Celsius\",\n    \"symbol\": \"degC\",\n    \"definition\": \"http://qudt.org/vocab/unit#DegreeCelsius\"\n  },\n  \"description\": \"test datastream.\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n  \"ObservedProperty\":{ \"@iot.id\":" + this.obsPropIds.get(0) + "},\n" + "  \"Sensor\": { \"@iot.id\": " + this.sensorIds.get(0) + " }\n" + "}";
            this.postInvalidEntity(EntityType.DATASTREAM, urlParameters);
            urlParameters = "{\"description\":\"This is a Test Thing From TestNG\"}";
            long thingId = this.postEntity(EntityType.THING, urlParameters).getLong("@iot.id");
            this.thingIds.add(thingId);
            urlParameters = "{\n  \"unitOfMeasurement\": {\n    \"name\": \"Celsius\",\n    \"symbol\": \"degC\",\n    \"definition\": \"http://qudt.org/vocab/unit#DegreeCelsius\"\n  },\n  \"description\": \"test datastream.\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n  \"Thing\": { \"@iot.id\": " + thingId + " },\n" + "  \"ObservedProperty\":{ \"@iot.id\":" + this.obsPropIds.get(0) + "},\n" + "  \"Sensor\": { \"@iot.id\": " + this.sensorIds.get(0) + " }\n" + "}";
            long datastreamId = this.postEntity(EntityType.DATASTREAM, urlParameters).getLong("@iot.id");
            this.datastreamIds.add(datastreamId);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-01T00:40:00.000Z\",\n  \"result\": 8,\n  \"FeatureOfInterest\": {\"@iot.id\": " + this.foiIds.get(0) + "}  \n" + "}";
            this.postInvalidEntity(EntityType.OBSERVATION, urlParameters);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-01T00:00:00.000Z\",\n  \"result\": 100,\n  \"Datastream\":{\"@iot.id\": " + datastreamId + "}\n" + "}";
            this.postInvalidEntity(EntityType.OBSERVATION, urlParameters);
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    @Test(description="PATCH Entities", groups={"level-2"}, priority=4)
    public void patchEntities() {
        try {
            long thingId = this.thingIds.get(0);
            JSONObject entity = this.getEntity(EntityType.THING, thingId);
            String urlParameters = "{\"description\":\"This is a PATCHED Test Thing From TestNG\"}";
            HashMap<String, String> diffs = new HashMap<String, String>();
            diffs.put("description", "This is a PATCHED Test Thing From TestNG");
            JSONObject updatedEntity = this.patchEntity(EntityType.THING, urlParameters, thingId);
            this.checkPatch(EntityType.THING, entity, updatedEntity, diffs);
            long locationId = this.locationIds.get(0);
            entity = this.getEntity(EntityType.LOCATION, locationId);
            urlParameters = "{\"location\": { \"type\": \"Point\", \"coordinates\": [114.05, -50] }}";
            diffs = new HashMap();
            diffs.put("location", (String)new JSONObject("{ \"type\": \"Point\", \"coordinates\": [114.05, -50] }}"));
            updatedEntity = this.patchEntity(EntityType.LOCATION, urlParameters, locationId);
            this.checkPatch(EntityType.LOCATION, entity, updatedEntity, diffs);
            long histLocId = this.historicalLocationIds.get(0);
            entity = this.getEntity(EntityType.HISTORICAL_LOCATION, histLocId);
            urlParameters = "{\"time\": \"2015-07-01T00:00:00.000Z\"}";
            diffs = new HashMap();
            diffs.put("time", "2015-07-01T00:00:00.000Z");
            updatedEntity = this.patchEntity(EntityType.HISTORICAL_LOCATION, urlParameters, histLocId);
            this.checkPatch(EntityType.HISTORICAL_LOCATION, entity, updatedEntity, diffs);
            long sensorId = this.sensorIds.get(0);
            entity = this.getEntity(EntityType.SENSOR, sensorId);
            urlParameters = "{\"metadata\": \"PATCHED\"}";
            diffs = new HashMap();
            diffs.put("metadata", "PATCHED");
            updatedEntity = this.patchEntity(EntityType.SENSOR, urlParameters, sensorId);
            this.checkPatch(EntityType.SENSOR, entity, updatedEntity, diffs);
            long obsPropId = this.obsPropIds.get(0);
            entity = this.getEntity(EntityType.OBSERVED_PROPERTY, obsPropId);
            urlParameters = "{\"description\":\"PATCHED\"}";
            diffs = new HashMap();
            diffs.put("description", "PATCHED");
            updatedEntity = this.patchEntity(EntityType.OBSERVED_PROPERTY, urlParameters, obsPropId);
            this.checkPatch(EntityType.OBSERVED_PROPERTY, entity, updatedEntity, diffs);
            long foiId = this.foiIds.get(0);
            entity = this.getEntity(EntityType.FEATURE_OF_INTEREST, foiId);
            urlParameters = "{\"feature\":{ \"type\": \"Point\", \"coordinates\": [114.05, -51.05] }}";
            diffs = new HashMap();
            diffs.put("feature", (String)new JSONObject("{ \"type\": \"Point\", \"coordinates\": [114.05, -51.05] }"));
            updatedEntity = this.patchEntity(EntityType.FEATURE_OF_INTEREST, urlParameters, foiId);
            this.checkPatch(EntityType.FEATURE_OF_INTEREST, entity, updatedEntity, diffs);
            long datastreamId = this.datastreamIds.get(0);
            entity = this.getEntity(EntityType.DATASTREAM, datastreamId);
            urlParameters = "{\"description\": \"Patched Description\"}";
            diffs = new HashMap();
            diffs.put("description", "Patched Description");
            updatedEntity = this.patchEntity(EntityType.DATASTREAM, urlParameters, datastreamId);
            this.checkPatch(EntityType.DATASTREAM, entity, updatedEntity, diffs);
            entity = updatedEntity;
            urlParameters = "{ \"unitOfMeasurement\": {\n    \"name\": \"Entropy2\",\n    \"symbol\": \"S2\",\n    \"definition\": \"http://qudt.org/vocab/unit#Entropy2\"\n  } }";
            diffs = new HashMap();
            diffs.put("unitOfMeasurement", (String)new JSONObject("{\"name\": \"Entropy2\",\"symbol\": \"S2\",\"definition\": \"http://qudt.org/vocab/unit#Entropy2\"}"));
            updatedEntity = this.patchEntity(EntityType.DATASTREAM, urlParameters, datastreamId);
            this.checkPatch(EntityType.DATASTREAM, entity, updatedEntity, diffs);
            long obsId1 = this.observationIds.get(0);
            entity = this.getEntity(EntityType.OBSERVATION, obsId1);
            urlParameters = "{\"phenomenonTime\": \"2015-07-01T00:40:00.000Z\"}";
            diffs = new HashMap();
            diffs.put("phenomenonTime", "2015-07-01T00:40:00.000Z");
            updatedEntity = this.patchEntity(EntityType.OBSERVATION, urlParameters, obsId1);
            this.checkPatch(EntityType.OBSERVATION, entity, updatedEntity, diffs);
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    @Test(description="PUT Entities", groups={"level-2"}, priority=4)
    public void putEntities() {
        try {
            long thingId = this.thingIds.get(0);
            JSONObject entity = this.getEntity(EntityType.THING, thingId);
            String urlParameters = "{\"description\":\"This is a Updated Test Thing From TestNG\"}";
            HashMap<String, String> diffs = new HashMap<String, String>();
            diffs.put("description", "This is a Updated Test Thing From TestNG");
            JSONObject updatedEntity = this.updateEntity(EntityType.THING, urlParameters, thingId);
            this.checkPut(EntityType.THING, entity, updatedEntity, diffs);
            long locationId = this.locationIds.get(0);
            entity = this.getEntity(EntityType.LOCATION, locationId);
            urlParameters = "{\"encodingType\":\"UPDATED ENCODING\",\"description\":\"UPDATED DESCRIPTION\", \"location\": { \"type\": \"Point\", \"coordinates\": [-114.05, 50] }}";
            diffs = new HashMap();
            diffs.put("encodingType", "UPDATED ENCODING");
            diffs.put("description", "UPDATED DESCRIPTION");
            diffs.put("location", (String)new JSONObject("{ \"type\": \"Point\", \"coordinates\": [-114.05, 50] }}"));
            updatedEntity = this.updateEntity(EntityType.LOCATION, urlParameters, locationId);
            this.checkPut(EntityType.LOCATION, entity, updatedEntity, diffs);
            long histLocId = this.historicalLocationIds.get(0);
            entity = this.getEntity(EntityType.HISTORICAL_LOCATION, histLocId);
            urlParameters = "{\"time\": \"2015-08-01T00:00:00.000Z\"}";
            diffs = new HashMap();
            diffs.put("time", "2015-08-01T00:00:00.000Z");
            updatedEntity = this.updateEntity(EntityType.HISTORICAL_LOCATION, urlParameters, histLocId);
            this.checkPut(EntityType.HISTORICAL_LOCATION, entity, updatedEntity, diffs);
            long sensorId = this.sensorIds.get(0);
            entity = this.getEntity(EntityType.SENSOR, sensorId);
            urlParameters = "{\"description\": \"UPDATED\", \"encodingType\":\"http://schema.org/description\", \"metadata\": \"UPDATED\"}";
            diffs = new HashMap();
            diffs.put("description", "UPDATED");
            diffs.put("encodingType", "http://schema.org/description");
            diffs.put("metadata", "UPDATED");
            updatedEntity = this.updateEntity(EntityType.SENSOR, urlParameters, sensorId);
            this.checkPut(EntityType.SENSOR, entity, updatedEntity, diffs);
            long obsPropId = this.obsPropIds.get(0);
            urlParameters = "{\"name\":\"QWERTY\", \"definition\": \"ZXCVB\", \"description\":\"POIUYTREW\"}";
            diffs = new HashMap();
            diffs.put("name", "QWERTY");
            diffs.put("definition", "ZXCVB");
            diffs.put("description", "POIUYTREW");
            updatedEntity = this.updateEntity(EntityType.OBSERVED_PROPERTY, urlParameters, obsPropId);
            this.checkPut(EntityType.OBSERVED_PROPERTY, entity, updatedEntity, diffs);
            long foiId = this.foiIds.get(0);
            entity = this.getEntity(EntityType.FEATURE_OF_INTEREST, foiId);
            urlParameters = "{\"encodingType\":\"SQUARE\",\"feature\":{ \"type\": \"Point\", \"coordinates\": [-114.05, 51.05] }, \"description\":\"POIUYTREW\"}";
            diffs = new HashMap();
            diffs.put("encodingType", "SQUARE");
            diffs.put("feature", (String)new JSONObject("{ \"type\": \"Point\", \"coordinates\": [-114.05, 51.05] }"));
            diffs.put("description", "POIUYTREW");
            updatedEntity = this.updateEntity(EntityType.FEATURE_OF_INTEREST, urlParameters, foiId);
            this.checkPut(EntityType.FEATURE_OF_INTEREST, entity, updatedEntity, diffs);
            long datastreamId = this.datastreamIds.get(0);
            entity = this.getEntity(EntityType.DATASTREAM, datastreamId);
            urlParameters = "{\n  \"description\": \"Data coming from sensor on ISS.\",\n  \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Observation\",\n  \"unitOfMeasurement\": {\n    \"name\": \"Entropy\",\n    \"symbol\": \"S\",\n    \"definition\": \"http://qudt.org/vocab/unit#Entropy\"\n  }\n}\n";
            diffs = new HashMap();
            diffs.put("description", "Data coming from sensor on ISS.");
            diffs.put("observationType", "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Observation");
            diffs.put("unitOfMeasurement", (String)new JSONObject("{\"name\": \"Entropy\",\"symbol\": \"S\",\"definition\": \"http://qudt.org/vocab/unit#Entropy\"}"));
            updatedEntity = this.updateEntity(EntityType.DATASTREAM, urlParameters, datastreamId);
            this.checkPut(EntityType.DATASTREAM, entity, updatedEntity, diffs);
            long obsId1 = this.observationIds.get(0);
            entity = this.getEntity(EntityType.OBSERVATION, obsId1);
            urlParameters = "{\"result\": \"99\", \"phenomenonTime\": \"2015-08-01T00:40:00.000Z\"}";
            diffs = new HashMap();
            diffs.put("result", "99");
            diffs.put("phenomenonTime", "2015-08-01T00:40:00.000Z");
            updatedEntity = this.updateEntity(EntityType.OBSERVATION, urlParameters, obsId1);
            this.checkPut(EntityType.OBSERVATION, entity, updatedEntity, diffs);
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    @Test(description="DELETE Entities", groups={"level-2"}, priority=5)
    public void deleteEntities() {
        int i;
        for (i = 0; i < this.observationIds.size(); ++i) {
            this.deleteEntity(EntityType.OBSERVATION, this.observationIds.get(i));
        }
        for (i = 0; i < this.foiIds.size(); ++i) {
            this.deleteEntity(EntityType.FEATURE_OF_INTEREST, this.foiIds.get(i));
        }
        for (i = 0; i < this.datastreamIds.size(); ++i) {
            this.deleteEntity(EntityType.DATASTREAM, this.datastreamIds.get(i));
        }
        for (i = 0; i < this.obsPropIds.size(); ++i) {
            this.deleteEntity(EntityType.OBSERVED_PROPERTY, this.obsPropIds.get(i));
        }
        for (i = 0; i < this.sensorIds.size(); ++i) {
            this.deleteEntity(EntityType.SENSOR, this.sensorIds.get(i));
        }
        for (i = 0; i < this.historicalLocationIds.size(); ++i) {
            this.deleteEntity(EntityType.HISTORICAL_LOCATION, this.historicalLocationIds.get(i));
        }
        for (i = 0; i < this.locationIds.size(); ++i) {
            this.deleteEntity(EntityType.LOCATION, this.locationIds.get(i));
        }
        for (i = 0; i < this.thingIds.size(); ++i) {
            this.deleteEntity(EntityType.THING, this.thingIds.get(i));
        }
        this.deleteNonExsistentEntity(EntityType.THING);
        this.deleteNonExsistentEntity(EntityType.LOCATION);
        this.deleteNonExsistentEntity(EntityType.HISTORICAL_LOCATION);
        this.deleteNonExsistentEntity(EntityType.SENSOR);
        this.deleteNonExsistentEntity(EntityType.OBSERVED_PROPERTY);
        this.deleteNonExsistentEntity(EntityType.DATASTREAM);
        this.deleteNonExsistentEntity(EntityType.OBSERVATION);
        this.deleteNonExsistentEntity(EntityType.FEATURE_OF_INTEREST);
        this.checkDeleteIntegrityConstraint();
    }

    private void checkDeleteIntegrityConstraint() {
        this.createEntitiesForDelete();
        this.deleteEntity(EntityType.THING, this.thingIds.get(0));
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        entityTypes.add(EntityType.THING);
        entityTypes.add(EntityType.DATASTREAM);
        entityTypes.add(EntityType.HISTORICAL_LOCATION);
        entityTypes.add(EntityType.OBSERVATION);
        this.checkNotExisting(entityTypes);
        entityTypes.clear();
        entityTypes.add(EntityType.LOCATION);
        entityTypes.add(EntityType.SENSOR);
        entityTypes.add(EntityType.OBSERVED_PROPERTY);
        entityTypes.add(EntityType.FEATURE_OF_INTEREST);
        this.checkExisting(entityTypes);
        this.createEntitiesForDelete();
        this.deleteEntity(EntityType.DATASTREAM, this.datastreamIds.get(0));
        entityTypes.clear();
        entityTypes.add(EntityType.DATASTREAM);
        entityTypes.add(EntityType.OBSERVATION);
        this.checkNotExisting(entityTypes);
        entityTypes.clear();
        entityTypes.add(EntityType.THING);
        entityTypes.add(EntityType.SENSOR);
        entityTypes.add(EntityType.OBSERVED_PROPERTY);
        entityTypes.add(EntityType.FEATURE_OF_INTEREST);
        entityTypes.add(EntityType.LOCATION);
        entityTypes.add(EntityType.HISTORICAL_LOCATION);
        this.checkExisting(entityTypes);
        this.createEntitiesForDelete();
        this.deleteEntity(EntityType.LOCATION, this.locationIds.get(0));
        entityTypes.clear();
        entityTypes.add(EntityType.LOCATION);
        entityTypes.add(EntityType.HISTORICAL_LOCATION);
        this.checkNotExisting(entityTypes);
        entityTypes.clear();
        entityTypes.add(EntityType.THING);
        entityTypes.add(EntityType.SENSOR);
        entityTypes.add(EntityType.OBSERVED_PROPERTY);
        entityTypes.add(EntityType.FEATURE_OF_INTEREST);
        entityTypes.add(EntityType.DATASTREAM);
        entityTypes.add(EntityType.OBSERVATION);
        this.checkExisting(entityTypes);
        this.createEntitiesForDelete();
        this.deleteEntity(EntityType.HISTORICAL_LOCATION, this.historicalLocationIds.get(0));
        entityTypes.clear();
        entityTypes.add(EntityType.HISTORICAL_LOCATION);
        this.checkNotExisting(entityTypes);
        entityTypes.clear();
        entityTypes.add(EntityType.THING);
        entityTypes.add(EntityType.SENSOR);
        entityTypes.add(EntityType.OBSERVED_PROPERTY);
        entityTypes.add(EntityType.FEATURE_OF_INTEREST);
        entityTypes.add(EntityType.DATASTREAM);
        entityTypes.add(EntityType.OBSERVATION);
        entityTypes.add(EntityType.LOCATION);
        this.checkExisting(entityTypes);
        this.createEntitiesForDelete();
        this.deleteEntity(EntityType.SENSOR, this.sensorIds.get(0));
        entityTypes.clear();
        entityTypes.add(EntityType.SENSOR);
        entityTypes.add(EntityType.DATASTREAM);
        entityTypes.add(EntityType.OBSERVATION);
        this.checkNotExisting(entityTypes);
        entityTypes.clear();
        entityTypes.add(EntityType.THING);
        entityTypes.add(EntityType.OBSERVED_PROPERTY);
        entityTypes.add(EntityType.FEATURE_OF_INTEREST);
        entityTypes.add(EntityType.LOCATION);
        entityTypes.add(EntityType.HISTORICAL_LOCATION);
        this.checkExisting(entityTypes);
        this.createEntitiesForDelete();
        this.deleteEntity(EntityType.OBSERVED_PROPERTY, this.obsPropIds.get(0));
        entityTypes.clear();
        entityTypes.add(EntityType.OBSERVED_PROPERTY);
        entityTypes.add(EntityType.DATASTREAM);
        entityTypes.add(EntityType.OBSERVATION);
        this.checkNotExisting(entityTypes);
        entityTypes.clear();
        entityTypes.add(EntityType.THING);
        entityTypes.add(EntityType.SENSOR);
        entityTypes.add(EntityType.FEATURE_OF_INTEREST);
        entityTypes.add(EntityType.LOCATION);
        entityTypes.add(EntityType.HISTORICAL_LOCATION);
        this.checkExisting(entityTypes);
        this.createEntitiesForDelete();
        this.deleteEntity(EntityType.FEATURE_OF_INTEREST, this.foiIds.get(0));
        entityTypes.clear();
        entityTypes.add(EntityType.FEATURE_OF_INTEREST);
        entityTypes.add(EntityType.OBSERVATION);
        this.checkNotExisting(entityTypes);
        entityTypes.clear();
        entityTypes.add(EntityType.THING);
        entityTypes.add(EntityType.SENSOR);
        entityTypes.add(EntityType.OBSERVED_PROPERTY);
        entityTypes.add(EntityType.LOCATION);
        entityTypes.add(EntityType.HISTORICAL_LOCATION);
        entityTypes.add(EntityType.DATASTREAM);
        this.checkExisting(entityTypes);
        this.createEntitiesForDelete();
        this.deleteEntity(EntityType.OBSERVATION, this.observationIds.get(0));
        entityTypes.clear();
        entityTypes.add(EntityType.OBSERVATION);
        this.checkNotExisting(entityTypes);
        entityTypes.clear();
        entityTypes.add(EntityType.THING);
        entityTypes.add(EntityType.SENSOR);
        entityTypes.add(EntityType.OBSERVED_PROPERTY);
        entityTypes.add(EntityType.FEATURE_OF_INTEREST);
        entityTypes.add(EntityType.DATASTREAM);
        entityTypes.add(EntityType.HISTORICAL_LOCATION);
        entityTypes.add(EntityType.LOCATION);
        this.checkExisting(entityTypes);
    }

    @Test(description="Invalid PATCH Entities", groups={"level-2"}, priority=4)
    public void invalidPatchEntities() {
        long thingId = this.thingIds.get(0);
        String urlParameters = "{\"Locations\": [\n    {\n      \"description\": \"West Roof\",\n      \"location\": { \"type\": \"Point\", \"coordinates\": [-117.05, 51.05] },\n      \"encodingType\": \"http://example.org/location_types#GeoJSON\"\n    }\n  ]}";
        this.invalidPatchEntity(EntityType.THING, urlParameters, thingId);
        urlParameters = "{\"Datastreams\": [\n    {\n      \"unitOfMeasurement\": {\n        \"name\": \"Lumen\",\n        \"symbol\": \"lm\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/unit/Instances.html#Lumen\"\n      }]}";
        this.invalidPatchEntity(EntityType.THING, urlParameters, thingId);
        long sensorId = this.sensorIds.get(0);
        urlParameters = "{\"Datastreams\": [\n    {\n      \"unitOfMeasurement\": {\n        \"name\": \"Lumen\",\n        \"symbol\": \"lm\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/unit/Instances.html#Lumen\"}\n        ,\"Thing\":{\"@iot.id\":" + thingId + "}" + "      }]}";
        this.invalidPatchEntity(EntityType.SENSOR, urlParameters, sensorId);
        long obsPropId = this.obsPropIds.get(0);
        urlParameters = "{\"Datastreams\": [\n    {\n      \"unitOfMeasurement\": {\n        \"name\": \"Lumen\",\n        \"symbol\": \"lm\",\n        \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/unit/Instances.html#Lumen\"}\n        ,\"Thing\":{\"@iot.id\":" + thingId + "}" + "      }]}";
        this.invalidPatchEntity(EntityType.OBSERVED_PROPERTY, urlParameters, obsPropId);
        long datastreamId = this.datastreamIds.get(0);
        urlParameters = "{\"ObservedProperty\": {\n  \t\"name\": \"Count\",\n\t\"definition\": \"http://qudt.org/vocab/unit#Dimensionless\",\n\t\"description\": \"Count is a dimensionless property.\"\n  } }";
        this.invalidPatchEntity(EntityType.DATASTREAM, urlParameters, datastreamId);
        urlParameters = "{\"Sensor\": {\n  \t\"description\": \"Acme Traffic 2000\",  \n  \t\"encodingType\": \"http://schema.org/description\",\n  \t\"metadata\": \"Traffic counting device\"\n  }}";
        this.invalidPatchEntity(EntityType.DATASTREAM, urlParameters, datastreamId);
        urlParameters = "{\"Thing\": { \"description\": \"test\" }}";
        this.invalidPatchEntity(EntityType.DATASTREAM, urlParameters, datastreamId);
        urlParameters = "{\"Observations\": [\n    {\n      \"phenomenonTime\": \"2015-03-01T00:00:00Z\",\n      \"result\": 92122,\n      \"resultQuality\": \"High\"\n    }\n  ]}";
        this.invalidPatchEntity(EntityType.DATASTREAM, urlParameters, datastreamId);
    }

    @Test(description="DELETE nonexistent Entities", groups={"level-2"}, priority=5)
    public void deleteNoneexistentEntities() {
        this.deleteNonExsistentEntity(EntityType.THING);
        this.deleteNonExsistentEntity(EntityType.LOCATION);
        this.deleteNonExsistentEntity(EntityType.HISTORICAL_LOCATION);
        this.deleteNonExsistentEntity(EntityType.SENSOR);
        this.deleteNonExsistentEntity(EntityType.OBSERVED_PROPERTY);
        this.deleteNonExsistentEntity(EntityType.DATASTREAM);
        this.deleteNonExsistentEntity(EntityType.OBSERVATION);
        this.deleteNonExsistentEntity(EntityType.FEATURE_OF_INTEREST);
    }

    private JSONObject getEntity(EntityType entityType, long id) {
        if (id == -1L) {
            return null;
        }
        String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, null, null);
        try {
            return new JSONObject(HTTPMethods.doGet(urlString).get("response").toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            return null;
        }
    }

    private JSONObject postEntity(EntityType entityType, String urlParameters) {
        String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, null);
        try {
            Map<String, Object> responseMap = HTTPMethods.doPost(urlString, urlParameters);
            int responseCode = Integer.parseInt(responseMap.get("response-code").toString());
            Assert.assertEquals((int)responseCode, (int)201, (String)("Error during creation of entity " + entityType.name()));
            String response = responseMap.get("response").toString();
            long id = Long.parseLong(response.substring(response.indexOf("(") + 1, response.indexOf(")")));
            urlString = urlString + "(" + id + ")";
            responseMap = HTTPMethods.doGet(urlString);
            responseCode = Integer.parseInt(responseMap.get("response-code").toString());
            Assert.assertEquals((int)responseCode, (int)200, (String)"The POSTed entity is not created.");
            JSONObject result = new JSONObject(responseMap.get("response").toString());
            return result;
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            return null;
        }
    }

    private void postInvalidEntity(EntityType entityType, String urlParameters) {
        String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, null);
        Map<String, Object> responseMap = HTTPMethods.doPost(urlString, urlParameters);
        int responseCode = Integer.parseInt(responseMap.get("response-code").toString());
        Assert.assertTrue((responseCode == 400 || responseCode == 409 ? 1 : 0) != 0, (String)("The  " + entityType.name() + " should not be created due to integrity constraints."));
    }

    private void deleteEntity(EntityType entityType, long id) {
        String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, null, null);
        Map<String, Object> responseMap = HTTPMethods.doDelete(urlString);
        int responseCode = Integer.parseInt(responseMap.get("response-code").toString());
        Assert.assertEquals((int)responseCode, (int)200, (String)("DELETE does not work properly for " + (Object)((Object)entityType) + " with id " + id + ". Returned with response code " + responseCode + "."));
        responseMap = HTTPMethods.doGet(urlString);
        responseCode = Integer.parseInt(responseMap.get("response-code").toString());
        Assert.assertEquals((int)responseCode, (int)404, (String)("Deleted entity was not actually deleted : " + (Object)((Object)entityType) + "(" + id + ")."));
    }

    private void deleteNonExsistentEntity(EntityType entityType) {
        long id = Long.MAX_VALUE;
        String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, null, null);
        Map<String, Object> responseMap = HTTPMethods.doDelete(urlString);
        int responseCode = Integer.parseInt(responseMap.get("response-code").toString());
        Assert.assertEquals((int)responseCode, (int)404, (String)("DELETE does not work properly for nonexistent " + (Object)((Object)entityType) + " with id " + id + ". Returned with response code " + responseCode + "."));
    }

    private JSONObject updateEntity(EntityType entityType, String urlParameters, long id) {
        String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, null, null);
        try {
            Map<String, Object> responseMap = HTTPMethods.doPut(urlString, urlParameters);
            int responseCode = Integer.parseInt(responseMap.get("response-code").toString());
            Assert.assertEquals((int)responseCode, (int)200, (String)("Error during updating(PUT) of entity " + entityType.name()));
            responseMap = HTTPMethods.doGet(urlString);
            JSONObject result = new JSONObject(responseMap.get("response").toString());
            return result;
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            return null;
        }
    }

    private JSONObject patchEntity(EntityType entityType, String urlParameters, long id) {
        String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, null, null);
        try {
            Map<String, Object> responseMap = HTTPMethods.doPatch(urlString, urlParameters);
            int responseCode = Integer.parseInt(responseMap.get("response-code").toString());
            Assert.assertEquals((int)responseCode, (int)200, (String)("Error during updating(PATCH) of entity " + entityType.name()));
            responseMap = HTTPMethods.doGet(urlString);
            JSONObject result = new JSONObject(responseMap.get("response").toString());
            return result;
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            return null;
        }
    }

    private void invalidPatchEntity(EntityType entityType, String urlParameters, long id) {
        String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, null, null);
        Map<String, Object> responseMap = HTTPMethods.doPatch(urlString, urlParameters);
        int responseCode = Integer.parseInt(responseMap.get("response-code").toString());
        Assert.assertEquals((int)responseCode, (int)400, (String)("Error: Patching related entities inline must be illegal for entity " + entityType.name()));
    }

    private void checkPatch(EntityType entityType, JSONObject oldEntity, JSONObject newEntity, Map diffs) {
        try {
            for (String property : EntityProperties.getPropertiesListFor(entityType)) {
                if (diffs.containsKey(property)) {
                    Assert.assertEquals((String)newEntity.get(property).toString(), (String)diffs.get(property).toString(), (String)("PATCH was not applied correctly for " + (Object)((Object)entityType) + "'s " + property + "."));
                    continue;
                }
                Assert.assertEquals((String)newEntity.get(property).toString(), (String)oldEntity.get(property).toString(), (String)("PATCH was not applied correctly for " + (Object)((Object)entityType) + "'s " + property + "."));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkPut(EntityType entityType, JSONObject oldEntity, JSONObject newEntity, Map diffs) {
        try {
            for (String property : EntityProperties.getPropertiesListFor(entityType)) {
                if (!diffs.containsKey(property)) continue;
                Assert.assertEquals((String)newEntity.get(property).toString(), (String)diffs.get(property).toString(), (String)("PUT was not applied correctly for " + (Object)((Object)entityType) + "."));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private long checkAutomaticInsertionOfFOI(long obsId, JSONObject locationObj, long expectedFOIId) {
        String urlString = this.rootUri + "/Observations(" + obsId + ")/FeatureOfInterest";
        try {
            Map<String, Object> responseMap = HTTPMethods.doGet(urlString);
            int responseCode = Integer.parseInt(responseMap.get("response-code").toString());
            Assert.assertEquals((int)responseCode, (int)200, (String)"ERROR: FeatureOfInterest was not automatically create.");
            JSONObject result = new JSONObject(responseMap.get("response").toString());
            long id = result.getLong("@iot.id");
            if (expectedFOIId != -1L) {
                Assert.assertEquals((long)id, (long)expectedFOIId, (String)("ERROR: the Observation should have linked to FeatureOfInterest with ID: " + expectedFOIId + " , but it is linked for FeatureOfInterest with Id: " + id + "."));
            }
            Assert.assertEquals((String)result.getJSONObject("feature").toString(), (String)locationObj.getJSONObject("location").toString(), (String)"ERROR: Automatic created FeatureOfInterest does not match last Location of that Thing.");
            return id;
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            return -1L;
        }
    }

    private long checkRelatedEntity(EntityType parentEntityType, long parentId, EntityType relationEntityType, JSONObject relationObj) {
        boolean isCollection = true;
        String urlString = ServiceURLBuilder.buildURLString(this.rootUri, parentEntityType, parentId, relationEntityType, null);
        if (urlString.trim().charAt(urlString.trim().length() - 1) != 's') {
            isCollection = false;
        }
        try {
            Map<String, Object> responseMap = HTTPMethods.doGet(urlString);
            int responseCode = Integer.parseInt(responseMap.get("response-code").toString());
            Assert.assertEquals((int)responseCode, (int)200, (String)("ERROR: Deep inserted " + (Object)((Object)relationEntityType) + " does not created or linked to " + (Object)((Object)parentEntityType)));
            JSONObject result = new JSONObject(responseMap.get("response").toString());
            if (isCollection) {
                result = result.getJSONArray("value").getJSONObject(0);
            }
            Iterator iterator = relationObj.keys();
            while (iterator.hasNext()) {
                String key = iterator.next().toString();
                Assert.assertEquals((String)result.get(key).toString(), (String)relationObj.get(key).toString(), (String)("ERROR: Deep inserted " + (Object)((Object)relationEntityType) + " is not created correctly."));
            }
            return result.getLong("@iot.id");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            return -1L;
        }
    }

    private void checkForObservationResultTime(JSONObject observation, String resultTimeValue) {
        try {
            if (resultTimeValue == null) {
                Assert.assertEquals((String)observation.get("resultTime").toString(), (String)"null", (String)("The resultTime of the Observation " + observation.getLong("@iot.id") + " should have been null but it is now \"" + observation.get("resultTime").toString() + "\"."));
            } else {
                Assert.assertEquals((String)observation.get("resultTime").toString(), (String)resultTimeValue, (String)("The resultTime of the Observation " + observation.getLong("@iot.id") + " should have been \"" + resultTimeValue + "\" but it is now \"" + observation.get("resultTime").toString() + "\"."));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkNotExisting(List<EntityType> entityTypes) {
        for (EntityType entityType : entityTypes) {
            String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, null);
            Map<String, Object> responseMap = HTTPMethods.doGet(urlString);
            try {
                JSONObject result = new JSONObject(responseMap.get("response").toString());
                JSONArray array = result.getJSONArray("value");
                Assert.assertEquals((int)array.length(), (int)0, (String)((Object)((Object)entityType) + " is created although it shouldn't."));
            }
            catch (JSONException e) {
                e.printStackTrace();
                Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            }
        }
    }

    private void checkExisting(List<EntityType> entityTypes) {
        for (EntityType entityType : entityTypes) {
            String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, null);
            Map<String, Object> responseMap = HTTPMethods.doGet(urlString);
            try {
                JSONObject result = new JSONObject(responseMap.get("response").toString());
                JSONArray array = result.getJSONArray("value");
                Assert.assertTrue((array.length() > 0 ? 1 : 0) != 0, (String)((Object)((Object)entityType) + " is created although it shouldn't."));
            }
            catch (JSONException e) {
                e.printStackTrace();
                Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            }
        }
    }

    @AfterClass
    public void deleteEverythings() {
        this.deleteEntityType(EntityType.OBSERVATION);
        this.deleteEntityType(EntityType.FEATURE_OF_INTEREST);
        this.deleteEntityType(EntityType.DATASTREAM);
        this.deleteEntityType(EntityType.SENSOR);
        this.deleteEntityType(EntityType.OBSERVED_PROPERTY);
        this.deleteEntityType(EntityType.HISTORICAL_LOCATION);
        this.deleteEntityType(EntityType.LOCATION);
        this.deleteEntityType(EntityType.THING);
    }

    private void deleteEntityType(EntityType entityType) {
        JSONArray array = null;
        do {
            try {
                String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, null);
                Map<String, Object> responseMap = HTTPMethods.doGet(urlString);
                int responseCode = Integer.parseInt(responseMap.get("response-code").toString());
                JSONObject result = new JSONObject(responseMap.get("response").toString());
                array = result.getJSONArray("value");
                for (int i = 0; i < array.length(); ++i) {
                    long id = array.getJSONObject(i).getLong("@iot.id");
                    this.deleteEntity(entityType, id);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
                Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            }
        } while (array.length() > 0);
    }

    private void createEntitiesForDelete() {
        try {
            this.deleteEverythings();
            this.thingIds.clear();
            this.locationIds.clear();
            this.historicalLocationIds.clear();
            this.datastreamIds.clear();
            this.sensorIds.clear();
            this.observationIds.clear();
            this.obsPropIds.clear();
            this.foiIds.clear();
            String urlParameters = "{\n    \"description\": \"thing 1\",\n    \"properties\": {\n        \"reference\": \"first\"\n    },\n    \"Locations\": [\n        {\n            \"description\": \"location 1\",\n            \"location\": {\n                \"type\": \"Point\",\n                \"coordinates\": [\n                    -117.05,\n                    51.05\n                ]\n            },\n            \"encodingType\": \"http://example.org/location_types#GeoJSON\"\n        }\n    ],\n    \"Datastreams\": [\n        {\n            \"unitOfMeasurement\": {\n                \"name\": \"Lumen\",\n                \"symbol\": \"lm\",\n                \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/unit/Instances.html#Lumen\"\n            },\n            \"description\": \"datastream 1\",\n            \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n            \"ObservedProperty\": {\n                \"name\": \"Luminous Flux\",\n                \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html#LuminousFlux\",\n                \"description\": \"observedProperty 1\"\n            },\n            \"Sensor\": {\n                \"description\": \"sensor 1\",\n                \"encodingType\": \"http://schema.org/description\",\n                \"metadata\": \"Light flux sensor\"\n            }\n        }\n    ]\n}";
            String urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.THING, -1L, null, null);
            Map<String, Object> responseMap = HTTPMethods.doPost(urlString, urlParameters);
            String response = responseMap.get("response").toString();
            this.thingIds.add(Long.parseLong(response.substring(response.indexOf("(") + 1, response.indexOf(")"))));
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.THING, this.thingIds.get(0), EntityType.LOCATION, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            JSONArray array = new JSONObject(response).getJSONArray("value");
            this.locationIds.add(array.getJSONObject(0).getLong("@iot.id"));
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.THING, this.thingIds.get(0), EntityType.DATASTREAM, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            array = new JSONObject(response).getJSONArray("value");
            this.datastreamIds.add(array.getJSONObject(0).getLong("@iot.id"));
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.DATASTREAM, this.datastreamIds.get(0), EntityType.SENSOR, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            this.sensorIds.add(new JSONObject(response).getLong("@iot.id"));
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.DATASTREAM, this.datastreamIds.get(0), EntityType.OBSERVED_PROPERTY, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            this.obsPropIds.add(new JSONObject(response).getLong("@iot.id"));
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.THING, this.thingIds.get(0), EntityType.HISTORICAL_LOCATION, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            array = new JSONObject(response).getJSONArray("value");
            this.historicalLocationIds.add(array.getJSONObject(0).getLong("@iot.id"));
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.DATASTREAM, this.datastreamIds.get(0), EntityType.OBSERVATION, null);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-01T00:00:00Z\",\n  \"result\": 1 \n   }";
            responseMap = HTTPMethods.doPost(urlString, urlParameters);
            response = responseMap.get("response").toString();
            this.observationIds.add(Long.parseLong(response.substring(response.lastIndexOf("(") + 1, response.lastIndexOf(")"))));
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.OBSERVATION, this.observationIds.get(0), EntityType.FEATURE_OF_INTEREST, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            this.foiIds.add(new JSONObject(response).getLong("@iot.id"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }
}

