/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.sta10.filteringExtension;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.cite.sta10.SuiteAttribute;
import org.opengis.cite.sta10.util.EntityProperties;
import org.opengis.cite.sta10.util.EntityPropertiesSampleValue;
import org.opengis.cite.sta10.util.EntityRelations;
import org.opengis.cite.sta10.util.EntityType;
import org.opengis.cite.sta10.util.HTTPMethods;
import org.opengis.cite.sta10.util.ServiceURLBuilder;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class Capability3Tests {
    public String rootUri;
    private long thingId1;
    private long thingId2;
    private long datastreamId1;
    private long datastreamId2;
    private long datastreamId3;
    private long datastreamId4;
    private long locationId1;
    private long locationId2;
    private long historicalLocationId1;
    private long historicalLocationId2;
    private long historicalLocationId3;
    private long historicalLocationId4;
    private long sensorId1;
    private long sensorId2;
    private long sensorId3;
    private long sensorId4;
    private long observedPropertyId1;
    private long observedPropertyId2;
    private long observedPropertyId3;
    private long observationId1;
    private long observationId2;
    private long observationId3;
    private long observationId4;
    private long observationId5;
    private long observationId6;
    private long observationId7;
    private long observationId8;
    private long observationId9;
    private long observationId10;
    private long observationId11;
    private long observationId12;
    private long featureOfInterestId1;
    private long featureOfInterestId2;

    @BeforeClass
    public void obtainTestSubject(ITestContext testContext) {
        Object obj = testContext.getSuite().getAttribute(SuiteAttribute.LEVEL.getName());
        if (null != obj) {
            Integer level = (Integer)Integer.class.cast(obj);
            Assert.assertTrue((level > 2 ? 1 : 0) != 0, (String)("Conformance level 3 will not be checked since ics = " + level));
        }
        this.rootUri = testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName()).toString();
        this.rootUri = this.rootUri.trim();
        if (this.rootUri.lastIndexOf(47) == this.rootUri.length() - 1) {
            this.rootUri = this.rootUri.substring(0, this.rootUri.length() - 1);
        }
        this.createEntities();
    }

    @Test(description="Check Query Evaluation Priority.", groups={"level-3"})
    public void readEntitiesWithSelectQO() {
        this.checkSelectForEntityType(EntityType.THING);
        this.checkSelectForEntityType(EntityType.LOCATION);
        this.checkSelectForEntityType(EntityType.HISTORICAL_LOCATION);
        this.checkSelectForEntityType(EntityType.DATASTREAM);
        this.checkSelectForEntityType(EntityType.SENSOR);
        this.checkSelectForEntityType(EntityType.OBSERVED_PROPERTY);
        this.checkSelectForEntityType(EntityType.OBSERVATION);
        this.checkSelectForEntityType(EntityType.FEATURE_OF_INTEREST);
        this.checkSelectForEntityTypeRelations(EntityType.THING);
        this.checkSelectForEntityTypeRelations(EntityType.LOCATION);
        this.checkSelectForEntityTypeRelations(EntityType.HISTORICAL_LOCATION);
        this.checkSelectForEntityTypeRelations(EntityType.DATASTREAM);
        this.checkSelectForEntityTypeRelations(EntityType.SENSOR);
        this.checkSelectForEntityTypeRelations(EntityType.OBSERVED_PROPERTY);
        this.checkSelectForEntityTypeRelations(EntityType.OBSERVATION);
        this.checkSelectForEntityTypeRelations(EntityType.FEATURE_OF_INTEREST);
    }

    @Test(description="GET Entities with $expand", groups={"level-3"})
    public void readEntitiesWithExpandQO() {
        this.checkExpandtForEntityType(EntityType.THING);
        this.checkExpandtForEntityType(EntityType.LOCATION);
        this.checkExpandtForEntityType(EntityType.HISTORICAL_LOCATION);
        this.checkExpandtForEntityType(EntityType.DATASTREAM);
        this.checkExpandtForEntityType(EntityType.SENSOR);
        this.checkExpandtForEntityType(EntityType.OBSERVED_PROPERTY);
        this.checkExpandtForEntityType(EntityType.OBSERVATION);
        this.checkExpandtForEntityType(EntityType.FEATURE_OF_INTEREST);
        this.checkExpandtForEntityTypeRelations(EntityType.THING);
        this.checkExpandtForEntityTypeRelations(EntityType.LOCATION);
        this.checkExpandtForEntityTypeRelations(EntityType.HISTORICAL_LOCATION);
        this.checkExpandtForEntityTypeRelations(EntityType.DATASTREAM);
        this.checkExpandtForEntityTypeRelations(EntityType.SENSOR);
        this.checkExpandtForEntityTypeRelations(EntityType.OBSERVED_PROPERTY);
        this.checkExpandtForEntityTypeRelations(EntityType.OBSERVATION);
        this.checkExpandtForEntityTypeRelations(EntityType.FEATURE_OF_INTEREST);
        this.checkExpandtForEntityTypeMultilevel(EntityType.THING);
        this.checkExpandtForEntityTypeMultilevel(EntityType.LOCATION);
        this.checkExpandtForEntityTypeMultilevel(EntityType.HISTORICAL_LOCATION);
        this.checkExpandtForEntityTypeMultilevel(EntityType.DATASTREAM);
        this.checkExpandtForEntityTypeMultilevel(EntityType.SENSOR);
        this.checkExpandtForEntityTypeMultilevel(EntityType.OBSERVED_PROPERTY);
        this.checkExpandtForEntityTypeMultilevel(EntityType.OBSERVATION);
        this.checkExpandtForEntityTypeMultilevel(EntityType.FEATURE_OF_INTEREST);
        this.checkExpandtForEntityTypeMultilevelRelations(EntityType.THING);
        this.checkExpandtForEntityTypeMultilevelRelations(EntityType.LOCATION);
        this.checkExpandtForEntityTypeMultilevelRelations(EntityType.HISTORICAL_LOCATION);
        this.checkExpandtForEntityTypeMultilevelRelations(EntityType.DATASTREAM);
        this.checkExpandtForEntityTypeMultilevelRelations(EntityType.SENSOR);
        this.checkExpandtForEntityTypeMultilevelRelations(EntityType.OBSERVED_PROPERTY);
        this.checkExpandtForEntityTypeMultilevelRelations(EntityType.OBSERVATION);
        this.checkExpandtForEntityTypeMultilevelRelations(EntityType.FEATURE_OF_INTEREST);
    }

    @Test(description="GET Entities with $top", groups={"level-3"})
    public void readEntitiesWithTopQO() {
        this.checkTopForEntityType(EntityType.THING);
        this.checkTopForEntityType(EntityType.LOCATION);
        this.checkTopForEntityType(EntityType.HISTORICAL_LOCATION);
        this.checkTopForEntityType(EntityType.DATASTREAM);
        this.checkTopForEntityType(EntityType.SENSOR);
        this.checkTopForEntityType(EntityType.OBSERVED_PROPERTY);
        this.checkTopForEntityType(EntityType.OBSERVATION);
        this.checkTopForEntityType(EntityType.FEATURE_OF_INTEREST);
        this.checkTopForEntityTypeRelation(EntityType.THING);
        this.checkTopForEntityTypeRelation(EntityType.LOCATION);
        this.checkTopForEntityTypeRelation(EntityType.HISTORICAL_LOCATION);
        this.checkTopForEntityTypeRelation(EntityType.DATASTREAM);
        this.checkTopForEntityTypeRelation(EntityType.SENSOR);
        this.checkTopForEntityTypeRelation(EntityType.OBSERVED_PROPERTY);
        this.checkTopForEntityTypeRelation(EntityType.OBSERVATION);
        this.checkTopForEntityTypeRelation(EntityType.FEATURE_OF_INTEREST);
    }

    @Test(description="GET Entities with $skip", groups={"level-3"})
    public void readEntitiesWithSkipQO() {
        this.checkSkipForEntityType(EntityType.THING);
        this.checkSkipForEntityType(EntityType.LOCATION);
        this.checkSkipForEntityType(EntityType.HISTORICAL_LOCATION);
        this.checkSkipForEntityType(EntityType.DATASTREAM);
        this.checkSkipForEntityType(EntityType.SENSOR);
        this.checkSkipForEntityType(EntityType.OBSERVED_PROPERTY);
        this.checkSkipForEntityType(EntityType.OBSERVATION);
        this.checkSkipForEntityType(EntityType.FEATURE_OF_INTEREST);
        this.checkSkipForEntityTypeRelation(EntityType.THING);
        this.checkSkipForEntityTypeRelation(EntityType.LOCATION);
        this.checkSkipForEntityTypeRelation(EntityType.HISTORICAL_LOCATION);
        this.checkSkipForEntityTypeRelation(EntityType.DATASTREAM);
        this.checkSkipForEntityTypeRelation(EntityType.SENSOR);
        this.checkSkipForEntityTypeRelation(EntityType.OBSERVED_PROPERTY);
        this.checkSkipForEntityTypeRelation(EntityType.OBSERVATION);
        this.checkSkipForEntityTypeRelation(EntityType.FEATURE_OF_INTEREST);
    }

    @Test(description="GET Entities with $orderby", groups={"level-3"})
    public void readEntitiesWithOrderbyQO() {
        this.checkOrderbyForEntityType(EntityType.THING);
        this.checkOrderbyForEntityType(EntityType.LOCATION);
        this.checkOrderbyForEntityType(EntityType.HISTORICAL_LOCATION);
        this.checkOrderbyForEntityType(EntityType.DATASTREAM);
        this.checkOrderbyForEntityType(EntityType.SENSOR);
        this.checkOrderbyForEntityType(EntityType.OBSERVED_PROPERTY);
        this.checkOrderbyForEntityType(EntityType.OBSERVATION);
        this.checkOrderbyForEntityType(EntityType.FEATURE_OF_INTEREST);
        this.checkOrderbyForEntityTypeRelations(EntityType.THING);
        this.checkOrderbyForEntityTypeRelations(EntityType.LOCATION);
        this.checkOrderbyForEntityTypeRelations(EntityType.HISTORICAL_LOCATION);
        this.checkOrderbyForEntityTypeRelations(EntityType.DATASTREAM);
        this.checkOrderbyForEntityTypeRelations(EntityType.SENSOR);
        this.checkOrderbyForEntityTypeRelations(EntityType.OBSERVED_PROPERTY);
        this.checkOrderbyForEntityTypeRelations(EntityType.OBSERVATION);
        this.checkOrderbyForEntityTypeRelations(EntityType.FEATURE_OF_INTEREST);
    }

    @Test(description="GET Entities with $count", groups={"level-3"})
    public void readEntitiesWithCountQO() {
        this.checkCountForEntityType(EntityType.THING);
        this.checkCountForEntityType(EntityType.LOCATION);
        this.checkCountForEntityType(EntityType.HISTORICAL_LOCATION);
        this.checkCountForEntityType(EntityType.DATASTREAM);
        this.checkCountForEntityType(EntityType.SENSOR);
        this.checkCountForEntityType(EntityType.OBSERVED_PROPERTY);
        this.checkCountForEntityType(EntityType.OBSERVATION);
        this.checkCountForEntityType(EntityType.FEATURE_OF_INTEREST);
        this.checkCountForEntityTypeRelations(EntityType.THING);
        this.checkCountForEntityTypeRelations(EntityType.LOCATION);
        this.checkCountForEntityTypeRelations(EntityType.HISTORICAL_LOCATION);
        this.checkCountForEntityTypeRelations(EntityType.DATASTREAM);
        this.checkCountForEntityTypeRelations(EntityType.SENSOR);
        this.checkCountForEntityTypeRelations(EntityType.OBSERVED_PROPERTY);
        this.checkCountForEntityTypeRelations(EntityType.OBSERVATION);
        this.checkCountForEntityTypeRelations(EntityType.FEATURE_OF_INTEREST);
    }

    @Test(description="GET Entities with $filter", groups={"level-3"})
    public void readEntitiesWithFilterQO() throws UnsupportedEncodingException {
        this.checkFilterForEntityType(EntityType.THING);
        this.checkFilterForEntityType(EntityType.LOCATION);
        this.checkFilterForEntityType(EntityType.HISTORICAL_LOCATION);
        this.checkFilterForEntityType(EntityType.DATASTREAM);
        this.checkFilterForEntityType(EntityType.SENSOR);
        this.checkFilterForEntityType(EntityType.OBSERVED_PROPERTY);
        this.checkFilterForEntityType(EntityType.OBSERVATION);
        this.checkFilterForEntityType(EntityType.FEATURE_OF_INTEREST);
        this.checkFilterForEntityTypeRelations(EntityType.THING);
        this.checkFilterForEntityTypeRelations(EntityType.LOCATION);
        this.checkFilterForEntityTypeRelations(EntityType.HISTORICAL_LOCATION);
        this.checkFilterForEntityTypeRelations(EntityType.DATASTREAM);
        this.checkFilterForEntityTypeRelations(EntityType.SENSOR);
        this.checkFilterForEntityTypeRelations(EntityType.OBSERVED_PROPERTY);
        this.checkFilterForEntityTypeRelations(EntityType.OBSERVATION);
        this.checkFilterForEntityTypeRelations(EntityType.FEATURE_OF_INTEREST);
    }

    @Test(description="Check priotity of query options", groups={"level-3"})
    public void checkQueriesPriorityOrdering() {
        try {
            String urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.OBSERVATION, -1L, null, "?$count=true&$top=1&$skip=2&$orderby=phenomenonTime%20asc&$filter=result%20gt%20'3'");
            Map<String, Object> responseMap = HTTPMethods.doGet(urlString);
            Assert.assertEquals((int)Integer.parseInt(responseMap.get("response-code").toString()), (int)200, (String)("There is problem for GET Observations using multiple Query Options! HTTP status code: " + responseMap.get("response-code")));
            String response = responseMap.get("response").toString();
            JSONArray array = new JSONObject(response).getJSONArray("value");
            Assert.assertEquals((long)new JSONObject(response).getLong("@iot.count"), (long)6L, (String)("The query order of execution is not correct. The expected count is 6, but the service returned " + new JSONObject(response).getLong("@iot.count")));
            Assert.assertEquals((int)array.length(), (int)1, (String)("The query asked for top 1, but the service rerurned " + array.length() + " entities."));
            Assert.assertEquals((String)array.getJSONObject(0).getString("result"), (String)"6", (String)("The query order of execution is not correct. The expected Observation result is 6, but it is " + array.getJSONObject(0).getString("result")));
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkOrderbyForEntityTypeRelations(EntityType entityType) {
        String[] relations = EntityRelations.getRelationsListFor(entityType);
        try {
            String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, null);
            Map<String, Object> responseMap = HTTPMethods.doGet(urlString);
            String response = responseMap.get("response").toString();
            JSONArray array = new JSONObject(response).getJSONArray("value");
            if (array.length() == 0) {
                return;
            }
            long id = array.getJSONObject(0).getLong("@iot.id");
            for (String relation : relations) {
                if (relation.charAt(relation.length() - 1) != 's' && !relation.equals("FeaturesOfInteret")) continue;
                String[] properties = EntityProperties.getPropertiesListFor(relation);
                EntityType relationEntityType = this.getEntityTypeFor(relation);
                for (String property : properties) {
                    int i;
                    if (property.equals("unitOfMeasurement")) continue;
                    urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, relationEntityType, "?$orderby=" + property);
                    responseMap = HTTPMethods.doGet(urlString);
                    response = responseMap.get("response").toString();
                    array = new JSONObject(response).getJSONArray("value");
                    for (i = 1; i < array.length(); ++i) {
                        Assert.assertTrue((this.compareWithPrevious(i, array, property) <= 0 ? 1 : 0) != 0, (String)("The ordering is not correct for EntityType " + (Object)((Object)entityType) + " orderby property " + property));
                    }
                    urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, relationEntityType, "?$orderby=" + property + "%20asc");
                    responseMap = HTTPMethods.doGet(urlString);
                    response = responseMap.get("response").toString();
                    array = new JSONObject(response).getJSONArray("value");
                    for (i = 1; i < array.length(); ++i) {
                        Assert.assertTrue((this.compareWithPrevious(i, array, property) <= 0 ? 1 : 0) != 0, (String)("The ordering is not correct for EntityType " + (Object)((Object)entityType) + " orderby asc property " + property));
                    }
                    urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, relationEntityType, "?$orderby=" + property + "%20desc");
                    responseMap = HTTPMethods.doGet(urlString);
                    response = responseMap.get("response").toString();
                    array = new JSONObject(response).getJSONArray("value");
                    for (i = 1; i < array.length(); ++i) {
                        Assert.assertTrue((this.compareWithPrevious(i, array, property) >= 0 ? 1 : 0) != 0, (String)("The ordering is not correct for EntityType " + (Object)((Object)entityType) + " orderby desc property " + property));
                    }
                }
                ArrayList<String> orderbyPropeties = new ArrayList<String>();
                String orderby = "?$orderby=";
                String orderbyAsc = "?$orderby=";
                String orderbyDesc = "?$orderby=";
                for (String property : properties) {
                    int compare;
                    int i;
                    if (property.equals("unitOfMeasurement")) continue;
                    if (orderby.charAt(orderby.length() - 1) != '=') {
                        orderby = orderby + ",";
                    }
                    orderby = orderby + property;
                    orderbyPropeties.add(property);
                    urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, relationEntityType, orderby);
                    responseMap = HTTPMethods.doGet(urlString);
                    response = responseMap.get("response").toString();
                    array = new JSONObject(response).getJSONArray("value");
                    block8: for (i = 1; i < array.length(); ++i) {
                        for (String orderProperty : orderbyPropeties) {
                            compare = this.compareWithPrevious(i, array, orderProperty);
                            Assert.assertTrue((compare <= 0 ? 1 : 0) != 0, (String)("The ordering is not correct for EntityType " + (Object)((Object)entityType) + " orderby property " + orderProperty));
                            if (compare == 0) continue;
                            continue block8;
                        }
                    }
                    if (orderbyAsc.charAt(orderbyAsc.length() - 1) != '=') {
                        orderbyAsc = orderbyAsc + ",";
                    }
                    orderbyAsc = orderbyAsc + property + "%20asc";
                    urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, relationEntityType, orderbyAsc);
                    responseMap = HTTPMethods.doGet(urlString);
                    response = responseMap.get("response").toString();
                    array = new JSONObject(response).getJSONArray("value");
                    block10: for (i = 1; i < array.length(); ++i) {
                        for (String orderProperty : orderbyPropeties) {
                            compare = this.compareWithPrevious(i, array, orderProperty);
                            Assert.assertTrue((compare <= 0 ? 1 : 0) != 0, (String)("The ordering is not correct for EntityType " + (Object)((Object)entityType) + " orderby asc property " + orderProperty));
                            if (compare == 0) continue;
                            continue block10;
                        }
                    }
                    if (orderbyDesc.charAt(orderbyDesc.length() - 1) != '=') {
                        orderbyDesc = orderbyDesc + ",";
                    }
                    orderbyDesc = orderbyDesc + property + "%20desc";
                    urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, relationEntityType, orderbyDesc);
                    responseMap = HTTPMethods.doGet(urlString);
                    response = responseMap.get("response").toString();
                    array = new JSONObject(response).getJSONArray("value");
                    block12: for (i = 1; i < array.length(); ++i) {
                        for (String orderProperty : orderbyPropeties) {
                            compare = this.compareWithPrevious(i, array, orderProperty);
                            Assert.assertTrue((compare >= 0 ? 1 : 0) != 0, (String)("The ordering is not correct for EntityType " + (Object)((Object)entityType) + " orderby desc property " + orderProperty));
                            if (compare == 0) continue;
                            continue block12;
                        }
                    }
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkOrderbyForEntityType(EntityType entityType) {
        String[] properties = EntityProperties.getPropertiesListFor(entityType);
        try {
            for (String property : properties) {
                int i;
                if (property.equals("unitOfMeasurement")) continue;
                String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, "?$orderby=" + property);
                Map<String, Object> responseMap = HTTPMethods.doGet(urlString);
                String response = responseMap.get("response").toString();
                JSONArray array = new JSONObject(response).getJSONArray("value");
                for (i = 1; i < array.length(); ++i) {
                    Assert.assertTrue((this.compareWithPrevious(i, array, property) <= 0 ? 1 : 0) != 0, (String)("The default ordering is not correct for EntityType " + (Object)((Object)entityType) + " orderby property " + property));
                }
                urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, "?$orderby=" + property + "%20asc");
                responseMap = HTTPMethods.doGet(urlString);
                response = responseMap.get("response").toString();
                array = new JSONObject(response).getJSONArray("value");
                for (i = 1; i < array.length(); ++i) {
                    Assert.assertTrue((this.compareWithPrevious(i, array, property) <= 0 ? 1 : 0) != 0, (String)("The ascending ordering is not correct for EntityType " + (Object)((Object)entityType) + " orderby asc property " + property));
                }
                urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, "?$orderby=" + property + "%20desc");
                responseMap = HTTPMethods.doGet(urlString);
                response = responseMap.get("response").toString();
                array = new JSONObject(response).getJSONArray("value");
                for (i = 1; i < array.length(); ++i) {
                    Assert.assertTrue((this.compareWithPrevious(i, array, property) >= 0 ? 1 : 0) != 0, (String)("The descending ordering is not correct for EntityType " + (Object)((Object)entityType) + " orderby desc property " + property));
                }
            }
            ArrayList<String> orderbyPropeties = new ArrayList<String>();
            String orderby = "?$orderby=";
            String orderbyAsc = "?$orderby=";
            String orderbyDesc = "?$orderby=";
            for (String property : properties) {
                int compare;
                int i;
                if (property.equals("unitOfMeasurement")) continue;
                if (orderby.charAt(orderby.length() - 1) != '=') {
                    orderby = orderby + ",";
                }
                orderby = orderby + property;
                orderbyPropeties.add(property);
                String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, orderby);
                Map<String, Object> responseMap = HTTPMethods.doGet(urlString);
                String response = responseMap.get("response").toString();
                JSONArray array = new JSONObject(response).getJSONArray("value");
                block7: for (i = 1; i < array.length(); ++i) {
                    for (String orderProperty : orderbyPropeties) {
                        compare = this.compareWithPrevious(i, array, orderProperty);
                        Assert.assertTrue((compare <= 0 ? 1 : 0) != 0, (String)("The ordering is not correct for EntityType " + (Object)((Object)entityType) + " orderby property " + orderProperty));
                        if (compare == 0) continue;
                        continue block7;
                    }
                }
                if (orderbyAsc.charAt(orderbyAsc.length() - 1) != '=') {
                    orderbyAsc = orderbyAsc + ",";
                }
                orderbyAsc = orderbyAsc + property + "%20asc";
                urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, orderbyAsc);
                responseMap = HTTPMethods.doGet(urlString);
                response = responseMap.get("response").toString();
                array = new JSONObject(response).getJSONArray("value");
                block9: for (i = 1; i < array.length(); ++i) {
                    for (String orderProperty : orderbyPropeties) {
                        compare = this.compareWithPrevious(i, array, orderProperty);
                        Assert.assertTrue((compare <= 0 ? 1 : 0) != 0, (String)("The ordering is not correct for EntityType " + (Object)((Object)entityType) + " orderby asc property " + orderProperty));
                        if (compare == 0) continue;
                        continue block9;
                    }
                }
                if (orderbyDesc.charAt(orderbyDesc.length() - 1) != '=') {
                    orderbyDesc = orderbyDesc + ",";
                }
                orderbyDesc = orderbyDesc + property + "%20desc";
                urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, orderbyDesc);
                responseMap = HTTPMethods.doGet(urlString);
                response = responseMap.get("response").toString();
                array = new JSONObject(response).getJSONArray("value");
                block11: for (i = 1; i < array.length(); ++i) {
                    for (String orderProperty : orderbyPropeties) {
                        compare = this.compareWithPrevious(i, array, orderProperty);
                        Assert.assertTrue((compare >= 0 ? 1 : 0) != 0, (String)("The ordering is not correct for EntityType " + (Object)((Object)entityType) + " orderby desc property " + orderProperty));
                        if (compare == 0) continue;
                        continue block11;
                    }
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private int compareWithPrevious(int idx, JSONArray array, String property) throws JSONException {
        JSONObject jObj1 = array.getJSONObject(idx - 1);
        JSONObject jObj2 = array.getJSONObject(idx);
        Object o1 = jObj1.get(property);
        Object o2 = jObj2.get(property);
        return this.compareForOrder(o1, o2);
    }

    private int compareForOrder(Object o1, Object o2) {
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            if (o1.getClass().isAssignableFrom(o2.getClass())) {
                return ((Comparable)o1).compareTo(o2);
            }
            if (o2.getClass().isAssignableFrom(o1.getClass())) {
                return -((Comparable)o2).compareTo(o1);
            }
        }
        return o1.toString().compareTo(o2.toString());
    }

    private void checkSkipForEntityType(EntityType entityType) {
        try {
            String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, "?$skip=1");
            Map<String, Object> responseMap = HTTPMethods.doGet(urlString);
            String response = responseMap.get("response").toString();
            JSONArray array = new JSONObject(response).getJSONArray("value");
            try {
                Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response should not have nextLink.");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            switch (entityType) {
                case THING: 
                case LOCATION: 
                case FEATURE_OF_INTEREST: {
                    Assert.assertEquals((int)array.length(), (int)1, (String)("Query requested entities skipping 1, result should have contained 1 entity, but it contains " + array.length()));
                    break;
                }
                case OBSERVED_PROPERTY: {
                    Assert.assertEquals((int)array.length(), (int)2, (String)("Query requested entities skipping 1, result should have contained 2 entities, but it contains " + array.length()));
                    break;
                }
                case HISTORICAL_LOCATION: 
                case SENSOR: 
                case DATASTREAM: {
                    Assert.assertEquals((int)array.length(), (int)3, (String)("Query requested entities skipping 1, result should have contained 3 entities, but it contains " + array.length()));
                    break;
                }
                case OBSERVATION: {
                    Assert.assertEquals((int)array.length(), (int)11, (String)("Query requested entities skipping 1, result should have contained 11 entities, but it contains " + array.length()));
                    break;
                }
            }
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, "?$skip=2");
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            array = new JSONObject(response).getJSONArray("value");
            try {
                Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response should not have nextLink.");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            switch (entityType) {
                case THING: 
                case LOCATION: 
                case FEATURE_OF_INTEREST: {
                    Assert.assertEquals((int)array.length(), (int)0, (String)("Query requested entities skipping 2, result should have contained 0 entity, but it contains " + array.length()));
                    break;
                }
                case OBSERVED_PROPERTY: {
                    Assert.assertEquals((int)array.length(), (int)1, (String)("Query requested entities skipping 2, result should have contained 1 entity, but it contains " + array.length()));
                    break;
                }
                case HISTORICAL_LOCATION: 
                case SENSOR: 
                case DATASTREAM: {
                    Assert.assertEquals((int)array.length(), (int)2, (String)("Query requested entities skipping 2, result should have contained 2 entities, but it contains " + array.length()));
                    break;
                }
                case OBSERVATION: {
                    Assert.assertEquals((int)array.length(), (int)10, (String)("Query requested entities skipping 2, result should have contained 10 entities, but it contains " + array.length()));
                    break;
                }
            }
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, "?$skip=3");
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            array = new JSONObject(response).getJSONArray("value");
            try {
                Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response should not have nextLink.");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            switch (entityType) {
                case THING: 
                case LOCATION: 
                case FEATURE_OF_INTEREST: 
                case OBSERVED_PROPERTY: {
                    Assert.assertEquals((int)array.length(), (int)0, (String)("Query requested entities skipping 3, result should have contained 0 entity, but it contains " + array.length()));
                    break;
                }
                case HISTORICAL_LOCATION: 
                case SENSOR: 
                case DATASTREAM: {
                    Assert.assertEquals((int)array.length(), (int)1, (String)("Query requested entities skipping 3, result should have contained 1 entity, but it contains " + array.length()));
                    break;
                }
                case OBSERVATION: {
                    Assert.assertEquals((int)array.length(), (int)9, (String)("Query requested entities skipping 3, result should have contained 9 entities, but it contains " + array.length()));
                    break;
                }
            }
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, "?$skip=4");
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            array = new JSONObject(response).getJSONArray("value");
            try {
                Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response should not have nextLink.");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            switch (entityType) {
                case THING: 
                case LOCATION: 
                case FEATURE_OF_INTEREST: 
                case OBSERVED_PROPERTY: 
                case HISTORICAL_LOCATION: 
                case SENSOR: 
                case DATASTREAM: {
                    Assert.assertEquals((int)array.length(), (int)0, (String)("Query requested entities skipping 4, result should have contained 0 entity, but it contains " + array.length()));
                    break;
                }
                case OBSERVATION: {
                    Assert.assertEquals((int)array.length(), (int)8, (String)("Query requested entities skipping 4, result should have contained 8 entities, but it contains " + array.length()));
                    break;
                }
            }
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, "?$skip=12");
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            array = new JSONObject(response).getJSONArray("value");
            try {
                Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response should not have nextLink.");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            Assert.assertEquals((int)array.length(), (int)0, (String)("Query requested entities skipping 12, result should have contained 0 entity, but it contains " + array.length()));
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkSkipForEntityTypeRelation(EntityType entityType) {
        try {
            String[] relations = EntityRelations.getRelationsListFor(entityType);
            String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, null);
            Map<String, Object> responseMap = HTTPMethods.doGet(urlString);
            String response = responseMap.get("response").toString();
            JSONArray array = new JSONObject(response).getJSONArray("value");
            if (array.length() == 0) {
                return;
            }
            long id = array.getJSONObject(0).getLong("@iot.id");
            block28: for (String relation : relations) {
                if (relation.charAt(relation.length() - 1) != 's' && !relation.equals("FeaturesOfInterest")) continue;
                EntityType relationEntityType = this.getEntityTypeFor(relation);
                urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, relationEntityType, "?$skip=1");
                responseMap = HTTPMethods.doGet(urlString);
                response = responseMap.get("response").toString();
                array = new JSONObject(response).getJSONArray("value");
                try {
                    Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response should not have nextLink.");
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                switch (entityType) {
                    case THING: {
                        switch (relationEntityType) {
                            case LOCATION: {
                                Assert.assertEquals((int)array.length(), (int)0, (String)("Query requested entities skipping 1, result should have contained 0 entity, but it contains " + array.length()));
                                break;
                            }
                            case HISTORICAL_LOCATION: {
                                Assert.assertEquals((int)array.length(), (int)1, (String)("Query requested entities skipping 1, result should have contained 1 entity, but it contains " + array.length()));
                                break;
                            }
                            case DATASTREAM: {
                                Assert.assertEquals((int)array.length(), (int)1, (String)("Query requested entities skipping 1, result should have contained 1 entity, but it contains " + array.length()));
                            }
                        }
                        continue block28;
                    }
                    case LOCATION: {
                        switch (relationEntityType) {
                            case HISTORICAL_LOCATION: {
                                Assert.assertEquals((int)array.length(), (int)1, (String)("Query requested entities skipping 1, result should have contained 1 entity, but it contains " + array.length()));
                                break;
                            }
                            case THING: {
                                Assert.assertEquals((int)array.length(), (int)0, (String)("Query requested entities skipping 1, result should have contained 0 entity, but it contains " + array.length()));
                            }
                        }
                        continue block28;
                    }
                    case FEATURE_OF_INTEREST: {
                        Assert.assertEquals((int)array.length(), (int)5, (String)("Query requested entities skipping 1, result should have contained 5 entities, but it contains " + array.length()));
                        continue block28;
                    }
                    case OBSERVED_PROPERTY: {
                        Assert.assertTrue((array.length() == 1 || array.length() == 0 ? 1 : 0) != 0, (String)("Query requested entities skipping 1, result should have contained 0 or 1 entity, but it contains " + array.length()));
                        continue block28;
                    }
                    case HISTORICAL_LOCATION: {
                        switch (relationEntityType) {
                            case LOCATION: {
                                Assert.assertEquals((int)array.length(), (int)0, (String)("Query requested entities skipping 1, result should have contained 0 entity, but it contains " + array.length()));
                            }
                        }
                        continue block28;
                    }
                    case SENSOR: {
                        Assert.assertEquals((int)array.length(), (int)0, (String)("Query requested entities skipping 1, result should have contained 0 entity, but it contains " + array.length()));
                        continue block28;
                    }
                    case DATASTREAM: {
                        switch (relationEntityType) {
                            case OBSERVATION: {
                                Assert.assertEquals((int)array.length(), (int)2, (String)("Query requested entities skipping 1, result should have contained 2 entities, but it contains " + array.length()));
                            }
                        }
                        continue block28;
                    }
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkTopForEntityType(EntityType entityType) {
        try {
            String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, "?$top=1");
            Map<String, Object> responseMap = HTTPMethods.doGet(urlString);
            String response = responseMap.get("response").toString();
            JSONArray array = new JSONObject(response).getJSONArray("value");
            Assert.assertEquals((int)array.length(), (int)1, (String)("Query requested 1 entity but response contains " + array.length()));
            try {
                Assert.assertNotNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
            }
            catch (JSONException e) {
                Assert.fail((String)"The response does not have nextLink");
            }
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, "?$top=2");
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            array = new JSONObject(response).getJSONArray("value");
            Assert.assertEquals((int)array.length(), (int)2, (String)("Query requested 2 entities but response contains " + array.length()));
            switch (entityType) {
                case THING: 
                case LOCATION: 
                case FEATURE_OF_INTEREST: {
                    try {
                        Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                    }
                    catch (JSONException e) {}
                    break;
                }
                default: {
                    try {
                        Assert.assertNotNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                        break;
                    }
                    catch (JSONException e) {
                        Assert.fail((String)"The response does not have nextLink");
                    }
                }
            }
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, "?$top=3");
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            array = new JSONObject(response).getJSONArray("value");
            switch (entityType) {
                case THING: {
                    Assert.assertEquals((int)array.length(), (int)2, (String)("Query requested 3 Things, there are only 2 Things,  but response contains " + array.length()));
                    try {
                        Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                    }
                    catch (JSONException e) {}
                    break;
                }
                case LOCATION: {
                    Assert.assertEquals((int)array.length(), (int)2, (String)("Query requested 3 Locations, there are only 2 Locations,  but response contains " + array.length()));
                    try {
                        Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                    }
                    catch (JSONException e) {}
                    break;
                }
                case FEATURE_OF_INTEREST: {
                    Assert.assertEquals((int)array.length(), (int)2, (String)("Query requested 3 FeaturesOfInterest, there are only 2 FeaturesOfInterest,  but response contains " + array.length()));
                    try {
                        Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                    }
                    catch (JSONException e) {}
                    break;
                }
                case OBSERVED_PROPERTY: {
                    Assert.assertEquals((int)array.length(), (int)3, (String)("Query requested 3 entities but response contains " + array.length()));
                    try {
                        Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                    }
                    catch (JSONException e) {}
                    break;
                }
                default: {
                    Assert.assertEquals((int)array.length(), (int)3, (String)("Query requested 3 entities but response contains " + array.length()));
                    try {
                        Assert.assertNotNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                        break;
                    }
                    catch (JSONException e) {
                        Assert.fail((String)"The response does not have nextLink");
                    }
                }
            }
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, "?$top=4");
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            array = new JSONObject(response).getJSONArray("value");
            switch (entityType) {
                case THING: {
                    Assert.assertEquals((int)array.length(), (int)2, (String)("Query requested 4 Things, there are only 2 Things,  but response contains " + array.length()));
                    try {
                        Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                    }
                    catch (JSONException e) {}
                    break;
                }
                case LOCATION: {
                    Assert.assertEquals((int)array.length(), (int)2, (String)("Query requested 4 Locations, there are only 2 Locations,  but response contains " + array.length()));
                    try {
                        Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                    }
                    catch (JSONException e) {}
                    break;
                }
                case FEATURE_OF_INTEREST: {
                    Assert.assertEquals((int)array.length(), (int)2, (String)("Query requested 4 FeaturesOfInterest, there are only 2 FeaturesOfInterest,  but response contains " + array.length()));
                    try {
                        Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                    }
                    catch (JSONException e) {}
                    break;
                }
                case OBSERVED_PROPERTY: {
                    Assert.assertEquals((int)array.length(), (int)3, (String)("Query requested 4 ObservedProperties, there are only 3 ObservedProperties,  but response contains " + array.length()));
                    try {
                        Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                    }
                    catch (JSONException e) {}
                    break;
                }
                case HISTORICAL_LOCATION: 
                case SENSOR: 
                case DATASTREAM: {
                    Assert.assertEquals((int)array.length(), (int)4, (String)("Query requested 4 entities but response contains " + array.length()));
                    try {
                        Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                    }
                    catch (JSONException e) {}
                    break;
                }
                default: {
                    Assert.assertEquals((int)array.length(), (int)4, (String)("Query requested 4 entities but response contains " + array.length()));
                    try {
                        Assert.assertNotNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                        break;
                    }
                    catch (JSONException e) {
                        Assert.fail((String)"The response does not have nextLink");
                    }
                }
            }
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, "?$top=5");
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            array = new JSONObject(response).getJSONArray("value");
            switch (entityType) {
                case THING: {
                    Assert.assertEquals((int)array.length(), (int)2, (String)("Query requested 5 Things, there are only 2 Things,  but response contains " + array.length()));
                    try {
                        Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                    }
                    catch (JSONException e) {}
                    break;
                }
                case LOCATION: {
                    Assert.assertEquals((int)array.length(), (int)2, (String)("Query requested 5 Locations, there are only 2 Locations,  but response contains " + array.length()));
                    try {
                        Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                    }
                    catch (JSONException e) {}
                    break;
                }
                case FEATURE_OF_INTEREST: {
                    Assert.assertEquals((int)array.length(), (int)2, (String)("Query requested 5 FeaturesOfInterest, there are only 2 FeaturesOfInterest,  but response contains " + array.length()));
                    try {
                        Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                    }
                    catch (JSONException e) {}
                    break;
                }
                case OBSERVED_PROPERTY: {
                    Assert.assertEquals((int)array.length(), (int)3, (String)("Query requested 5 ObservedProperties, there are only 3 ObservedProperties,  but response contains " + array.length()));
                    try {
                        Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                    }
                    catch (JSONException e) {}
                    break;
                }
                case SENSOR: {
                    Assert.assertEquals((int)array.length(), (int)4, (String)("Query requested 5 Sensors, there are only 4 Sensors,  but response contains " + array.length()));
                    try {
                        Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                    }
                    catch (JSONException e) {}
                    break;
                }
                case HISTORICAL_LOCATION: {
                    Assert.assertEquals((int)array.length(), (int)4, (String)("Query requested 5 HistoricalLocations, there are only 4 HistoricalLocations,  but response contains " + array.length()));
                    try {
                        Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                    }
                    catch (JSONException e) {}
                    break;
                }
                case DATASTREAM: {
                    Assert.assertEquals((int)array.length(), (int)4, (String)("Query requested 5 Datastreams, there are only 4 Datastreams, but response contains " + array.length()));
                    try {
                        Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                    }
                    catch (JSONException e) {}
                    break;
                }
                default: {
                    Assert.assertEquals((int)array.length(), (int)5, (String)("Query requested 5 entities but response contains " + array.length()));
                    try {
                        Assert.assertNotNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                        break;
                    }
                    catch (JSONException e) {
                        Assert.fail((String)"The response does not have nextLink");
                    }
                }
            }
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, "?$top=12");
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            try {
                Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, "?$top=13");
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            array = new JSONObject(response).getJSONArray("value");
            try {
                Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            switch (entityType) {
                case THING: {
                    Assert.assertEquals((int)array.length(), (int)2, (String)("Query requested 13 Things, there are only 2 Things,  but response contains " + array.length()));
                    break;
                }
                case LOCATION: {
                    Assert.assertEquals((int)array.length(), (int)2, (String)("Query requested 13 Locations, there are only 2 Locations,  but response contains " + array.length()));
                    break;
                }
                case FEATURE_OF_INTEREST: {
                    Assert.assertEquals((int)array.length(), (int)2, (String)("Query requested 13 FeaturesOfInterest, there are only 2 FeaturesOfInterest,  but response contains " + array.length()));
                    break;
                }
                case OBSERVED_PROPERTY: {
                    Assert.assertEquals((int)array.length(), (int)3, (String)("Query requested 13 ObservedProperties, there are only 3 ObservedProperties,  but response contains " + array.length()));
                    break;
                }
                case SENSOR: {
                    Assert.assertEquals((int)array.length(), (int)4, (String)("Query requested 13 Sensors, there are only 4 Sensors,  but response contains " + array.length()));
                    break;
                }
                case HISTORICAL_LOCATION: {
                    Assert.assertEquals((int)array.length(), (int)4, (String)("Query requested 13 HistoricalLocations, there are only 4 HistoricalLocations,  but response contains " + array.length()));
                    break;
                }
                case DATASTREAM: {
                    Assert.assertEquals((int)array.length(), (int)4, (String)("Query requested 13 Datastreams, there are only 4 Datastreams, but response contains " + array.length()));
                    break;
                }
                case OBSERVATION: {
                    Assert.assertEquals((int)array.length(), (int)12, (String)("Query requested 13 Observations, there are only 12 Observations, but response contains " + array.length()));
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkTopForEntityTypeRelation(EntityType entityType) {
        try {
            String[] relations = EntityRelations.getRelationsListFor(entityType);
            String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, null);
            Map<String, Object> responseMap = HTTPMethods.doGet(urlString);
            String response = responseMap.get("response").toString();
            JSONArray array = new JSONObject(response).getJSONArray("value");
            if (array.length() == 0) {
                return;
            }
            long id = array.getJSONObject(0).getLong("@iot.id");
            block40: for (String relation : relations) {
                if (relation.charAt(relation.length() - 1) != 's' && !relation.equals("FeaturesOfInterest")) continue;
                EntityType relationEntityType = this.getEntityTypeFor(relation);
                urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, relationEntityType, "?$top=3");
                responseMap = HTTPMethods.doGet(urlString);
                response = responseMap.get("response").toString();
                array = new JSONObject(response).getJSONArray("value");
                switch (entityType) {
                    case THING: {
                        try {
                            Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                        switch (relationEntityType) {
                            case LOCATION: {
                                Assert.assertEquals((int)array.length(), (int)1, (String)("Query requested entities 3 entities, result should have contained 1 entity, but it contains " + array.length()));
                                break;
                            }
                            case HISTORICAL_LOCATION: {
                                Assert.assertEquals((int)array.length(), (int)2, (String)("Query requested entities 3 entities, result should have contained 2 entities, but it contains " + array.length()));
                                break;
                            }
                            case DATASTREAM: {
                                Assert.assertEquals((int)array.length(), (int)2, (String)("Query requested entities 3 entities, result should have contained 2 entities, but it contains " + array.length()));
                            }
                        }
                        continue block40;
                    }
                    case LOCATION: {
                        try {
                            Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                        switch (relationEntityType) {
                            case HISTORICAL_LOCATION: {
                                Assert.assertEquals((int)array.length(), (int)2, (String)("Query requested entities 3 entities, result should have contained 2 entities, but it contains " + array.length()));
                                break;
                            }
                            case THING: {
                                Assert.assertEquals((int)array.length(), (int)1, (String)("Query requested entities 3 entities, result should have contained 1 entity, but it contains" + array.length()));
                            }
                        }
                        continue block40;
                    }
                    case FEATURE_OF_INTEREST: {
                        Assert.assertEquals((int)array.length(), (int)3, (String)("Query requested entities 3 entities, result should have contained 3 entities, but it contains " + array.length()));
                        try {
                            Assert.assertNotNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                        }
                        catch (JSONException e) {
                            Assert.fail((String)"The response does not have nextLink");
                        }
                        continue block40;
                    }
                    case OBSERVED_PROPERTY: {
                        Assert.assertTrue((array.length() == 1 || array.length() == 2 ? 1 : 0) != 0, (String)("Query requested entities 3 entities, result should have contained 1 or 2 entities, but it contains " + array.length()));
                        try {
                            Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response should not have nextLink");
                        }
                        catch (JSONException jSONException) {}
                        continue block40;
                    }
                    case HISTORICAL_LOCATION: {
                        try {
                            Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response should not have nextLink");
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                        switch (relationEntityType) {
                            case LOCATION: {
                                Assert.assertEquals((int)array.length(), (int)1, (String)("Query requested entities 3 entities, result should have contained 1 entity, but it contains " + array.length()));
                            }
                        }
                        continue block40;
                    }
                    case SENSOR: {
                        try {
                            Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response should not have nextLink");
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                        Assert.assertEquals((int)array.length(), (int)1, (String)("Query requested entities 3 entities, result should have contained 1 entity, but it contains " + array.length()));
                        continue block40;
                    }
                    case DATASTREAM: {
                        try {
                            Assert.assertNull((Object)new JSONObject(response).get("@iot.nextLink"), (String)"The response does not have nextLink");
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                        switch (relationEntityType) {
                            case OBSERVATION: {
                                Assert.assertEquals((int)array.length(), (int)3, (String)("Query requested entities 3 entities, result should have contained 3 entities, but it contains " + array.length()));
                            }
                        }
                        continue block40;
                    }
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkSelectForEntityType(EntityType entityType) {
        String response;
        ArrayList<String> selectedProperties;
        String[] properties;
        for (String property : properties = EntityProperties.getPropertiesListFor(entityType)) {
            selectedProperties = new ArrayList();
            selectedProperties.add(property);
            response = this.getEntities(entityType, -1L, null, selectedProperties, null);
            this.checkEntitiesAllAspectsForSelectResponse(entityType, response, selectedProperties);
        }
        selectedProperties = new ArrayList<String>();
        for (String property : properties) {
            selectedProperties.add(property);
            response = this.getEntities(entityType, -1L, null, selectedProperties, null);
            this.checkEntitiesAllAspectsForSelectResponse(entityType, response, selectedProperties);
        }
    }

    private void checkSelectForEntityTypeRelations(EntityType entityType) {
        try {
            String[] parentRelations = EntityRelations.getRelationsListFor(entityType);
            String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, null);
            Map<String, Object> responseMap = HTTPMethods.doGet(urlString);
            String response = responseMap.get("response").toString();
            JSONArray array = new JSONObject(response).getJSONArray("value");
            if (array.length() == 0) {
                return;
            }
            long id = array.getJSONObject(0).getLong("@iot.id");
            for (String parentRelation : parentRelations) {
                ArrayList<String> selectedProperties;
                String[] properties;
                EntityType relationEntityType = this.getEntityTypeFor(parentRelation);
                for (String property : properties = EntityProperties.getPropertiesListFor(relationEntityType)) {
                    selectedProperties = new ArrayList();
                    selectedProperties.add(property);
                    response = this.getEntities(entityType, id, relationEntityType, selectedProperties, null);
                    this.checkEntitiesAllAspectsForSelectResponse(relationEntityType, response, selectedProperties);
                }
                selectedProperties = new ArrayList<String>();
                for (String property : properties) {
                    selectedProperties.add(property);
                    response = this.getEntities(entityType, id, relationEntityType, selectedProperties, null);
                    this.checkEntitiesAllAspectsForSelectResponse(relationEntityType, response, selectedProperties);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private String getEntities(EntityType entityType, long id, EntityType relationEntityType, List<String> selectedProperties, List<String> expandedRelations) {
        String urlString = this.rootUri;
        String selectString = "";
        if (selectedProperties != null && selectedProperties.size() > 0) {
            selectString = "?$select=";
            for (String string : selectedProperties) {
                if (selectString.charAt(selectString.length() - 1) != '=') {
                    selectString = selectString + ',';
                }
                selectString = selectString + string;
            }
        }
        String expandString = "";
        if (expandedRelations != null && expandedRelations.size() > 0) {
            expandString = selectString.equals("") ? "?$expand=" : "&$expand=";
            for (String expand : expandedRelations) {
                if (expandString.charAt(expandString.length() - 1) != '=') {
                    expandString = expandString + ',';
                }
                expandString = expandString + expand;
            }
        }
        if (entityType != null) {
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, relationEntityType, selectString + expandString);
        }
        Map<String, Object> map = HTTPMethods.doGet(urlString);
        String response = map.get("response").toString();
        int responseCode = Integer.parseInt(map.get("response-code").toString());
        Assert.assertEquals((int)responseCode, (int)200, (String)("Error during getting entities: " + entityType.name()));
        return response;
    }

    private void checkEntitiesAllAspectsForSelectResponse(EntityType entityType, String response, List<String> selectedProperties) {
        this.checkEntitiesProperties(entityType, response, selectedProperties);
        this.checkEntitiesRelations(entityType, response, selectedProperties, null);
    }

    private void checkEntitiesProperties(EntityType entityType, String response, List<String> selectedProperties) {
        try {
            JSONObject jsonResponse = new JSONObject(response.toString());
            JSONArray entities = null;
            if (response.contains("value")) {
                entities = jsonResponse.getJSONArray("value");
            } else {
                entities = new JSONArray();
                entities.put((Object)jsonResponse);
            }
            this.checkPropertiesForEntityArray(entityType, entities, selectedProperties);
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkPropertiesForEntityArray(EntityType entityType, JSONArray entities, List<String> selectedProperties) {
        int count = 0;
        for (int i = 0; i < entities.length() && count < 2; ++i) {
            ++count;
            JSONObject entity = null;
            try {
                entity = entities.getJSONObject(i);
            }
            catch (JSONException e) {
                e.printStackTrace();
                Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            }
            this.checkEntityProperties(entityType, entity, selectedProperties);
        }
    }

    private void checkEntityProperties(EntityType entityType, Object response, List<String> selectedProperties) {
        try {
            String[] properties;
            JSONObject entity = new JSONObject(response.toString());
            for (String property : properties = EntityProperties.getPropertiesListFor(entityType)) {
                if (selectedProperties.contains(property)) {
                    try {
                        Assert.assertNotNull((Object)entity.get(property), (String)("Entity type \"" + (Object)((Object)entityType) + "\" does not have selected property: \"" + property + "\"."));
                    }
                    catch (JSONException e) {
                        Assert.fail((String)("Entity type \"" + (Object)((Object)entityType) + "\" does not have selected property: \"" + property + "\"."));
                    }
                    continue;
                }
                try {
                    Assert.assertNull((Object)entity.get(property), (String)("Entity type \"" + (Object)((Object)entityType) + "\" contains not-selected property: \"" + property + "\"."));
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkEntitiesRelations(EntityType entityType, String response, List<String> selectedProperties, List<String> expandedRelations) {
        try {
            JSONObject jsonResponse = new JSONObject(response.toString());
            JSONArray entities = null;
            if (response.contains("value")) {
                entities = jsonResponse.getJSONArray("value");
            } else {
                entities = new JSONArray();
                entities.put((Object)jsonResponse);
            }
            int count = 0;
            for (int i = 0; i < entities.length() && count < 2; ++count, ++i) {
                JSONObject entity = entities.getJSONObject(i);
                this.checkEntityRelations(entityType, entity, selectedProperties, expandedRelations);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkEntityRelations(EntityType entityType, Object response, List<String> selectedProperties, List<String> expandedRelations) {
        try {
            String[] relations;
            JSONObject entity = new JSONObject(response.toString());
            for (String relation : relations = EntityRelations.getRelationsListFor(entityType)) {
                if (selectedProperties == null || selectedProperties.contains(relation)) {
                    if (expandedRelations == null || !this.listContainsString(expandedRelations, relation)) {
                        try {
                            Assert.assertNotNull((Object)entity.get(relation + "@iot.navigationLink"), (String)("Entity type \"" + (Object)((Object)entityType) + "\" does not have selected relation: \"" + relation + "\"."));
                        }
                        catch (JSONException e) {
                            Assert.fail((String)("Entity type \"" + (Object)((Object)entityType) + "\" does not have selected relation: \"" + relation + "\"."));
                        }
                        continue;
                    }
                    Assert.assertNotNull((Object)entity.get(relation), (String)("Entity type \"" + (Object)((Object)entityType) + "\" does not have expanded relation Correctly: \"" + relation + "\"."));
                    JSONArray expandedEntityArray = null;
                    try {
                        if (relation.charAt(relation.length() - 1) != 's' && !relation.equals("FeaturesOfInterest")) {
                            expandedEntityArray = new JSONArray();
                            expandedEntityArray.put((Object)entity.getJSONObject(relation));
                        } else {
                            expandedEntityArray = entity.getJSONArray(relation);
                        }
                    }
                    catch (JSONException e) {
                        Assert.fail((String)("Entity type \"" + (Object)((Object)entityType) + "\" does not have expanded relation Correctly: \"" + relation + "\"."));
                    }
                    this.checkPropertiesForEntityArray(this.getEntityTypeFor(relation), expandedEntityArray, new ArrayList<String>(Arrays.asList(EntityProperties.getPropertiesListFor(relation))));
                    if (!this.listContainsString(expandedRelations, "/")) continue;
                    String[] secondLevelRelations = EntityRelations.getRelationsListFor(relation);
                    JSONObject expandedEntity = expandedEntityArray.getJSONObject(0);
                    for (String secondLeveleRelation : secondLevelRelations) {
                        if (!this.listContainsString(expandedRelations, relation + "/" + secondLeveleRelation)) continue;
                        expandedEntityArray = null;
                        try {
                            if (secondLeveleRelation.charAt(secondLeveleRelation.length() - 1) != 's' && !secondLeveleRelation.equals("FeaturesOfInterest")) {
                                expandedEntityArray = new JSONArray();
                                expandedEntityArray.put((Object)expandedEntity.getJSONObject(secondLeveleRelation));
                            } else {
                                expandedEntityArray = expandedEntity.getJSONArray(secondLeveleRelation);
                            }
                        }
                        catch (JSONException e) {
                            Assert.fail((String)("Entity type \"" + (Object)((Object)entityType) + "\" does not have expanded relation Correctly: \"" + relation + "/" + secondLeveleRelation + "\"."));
                        }
                        this.checkPropertiesForEntityArray(this.getEntityTypeFor(secondLeveleRelation), expandedEntityArray, new ArrayList<String>(Arrays.asList(EntityProperties.getPropertiesListFor(secondLeveleRelation))));
                    }
                    continue;
                }
                try {
                    Assert.assertNull((Object)entity.get(relation + "@iot.navigationLink"), (String)("Entity type \"" + (Object)((Object)entityType) + "\" contains not-selectd relation: \"" + relation + "\"."));
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                try {
                    Assert.assertNull((Object)entity.get(relation), (String)("Entity type \"" + (Object)((Object)entityType) + "\" contains not-selectd relation: \"" + relation + "\"."));
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkExpandtForEntityType(EntityType entityType) {
        String response;
        ArrayList<String> expandedRelations;
        String[] relations;
        for (String relation : relations = EntityRelations.getRelationsListFor(entityType)) {
            expandedRelations = new ArrayList();
            expandedRelations.add(relation);
            response = this.getEntities(entityType, -1L, null, null, expandedRelations);
            this.checkEntitiesAllAspectsForExpandResponse(entityType, response, expandedRelations);
        }
        expandedRelations = new ArrayList<String>();
        for (String relation : relations) {
            expandedRelations.add(relation);
            response = this.getEntities(entityType, -1L, null, null, expandedRelations);
            this.checkEntitiesAllAspectsForExpandResponse(entityType, response, expandedRelations);
        }
    }

    private void checkExpandtForEntityTypeRelations(EntityType entityType) {
        try {
            String[] parentRelations = EntityRelations.getRelationsListFor(entityType);
            String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, null);
            Map<String, Object> responseMap = HTTPMethods.doGet(urlString);
            String response = responseMap.get("response").toString();
            JSONArray array = new JSONObject(response).getJSONArray("value");
            if (array.length() == 0) {
                return;
            }
            long id = array.getJSONObject(0).getLong("@iot.id");
            for (String parentRelation : parentRelations) {
                ArrayList<String> expandedRelations;
                String[] relations;
                EntityType relationEntityType = this.getEntityTypeFor(parentRelation);
                for (String relation : relations = EntityRelations.getRelationsListFor(relationEntityType)) {
                    expandedRelations = new ArrayList();
                    expandedRelations.add(relation);
                    response = this.getEntities(entityType, id, relationEntityType, null, expandedRelations);
                    this.checkEntitiesAllAspectsForExpandResponse(relationEntityType, response, expandedRelations);
                }
                expandedRelations = new ArrayList<String>();
                for (String relation : relations) {
                    expandedRelations.add(relation);
                    response = this.getEntities(entityType, id, relationEntityType, null, expandedRelations);
                    this.checkEntitiesAllAspectsForExpandResponse(relationEntityType, response, expandedRelations);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkExpandtForEntityTypeMultilevelRelations(EntityType entityType) {
        try {
            String[] parentRelations = EntityRelations.getRelationsListFor(entityType);
            String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, null);
            Map<String, Object> responseMap = HTTPMethods.doGet(urlString);
            String response = responseMap.get("response").toString();
            JSONArray array = new JSONObject(response).getJSONArray("value");
            if (array.length() == 0) {
                return;
            }
            long id = array.getJSONObject(0).getLong("@iot.id");
            for (String parentRelation : parentRelations) {
                ArrayList<String> expandedRelations;
                String[] secondLevelRelations;
                String[] relations;
                EntityType relationEntityType = this.getEntityTypeFor(parentRelation);
                for (String relation : relations = EntityRelations.getRelationsListFor(relationEntityType)) {
                    for (String secondLevelRelation : secondLevelRelations = EntityRelations.getRelationsListFor(relation)) {
                        expandedRelations = new ArrayList();
                        expandedRelations.add(relation + "/" + secondLevelRelation);
                        response = this.getEntities(entityType, id, relationEntityType, null, expandedRelations);
                        this.checkEntitiesAllAspectsForExpandResponse(relationEntityType, response, expandedRelations);
                    }
                }
                expandedRelations = new ArrayList<String>();
                for (String relation : relations) {
                    for (String secondLevelRelation : secondLevelRelations = EntityRelations.getRelationsListFor(relation)) {
                        expandedRelations.add(relation + "/" + secondLevelRelation);
                        response = this.getEntities(entityType, id, relationEntityType, null, expandedRelations);
                        this.checkEntitiesAllAspectsForExpandResponse(relationEntityType, response, expandedRelations);
                    }
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkExpandtForEntityTypeMultilevel(EntityType entityType) {
        String response;
        ArrayList<String> expandedRelations;
        String[] secondLevelRelations;
        String[] relations;
        for (String relation : relations = EntityRelations.getRelationsListFor(entityType)) {
            for (String secondLevelRelation : secondLevelRelations = EntityRelations.getRelationsListFor(relation)) {
                expandedRelations = new ArrayList();
                expandedRelations.add(relation + "/" + secondLevelRelation);
                response = this.getEntities(entityType, -1L, null, null, expandedRelations);
                this.checkEntitiesAllAspectsForExpandResponse(entityType, response, expandedRelations);
            }
        }
        expandedRelations = new ArrayList<String>();
        for (String relation : relations) {
            for (String secondLevelRelation : secondLevelRelations = EntityRelations.getRelationsListFor(relation)) {
                expandedRelations.add(relation + "/" + secondLevelRelation);
                response = this.getEntities(entityType, -1L, null, null, expandedRelations);
                this.checkEntitiesAllAspectsForExpandResponse(entityType, response, expandedRelations);
            }
        }
    }

    private void checkCountForEntityType(EntityType entityType) {
        String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, "?$count=true");
        Map<String, Object> responseMap = HTTPMethods.doGet(urlString);
        String response = responseMap.get("response").toString();
        int count = -1;
        try {
            count = new JSONObject(response).getInt("@iot.count");
        }
        catch (JSONException e) {
            Assert.fail((String)("the query asked for count but the response does not contain count, for getting collection: " + (Object)((Object)entityType)));
        }
        switch (entityType) {
            case THING: 
            case LOCATION: 
            case FEATURE_OF_INTEREST: {
                Assert.assertEquals((int)count, (int)2, (String)("The count for " + (Object)((Object)entityType) + "should be 2, but it is " + count));
                break;
            }
            case OBSERVED_PROPERTY: {
                Assert.assertEquals((int)count, (int)3, (String)("The count for " + (Object)((Object)entityType) + "should be 3, but it is " + count));
                break;
            }
            case HISTORICAL_LOCATION: 
            case SENSOR: 
            case DATASTREAM: {
                Assert.assertEquals((int)count, (int)4, (String)("The count for " + (Object)((Object)entityType) + "should be 4, but it is " + count));
                break;
            }
            case OBSERVATION: {
                Assert.assertEquals((int)count, (int)12, (String)("The count for " + (Object)((Object)entityType) + "should be 12, but it is " + count));
                break;
            }
        }
        urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, "?$count=false");
        responseMap = HTTPMethods.doGet(urlString);
        response = responseMap.get("response").toString();
        try {
            Assert.assertNull((Object)new JSONObject(response).getInt("@iot.count"), (String)("the query asked for not count but the response does contain count, for getting collection: " + (Object)((Object)entityType)));
            Assert.fail((String)("the query asked for not count but the response does contain count, for getting collection: " + (Object)((Object)entityType)));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void checkCountForEntityTypeRelations(EntityType entityType) {
        try {
            String[] relations = EntityRelations.getRelationsListFor(entityType);
            String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, null);
            Map<String, Object> responseMap = HTTPMethods.doGet(urlString);
            String response = responseMap.get("response").toString();
            JSONArray array = new JSONObject(response).getJSONArray("value");
            if (array.length() == 0) {
                return;
            }
            long id = array.getJSONObject(0).getLong("@iot.id");
            for (String relation : relations) {
                if (relation.charAt(relation.length() - 1) != 's' && !relation.equals("FeatureOfInterest")) {
                    return;
                }
                EntityType relationEntityType = this.getEntityTypeFor(relation);
                urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, relationEntityType, "?$count=true");
                responseMap = HTTPMethods.doGet(urlString);
                response = responseMap.get("response").toString();
                int count = -1;
                try {
                    count = new JSONObject(response).getInt("@iot.count");
                }
                catch (JSONException e) {
                    Assert.fail((String)("the query asked for count but the response does not contain count, for getting collection: " + (Object)((Object)entityType)));
                }
                switch (relationEntityType) {
                    case THING: 
                    case LOCATION: {
                        Assert.assertEquals((int)count, (int)1, (String)("The count for " + (Object)((Object)entityType) + "should be 1, but it is " + count));
                        break;
                    }
                    case HISTORICAL_LOCATION: 
                    case DATASTREAM: {
                        switch (entityType) {
                            case THING: {
                                Assert.assertEquals((int)count, (int)2, (String)("The count for " + (Object)((Object)entityType) + "should be 2, but it is " + count));
                                break;
                            }
                            case SENSOR: {
                                Assert.assertEquals((int)count, (int)1, (String)("The count for " + (Object)((Object)entityType) + "should be 1, but it is " + count));
                                break;
                            }
                            case OBSERVED_PROPERTY: {
                                Assert.assertTrue((count == 2 || count == 1 ? 1 : 0) != 0, (String)("The count for " + (Object)((Object)entityType) + "should be 1 or 2, but it is " + count));
                            }
                        }
                        break;
                    }
                    case OBSERVATION: {
                        if (entityType.equals((Object)EntityType.DATASTREAM)) {
                            Assert.assertEquals((int)count, (int)3, (String)("The count for " + (Object)((Object)entityType) + "should be 3, but it is " + count));
                            break;
                        }
                        if (!entityType.equals((Object)EntityType.FEATURE_OF_INTEREST)) break;
                        Assert.assertEquals((int)count, (int)6, (String)("The count for " + (Object)((Object)entityType) + "should be 6, but it is " + count));
                        break;
                    }
                }
                urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, relationEntityType, "?$count=false");
                responseMap = HTTPMethods.doGet(urlString);
                response = responseMap.get("response").toString();
                try {
                    Assert.assertNull((Object)new JSONObject(response).getInt("@iot.count"), (String)("the query asked for not count but the response does contain count, for getting collection: " + (Object)((Object)entityType)));
                    Assert.fail((String)("the query asked for not count but the response does contain count, for getting collection: " + (Object)((Object)entityType)));
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private void checkEntitiesAllAspectsForExpandResponse(EntityType entityType, String response, List<String> expandedRelations) {
        this.checkEntitiesRelations(entityType, response, null, expandedRelations);
    }

    private void checkFilterForEntityType(EntityType entityType) throws UnsupportedEncodingException {
        String[] properties = EntityProperties.getPropertiesListFor(entityType);
        for (int i = 0; i < properties.length; ++i) {
            ArrayList<String> filteredProperties = new ArrayList<String>();
            ArrayList<Comparable> samplePropertyValues = new ArrayList<Comparable>();
            String property = properties[i];
            filteredProperties.add(property);
            if (property.equals("location") || property.equals("feature") || property.equals("unitOfMeasurement")) continue;
            Object propertyValue = EntityPropertiesSampleValue.getPropertyValueFor(entityType, i);
            samplePropertyValues.add((Comparable)propertyValue);
            propertyValue = URLEncoder.encode(propertyValue.toString(), "UTF-8");
            String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, "?$filter=" + property + "%20lt%20" + propertyValue);
            Map<String, Object> responseMap = HTTPMethods.doGet(urlString);
            String response = responseMap.get("response").toString();
            this.checkPropertiesForFilter(response, filteredProperties, samplePropertyValues, -2);
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, "?$filter=" + property + "%20le%20" + propertyValue);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            this.checkPropertiesForFilter(response, filteredProperties, samplePropertyValues, -1);
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, "?$filter=" + property + "%20eq%20" + propertyValue);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            this.checkPropertiesForFilter(response, filteredProperties, samplePropertyValues, 0);
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, "?$filter=" + property + "%20ne%20" + propertyValue);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            this.checkPropertiesForFilter(response, filteredProperties, samplePropertyValues, -3);
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, "?$filter=" + property + "%20ge%20" + propertyValue);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            this.checkPropertiesForFilter(response, filteredProperties, samplePropertyValues, 1);
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, "?$filter=" + property + "%20gt%20" + propertyValue);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            this.checkPropertiesForFilter(response, filteredProperties, samplePropertyValues, 2);
        }
    }

    private void checkFilterForEntityTypeRelations(EntityType entityType) throws UnsupportedEncodingException {
        String[] relations = EntityRelations.getRelationsListFor(entityType);
        String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, null);
        Map<String, Object> responseMap = HTTPMethods.doGet(urlString);
        String response = responseMap.get("response").toString();
        JSONArray array = null;
        try {
            array = new JSONObject(response).getJSONArray("value");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
        if (array.length() == 0) {
            return;
        }
        long id = 0L;
        try {
            id = array.getJSONObject(0).getLong("@iot.id");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
        for (String relation : relations) {
            if (relation.charAt(relation.length() - 1) != 's' && !relation.equals("FeatureOfInterest")) {
                return;
            }
            EntityType relationEntityType = this.getEntityTypeFor(relation);
            String[] properties = EntityProperties.getPropertiesListFor(relationEntityType);
            for (int i = 0; i < properties.length; ++i) {
                ArrayList<String> filteredProperties = new ArrayList<String>();
                ArrayList<Comparable> samplePropertyValues = new ArrayList<Comparable>();
                String property = properties[i];
                filteredProperties.add(property);
                if (property.equals("location") || property.equals("feature") || property.equals("unitOfMeasurement")) continue;
                Object propertyValue = EntityPropertiesSampleValue.getPropertyValueFor(relationEntityType, i);
                samplePropertyValues.add((Comparable)propertyValue);
                propertyValue = URLEncoder.encode(propertyValue.toString(), "UTF-8");
                urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, relationEntityType, "?$filter=" + property + "%20lt%20" + propertyValue);
                responseMap = HTTPMethods.doGet(urlString);
                response = responseMap.get("response").toString();
                this.checkPropertiesForFilter(response, filteredProperties, samplePropertyValues, -2);
                urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, relationEntityType, "?$filter=" + property + "%20le%20" + propertyValue);
                responseMap = HTTPMethods.doGet(urlString);
                response = responseMap.get("response").toString();
                this.checkPropertiesForFilter(response, filteredProperties, samplePropertyValues, -1);
                urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, relationEntityType, "?$filter=" + property + "%20eq%20" + propertyValue);
                responseMap = HTTPMethods.doGet(urlString);
                response = responseMap.get("response").toString();
                this.checkPropertiesForFilter(response, filteredProperties, samplePropertyValues, 0);
                urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, relationEntityType, "?$filter=" + property + "%20ne%20" + propertyValue);
                responseMap = HTTPMethods.doGet(urlString);
                response = responseMap.get("response").toString();
                this.checkPropertiesForFilter(response, filteredProperties, samplePropertyValues, -3);
                urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, relationEntityType, "?$filter=" + property + "%20ge%20" + propertyValue);
                responseMap = HTTPMethods.doGet(urlString);
                response = responseMap.get("response").toString();
                this.checkPropertiesForFilter(response, filteredProperties, samplePropertyValues, 1);
                urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, relationEntityType, "?$filter=" + property + "%20gt%20" + propertyValue);
                responseMap = HTTPMethods.doGet(urlString);
                response = responseMap.get("response").toString();
                this.checkPropertiesForFilter(response, filteredProperties, samplePropertyValues, 2);
            }
        }
    }

    private void checkPropertiesForFilter(String response, List<String> properties, List<Comparable> values, int operator) {
        try {
            JSONObject entities = new JSONObject(response);
            JSONArray entityArray = entities.getJSONArray("value");
            for (int i = 0; i < entityArray.length(); ++i) {
                JSONObject entity = entityArray.getJSONObject(i);
                block13: for (int j = 0; j < properties.size(); ++j) {
                    Object value;
                    Object propertyValue = "";
                    try {
                        propertyValue = entity.get(properties.get(j));
                    }
                    catch (JSONException e) {
                        Assert.fail((String)("The entity does not have property " + properties.get(j)));
                    }
                    if (propertyValue == null) {
                        Assert.fail((String)("The entity has null value for property " + properties.get(j)));
                    }
                    if ((value = values.get(j)) instanceof String && ((String)value).charAt(0) == '\'') {
                        String sValue = (String)value;
                        value = sValue.substring(1, sValue.length() - 1);
                        if (!(propertyValue instanceof String)) {
                            propertyValue = propertyValue.toString();
                        }
                    } else if (value instanceof DateTime) {
                        propertyValue = ISODateTimeFormat.dateTime().parseDateTime(propertyValue.toString());
                    }
                    int result = value.compareTo(propertyValue);
                    switch (operator) {
                        case -3: {
                            Assert.assertTrue((result != 0 ? 1 : 0) != 0, (String)(properties.get(j) + " should not be equal to " + value + ". But the property value is " + propertyValue));
                            continue block13;
                        }
                        case -2: {
                            Assert.assertTrue((result > 0 ? 1 : 0) != 0, (String)(properties.get(j) + " should be less than " + value + ". But the property value is " + propertyValue));
                            continue block13;
                        }
                        case -1: {
                            Assert.assertTrue((result >= 0 ? 1 : 0) != 0, (String)(properties.get(j) + " should be less than or equal to " + value + ". But the property value is " + propertyValue));
                            continue block13;
                        }
                        case 0: {
                            Assert.assertTrue((result == 0 ? 1 : 0) != 0, (String)(properties.get(j) + " should be equal to than " + value + ". But the property value is " + propertyValue));
                            continue block13;
                        }
                        case 1: {
                            Assert.assertTrue((result <= 0 ? 1 : 0) != 0, (String)(properties.get(j) + " should be greate than or equal to " + value + ". But the property value is " + propertyValue));
                            continue block13;
                        }
                        case 2: {
                            Assert.assertTrue((result < 0 ? 1 : 0) != 0, (String)(properties.get(j) + " should be greater than " + value + ". But the property value is " + propertyValue));
                        }
                    }
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private EntityType getEntityTypeFor(String name) {
        switch (name.toLowerCase()) {
            case "thing": 
            case "things": {
                return EntityType.THING;
            }
            case "location": 
            case "locations": {
                return EntityType.LOCATION;
            }
            case "historicallocation": 
            case "historicallocations": {
                return EntityType.HISTORICAL_LOCATION;
            }
            case "datastream": 
            case "datastreams": {
                return EntityType.DATASTREAM;
            }
            case "sensor": 
            case "sensors": {
                return EntityType.SENSOR;
            }
            case "observedproperty": 
            case "observedproperties": {
                return EntityType.OBSERVED_PROPERTY;
            }
            case "observation": 
            case "observations": {
                return EntityType.OBSERVATION;
            }
            case "featureofinterest": 
            case "featuresofinterest": {
                return EntityType.FEATURE_OF_INTEREST;
            }
        }
        return null;
    }

    private void createEntities() {
        try {
            String urlParameters = "{\n    \"name\": \"thing 1\",\n    \"description\": \"thing 1\",\n    \"properties\": {\n        \"reference\": \"first\"\n    },\n    \"Locations\": [\n        {\n            \"name\": \"location 1\",\n            \"description\": \"location 1\",\n            \"location\": {\n                \"type\": \"Point\",\n                \"coordinates\": [\n                    -117.05,\n                    51.05\n                ]\n            },\n            \"encodingType\": \"application/vnd.geo+json\"\n        }\n    ],\n    \"Datastreams\": [\n        {\n            \"unitOfMeasurement\": {\n                \"name\": \"Lumen\",\n                \"symbol\": \"lm\",\n                \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/unit/Instances.html/Lumen\"\n            },\n            \"name\": \"datastream 1\",\n            \"description\": \"datastream 1\",\n            \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n            \"ObservedProperty\": {\n                \"name\": \"Luminous Flux\",\n                \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html/LuminousFlux\",\n                \"description\": \"observedProperty 1\"\n            },\n            \"Sensor\": {\n                \"name\": \"sensor 1\",\n                \"description\": \"sensor 1\",\n                \"encodingType\": \"application/pdf\",\n                \"metadata\": \"Light flux sensor\"\n            }\n        },\n        {\n            \"unitOfMeasurement\": {\n                \"name\": \"Centigrade\",\n                \"symbol\": \"C\",\n                \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/unit/Instances.html/Lumen\"\n            },\n            \"name\": \"datastream 2\",\n            \"description\": \"datastream 2\",\n            \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n            \"ObservedProperty\": {\n                \"name\": \"Tempretaure\",\n                \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html/Tempreture\",\n                \"description\": \"observedProperty 2\"\n            },\n            \"Sensor\": {\n                \"name\": \"sensor 2\",\n                \"description\": \"sensor 2\",\n                \"encodingType\": \"application/pdf\",\n                \"metadata\": \"Tempreture sensor\"\n            }\n        }\n    ]\n}";
            String urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.THING, -1L, null, null);
            Map<String, Object> responseMap = HTTPMethods.doPost(urlString, urlParameters);
            String response = responseMap.get("response").toString();
            this.thingId1 = Long.parseLong(response.substring(response.indexOf("(") + 1, response.indexOf(")")));
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.THING, this.thingId1, EntityType.LOCATION, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            JSONArray array = new JSONObject(response).getJSONArray("value");
            this.locationId1 = array.getJSONObject(0).getLong("@iot.id");
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.THING, this.thingId1, EntityType.DATASTREAM, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            array = new JSONObject(response).getJSONArray("value");
            this.datastreamId1 = array.getJSONObject(0).getLong("@iot.id");
            this.datastreamId2 = array.getJSONObject(1).getLong("@iot.id");
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.DATASTREAM, this.datastreamId1, EntityType.SENSOR, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            this.sensorId1 = new JSONObject(response).getLong("@iot.id");
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.DATASTREAM, this.datastreamId1, EntityType.OBSERVED_PROPERTY, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            this.observedPropertyId1 = new JSONObject(response).getLong("@iot.id");
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.DATASTREAM, this.datastreamId2, EntityType.SENSOR, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            this.sensorId2 = new JSONObject(response).getLong("@iot.id");
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.DATASTREAM, this.datastreamId1, EntityType.OBSERVED_PROPERTY, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            this.observedPropertyId2 = new JSONObject(response).getLong("@iot.id");
            urlParameters = "{\n    \"name\": \"thing 2\",\n    \"description\": \"thing 2\",\n    \"properties\": {\n        \"reference\": \"second\"\n    },\n    \"Locations\": [\n        {\n            \"name\": \"location 2\",\n            \"description\": \"location 2\",\n            \"location\": {\n                \"type\": \"Point\",\n                \"coordinates\": [\n                    -100.05,\n                    50.05\n                ]\n            },\n            \"encodingType\": \"application/vnd.geo+json\"\n        }\n    ],\n    \"Datastreams\": [\n        {\n            \"unitOfMeasurement\": {\n                \"name\": \"Lumen\",\n                \"symbol\": \"lm\",\n                \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/unit/Instances.html/Lumen\"\n            },\n            \"name\": \"datastream 3\",\n            \"description\": \"datastream 3\",\n            \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n            \"ObservedProperty\": {\n                \"name\": \"Second Luminous Flux\",\n                \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/quantity/Instances.html/LuminousFlux\",\n                \"description\": \"observedProperty 3\"\n            },\n            \"Sensor\": {\n                \"name\": \"sensor 3\",\n                \"description\": \"sensor 3\",\n                \"encodingType\": \"application/pdf\",\n                \"metadata\": \"Second Light flux sensor\"\n            }\n        },\n        {\n            \"unitOfMeasurement\": {\n                \"name\": \"Centigrade\",\n                \"symbol\": \"C\",\n                \"definition\": \"http://www.qudt.org/qudt/owl/1.0.0/unit/Instances.html/Lumen\"\n            },\n            \"name\": \"datastream 2\",\n            \"description\": \"datastream 2\",\n            \"observationType\": \"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement\",\n            \"ObservedProperty\": {\n                \"@iot.id\": " + this.observedPropertyId2 + "\n" + "            },\n" + "            \"Sensor\": {\n" + "                \"name\": \"sensor 4 \",\n" + "                \"description\": \"sensor 4 \",\n" + "                \"encodingType\": \"application/pdf\",\n" + "                \"metadata\": \"Second Tempreture sensor\"\n" + "            }\n" + "        }\n" + "    ]\n" + "}";
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.THING, -1L, null, null);
            responseMap = HTTPMethods.doPost(urlString, urlParameters);
            response = responseMap.get("response").toString();
            this.thingId2 = Long.parseLong(response.substring(response.indexOf("(") + 1, response.indexOf(")")));
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.THING, this.thingId2, EntityType.LOCATION, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            array = new JSONObject(response).getJSONArray("value");
            this.locationId2 = array.getJSONObject(0).getLong("@iot.id");
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.THING, this.thingId2, EntityType.DATASTREAM, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            array = new JSONObject(response).getJSONArray("value");
            this.datastreamId3 = array.getJSONObject(0).getLong("@iot.id");
            this.datastreamId4 = array.getJSONObject(1).getLong("@iot.id");
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.DATASTREAM, this.datastreamId3, EntityType.SENSOR, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            this.sensorId3 = new JSONObject(response).getLong("@iot.id");
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.DATASTREAM, this.datastreamId3, EntityType.OBSERVED_PROPERTY, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            this.observedPropertyId3 = new JSONObject(response).getLong("@iot.id");
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.DATASTREAM, this.datastreamId4, EntityType.SENSOR, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            this.sensorId4 = new JSONObject(response).getLong("@iot.id");
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.THING, this.thingId1, null, null);
            urlParameters = "{\"Locations\": [\n    {\n      \"@iot.id\": " + this.locationId2 + "\n" + "    }\n" + "  ]}";
            HTTPMethods.doPatch(urlString, urlParameters);
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.THING, this.thingId2, null, null);
            urlParameters = "{\"Locations\": [\n    {\n      \"@iot.id\": " + this.locationId1 + "\n" + "    }\n" + "  ]}";
            HTTPMethods.doPatch(urlString, urlParameters);
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.THING, this.thingId1, EntityType.HISTORICAL_LOCATION, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            array = new JSONObject(response).getJSONArray("value");
            this.historicalLocationId1 = array.getJSONObject(0).getLong("@iot.id");
            this.historicalLocationId2 = array.getJSONObject(1).getLong("@iot.id");
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.THING, this.thingId2, EntityType.HISTORICAL_LOCATION, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            array = new JSONObject(response).getJSONArray("value");
            this.historicalLocationId3 = array.getJSONObject(0).getLong("@iot.id");
            this.historicalLocationId4 = array.getJSONObject(1).getLong("@iot.id");
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.DATASTREAM, this.datastreamId1, EntityType.OBSERVATION, null);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-01T00:00:00Z\",\n  \"result\": 1 \n   }";
            responseMap = HTTPMethods.doPost(urlString, urlParameters);
            response = responseMap.get("response").toString();
            this.observationId1 = Long.parseLong(response.substring(response.lastIndexOf("(") + 1, response.lastIndexOf(")")));
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-02T00:00:00Z\",\n  \"result\": 2 \n   }";
            responseMap = HTTPMethods.doPost(urlString, urlParameters);
            response = responseMap.get("response").toString();
            this.observationId2 = Long.parseLong(response.substring(response.lastIndexOf("(") + 1, response.lastIndexOf(")")));
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-03T00:00:00Z\",\n  \"result\": 3 \n   }";
            responseMap = HTTPMethods.doPost(urlString, urlParameters);
            response = responseMap.get("response").toString();
            this.observationId3 = Long.parseLong(response.substring(response.lastIndexOf("(") + 1, response.lastIndexOf(")")));
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.DATASTREAM, this.datastreamId2, EntityType.OBSERVATION, null);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-04T00:00:00Z\",\n  \"result\": 4 \n   }";
            responseMap = HTTPMethods.doPost(urlString, urlParameters);
            response = responseMap.get("response").toString();
            this.observationId4 = Long.parseLong(response.substring(response.lastIndexOf("(") + 1, response.lastIndexOf(")")));
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-05T00:00:00Z\",\n  \"result\": 5 \n   }";
            responseMap = HTTPMethods.doPost(urlString, urlParameters);
            response = responseMap.get("response").toString();
            this.observationId5 = Long.parseLong(response.substring(response.lastIndexOf("(") + 1, response.lastIndexOf(")")));
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-06T00:00:00Z\",\n  \"result\": 6 \n   }";
            responseMap = HTTPMethods.doPost(urlString, urlParameters);
            response = responseMap.get("response").toString();
            this.observationId6 = Long.parseLong(response.substring(response.lastIndexOf("(") + 1, response.lastIndexOf(")")));
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.DATASTREAM, this.datastreamId3, EntityType.OBSERVATION, null);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-07T00:00:00Z\",\n  \"result\": 7 \n   }";
            responseMap = HTTPMethods.doPost(urlString, urlParameters);
            response = responseMap.get("response").toString();
            this.observationId7 = Long.parseLong(response.substring(response.lastIndexOf("(") + 1, response.lastIndexOf(")")));
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-08T00:00:00Z\",\n  \"result\": 8 \n   }";
            responseMap = HTTPMethods.doPost(urlString, urlParameters);
            response = responseMap.get("response").toString();
            this.observationId8 = Long.parseLong(response.substring(response.lastIndexOf("(") + 1, response.lastIndexOf(")")));
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-09T00:00:00Z\",\n  \"result\": 9 \n   }";
            responseMap = HTTPMethods.doPost(urlString, urlParameters);
            response = responseMap.get("response").toString();
            this.observationId9 = Long.parseLong(response.substring(response.lastIndexOf("(") + 1, response.lastIndexOf(")")));
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.DATASTREAM, this.datastreamId4, EntityType.OBSERVATION, null);
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-10T00:00:00Z\",\n  \"result\": 10 \n   }";
            responseMap = HTTPMethods.doPost(urlString, urlParameters);
            response = responseMap.get("response").toString();
            this.observationId10 = Long.parseLong(response.substring(response.lastIndexOf("(") + 1, response.lastIndexOf(")")));
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-11T00:00:00Z\",\n  \"result\": 11 \n   }";
            responseMap = HTTPMethods.doPost(urlString, urlParameters);
            response = responseMap.get("response").toString();
            this.observationId11 = Long.parseLong(response.substring(response.lastIndexOf("(") + 1, response.lastIndexOf(")")));
            urlParameters = "{\n  \"phenomenonTime\": \"2015-03-12T00:00:00Z\",\n  \"result\": 12 \n   }";
            responseMap = HTTPMethods.doPost(urlString, urlParameters);
            response = responseMap.get("response").toString();
            this.observationId12 = Long.parseLong(response.substring(response.lastIndexOf("(") + 1, response.lastIndexOf(")")));
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.OBSERVATION, this.observationId1, EntityType.FEATURE_OF_INTEREST, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            this.featureOfInterestId1 = new JSONObject(response).getLong("@iot.id");
            urlString = ServiceURLBuilder.buildURLString(this.rootUri, EntityType.OBSERVATION, this.observationId7, EntityType.FEATURE_OF_INTEREST, null);
            responseMap = HTTPMethods.doGet(urlString);
            response = responseMap.get("response").toString();
            this.featureOfInterestId2 = new JSONObject(response).getLong("@iot.id");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
        }
    }

    private boolean listContainsString(List<String> list, String entity) {
        for (String item : list) {
            if (!item.toLowerCase().contains(entity.toLowerCase()) || entity.toLowerCase().equals("locations") && (item.toLowerCase().equals("historicallocations/thing") || item.toLowerCase().equals("historicallocations") || item.toLowerCase().equals("things/historicallocations") || item.toLowerCase().equals("thing/historicallocations")) || !entity.contains("/") && item.contains("/" + entity)) continue;
            return true;
        }
        return false;
    }

    @AfterClass
    public void deleteEverythings() {
        this.deleteEntityType(EntityType.OBSERVATION);
        this.deleteEntityType(EntityType.FEATURE_OF_INTEREST);
        this.deleteEntityType(EntityType.DATASTREAM);
        this.deleteEntityType(EntityType.SENSOR);
        this.deleteEntityType(EntityType.OBSERVED_PROPERTY);
        this.deleteEntityType(EntityType.HISTORICAL_LOCATION);
        this.deleteEntityType(EntityType.LOCATION);
        this.deleteEntityType(EntityType.THING);
    }

    private void deleteEntityType(EntityType entityType) {
        JSONArray array = null;
        do {
            try {
                String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, -1L, null, null);
                Map<String, Object> responseMap = HTTPMethods.doGet(urlString);
                int responseCode = Integer.parseInt(responseMap.get("response-code").toString());
                JSONObject result = new JSONObject(responseMap.get("response").toString());
                array = result.getJSONArray("value");
                for (int i = 0; i < array.length(); ++i) {
                    long id = array.getJSONObject(i).getLong("@iot.id");
                    this.deleteEntity(entityType, id);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
                Assert.fail((String)("An Exception occurred during testing!:\n" + e.getMessage()));
            }
        } while (array.length() > 0);
    }

    private void deleteEntity(EntityType entityType, long id) {
        String urlString = ServiceURLBuilder.buildURLString(this.rootUri, entityType, id, null, null);
        Map<String, Object> responseMap = HTTPMethods.doDelete(urlString);
        int responseCode = Integer.parseInt(responseMap.get("response-code").toString());
        Assert.assertEquals((int)responseCode, (int)200, (String)("DELETE does not work properly for " + (Object)((Object)entityType) + " with id " + id + ". Returned with response code " + responseCode + "."));
        responseMap = HTTPMethods.doGet(urlString);
        responseCode = Integer.parseInt(responseMap.get("response-code").toString());
        Assert.assertEquals((int)responseCode, (int)404, (String)("Deleted entity was not actually deleted : " + (Object)((Object)entityType) + "(" + id + ")."));
    }
}

