/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.spi.executors.testng;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class PrimarySuiteListener
implements ISuiteListener {
    private static final Logger LOGR = Logger.getLogger(PrimarySuiteListener.class.getName());
    private Document testRunArgs;

    PrimarySuiteListener(Document testRunArgs) {
        LOGR.log(Level.FINE, "Initializing PrimarySuiteListener...");
        if (null == testRunArgs) {
            LOGR.log(Level.WARNING, "Test run input document is null");
            throw new NullPointerException("Test run input document is null");
        }
        NodeList entries = testRunArgs.getElementsByTagName("entry");
        if (entries.getLength() == 0) {
            throw new IllegalArgumentException(String.format("No test run arguments found in %s", testRunArgs.getDocumentElement().getNodeName()));
        }
        this.testRunArgs = testRunArgs;
    }

    @Override
    public void onStart(ISuite suite) {
        LOGR.log(Level.FINE, "Entering PrimarySuiteListener::onStart...");
        Map<String, String> params = suite.getXmlSuite().getParameters();
        NodeList entries = this.testRunArgs.getElementsByTagName("entry");
        for (int i = 0; i < entries.getLength(); ++i) {
            Element entry = (Element)entries.item(i);
            String value = entry.getTextContent().trim();
            if (value.isEmpty()) continue;
            params.put(entry.getAttribute("key"), value);
            LOGR.log(Level.FINE, "Added parameter: {0}={1}", new Object[]{entry.getAttribute("key"), value});
        }
    }

    @Override
    public void onFinish(ISuite suite) {
    }
}

