/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.spi.jaxrs.resources;

import com.occamlab.te.spi.jaxrs.ErrorResponseBuilder;
import com.occamlab.te.spi.jaxrs.TestSuiteController;
import com.occamlab.te.spi.jaxrs.TestSuiteRegistry;
import com.sun.jersey.multipart.FormDataParam;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="suites/{etsCode}/{etsVersion}/run")
@Produces(value={"application/xml; charset='utf-8'"})
public class TestRunResource {
    private static final Logger LOGR = Logger.getLogger(TestRunResource.class.getPackage().getName());
    @Context
    private UriInfo reqUriInfo;
    @Context
    private HttpHeaders headers;

    @GET
    public Source handleGet(@PathParam(value="etsCode") String etsCode, @PathParam(value="etsVersion") String etsVersion) {
        MultivaluedMap<String, String> params = this.reqUriInfo.getQueryParameters();
        if (LOGR.isLoggable(Level.FINE)) {
            StringBuilder msg = new StringBuilder("Test run arguments - ");
            msg.append(etsCode).append("/").append(etsVersion).append("\n");
            msg.append(params.toString());
            LOGR.fine(msg.toString());
        }
        Source results = this.executeTestRun(etsCode, etsVersion, params);
        return results;
    }

    @POST
    @Consumes(value={"application/xml", "text/xml"})
    public Source handlePost(@PathParam(value="etsCode") String etsCode, @PathParam(value="etsVersion") String etsVersion, File entityBody) {
        if (!entityBody.exists() || entityBody.length() == 0L) {
            throw new WebApplicationException(400);
        }
        if (LOGR.isLoggable(Level.FINE)) {
            StringBuilder msg = new StringBuilder("Test run arguments - ");
            msg.append(etsCode).append("/").append(etsVersion).append("\n");
            msg.append("Entity media type: " + this.headers.getMediaType());
            msg.append("File location: " + entityBody.getAbsolutePath());
            LOGR.fine(msg.toString());
        }
        HashMap<String, List<String>> args = new HashMap<String, List<String>>();
        args.put("iut", Arrays.asList(entityBody.toURI().toString()));
        Source results = this.executeTestRun(etsCode, etsVersion, args);
        return results;
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public Source handleMultipartFormData(@PathParam(value="etsCode") String etsCode, @PathParam(value="etsVersion") String etsVersion, @FormDataParam(value="iut") File entityBody, @FormDataParam(value="sch") File schBody) {
        StringBuilder msg;
        HashMap<String, List<String>> args = new HashMap<String, List<String>>();
        if (!entityBody.exists() || entityBody.length() == 0L) {
            throw new WebApplicationException(400);
        }
        if (LOGR.isLoggable(Level.FINE)) {
            msg = new StringBuilder("Test run arguments - ");
            msg.append(etsCode).append("/").append(etsVersion).append("\n");
            msg.append("Entity media type: " + this.headers.getMediaType());
            msg.append("File location: " + entityBody.getAbsolutePath());
            LOGR.fine(msg.toString());
        }
        args.put("iut", Arrays.asList(entityBody.toURI().toString()));
        if (null != schBody) {
            if (!schBody.exists() || schBody.length() == 0L) {
                throw new WebApplicationException(400);
            }
            if (LOGR.isLoggable(Level.FINE)) {
                msg = new StringBuilder("Test run arguments - ");
                msg.append(etsCode).append("/").append(etsVersion).append("\n");
                msg.append("Entity media type: " + this.headers.getMediaType());
                msg.append("File location: " + schBody.getAbsolutePath());
                LOGR.fine(msg.toString());
            }
            args.put("sch", Arrays.asList(schBody.toURI().toString()));
        }
        Source results = this.executeTestRun(etsCode, etsVersion, args);
        return results;
    }

    Source executeTestRun(String etsCode, String etsVersion, Map<String, List<String>> testRunArgs) {
        TestSuiteController controller = this.findController(etsCode, etsVersion);
        Document xmlArgs = this.readTestRunArguments(testRunArgs);
        Source testResults = null;
        try {
            testResults = controller.doTestRun(xmlArgs);
        }
        catch (IllegalArgumentException iae) {
            ErrorResponseBuilder builder = new ErrorResponseBuilder();
            Response rsp = builder.buildErrorResponse(400, iae.getMessage());
            throw new WebApplicationException(rsp);
        }
        catch (Exception ex) {
            LOGR.log(Level.WARNING, ex.getMessage(), ex);
            ErrorResponseBuilder builder = new ErrorResponseBuilder();
            Response rsp = builder.buildErrorResponse(500, String.format("Error executing test suite (%s-%s)", etsCode, etsVersion));
            throw new WebApplicationException(rsp);
        }
        return testResults;
    }

    TestSuiteController findController(String code, String version) throws WebApplicationException {
        TestSuiteRegistry registry = TestSuiteRegistry.getInstance();
        TestSuiteController controller = registry.getController(code, version);
        if (null == controller) {
            throw new WebApplicationException(404);
        }
        return controller;
    }

    Document readTestRunArguments(Map<String, List<String>> requestParams) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document propsDoc = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            propsDoc = db.newDocument();
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(TestRunResource.class.getName()).log(Level.SEVERE, null, ex);
        }
        Element docElem = propsDoc.createElement("properties");
        docElem.setAttribute("version", "1.0");
        for (Map.Entry<String, List<String>> param : requestParams.entrySet()) {
            Element entry = propsDoc.createElement("entry");
            entry.setAttribute("key", param.getKey());
            StringBuilder values = new StringBuilder();
            Iterator<String> itr = param.getValue().iterator();
            while (itr.hasNext()) {
                values.append(itr.next());
                if (!itr.hasNext()) continue;
                values.append(",");
            }
            entry.setTextContent(values.toString());
            docElem.appendChild(entry);
        }
        propsDoc.appendChild(docElem);
        return propsDoc;
    }
}

