/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.sta10.util;

import java.util.List;
import org.opengis.cite.sta10.util.EntityType;
import org.testng.Assert;

public class ServiceURLBuilder {
    public static String buildURLString(String rootURI, EntityType parentEntityType, long parentId, EntityType relationEntityType, String property) {
        String urlString = rootURI;
        if (relationEntityType == null) {
            switch (parentEntityType) {
                case THING: {
                    urlString = urlString + "/Things";
                    break;
                }
                case LOCATION: {
                    urlString = urlString + "/Locations";
                    break;
                }
                case HISTORICAL_LOCATION: {
                    urlString = urlString + "/HistoricalLocations";
                    break;
                }
                case DATASTREAM: {
                    urlString = urlString + "/Datastreams";
                    break;
                }
                case SENSOR: {
                    urlString = urlString + "/Sensors";
                    break;
                }
                case OBSERVATION: {
                    urlString = urlString + "/Observations";
                    break;
                }
                case OBSERVED_PROPERTY: {
                    urlString = urlString + "/ObservedProperties";
                    break;
                }
                case FEATURE_OF_INTEREST: {
                    urlString = urlString + "/FeaturesOfInterest";
                    break;
                }
                default: {
                    Assert.fail("Entity type is not recognized in SensorThings API : " + (Object)((Object)parentEntityType));
                    return null;
                }
            }
            if (parentId != -1L) {
                urlString = urlString + "(" + parentId + ")";
            }
        } else {
            block10 : switch (parentEntityType) {
                case THING: {
                    urlString = urlString + "/Things(" + parentId + ")";
                    switch (relationEntityType) {
                        case LOCATION: {
                            urlString = urlString + "/Locations";
                            break block10;
                        }
                        case HISTORICAL_LOCATION: {
                            urlString = urlString + "/HistoricalLocations";
                            break block10;
                        }
                        case DATASTREAM: {
                            urlString = urlString + "/Datastreams";
                            break block10;
                        }
                    }
                    Assert.fail("Entity type relation is not recognized in SensorThings API : " + (Object)((Object)parentEntityType) + " and " + (Object)((Object)relationEntityType));
                    break;
                }
                case LOCATION: {
                    urlString = urlString + "/Locations(" + parentId + ")";
                    switch (relationEntityType) {
                        case THING: {
                            urlString = urlString + "/Things";
                            break block10;
                        }
                        case HISTORICAL_LOCATION: {
                            urlString = urlString + "/HistoricalLocations";
                            break block10;
                        }
                    }
                    Assert.fail("Entity type relation is not recognized in SensorThings API : " + (Object)((Object)parentEntityType) + " and " + (Object)((Object)relationEntityType));
                    break;
                }
                case HISTORICAL_LOCATION: {
                    urlString = urlString + "/HistoricalLocations(" + parentId + ")";
                    switch (relationEntityType) {
                        case THING: {
                            urlString = urlString + "/Thing";
                            break block10;
                        }
                        case LOCATION: {
                            urlString = urlString + "/Locations";
                            break block10;
                        }
                    }
                    Assert.fail("Entity type relation is not recognized in SensorThings API : " + (Object)((Object)parentEntityType) + " and " + (Object)((Object)relationEntityType));
                    break;
                }
                case DATASTREAM: {
                    urlString = urlString + "/Datastreams(" + parentId + ")";
                    switch (relationEntityType) {
                        case THING: {
                            urlString = urlString + "/Thing";
                            break block10;
                        }
                        case SENSOR: {
                            urlString = urlString + "/Sensor";
                            break block10;
                        }
                        case OBSERVATION: {
                            urlString = urlString + "/Observations";
                            break block10;
                        }
                        case OBSERVED_PROPERTY: {
                            urlString = urlString + "/ObservedProperty";
                            break block10;
                        }
                    }
                    Assert.fail("Entity type relation is not recognized in SensorThings API : " + (Object)((Object)parentEntityType) + " and " + (Object)((Object)relationEntityType));
                    break;
                }
                case SENSOR: {
                    urlString = urlString + "/Sensors(" + parentId + ")";
                    switch (relationEntityType) {
                        case DATASTREAM: {
                            urlString = urlString + "/Datastreams";
                            break block10;
                        }
                    }
                    Assert.fail("Entity type relation is not recognized in SensorThings API : " + (Object)((Object)parentEntityType) + " and " + (Object)((Object)relationEntityType));
                    break;
                }
                case OBSERVATION: {
                    urlString = urlString + "/Observations(" + parentId + ")";
                    switch (relationEntityType) {
                        case THING: 
                        case DATASTREAM: {
                            urlString = urlString + "/Datastream";
                            break block10;
                        }
                        case FEATURE_OF_INTEREST: {
                            urlString = urlString + "/FeatureOfInterest";
                            break block10;
                        }
                    }
                    Assert.fail("Entity type relation is not recognized in SensorThings API : " + (Object)((Object)parentEntityType) + " and " + (Object)((Object)relationEntityType));
                    break;
                }
                case OBSERVED_PROPERTY: {
                    urlString = urlString + "/ObservedProperties(" + parentId + ")";
                    switch (relationEntityType) {
                        case DATASTREAM: {
                            urlString = urlString + "/Datastreams";
                            break block10;
                        }
                    }
                    Assert.fail("Entity type relation is not recognized in SensorThings API : " + (Object)((Object)parentEntityType) + " and " + (Object)((Object)relationEntityType));
                    break;
                }
                case FEATURE_OF_INTEREST: {
                    urlString = urlString + "/FeaturesOfInterest(" + parentId + ")";
                    switch (relationEntityType) {
                        case OBSERVATION: {
                            urlString = urlString + "/Observations";
                            break block10;
                        }
                    }
                    Assert.fail("Entity type relation is not recognized in SensorThings API : " + (Object)((Object)parentEntityType) + " and " + (Object)((Object)relationEntityType));
                    break;
                }
                default: {
                    Assert.fail("Entity type is not recognized in SensorThings API : " + (Object)((Object)parentEntityType));
                }
            }
        }
        if (property != null) {
            urlString = property.indexOf(63) >= 0 ? urlString + property : urlString + "/" + property;
        }
        return urlString;
    }

    public static String buildURLString(String rootURI, List<String> entityTypes, List<Long> ids, String property) {
        String urlString = rootURI;
        if (entityTypes.size() != ids.size() && entityTypes.size() != ids.size() + 1) {
            Assert.fail("There is problem with the path of entities!!!");
        }
        if (urlString.charAt(urlString.length() - 1) != '/') {
            urlString = urlString + '/';
        }
        for (int i = 0; i < entityTypes.size(); ++i) {
            urlString = urlString + entityTypes.get(i);
            if (i >= ids.size()) continue;
            urlString = urlString + "(" + ids.get(i) + ")/";
        }
        if (urlString.charAt(urlString.length() - 1) == '/') {
            urlString = urlString.substring(0, urlString.length() - 1);
        }
        if (property != null) {
            urlString = property.indexOf(63) >= 0 ? urlString + property : urlString + "/" + property;
        }
        return urlString;
    }
}

