/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.spi.executors.testng;

import com.occamlab.te.spi.executors.TestRunExecutor;
import com.occamlab.te.spi.executors.testng.PrimarySuiteListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.testng.TestNG;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TestNGExecutor
implements TestRunExecutor {
    private static final Logger LOGR = Logger.getLogger(TestNGExecutor.class.getPackage().getName());
    private boolean useDefaultListeners;
    private File outputDir;
    private URI testngConfig;

    public TestNGExecutor(String testngSuite) {
        this(testngSuite, System.getProperty("java.io.tmpdir"), false);
    }

    public TestNGExecutor(String testngSuite, String outputDirPath, boolean useDefaultListeners) {
        this.useDefaultListeners = useDefaultListeners;
        this.outputDir = new File(outputDirPath, "testng");
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            this.outputDir = new File(System.getProperty("java.io.tmpdir"));
        }
        if (null != testngSuite && !testngSuite.isEmpty()) {
            this.testngConfig = URI.create(testngSuite);
        }
    }

    @Override
    public Source execute(Document testRunArgs) {
        if (null == testRunArgs) {
            throw new IllegalArgumentException("No test run arguments were supplied.");
        }
        TestNG driver = new TestNG();
        this.setTestSuites(driver, this.testngConfig);
        driver.setVerbose(0);
        driver.setUseDefaultListeners(this.useDefaultListeners);
        UUID runId = UUID.randomUUID();
        File runDir = new File(this.outputDir, runId.toString());
        if (!runDir.mkdir()) {
            runDir = this.outputDir;
        }
        driver.setOutputDirectory(runDir.getAbsolutePath());
        driver.addListener(new PrimarySuiteListener(testRunArgs));
        driver.run();
        Document resultsDoc = null;
        try {
            resultsDoc = this.parseResultsDoc(driver.getOutputDirectory());
        }
        catch (Exception ex) {
            LOGR.log(Level.SEVERE, "Failed to parse test results in " + driver.getOutputDirectory(), ex);
        }
        return new DOMSource(resultsDoc, resultsDoc.getDocumentURI());
    }

    Document parseResultsDoc(String outputDirectory) throws ParserConfigurationException, SAXException, IOException {
        File results = new File(outputDirectory, "testng-results.xml");
        if (!results.isFile()) {
            throw new FileNotFoundException("Test results not found");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document resultsDoc = db.parse(results);
        resultsDoc.setDocumentURI(results.getAbsolutePath());
        return resultsDoc;
    }

    private void setTestSuites(TestNG driver, URI ets) {
        if (ets.getScheme().equalsIgnoreCase("jar")) {
            String[] jarPath = ets.getSchemeSpecificPart().split("!");
            File jarFile = new File(URI.create(jarPath[0]));
            driver.setTestJar(jarFile.getAbsolutePath());
            driver.setXmlPathInJar(jarPath[1].substring(1));
        } else {
            ArrayList<String> testSuites = new ArrayList<String>();
            File tngFile = new File(ets);
            if (!tngFile.exists()) {
                throw new IllegalArgumentException("A valid TestNG config file reference is required.");
            }
            LOGR.log(Level.CONFIG, "Using TestNG config file {0}", tngFile.getAbsolutePath());
            testSuites.add(tngFile.getAbsolutePath());
            driver.setTestSuites(testSuites);
        }
    }
}

