/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.charcode;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Properties;
import net.sf.saxon.charcode.ASCIICharacterSet;
import net.sf.saxon.charcode.Big5CharacterSet;
import net.sf.saxon.charcode.BuggyCharacterSet;
import net.sf.saxon.charcode.CP1250CharacterSet;
import net.sf.saxon.charcode.CP1251CharacterSet;
import net.sf.saxon.charcode.CP1252CharacterSet;
import net.sf.saxon.charcode.CP852CharacterSet;
import net.sf.saxon.charcode.CharacterSet;
import net.sf.saxon.charcode.EucJPCharacterSet;
import net.sf.saxon.charcode.EucKRCharacterSet;
import net.sf.saxon.charcode.GB2312CharacterSet;
import net.sf.saxon.charcode.ISO88591CharacterSet;
import net.sf.saxon.charcode.ISO88592CharacterSet;
import net.sf.saxon.charcode.ISO88595CharacterSet;
import net.sf.saxon.charcode.ISO88597CharacterSet;
import net.sf.saxon.charcode.ISO88598CharacterSet;
import net.sf.saxon.charcode.ISO88599CharacterSet;
import net.sf.saxon.charcode.KOI8RCharacterSet;
import net.sf.saxon.charcode.PluggableCharacterSet;
import net.sf.saxon.charcode.ShiftJISCharacterSet;
import net.sf.saxon.charcode.UnicodeCharacterSet;
import net.sf.saxon.charcode.UnknownCharacterSet;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.trans.XPathException;

public class CharacterSetFactory {
    private CharacterSetFactory() {
    }

    public static CharacterSet getCharacterSet(Properties details, PipelineConfiguration pipe) throws XPathException {
        CharacterSet charSet;
        String encoding = details.getProperty("encoding");
        if (encoding == null) {
            encoding = "UTF8";
        }
        if (encoding.equalsIgnoreCase("UTF-8")) {
            encoding = "UTF8";
        }
        if ((charSet = CharacterSetFactory.makeCharacterSet(encoding, pipe)) == null) {
            XPathException err = new XPathException("Unknown encoding requested: " + encoding);
            err.setErrorCode("SESU0007");
            throw err;
        }
        return charSet;
    }

    private static CharacterSet makeCharacterSet(String encoding, PipelineConfiguration pipe) throws XPathException {
        String enc2 = encoding.replace('_', '-');
        switch (enc2.length()) {
            case 4: {
                if (enc2.equalsIgnoreCase("UTF8")) {
                    return UnicodeCharacterSet.getInstance();
                }
                if (enc2.equalsIgnoreCase("Big5")) {
                    return Big5CharacterSet.getInstance();
                }
                if (!enc2.equalsIgnoreCase("SJIS")) break;
                return ShiftJISCharacterSet.getInstance();
            }
            case 5: {
                if (enc2.equalsIgnoreCase("ASCII")) {
                    return ASCIICharacterSet.getInstance();
                }
                if (enc2.equalsIgnoreCase("UTF-8")) {
                    return UnicodeCharacterSet.getInstance();
                }
                if (enc2.equalsIgnoreCase("UTF16")) {
                    return UnicodeCharacterSet.getInstance();
                }
                if (!enc2.equalsIgnoreCase("cp852")) break;
                return CP852CharacterSet.getInstance();
            }
            case 6: {
                if (enc2.equalsIgnoreCase("iso646")) {
                    return ASCIICharacterSet.getInstance();
                }
                if (enc2.equalsIgnoreCase("UTF-16")) {
                    return UnicodeCharacterSet.getInstance();
                }
                if (enc2.equalsIgnoreCase("EUC-CN")) {
                    return GB2312CharacterSet.getInstance();
                }
                if (enc2.equalsIgnoreCase("GB2312")) {
                    return GB2312CharacterSet.getInstance();
                }
                if (enc2.equalsIgnoreCase("EUC-JP")) {
                    return EucJPCharacterSet.getInstance();
                }
                if (enc2.equalsIgnoreCase("EUC-KR")) {
                    return EucKRCharacterSet.getInstance();
                }
                if (enc2.equalsIgnoreCase("KOI8-R")) {
                    return KOI8RCharacterSet.getInstance();
                }
                if (enc2.equalsIgnoreCase("cp1251")) {
                    return CP1251CharacterSet.getInstance();
                }
                if (enc2.equalsIgnoreCase("cp1250")) {
                    return CP1250CharacterSet.getInstance();
                }
                if (!enc2.equalsIgnoreCase("cp1252")) break;
                return CP1252CharacterSet.getInstance();
            }
            case 7: {
                if (!enc2.equalsIgnoreCase("iso-646")) break;
                return ASCIICharacterSet.getInstance();
            }
            case 8: {
                if (!enc2.equalsIgnoreCase("US-ASCII")) break;
                return ASCIICharacterSet.getInstance();
            }
            case 9: {
                if (enc2.equalsIgnoreCase("Shift-JIS")) {
                    return ShiftJISCharacterSet.getInstance();
                }
                if (enc2.equalsIgnoreCase("ISO8859-1")) {
                    return ISO88591CharacterSet.getInstance();
                }
                if (enc2.equalsIgnoreCase("ISO8859-2")) {
                    return ISO88592CharacterSet.getInstance();
                }
                if (enc2.equalsIgnoreCase("ISO8859-5")) {
                    return ISO88595CharacterSet.getInstance();
                }
                if (enc2.equalsIgnoreCase("ISO8859-7")) {
                    return ISO88597CharacterSet.getInstance();
                }
                if (enc2.equalsIgnoreCase("ISO8859-8")) {
                    return ISO88598CharacterSet.getInstance();
                }
                if (!enc2.equalsIgnoreCase("ISO8859-9")) break;
                return ISO88599CharacterSet.getInstance();
            }
            case 10: {
                if (enc2.equalsIgnoreCase("iso-8859-1")) {
                    return ISO88591CharacterSet.getInstance();
                }
                if (enc2.equalsIgnoreCase("iso-8859-2")) {
                    return ISO88592CharacterSet.getInstance();
                }
                if (enc2.equalsIgnoreCase("iso-8859-5")) {
                    return ISO88595CharacterSet.getInstance();
                }
                if (enc2.equalsIgnoreCase("iso-8859-7")) {
                    return ISO88597CharacterSet.getInstance();
                }
                if (enc2.equalsIgnoreCase("iso-8859-8")) {
                    return ISO88598CharacterSet.getInstance();
                }
                if (enc2.equalsIgnoreCase("iso-8859-9")) {
                    return ISO88599CharacterSet.getInstance();
                }
            }
            case 11: {
                if (!enc2.equalsIgnoreCase("windows-852")) break;
                return CP852CharacterSet.getInstance();
            }
            case 12: {
                if (enc2.equalsIgnoreCase("windows-1251")) {
                    return CP1251CharacterSet.getInstance();
                }
                if (enc2.equalsIgnoreCase("windows-1250")) {
                    return CP1250CharacterSet.getInstance();
                }
                if (!enc2.equalsIgnoreCase("windows-1252")) break;
                return CP1252CharacterSet.getInstance();
            }
        }
        String csname = System.getProperty("encoding." + enc2);
        if (csname == null) {
            try {
                Charset charset = Charset.forName(encoding);
                CharacterSet res = UnknownCharacterSet.makeCharSet(charset);
                if (res.inCharset(511) && res.inCharset(768) && res.inCharset(2704) && res.inCharset(8704) && res.inCharset(13312)) {
                    res = BuggyCharacterSet.makeCharSet(charset);
                }
                return res;
            }
            catch (IllegalCharsetNameException err) {
                throw new XPathException("Invalid encoding name: " + encoding);
            }
            catch (UnsupportedCharsetException err) {
                return null;
            }
        }
        try {
            Object obj = pipe.getConfiguration().getInstance(csname, pipe.getController().getClassLoader());
            if (obj instanceof PluggableCharacterSet) {
                return (PluggableCharacterSet)obj;
            }
        }
        catch (Exception err) {
            throw new XPathException("Failed to load " + csname);
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        System.err.println("Available Character Sets in the java.nio package for this Java VM:");
        for (String s2 : Charset.availableCharsets().keySet()) {
            System.err.println(s2);
        }
    }
}

