/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.evpull.EmptyEventIterator;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventIteratorOverSequence;
import net.sf.saxon.evpull.SingletonEventIterator;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.EvaluableItem;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.SequenceIterable;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public abstract class Expression
implements SequenceIterable,
EvaluableItem,
Serializable,
InstructionInfoProvider,
SourceLocator {
    public static final int EVALUATE_METHOD = 1;
    public static final int ITERATE_METHOD = 2;
    public static final int PROCESS_METHOD = 4;
    protected int staticProperties = -1;
    protected int locationId = -1;
    private Container container;
    private int[] slotsUsed;

    public int getImplementationMethod() {
        if (Cardinality.allowsMany(this.getCardinality())) {
            return 2;
        }
        return 1;
    }

    public boolean implementsStaticTypeCheck() {
        return false;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        return this;
    }

    public Expression staticTypeCheck(SequenceType req, boolean backwardsCompatible, RoleLocator role, ExpressionVisitor visitor) throws XPathException {
        throw new UnsupportedOperationException("staticTypeCheck");
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        return this;
    }

    public Expression promote(PromotionOffer offer) throws XPathException {
        return this;
    }

    public final int getSpecialProperties() {
        if (this.staticProperties == -1) {
            this.computeStaticProperties();
        }
        return this.staticProperties & 0x1FF0000;
    }

    public int getCardinality() {
        if (this.staticProperties == -1) {
            this.computeStaticProperties();
        }
        return this.staticProperties & 0xE000;
    }

    public abstract ItemType getItemType(TypeHierarchy var1);

    public int getDependencies() {
        if (this.staticProperties == -1) {
            this.computeStaticProperties();
        }
        return this.staticProperties & 0x10003FF;
    }

    public Iterator iterateSubExpressions() {
        return Collections.EMPTY_LIST.iterator();
    }

    public boolean hasLoopingSubexpression(Expression child) {
        return false;
    }

    public Expression findParentOf(Expression leaf) {
        Iterator children = this.iterateSubExpressions();
        while (children.hasNext()) {
            Expression child = (Expression)children.next();
            if (child == leaf) {
                return this;
            }
            Expression target = child.findParentOf(leaf);
            if (target == null) continue;
            return target;
        }
        return null;
    }

    public void setFlattened(boolean flattened) {
    }

    public void setFiltered(boolean filtered) {
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        return this.iterate(context).next();
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        Item value = this.evaluateItem(context);
        return SingletonIterator.makeIterator(value);
    }

    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        int m4 = this.getImplementationMethod();
        if ((m4 & 1) != 0) {
            Item item = this.evaluateItem(context);
            if (item == null) {
                return EmptyEventIterator.getInstance();
            }
            return new SingletonEventIterator(item);
        }
        return new EventIteratorOverSequence(this.iterate(context));
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.iterate(context));
    }

    public CharSequence evaluateAsString(XPathContext context) throws XPathException {
        Item o = this.evaluateItem(context);
        StringValue value = (StringValue)o;
        if (value == null) {
            return "";
        }
        return value.getStringValue();
    }

    public void process(XPathContext context) throws XPathException {
        int m4 = this.getImplementationMethod();
        if ((m4 & 1) != 0) {
            Item item = this.evaluateItem(context);
            if (item != null) {
                context.getReceiver().append(item, this.locationId, 2);
            }
        } else if ((m4 & 2) != 0) {
            SequenceIterator iter = this.iterate(context);
            SequenceReceiver out = context.getReceiver();
            try {
                Item it;
                while ((it = iter.next()) != null) {
                    out.append(it, this.locationId, 2);
                }
            }
            catch (XPathException e) {
                e.maybeSetLocation(this);
                e.maybeSetContext(context);
                throw e;
            }
        } else {
            throw new AssertionError((Object)("process() is not implemented in the subclass " + this.getClass()));
        }
    }

    public String toString() {
        int dot;
        FastStringBuffer buff = new FastStringBuffer(120);
        String className = this.getClass().getName();
        while ((dot = className.indexOf(46)) >= 0) {
            className = className.substring(dot + 1);
        }
        buff.append(className);
        Iterator iter = this.iterateSubExpressions();
        boolean first = true;
        while (iter.hasNext()) {
            buff.append(first ? "(" : ", ");
            buff.append(iter.next().toString());
            first = false;
        }
        buff.append(")");
        return buff.toString();
    }

    public void display(int level, PrintStream out, Configuration config) {
        try {
            ExpressionPresenter ep = new ExpressionPresenter(config, ExpressionPresenter.defaultDestination(config, out));
            this.explain(ep);
        }
        catch (XPathException err) {
            // empty catch block
        }
    }

    public abstract void explain(ExpressionPresenter var1);

    public final void explain(OutputStream out) {
        ExpressionPresenter ep = new ExpressionPresenter(this.getExecutable().getConfiguration(), out);
        this.explain(ep);
        ep.close();
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
    }

    public void setContainer(Container container) {
        this.container = container;
        if (container != null) {
            Iterator children = this.iterateSubExpressions();
            while (children.hasNext()) {
                Expression child = (Expression)children.next();
                if (child == null || child.getContainer() == container) continue;
                child.setContainer(container);
            }
        }
    }

    public Container getContainer() {
        return this.container;
    }

    public void adoptChildExpression(Expression child) {
        if (child == null) {
            return;
        }
        if (this.container == null) {
            this.container = child.container;
        } else {
            child.setContainer(this.container);
        }
        if (this.locationId == -1) {
            ExpressionTool.copyLocationInfo(child, this);
        } else if (child.locationId == -1) {
            ExpressionTool.copyLocationInfo(this, child);
        }
        this.resetLocalStaticProperties();
    }

    public void setLocationId(int id) {
        this.locationId = id;
    }

    public final int getLocationId() {
        return this.locationId;
    }

    public int getLineNumber() {
        if (this.locationId == -1) {
            return -1;
        }
        return this.locationId & 0xFFFFF;
    }

    public int getColumnNumber() {
        return -1;
    }

    public String getSystemId() {
        if (this.locationId == -1) {
            return null;
        }
        Executable exec = this.getExecutable();
        if (exec == null) {
            return null;
        }
        LocationMap map = exec.getLocationMap();
        if (map == null) {
            return null;
        }
        return map.getSystemId(this.locationId);
    }

    public final String getPublicId() {
        return null;
    }

    public Executable getExecutable() {
        return this.getContainer().getExecutable();
    }

    public LocationProvider getLocationProvider() {
        Executable exec = this.getExecutable();
        if (exec != null) {
            return exec.getLocationMap();
        }
        return null;
    }

    public final Expression doPromotion(Expression subexpression, PromotionOffer offer) throws XPathException {
        Expression e = subexpression.promote(offer);
        if (e != subexpression) {
            this.adoptChildExpression(e);
        } else if (offer.accepted) {
            this.resetLocalStaticProperties();
        }
        return e;
    }

    public final void computeStaticProperties() {
        this.staticProperties = this.computeDependencies() | this.computeCardinality() | this.computeSpecialProperties();
    }

    protected final void resetLocalStaticProperties() {
        this.staticProperties = -1;
    }

    protected abstract int computeCardinality();

    protected int computeSpecialProperties() {
        return 0;
    }

    public int computeDependencies() {
        int dependencies = this.getIntrinsicDependencies();
        Iterator children = this.iterateSubExpressions();
        while (children.hasNext()) {
            dependencies |= ((Expression)children.next()).getDependencies();
        }
        return dependencies;
    }

    public int getIntrinsicDependencies() {
        return 0;
    }

    public abstract Expression copy();

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        throw new IllegalArgumentException("Invalid replacement");
    }

    public void suppressValidation(int validationMode) {
    }

    public int markTailFunctionCalls(StructuredQName qName, int arity) {
        return 0;
    }

    public synchronized int[] getSlotsUsed() {
        if (this.slotsUsed != null) {
            return this.slotsUsed;
        }
        IntHashSet slots = new IntHashSet(10);
        Expression.gatherSlotsUsed(this, slots);
        this.slotsUsed = new int[slots.size()];
        int i = 0;
        IntIterator iter = slots.iterator();
        while (iter.hasNext()) {
            this.slotsUsed[i++] = iter.next();
        }
        Arrays.sort(this.slotsUsed);
        return this.slotsUsed;
    }

    private static void gatherSlotsUsed(Expression exp, IntHashSet slots) {
        if (exp instanceof VariableReference) {
            int slot;
            Binding binding = ((VariableReference)exp).getBinding();
            if (binding == null) {
                throw new NullPointerException("Unbound variable at line " + exp.getLineNumber());
            }
            if (!binding.isGlobal() && (slot = binding.getLocalSlotNumber()) != -1 && !slots.contains(slot)) {
                slots.add(slot);
            }
        } else {
            Iterator iter = exp.iterateSubExpressions();
            while (iter.hasNext()) {
                Expression sub = (Expression)iter.next();
                Expression.gatherSlotsUsed(sub, slots);
            }
        }
    }

    protected void dynamicError(String message, String code, XPathContext context) throws XPathException {
        XPathException err = new XPathException(message, this);
        err.setXPathContext(context);
        err.setErrorCode(code);
        throw err;
    }

    protected void typeError(String message, String errorCode, XPathContext context) throws XPathException {
        XPathException e = new XPathException(message, this);
        e.setIsTypeError(true);
        e.setErrorCode(errorCode);
        e.setXPathContext(context);
        throw e;
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails details = new InstructionDetails();
        details.setConstructType(this.getConstructType());
        details.setProperty("expression", this);
        details.setSystemId(this.getSystemId());
        details.setLineNumber(this.getLineNumber());
        details.setColumnNumber(this.getColumnNumber());
        if (this instanceof Assignation) {
            details.setObjectName(((Assignation)this).getVariableQName());
        }
        return details;
    }

    protected int getConstructType() {
        return 2098;
    }

    public int getHostLanguage() {
        return this.getContainer().getHostLanguage();
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet attachmentPoint;
        boolean dependsOnFocus = (this.getDependencies() & 0x1E) != 0;
        TypeHierarchy th = this.getExecutable().getConfiguration().getTypeHierarchy();
        if (pathMapNodeSet == null) {
            if (dependsOnFocus) {
                ContextItemExpression cie = new ContextItemExpression();
                cie.setContainer(this.getContainer());
                pathMapNodeSet = new PathMap.PathMapNodeSet(pathMap.makeNewRoot(cie));
            }
            attachmentPoint = pathMapNodeSet;
        } else {
            attachmentPoint = dependsOnFocus ? pathMapNodeSet : null;
        }
        PathMap.PathMapNodeSet result = new PathMap.PathMapNodeSet();
        Iterator iter = this.iterateSubExpressions();
        while (iter.hasNext()) {
            Expression child = (Expression)iter.next();
            result.addNodeSet(child.addToPathMap(pathMap, attachmentPoint));
        }
        if (this.getItemType(th) instanceof AtomicType) {
            return null;
        }
        return result;
    }
}

