/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.Serializable;
import net.sf.saxon.event.LocationProvider;

public class LocationMap
implements LocationProvider,
Serializable {
    private String[] modules = new String[10];
    private int numberOfModules = 0;

    public int allocateLocationId(String module, int lineNumber) {
        if (module == null) {
            module = "*module with no systemId*";
        }
        int mod = -1;
        for (int m4 = this.numberOfModules - 1; m4 >= 0; --m4) {
            if (!this.modules[m4].equals(module)) continue;
            mod = m4;
            break;
        }
        if (mod == -1) {
            if (this.numberOfModules >= this.modules.length) {
                String[] m22 = new String[this.numberOfModules * 2];
                System.arraycopy(this.modules, 0, m22, 0, this.numberOfModules);
                this.modules = m22;
            }
            mod = this.numberOfModules;
            this.modules[this.numberOfModules++] = module;
        }
        if (mod >= 1024) {
            this.modules[mod] = "*unknown module*";
            mod = 1023;
        }
        if (lineNumber > 999999) {
            lineNumber = 999999;
        }
        return (mod << 20) + lineNumber;
    }

    public String getSystemId(long locationId) {
        int m4 = (int)locationId >> 20;
        if (m4 < 0 || m4 >= this.numberOfModules) {
            return null;
        }
        return this.modules[m4];
    }

    public int getLineNumber(long locationId) {
        return (int)locationId & 0xFFFFF;
    }
}

