/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.Chars;
import org.apache.jena.atlas.lib.EscapeStr;
import org.apache.jena.atlas.lib.InternalErrorException;

public class StrUtils {
    public static final int CMP_GREATER = 1;
    public static final int CMP_EQUAL = 0;
    public static final int CMP_LESS = -1;
    public static final int CMP_UNEQUAL = -9;
    public static final int CMP_INDETERMINATE = 2;

    private StrUtils() {
    }

    public static String strjoinNL(String ... args) {
        return String.join((CharSequence)"\n", args);
    }

    public static String strjoinNL(List<String> args) {
        return String.join((CharSequence)"\n", args);
    }

    public static <X> String strjoin(List<X> args, String sep) {
        return args.stream().map(obj -> obj.toString()).collect(Collectors.joining(sep));
    }

    public static int strCompare(String s1, String s2) {
        int x = s1.compareTo(s2);
        if (x < 0) {
            return -1;
        }
        if (x > 0) {
            return 1;
        }
        if (x == 0) {
            return 0;
        }
        throw new InternalErrorException("String comparison failure");
    }

    public static int strCompareIgnoreCase(String s1, String s2) {
        int x = s1.compareToIgnoreCase(s2);
        if (x < 0) {
            return -1;
        }
        if (x > 0) {
            return 1;
        }
        if (x == 0) {
            return 0;
        }
        throw new InternalErrorException("String comparison failure");
    }

    public static boolean strStartsWithIgnoreCase(String str, String prefix) {
        return str.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean strEndsWithIgnoreCase(String str, String suffix) {
        return str.regionMatches(true, str.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static byte[] asUTF8bytes(String s2) {
        return Bytes.asUTF8bytes(s2);
    }

    public static String fromUTF8bytes(byte[] bytes) {
        return Bytes.fromUTF8bytes(bytes);
    }

    public static String str(Object x) {
        return Objects.toString(x, "<null>");
    }

    public static String[] split(String s2, String splitStr) {
        return (String[])Arrays.stream(s2.split(splitStr)).map(String::trim).toArray(String[]::new);
    }

    public static final boolean contains(String str1, String str2) {
        return str1.contains(str2);
    }

    public static final String replace(String string, String target, String replacement) {
        return string.replace(target, replacement);
    }

    public static String substitute(String str, Map<String, String> subs) {
        for (Map.Entry<String, String> e : subs.entrySet()) {
            String param = e.getKey();
            if (!str.contains(param)) continue;
            str = str.replace(param, e.getValue());
        }
        return str;
    }

    public static String strform(Map<String, String> subs, String ... args) {
        return StrUtils.substitute(StrUtils.strjoinNL(args), subs);
    }

    public static String chop(String x) {
        return x.isEmpty() ? x : x.substring(0, x.length() - 1);
    }

    public static String noNewlineEnding(String x) {
        while (x.endsWith("\n") || x.endsWith("\r")) {
            x = StrUtils.chop(x);
        }
        return x;
    }

    public static List<Character> toCharList(String str) {
        return str.codePoints().mapToObj(i -> Character.valueOf((char)i)).map(Character::valueOf).collect(Collectors.toList());
    }

    public static String encodeHex(String str, char marker, char[] escapees) {
        char ch;
        int idx;
        int N2 = str.length();
        for (idx = 0; idx < N2 && !Chars.charInArray(ch = str.charAt(idx), escapees); ++idx) {
        }
        if (idx == N2) {
            return str;
        }
        StringBuilder buff = new StringBuilder();
        buff.append(str, 0, idx);
        while (idx < N2) {
            char ch2 = str.charAt(idx);
            if (Chars.charInArray(ch2, escapees)) {
                Chars.encodeAsHex(buff, marker, ch2);
            } else {
                buff.append(ch2);
            }
            ++idx;
        }
        return buff.toString();
    }

    public static String decodeHex(String str, char marker) {
        if (str.indexOf(marker) < 0) {
            return str;
        }
        byte[] strBytes = StrUtils.asUTF8bytes(str);
        int N2 = strBytes.length;
        byte[] bytes = new byte[strBytes.length];
        int i = 0;
        for (int j = 0; j < N2; ++j) {
            byte b = strBytes[j];
            if (b != marker) {
                bytes[i++] = b;
                continue;
            }
            if (j + 2 >= N2) {
                throw new AtlasException("Decoding error: incomplete hex value. \"" + str + "\"");
            }
            byte hi = strBytes[j + 1];
            byte lo = strBytes[j + 2];
            j += 2;
            int x1 = StrUtils.hexDecode(hi);
            int x2 = StrUtils.hexDecode(lo);
            int ch2 = StrUtils.hexDecode(hi) << 4 | StrUtils.hexDecode(lo);
            bytes[i++] = (byte)ch2;
        }
        String s2 = new String(bytes, 0, i, StandardCharsets.UTF_8);
        return s2;
    }

    private static String _forInfo_decodeHex(String str, char marker) {
        int idx = str.indexOf(marker);
        if (idx == -1) {
            return str;
        }
        StringBuilder buff = new StringBuilder();
        buff.append(str, 0, idx);
        int N2 = str.length();
        while (idx < N2) {
            char ch = str.charAt(idx);
            if (ch != marker) {
                buff.append(ch);
            } else {
                if (idx + 2 >= N2) {
                    throw new AtlasException("Decoding error: incomplete hex value. \"" + str + "\"");
                }
                char hi = str.charAt(idx + 1);
                char lo = str.charAt(idx + 2);
                char ch2 = (char)(StrUtils.hexDecode(hi) << 4 | StrUtils.hexDecode(lo));
                buff.append(ch2);
                idx += 2;
            }
            ++idx;
        }
        return buff.toString();
    }

    private static int hexDecode(int ch) {
        if (ch >= 48 && ch <= 57) {
            return ch - 48;
        }
        if (ch >= 65 && ch <= 70) {
            return ch - 65 + 10;
        }
        if (ch >= 97 && ch <= 102) {
            return ch - 97 + 10;
        }
        throw new AtlasException(String.format("Decoding error: bad character for hex digit (0x%02X) '%c' ", ch, ch));
    }

    public static String escapeString(String x) {
        return EscapeStr.stringEsc(x);
    }

    public static String unescapeString(String x) {
        return EscapeStr.unescapeStr(x);
    }
}

