/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.sta10;

import jakarta.ws.rs.client.Client;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.cite.sta10.SuiteAttribute;
import org.opengis.cite.sta10.TestRunArg;
import org.opengis.cite.sta10.util.ClientUtils;
import org.opengis.cite.sta10.util.TestSuiteLogger;
import org.testng.ISuite;
import org.testng.ISuiteListener;

public class SuiteFixtureListener
implements ISuiteListener {
    @Override
    public void onStart(ISuite suite) {
        this.processSuiteParameters(suite);
        this.registerClientComponent(suite);
    }

    @Override
    public void onFinish(ISuite suite) {
    }

    void processSuiteParameters(ISuite suite) {
        Map<String, String> params = suite.getXmlSuite().getParameters();
        TestSuiteLogger.log(Level.CONFIG, "Suite parameters\n" + params.toString());
        Integer level = new Integer(1);
        if (null != params.get(TestRunArg.ICS.toString())) {
            try {
                level = Integer.valueOf(params.get(TestRunArg.ICS.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        suite.setAttribute(SuiteAttribute.LEVEL.getName(), level);
        String iutParam = params.get(TestRunArg.IUT.toString());
        if (iutParam == null) {
            throw new IllegalArgumentException("No IUT specified.");
        }
        String response = this.checkServiceRootUri(iutParam);
        if (!response.equals("")) {
            throw new IllegalArgumentException(response);
        }
        suite.setAttribute(SuiteAttribute.TEST_SUBJECT.getName(), iutParam);
        if (TestSuiteLogger.isLoggable(Level.FINE)) {
            StringBuilder logMsg = new StringBuilder("Parsed resource retrieved from ");
            logMsg.append((Object)TestRunArg.IUT).append("\n");
            TestSuiteLogger.log(Level.FINE, logMsg.toString());
        }
    }

    void registerClientComponent(ISuite suite) {
        Client client = ClientUtils.buildClient();
        if (null != client) {
            suite.setAttribute(SuiteAttribute.CLIENT.getName(), client);
        }
    }

    private String checkServiceRootUri(String rootUri) {
        if ((rootUri = rootUri.trim()).lastIndexOf(47) == rootUri.length() - 1) {
            rootUri = rootUri.substring(0, rootUri.length() - 1);
        }
        HttpURLConnection connection = null;
        String response = null;
        URL url = null;
        try {
            String line;
            url = new URL(rootUri);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            InputStream is = connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            StringBuilder responseBuilder = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                responseBuilder.append(line);
                responseBuilder.append('\r');
            }
            response = responseBuilder.toString();
            rd.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return "The requested URL is not well formed: " + rootUri + ".";
        }
        catch (ProtocolException e) {
            e.printStackTrace();
            return "Unknown protocol in requested URL: " + rootUri + ".";
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Cannot connect to " + rootUri + ".";
        }
        JSONObject jsonResponse = null;
        JSONArray entities = null;
        try {
            jsonResponse = new JSONObject(response);
            entities = jsonResponse.getJSONArray("value");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "The service response for the root URI \"" + rootUri + "\" is not JSON.";
        }
        HashMap<String, Boolean> addedLinks = new HashMap<String, Boolean>();
        addedLinks.put("Things", false);
        addedLinks.put("Locations", false);
        addedLinks.put("HistoricalLocations", false);
        addedLinks.put("Datastreams", false);
        addedLinks.put("Sensors", false);
        addedLinks.put("Observations", false);
        addedLinks.put("ObservedProperties", false);
        addedLinks.put("FeaturesOfInterest", false);
        block31: for (int i = 0; i < entities.length(); ++i) {
            String nameUrl;
            String name;
            JSONObject entity = null;
            try {
                entity = entities.getJSONObject(i);
                if (!entity.has("name")) {
                    return "The name component of Service root URI response is not available.[ENTITY]: " + entity.toString();
                }
                if (!entity.has("url")) {
                    return "The name component of Service root URI response is not available. [ENTITY]: " + entity.toString();
                }
                name = entity.getString("name");
                nameUrl = entity.getString("url");
            }
            catch (JSONException e) {
                e.printStackTrace();
                return "The service response for the root URI \"" + rootUri + "\" is not JSON.";
            }
            switch (name) {
                case "Things": {
                    if (!nameUrl.equals(rootUri + "/Things")) {
                        return "The URL for Things in Service Root URI is not compliant to SensorThings API.";
                    }
                    addedLinks.remove("Things");
                    addedLinks.put(name, true);
                    continue block31;
                }
                case "Locations": {
                    if (!nameUrl.equals(rootUri + "/Locations")) {
                        return "The URL for Locations in Service Root URI is not compliant to SensorThings API.";
                    }
                    addedLinks.remove("Locations");
                    addedLinks.put(name, true);
                    continue block31;
                }
                case "HistoricalLocations": {
                    if (!nameUrl.equals(rootUri + "/HistoricalLocations")) {
                        return "The URL for HistoricalLocations in Service Root URI is not compliant to SensorThings API.";
                    }
                    addedLinks.remove("HistoricalLocations");
                    addedLinks.put(name, true);
                    continue block31;
                }
                case "Datastreams": {
                    if (!nameUrl.equals(rootUri + "/Datastreams")) {
                        return "The URL for Datastreams in Service Root URI is not compliant to SensorThings API.";
                    }
                    addedLinks.remove("Datastreams");
                    addedLinks.put(name, true);
                    continue block31;
                }
                case "Sensors": {
                    if (!nameUrl.equals(rootUri + "/Sensors")) {
                        return "The URL for Sensors in Service Root URI is not compliant to SensorThings API.";
                    }
                    addedLinks.remove("Sensors");
                    addedLinks.put(name, true);
                    continue block31;
                }
                case "Observations": {
                    if (!nameUrl.equals(rootUri + "/Observations")) {
                        return "The URL for Observations in Service Root URI is not compliant to SensorThings API.";
                    }
                    addedLinks.remove("Observations");
                    addedLinks.put(name, true);
                    continue block31;
                }
                case "ObservedProperties": {
                    if (!nameUrl.equals(rootUri + "/ObservedProperties")) {
                        return "The URL for ObservedProperties in Service Root URI is not compliant to SensorThings API.";
                    }
                    addedLinks.remove("ObservedProperties");
                    addedLinks.put(name, true);
                    continue block31;
                }
                case "FeaturesOfInterest": {
                    if (!nameUrl.equals(rootUri + "/FeaturesOfInterest")) {
                        return "The URL for FeaturesOfInterest in Service Root URI is not compliant to SensorThings API.";
                    }
                    addedLinks.remove("FeaturesOfInterest");
                    addedLinks.put(name, true);
                    continue block31;
                }
                case "MultiDatastreams": {
                    if (nameUrl.equals(rootUri + "/MultiDatastreams")) continue block31;
                    return "The URL for MultiDatastreams in Service Root URI is not compliant to SensorThings API.";
                }
                default: {
                    return "There is a component in Service Root URI response that is not in SensorThings API : " + name;
                }
            }
        }
        for (String key : addedLinks.keySet()) {
            if (((Boolean)addedLinks.get(key)).booleanValue()) continue;
            return "The Service Root URI response does not contain ";
        }
        return "";
    }
}

