/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.sta10;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.nio.charset.StandardCharsets;
import org.glassfish.jersey.client.ClientRequest;
import org.opengis.cite.sta10.CommonFixture;
import org.opengis.cite.sta10.util.ClientUtils;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.w3c.dom.Document;

public class TestFailureListener
extends TestListenerAdapter {
    @Override
    public void onTestFailure(ITestResult result) {
        super.onTestFailure(result);
        Object instance = result.getInstance();
        if (CommonFixture.class.isInstance(instance)) {
            CommonFixture fixture = (CommonFixture)CommonFixture.class.cast(instance);
            result.setAttribute("request", this.getRequestMessageInfo(fixture.request));
            result.setAttribute("response", this.getResponseMessageInfo(fixture.response));
        }
    }

    String getRequestMessageInfo(ClientRequest req) {
        if (null == req) {
            return "No request message.";
        }
        StringBuilder msgInfo = new StringBuilder();
        msgInfo.append("Method: ").append(req.getMethod()).append('\n');
        msgInfo.append("Target URI: ").append(req.getUri()).append('\n');
        msgInfo.append("Headers: ").append(req.getHeaders()).append('\n');
        if (null != req.getEntity()) {
            Object entity = req.getEntity();
            String body = "";
            if (Document.class.isInstance(entity)) {
                Document document = (Document)Document.class.cast(entity);
            } else {
                body = entity.toString();
            }
            msgInfo.append(body).append('\n');
        }
        return msgInfo.toString();
    }

    String getResponseMessageInfo(Response rsp) {
        if (null == rsp) {
            return "No response message.";
        }
        StringBuilder msgInfo = new StringBuilder();
        msgInfo.append("Status: ").append(rsp.getStatus()).append('\n');
        msgInfo.append("Headers: ").append(rsp.getHeaders()).append('\n');
        if (rsp.hasEntity()) {
            if (rsp.getMediaType().isCompatible(MediaType.APPLICATION_XML_TYPE)) {
                Document document = ClientUtils.getResponseEntityAsDocument(rsp, null);
            } else {
                byte[] body = rsp.readEntity(byte[].class);
                msgInfo.append(new String(body, StandardCharsets.UTF_8));
            }
            msgInfo.append('\n');
        }
        return msgInfo.toString();
    }
}

